/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.BeforeBuildRowConditionEventArgs;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.utils.BotpDrawServiceUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.common.BotpPO.downNodeBill;

public class ErChangeAccountConvertUtils {
    public static boolean pushValidator(AbstractConvertPlugIn convertPlugIn, BeforeBuildRowConditionEventArgs e) {
        boolean isNotLoan;
        String srcEntityId = convertPlugIn.getSrcMainType().getName();
        String tgtEntityId = convertPlugIn.getTgtMainType().getName();
        List selectedRows = e.getSelectedRows();
        if (selectedRows == null || selectedRows.isEmpty()) {
            return false;
        }
        List selectPks = selectedRows.stream().filter(row -> row.getPrimaryKeyValue() != null).map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        List<String> srcRangBills = Arrays.asList("er_dailyreimbursebill", "er_publicreimbursebill", "er_tripreimbursebill", "er_dailyloanbill", "er_prepaybill", "er_tripreqbill", "er_applypaybill");
        if (!srcRangBills.contains(srcEntityId)) {
            return false;
        }
        if (ErEntityTypeUtils.isTripReqBill(srcEntityId) && (isNotLoan = QueryServiceHelper.exists((String)srcEntityId, (QFilter[])new QFilter[]{new QFilter("id", "in", selectPks), new QFilter("isloan", "=", (Object)Boolean.FALSE)}))) {
            return false;
        }
        List<String> tgtRangBills = Arrays.asList("cas_paybill", "cas_agentpaybill", "er_applypaybill", "ap_finapbill");
        if (!tgtRangBills.contains(tgtEntityId)) {
            return false;
        }
        DynamicObjectCollection colls = QueryServiceHelper.query((String)srcEntityId, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", selectPks)});
        Map<Long, String> pksAndBillnos = colls.stream().collect(Collectors.toMap(col -> col.getLong("id"), col -> col.getString("billno"), (a, b) -> a));
        if (ErEntityTypeUtils.isApplyPayBill(srcEntityId)) {
            Set<Long> publicreimburseBill_Pks = BotpDrawServiceUtil.getDirectTrackUpBills(srcEntityId, pksAndBillnos.keySet().toArray(new Long[0])).values().stream().flatMap(downNodeBills -> downNodeBills.stream().filter(downNodeBill2 -> ErEntityTypeUtils.isPublicReimburseBill(downNodeBill2.getTableDefine().getEntityKey())).map(downNodeBill::getPk)).collect(Collectors.toSet());
            Set<Long> accountChangBill_Pks = BotpDrawServiceUtil.getDirectTrackDownBills("er_publicreimbursebill", publicreimburseBill_Pks.toArray(new Long[0])).values().stream().flatMap(downNodeBills -> downNodeBills.stream().filter(downNodeBill2 -> ErEntityTypeUtils.isAccountChangeBill(downNodeBill2.getTableDefine().getEntityKey())).map(downNodeBill::getPk)).collect(Collectors.toSet());
            if (ErChangeAccountConvertUtils.existAccountChangeOnWayBill(accountChangBill_Pks)) {
                e.setCustFilterDesc(ResManager.loadKDString((String)"\u4e0a\u6e38\u5bf9\u516c\u62a5\u9500\u5355\u5b58\u5728\u4e0b\u6e38\u5728\u9014\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u5355\uff0c\u4e0d\u80fd\u4e0b\u63a8\u4ed8\u6b3e\u3002", (String)"ErChangeAccountConvertUtils_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
                e.setCustFilterExpression(" billstatus = '-1' ");
                e.getCustQFilters().add(new QFilter("billstatus", "=", (Object)"-1"));
                return true;
            }
            return false;
        }
        Map<Long, List<downNodeBill>> directTrackDownBills = BotpDrawServiceUtil.getDirectTrackDownBills(srcEntityId, pksAndBillnos.keySet().toArray(new Long[0]));
        HashMap<Long, String> errorMsMap = new HashMap<Long, String>(pksAndBillnos.size());
        Set<Map.Entry<Long, List<downNodeBill>>> entries = directTrackDownBills.entrySet();
        for (Map.Entry<Long, List<downNodeBill>> entry : entries) {
            Long selectPk = entry.getKey();
            List<downNodeBill> downNodeBills2 = entry.getValue();
            Set<Long> downNodeChangeAccountBillPks = downNodeBills2.stream().filter(downBill -> ErEntityTypeUtils.isAccountChangeBill(downBill.getTableDefine().getEntityKey())).map(downNodeBill::getPk).collect(Collectors.toSet());
            if (!ErChangeAccountConvertUtils.existAccountChangeOnWayBill(downNodeChangeAccountBillPks)) continue;
            errorMsMap.put(selectPk, pksAndBillnos.get(selectPk));
        }
        if (!errorMsMap.isEmpty()) {
            Set errPks = errorMsMap.keySet();
            Collection errBillno = errorMsMap.values();
            e.setCustFilterDesc(String.format(ResManager.loadKDString((String)"\u9009\u4e2d%1$s\u5355\u636e\u5b58\u5728\u4e0b\u6e38\u5728\u9014\u6536\u6b3e\u4fe1\u606f\u53d8\u66f4\u5355\uff0c\u4e0d\u80fd\u4e0b\u63a8\u4ed8\u6b3e\u3002", (String)"ErChangeAccountConvertUtils_0", (String)"fi-er-formplugin", (Object[])new Object[0]), errBillno));
            e.setCustFilterExpression(" billstatus = '-1' ");
            e.getCustQFilters().add(new QFilter("id", "not in", errPks));
            return true;
        }
        return false;
    }

    public static boolean existAccountChangeOnWayBill(Set<Long> AccountChangeBillPks) {
        List<String> onWayBillStatus = Arrays.asList("A", "B", "C", "D");
        return QueryServiceHelper.exists((String)"er_accountchangebill", (QFilter[])new QFilter[]{new QFilter("billstatus", "in", onWayBillStatus), new QFilter("id", "in", AccountChangeBillPks)});
    }

    public static PublicReimBurseBFRowDataHandler PublicReimBurseBFRowDataHandlerBuilder() {
        return new PublicReimBurseBFRowDataHandler();
    }

    public static class PublicReimBurseBFRowDataHandler {
        private static final String FINAPBILL_ENTITYID = "ap_finapbill";
        private static final String APPLYPAY_ENTITYID = "er_applypaybill";
        private List<BFRow> bfRows;
        private Map<Long, List<Long>> finApbill;
        private Map<Long, List<Long>> applyPaybill;

        private PublicReimBurseBFRowDataHandler() {
        }

        public PublicReimBurseBFRowDataHandler setBFRow(List<BFRow> bfRows) {
            this.bfRows = bfRows;
            return this;
        }

        private void fillSrcIdAndTgtEntryIdMap(Map<Long, List<Long>> SrcIdAndTgtEntryIdMap, BFRow bfRow) {
            Long sBillId = bfRow.getSId().getBillId();
            List<Long> tgtIdList = SrcIdAndTgtEntryIdMap.get(sBillId);
            if (tgtIdList == null) {
                tgtIdList = new ArrayList<Long>(12);
            }
            tgtIdList.add(bfRow.getId().getBillId());
            SrcIdAndTgtEntryIdMap.put(sBillId, tgtIdList);
        }

        public PublicReimBurseBFRowDataHandler build() {
            this.finApbill = new HashMap<Long, List<Long>>(this.bfRows.size());
            this.applyPaybill = new HashMap<Long, List<Long>>(this.bfRows.size());
            Long finApBillTableId = EntityMetadataCache.loadMainTableDefine((String)FINAPBILL_ENTITYID).getTableId();
            Long applyPayBillTableId = EntityMetadataCache.loadMainTableDefine((String)APPLYPAY_ENTITYID).getTableId();
            for (BFRow bfRow : this.bfRows) {
                BFRowId bfRowId = bfRow.getId();
                Long mainTableId = bfRowId.getMainTableId();
                if (finApBillTableId != 0L && mainTableId.compareTo(finApBillTableId) == 0) {
                    this.fillSrcIdAndTgtEntryIdMap(this.finApbill, bfRow);
                }
                if (applyPayBillTableId == 0L || mainTableId.compareTo(applyPayBillTableId) != 0) continue;
                this.fillSrcIdAndTgtEntryIdMap(this.applyPaybill, bfRow);
            }
            return this;
        }

        public Map<Long, List<Long>> getFinApbill() {
            return this.finApbill;
        }

        public Set<Long> getAccountEntryAssociateWithApplyPayBill() {
            List downNodeApplyPaybillPks = this.applyPaybill.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            return QueryServiceHelper.query((String)APPLYPAY_ENTITYID, (String)"accountentry.id,accountentry.recsrcentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", downNodeApplyPaybillPks), new QFilter("accountentry.buildedamount", "=", (Object)BigDecimal.ZERO)}).stream().map(appbill -> appbill.getLong("accountentry.recsrcentryid")).collect(Collectors.toSet());
        }
    }
}

