/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageTypes;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.SystemParamterUtil;
import org.apache.commons.lang3.StringUtils;

public class ErCostCenterUtil {
    public static final Map<String, ThreeTuple<String, String, String>> COSTDEPT_COSTCENTER_MAP;

    public static boolean checkCostOrg(AbstractFormPlugin plugin, String formType) {
        IFormView view = plugin.getView();
        IDataModel model = view.getModel();
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            return false;
        }
        if (model.getProperty("std_costcenter") == null) {
            return false;
        }
        Long companyId = (Long)company.getPkValue();
        String costMode = ErCommonUtils.getCostOrgUseMode(companyId);
        DynamicObject costCenter = (DynamicObject)model.getValue("std_costcenter");
        ArrayList<String> errMsgs = new ArrayList<String>();
        boolean res = true;
        switch (costMode) {
            case "0": {
                if (model.getValue("company") == null) {
                    errMsgs.add(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErCostCenterUtil_1", (String)"fi-er-business", (Object[])new Object[0]));
                    res = false;
                }
                if (model.getValue("costcompany") != null) break;
                errMsgs.add(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErCostCenterUtil_2", (String)"fi-er-business", (Object[])new Object[0]));
                res = false;
                break;
            }
            case "2": 
            case "1": {
                if (model.getValue("company") == null) {
                    errMsgs.add(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErExpenseBaseEdit_1", (String)"fi-er-business", (Object[])new Object[0]));
                    res = false;
                }
                if (costCenter == null) {
                    errMsgs.add(ResManager.loadKDString((String)"\u6210\u672c\u4e2d\u5fc3\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErCostCenterUtil_0", (String)"fi-er-business", (Object[])new Object[0]));
                    res = false;
                }
                if (model.getValue("costcompany") != null) break;
                errMsgs.add(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErExpenseBaseEdit_2", (String)"fi-er-business", (Object[])new Object[0]));
                res = false;
                break;
            }
        }
        for (String msg : errMsgs) {
            if ("1".equals(formType)) {
                view.showMessage(msg, MessageTypes.Permission, new ConfirmCallBackListener("ok", (IFormPlugin)plugin));
                view.getPageCache().put("showCostCenterTip", "false");
                continue;
            }
            if (!"6".equals(formType)) continue;
            view.showConfirm(msg, MessageBoxOptions.OK, new ConfirmCallBackListener("ok", (IFormPlugin)plugin));
        }
        return res;
    }

    public static void initCostCenter(IDataModel model, String entryName, int rowIndex, int parentRow) {
        ThreeTuple<String, String, String> tuple = COSTDEPT_COSTCENTER_MAP.get(entryName);
        String deptPropName = (String)tuple.item1;
        String costComPropName = (String)tuple.item2;
        String centerPropName = (String)tuple.item3;
        if (model.getProperty(centerPropName) == null) {
            return;
        }
        if (centerPropName.equals("std_entrycostcenter") && model.getProperty("std_entrycostcenter") == null && model.getProperty("entrycostcenter") != null) {
            centerPropName = "entrycostcenter";
        }
        DynamicObject costDept = (DynamicObject)model.getValue(deptPropName, rowIndex, parentRow);
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            return;
        }
        String useMode = ErCommonUtils.getCostOrgUseMode((Long)company.getPkValue());
        if ("0".equals(useMode)) {
            return;
        }
        if (costDept == null) {
            return;
        }
        DynamicObject costCenter = ErCostCenterUtil.getCostCenterByCostDept(ErCommonUtils.getPk(costDept));
        model.setValue(centerPropName, (Object)costCenter, rowIndex, parentRow);
        if ("1".equals(useMode) || "2".equals(useMode)) {
            if (costCenter == null) {
                model.setValue(costComPropName, null, rowIndex, parentRow);
            } else {
                DynamicObject costCompany = costCenter.getDynamicObject("accountorg");
                if (ErCostCenterUtil.checkLeafCostCompany((Long)company.getPkValue(), costCompany)) {
                    model.setValue(costComPropName, costCenter == null ? null : costCenter.get("accountorg"), rowIndex, parentRow);
                } else {
                    model.setValue(costComPropName, null, rowIndex, parentRow);
                }
            }
        }
    }

    public static DynamicObject getCostCenterByCostDept(Long costDept) {
        Map.Entry entry;
        if (costDept == null || costDept == 0L) {
            return null;
        }
        Map dys = BusinessDataServiceHelper.loadFromCache((String)"bos_costcenter", (QFilter[])new QFilter[]{new QFilter("entryentity.data", "=", (Object)costDept), new QFilter("isleaf", "=", (Object)true), new QFilter("enable", "=", (Object)"1")});
        DynamicObject costCenter = null;
        Iterator iterator = dys.entrySet().iterator();
        while (iterator.hasNext() && (costCenter = (DynamicObject)(entry = iterator.next()).getValue()) == null) {
        }
        return costCenter;
    }

    public static DynamicObject getCostCompanyByCostCenter(DynamicObject costCenter) {
        if (costCenter == null) {
            return null;
        }
        DynamicObject accountorg = costCenter.getDynamicObject("accountorg");
        if (accountorg != null && !ErCostCenterUtil.isHaveChildCostCom((Long)accountorg.getPkValue())) {
            return accountorg;
        }
        return null;
    }

    public static void initHeadCostCenter(IFormView view, boolean show) {
        Long currencyId;
        ErCostCenterUtil.initCostCenter(view.getModel(), "head", -1, -1);
        if (!ErEntityTypeUtils.isTripReimburseBill(view.getEntityId()) && !ErEntityTypeUtils.isTripReqBill(view.getEntityId()) && view.getModel().getProperty((String)ErCostCenterUtil.COSTDEPT_COSTCENTER_MAP.get((Object)"head").item3) != null) {
            ErCostCenterUtil.headCostCenterChange(view, view.getModel().getValue((String)ErCostCenterUtil.COSTDEPT_COSTCENTER_MAP.get((Object)"head").item3), show);
        }
        if (view.getModel().getValue("costcompany") != null && ErCostCenterUtil.checkCompanyMode(view) && (currencyId = BaseCurrencyServiceHelper.getBaseCurrencyId(view.getModel().getValue("company"), view.getModel().getValue("costcompany"))) != null) {
            view.getModel().setValue("currency", (Object)currencyId);
        }
    }

    public static void initEntryCostCenter(IDataModel model, String entryName, int rowIndex, int parentRow) {
        ErCostCenterUtil.initCostCenter(model, entryName, rowIndex, parentRow);
    }

    public static void headCostCompanyChange(DynamicObject propValue, IFormView view) {
        if (!ErCostCenterUtil.checkCompanyMode(view)) {
            return;
        }
        DynamicObject costCenter = (DynamicObject)view.getModel().getValue("std_costcenter");
        if (costCenter == null) {
            return;
        }
        if (propValue == null || ErCostCenterUtil.costCenterHasCostCompany(costCenter, propValue)) {
            ErCostCenterUtil.setCostCenterNull(view);
        }
    }

    private static void setCostCenterNull(IFormView view) {
        view.getModel().beginInit();
        view.getModel().setValue("std_costcenter", null);
        view.getModel().endInit();
        view.updateView("std_costcenter");
    }

    private static void setEntryCostCenterNull(IFormView view, int index) {
        view.getModel().beginInit();
        view.getModel().setValue("std_entrycostcenter", null, index);
        view.getModel().endInit();
        view.updateView("std_entrycostcenter", index);
    }

    public static void costDeptChange(IFormView view) {
        if (view.getModel().getProperty("std_costcenter") != null && !ErCostCenterUtil.checkCompanyMode(view)) {
            view.getModel().setValue("std_costcenter", null);
        }
        if (!ErCostCenterUtil.checkCompanyMode(view)) {
            DynamicObjectCollection expenseentryentity = null;
            if (view.getModel().getProperty("expenseentryentity") != null) {
                expenseentryentity = view.getModel().getEntryEntity("expenseentryentity");
            }
            if (view.getModel().getProperty("tripentry") != null) {
                expenseentryentity = view.getModel().getEntryEntity("tripentry");
            }
            if (expenseentryentity == null || expenseentryentity.size() == 0) {
                return;
            }
            DataEntityPropertyCollection properties = expenseentryentity.getDynamicObjectType().getProperties();
            if (!properties.containsKey((Object)"std_entrycostcenter") || !properties.containsKey((Object)"entrycostcompany")) {
                return;
            }
            for (int i = 0; i < expenseentryentity.size(); ++i) {
                ErCostCenterUtil.setEntryCostCenterNull(view, i);
            }
        }
    }

    public static DynamicObject getCompanyForMob(IFormView view) {
        IFormView parentView;
        DynamicObject company = (DynamicObject)view.getModel().getValue("company");
        if (company == null && (parentView = view.getViewNoPlugin(view.getFormShowParameter().getParentPageId())) != null && parentView.getModel().getProperty("company") != null) {
            company = (DynamicObject)parentView.getModel().getValue("company");
        }
        return company;
    }

    public static boolean checkCompanyMode(IFormView view) {
        DynamicObject company = ErCostCenterUtil.getCompanyForMob(view);
        if (company == null) {
            return false;
        }
        String selectMode = ErCommonUtils.getCostOrgUseMode((Long)company.getPkValue());
        return !"0".equals(selectMode);
    }

    public static void entryCostCompanyChange(IFormView view) {
        if (!ErCostCenterUtil.checkCompanyMode(view)) {
            return;
        }
        if (view.getModel().getProperty("std_entrycostcenter") == null) {
            return;
        }
        DynamicObjectCollection expenseentryentity = null;
        if (view.getModel().getProperty("expenseentryentity") != null) {
            expenseentryentity = view.getModel().getEntryEntity("expenseentryentity");
        }
        if (view.getModel().getProperty("tripentry") != null) {
            expenseentryentity = view.getModel().getEntryEntity("tripentry");
        }
        if (expenseentryentity == null || expenseentryentity.size() == 0) {
            return;
        }
        DataEntityPropertyCollection properties = expenseentryentity.getDynamicObjectType().getProperties();
        if (!properties.containsKey((Object)"std_entrycostcenter") || !properties.containsKey((Object)"entrycostcompany")) {
            return;
        }
        for (int i = 0; i < expenseentryentity.size(); ++i) {
            DynamicObject item = (DynamicObject)expenseentryentity.get(i);
            if (!ErCostCenterUtil.costCenterHasCostCompany(item.get("std_entrycostcenter"), item.get("entrycostcompany"))) continue;
            ErCostCenterUtil.setEntryCostCenterNull(view, i);
        }
    }

    public static boolean costCenterHasCostCompany(Object center, Object costCompany) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_costcenter", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ErCommonUtils.getPk(center)), new QFilter("accountorg.id", "=", (Object)ErCommonUtils.getPk(costCompany)), new QFilter("isleaf", "=", (Object)true), new QFilter("enable", "=", (Object)"1")});
        return dynamicObject == null;
    }

    public static void dealCostCenter(IFormView view) {
        if (!"A".equals(view.getModel().getValue("billstatus"))) {
            return;
        }
        if (!ErCostCenterUtil.checkCompanyMode(view)) {
            return;
        }
        if (view.getModel().getProperty("std_costcenter") == null) {
            return;
        }
        DynamicObject costCompany = (DynamicObject)view.getModel().getValue("costcompany");
        DynamicObject costCenter = (DynamicObject)view.getModel().getValue("std_costcenter");
        if (costCompany != null && costCenter != null && ErCostCenterUtil.costCenterHasCostCompany(costCenter, costCompany) && !ErEntityTypeUtils.isWithholdingBill(view.getEntityId())) {
            ErCostCenterUtil.setCostCenterNull(view);
        }
        DynamicObjectCollection expenseentryentity = null;
        if (view.getModel().getProperty("expenseentryentity") != null) {
            expenseentryentity = view.getModel().getEntryEntity("expenseentryentity");
        }
        if (view.getModel().getProperty("tripentry") != null) {
            expenseentryentity = view.getModel().getEntryEntity("tripentry");
        }
        if (expenseentryentity == null) {
            return;
        }
        for (int i = 0; i < expenseentryentity.size(); ++i) {
            DynamicObject dynamicObject = (DynamicObject)expenseentryentity.get(i);
            if (!dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"std_entrycostcenter") || !dynamicObject.getDynamicObjectType().getProperties().containsKey((Object)"entrycostcompany") || dynamicObject.get("entrycostcompany") == null || dynamicObject.get("std_entrycostcenter") == null || !ErCostCenterUtil.costCenterHasCostCompany(dynamicObject.get("std_entrycostcenter"), dynamicObject.get("entrycostcompany"))) continue;
            ErCostCenterUtil.setEntryCostCenterNull(view, i);
        }
    }

    public static void headCostCenterChange(IFormView view, Object propValue, boolean show) {
        if (propValue == null) {
            return;
        }
        if (!ErCostCenterUtil.checkCompanyMode(view)) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObject newCostCenter = (DynamicObject)propValue;
        DynamicObject newCostCompany = ErCostCenterUtil.getCostCompanyByCenter(newCostCenter, view, show);
        int entryRowCount = model.getEntryRowCount("expenseentryentity");
        String expensesAssumeShowTypes = ErCommonUtils.getEMParameter(ErCommonUtils.getPk(model.getValue("company")), "expensesassumeshowtypes").toString();
        if (StringUtils.equalsAny((CharSequence)expensesAssumeShowTypes, (CharSequence[])new CharSequence[]{"1", "3"})) {
            for (int i = 0; i < entryRowCount; ++i) {
                model.beginInit();
                if (model.getProperty("std_entrycostcenter") != null) {
                    model.setValue("std_entrycostcenter", (Object)newCostCenter, i);
                } else if (model.getProperty("entrycostcenter") != null) {
                    model.setValue("entrycostcenter", (Object)newCostCenter, i);
                }
                model.endInit();
                model.setValue("entrycostcompany", (Object)newCostCompany, i);
                if (model.getProperty("std_entrycostcenter") != null) {
                    view.updateView("std_entrycostcenter", i);
                }
                if (model.getProperty("entrycostcenter") == null) continue;
                view.updateView("entrycostcenter", i);
            }
        }
        model.setValue("costcompany", (Object)newCostCompany);
    }

    private static DynamicObject getCostCompanyByCenter(DynamicObject newCostCenter, IFormView view, boolean show) {
        IDataModel model = view.getModel();
        Map centerBaseData = BusinessDataServiceHelper.loadFromCache((String)"bos_costcenter", (QFilter[])new QFilter[]{new QFilter("id", "=", newCostCenter.getPkValue())});
        DynamicObject newCostCompany = (newCostCenter = (DynamicObject)centerBaseData.get(newCostCenter.getPkValue())).getDynamicObject("accountorg");
        if (newCostCompany == null && show) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErCostCenterUtil_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        if (!ErCostCenterUtil.checkLeafCostCompany(ErCommonUtils.getPk(model.getValue("company")), newCostCompany) && show) {
            newCostCompany = null;
            view.showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErCostCenterUtil_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        return newCostCompany;
    }

    public static void costCenterChangeForTripEdit(IFormView view, Object propValue) {
        if (propValue == null) {
            return;
        }
        if (!ErCostCenterUtil.checkCompanyMode(view)) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObject newCostCenter = (DynamicObject)propValue;
        DynamicObject newCostCompany = ErCostCenterUtil.getCostCompanyByCenter(newCostCenter, view, true);
        model.setValue("entrycostcompany", (Object)newCostCompany);
    }

    public static void costCenterChangeForTrip(IFormView view, Object propValue) {
        if (propValue == null) {
            return;
        }
        if (!ErCostCenterUtil.checkCompanyMode(view)) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObject newCostCenter = (DynamicObject)propValue;
        DynamicObject newCostCompany = ErCostCenterUtil.getCostCompanyByCenter(newCostCenter, view, true);
        model.setValue("costcompany", (Object)newCostCompany);
        DynamicObjectCollection tripEntries = model.getEntryEntity("tripentry");
        int entryRowCount = model.getEntryRowCount("tripentry");
        String expensesAssumeShowTypes = ErCommonUtils.getEMParameter(ErCommonUtils.getPk(model.getValue("company")), "expensesassumeshowtypes").toString();
        if (StringUtils.equalsAny((CharSequence)expensesAssumeShowTypes, (CharSequence[])new CharSequence[]{"1", "3"})) {
            for (int i = 0; i < entryRowCount; ++i) {
                DynamicObjectCollection entryEntries;
                model.beginInit();
                model.setValue("std_entrycostcenter", (Object)newCostCenter, i);
                model.endInit();
                view.updateView("std_entrycostcenter", i);
                model.setValue("entrycostcompany", (Object)newCostCompany, i);
                if (!ErEntityTypeUtils.isTripReimburseBill(view.getEntityId()) || (entryEntries = ((DynamicObject)tripEntries.get(i)).getDynamicObjectCollection("entryentity")) == null || entryEntries.size() <= 0) continue;
                for (int j = 0; j < entryEntries.size(); ++j) {
                    model.setValue("travelcostcompany", (Object)newCostCompany, j, i);
                    model.setValue("travelcostcenter", (Object)newCostCenter, j, i);
                }
            }
        }
    }

    public static void clearCostCenterByCostDept(IDataModel model, String entryName, int rowIndex, int pIndex) {
        Object company = model.getValue("company");
        int mode = ErCommonUtils.getCostCenterSelect(ErCommonUtils.getPk(company));
        if (mode == 1) {
            return;
        }
        ThreeTuple<String, String, String> tuple = COSTDEPT_COSTCENTER_MAP.get(entryName);
        DynamicObject costDept = (DynamicObject)model.getValue((String)tuple.item1, rowIndex, pIndex);
        DynamicObject costCenter = (DynamicObject)model.getValue((String)tuple.item3, rowIndex, pIndex);
        if (costCenter == null) {
            return;
        }
        DynamicObjectCollection entry = (costCenter = BusinessDataServiceHelper.loadSingle((String)"bos_costcenter", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)ErCommonUtils.getPk(costCenter))})).getDynamicObjectCollection("entryentity");
        Set idSet = entry.stream().map(row -> row.getLong("data_id")).collect(Collectors.toSet());
        if (idSet.contains(ErCommonUtils.getPk(costDept))) {
            return;
        }
        model.setValue((String)tuple.item3, null, rowIndex, pIndex);
    }

    public static void costEntryCenterChangeContractForPC(IFormView view, Object propValue, int rowIndex) {
        if (propValue == null) {
            return;
        }
        DynamicObject company = (DynamicObject)view.getModel().getValue("company");
        String selectMode = ErCommonUtils.getCostOrgUseMode((Long)company.getPkValue());
        if ("0".equals(selectMode)) {
            return;
        }
        DynamicObject newCostCenter = (DynamicObject)propValue;
        DynamicObject newCostCompany = ErCostCenterUtil.getCostCompanyByCenter(newCostCenter, view, true);
        view.getModel().setValue("entrycostcompany", (Object)newCostCompany, rowIndex);
    }

    public static void mobSecondcostEntryCenterChange(IFormView view, Object propValue, int rowIndex) {
        DynamicObject company = (DynamicObject)view.getParentView().getModel().getValue("company");
        String selectMode = ErCommonUtils.getCostOrgUseMode((Long)company.getPkValue());
        if ("0".equals(selectMode)) {
            return;
        }
        DynamicObject newCostCenter = (DynamicObject)propValue;
        DynamicObject newCostCompany = ErCostCenterUtil.getCostCompanyByCenter(newCostCenter, view, true);
        if (view.getModel().getProperty("entrycostcompany") != null) {
            view.getModel().setValue("entrycostcompany", (Object)newCostCompany, rowIndex);
        }
    }

    public static void costEntryCenterChangeForPC(IFormView view, Object propValue, int rowIndex) {
        if (propValue == null) {
            return;
        }
        DynamicObject company = (DynamicObject)view.getModel().getValue("company");
        String selectMode = ErCommonUtils.getCostOrgUseMode((Long)company.getPkValue());
        if ("0".equals(selectMode)) {
            return;
        }
        IDataModel model = view.getModel();
        int showType = 1;
        String billtype = (String)model.getValue("formid");
        if (!ErEntityTypeUtils.isDailyVehicleBill(billtype)) {
            showType = ErCommonUtils.getExpenseAssumeShowTypes(ErCommonUtils.getPk(company));
        }
        DynamicObject newCostCenter = (DynamicObject)propValue;
        DynamicObject newCostCompany = ErCostCenterUtil.getCostCompanyByCenter(newCostCenter, view, true);
        if (!ErCostCenterUtil.checkLeafCostCompany(ErCommonUtils.getPk(company), newCostCompany)) {
            newCostCompany = null;
            view.showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErCostCenterUtil_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        if (showType != 3) {
            model.setValue("entrycostcompany", (Object)newCostCompany, rowIndex);
        }
        if (rowIndex == 0 && (showType == 2 || showType == 3)) {
            model.beginInit();
            model.setValue("std_costcenter", (Object)newCostCenter);
            model.endInit();
            if (showType != 3) {
                model.setValue("costcompany", (Object)newCostCompany);
            }
            view.updateView("std_costcenter");
        }
    }

    public static void clearHeadCostCenter(IDataModel model) {
        ErCostCenterUtil.clearCostCenterByCostDept(model, "head", -1, -1);
    }

    public static void clearEntryCostCenter(IDataModel model, int rowIndex, String propName, String entryName) {
        int parentRow = -1;
        IDataEntityProperty prop = model.getProperty(propName);
        if (prop != null) {
            IDataEntityType pet = prop.getParent();
            parentRow = model.getEntryCurrentRowIndex(pet.getParent().getName());
        }
        ErCostCenterUtil.clearCostCenterByCostDept(model, entryName, rowIndex, parentRow);
    }

    public static boolean isLeafCostCenter(Object propValue) {
        if (propValue == null) {
            return true;
        }
        Long centerId = (Long)((DynamicObject)propValue).getPkValue();
        List<DynamicObject> costCenters = ErCostCenterUtil.getCostCenterByFilter(new QFilter("id", "=", (Object)centerId));
        if (costCenters.size() == 0) {
            return true;
        }
        boolean isLeaf = costCenters.get(0).getBoolean("isleaf");
        return isLeaf;
    }

    public static List<DynamicObject> getCostCenterByFilter(QFilter filter) {
        Map centerBaseData = BusinessDataServiceHelper.loadFromCache((String)"bos_costcenter", (QFilter[])new QFilter[]{filter, new QFilter("enable", "=", (Object)"1")});
        return centerBaseData.values().stream().collect(Collectors.toList());
    }

    public static void costEntryCenterChangeForMob(IFormView view, Object propValue, int rowIndex) {
        if (propValue == null) {
            return;
        }
        DynamicObject company = (DynamicObject)view.getModel().getValue("company");
        IFormView parentView = view.getParentView();
        if (company == null && parentView != null) {
            IDataModel pModel = parentView.getModel();
            company = (DynamicObject)pModel.getValue("company");
        }
        if (company == null) {
            return;
        }
        Long companyPk = ErCommonUtils.getPk(company);
        String selectMode = ErCommonUtils.getCostOrgUseMode(companyPk);
        if ("0".equals(selectMode)) {
            return;
        }
        DynamicObject newCostCenter = (DynamicObject)propValue;
        DynamicObject newCostCompany = ErCostCenterUtil.getCostCompanyByCenter(newCostCenter, view, true);
        if (!ErCostCenterUtil.checkLeafCostCompany(companyPk, newCostCompany)) {
            newCostCompany = null;
            view.showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErCostCenterUtil_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        view.getModel().setValue("entrycostcompany", (Object)newCostCompany, rowIndex);
    }

    public static boolean checkLeafCostCompany(Long companyId, DynamicObject costCompany) {
        boolean isRelate;
        if (costCompany == null) {
            return true;
        }
        int showType = 1;
        String enableCost = "0";
        if (companyId != 0L) {
            showType = ErCommonUtils.getExpenseAssumeShowTypes(companyId);
            enableCost = SystemParamterUtil.enableCostCompanyEdit(companyId);
        }
        boolean bl = isRelate = !"2".equals(ErStdConfig.get("Costcompany Unbinding")) || showType != 1;
        return !ErCostCenterUtil.isHaveChildCostCom((Long)costCompany.getPkValue());
    }

    private static boolean isHaveChildCostCom(Long pId) {
        QFilter f = new QFilter("structure.viewparent", "=", (Object)pId);
        f.and(new QFilter("structure.view.number", "=", (Object)"10"));
        Map childNodes = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{f});
        if (childNodes == null || childNodes.size() == 0) {
            return false;
        }
        for (Map.Entry entry : childNodes.entrySet()) {
            DynamicObject node = (DynamicObject)entry.getValue();
            DynamicObjectCollection structure = node.getDynamicObjectCollection("structure");
            if (structure.size() == 0) continue;
            for (DynamicObject struct : structure) {
                DynamicObject view = struct.getDynamicObject("view");
                String viewNumber = view.getString("number");
                if (!"10".equals(viewNumber)) continue;
                return true;
            }
        }
        return false;
    }

    public static void costEntryCenterChangeForTripPC(IFormView view, Object propValue, int rowIndex) {
        IDataModel model = view.getModel();
        DynamicObject company = (DynamicObject)model.getValue("company");
        String selectUseMode = ErCommonUtils.getCostOrgUseMode((Long)company.getPkValue());
        if ("0".equals(selectUseMode)) {
            return;
        }
        ErCostCenterUtil.costEntryCenterChangeForPC(view, propValue, rowIndex);
        DynamicObject trip = model.getEntryRowEntity("tripentry", rowIndex);
        if (trip == null) {
            return;
        }
        DynamicObject newCostCenter = trip.getDynamicObject("std_entrycostcenter");
        DynamicObject newCostCompany = trip.getDynamicObject("entrycostcompany");
        trip.getDynamicObjectCollection("entryentity").forEach(v -> {
            v.set("travelcostcompany", (Object)newCostCompany);
            v.set("travelcostcenter", (Object)newCostCenter);
        });
    }

    public static void travelEntryCostCenterChangeForPC(IFormView view, Object propValue, int rowIndex, int parentRowIndex) {
        if (propValue == null) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObject company = (DynamicObject)model.getValue("company");
        String selectUseMode = ErCommonUtils.getCostOrgUseMode((Long)company.getPkValue());
        if ("0".equals(selectUseMode)) {
            return;
        }
        DynamicObject newCostCenter = (DynamicObject)propValue;
        boolean show = true;
        String showCostCenterTip = view.getPageCache().get("showCostCenterTip");
        if ("false".equals(showCostCenterTip)) {
            show = false;
        }
        DynamicObject newCostCompany = ErCostCenterUtil.getCostCompanyByCenter(newCostCenter, view, show);
        model.setValue("travelcostcompany", (Object)newCostCompany, rowIndex, parentRowIndex);
    }

    public static void costEntryCenterChangeForTripMob(IFormView view, Object propValue, int rowIndex) {
        if (propValue == null) {
            return;
        }
        IDataModel model = view.getModel();
        DynamicObject newCostCenter = (DynamicObject)propValue;
        DynamicObject newCostCompany = ErCostCenterUtil.getCostCompanyByCenter(newCostCenter, view, true);
        Long companyId = (Long)((DynamicObject)view.getParentView().getModel().getValue("company")).getPkValue();
        if (!ErCostCenterUtil.checkLeafCostCompany(companyId, newCostCompany)) {
            newCostCompany = null;
            view.showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u4e3a\u7a7a\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u3002", (String)"ErCostCenterUtil_2", (String)"fi-er-business", (Object[])new Object[0]));
        }
        view.getModel().setValue("entrycostcompany", (Object)newCostCompany, rowIndex);
        DynamicObject trip = model.getEntryRowEntity("tripentry", rowIndex);
        DynamicObject finalNewCostCompany = newCostCompany;
        trip.getDynamicObjectCollection("entryentity").forEach(v -> {
            v.set("travelcostcompany", (Object)finalNewCostCompany);
            v.set("travelcostcenter", (Object)newCostCenter);
        });
    }

    public static void setCostCenterByCostDept(IFormView view, String entryName, DynamicObject costDept, int rowIndex, int parentRow) {
        Map.Entry entry;
        ThreeTuple<String, String, String> tuple = COSTDEPT_COSTCENTER_MAP.get(entryName);
        String centerPropName = (String)tuple.item3;
        IDataModel model = view.getModel();
        if (costDept == null) {
            return;
        }
        Map dys = BusinessDataServiceHelper.loadFromCache((String)"bos_costcenter", (QFilter[])new QFilter[]{new QFilter("entryentity.data", "=", costDept.getPkValue()), new QFilter("isleaf", "=", (Object)true), new QFilter("enable", "=", (Object)"1")});
        DynamicObject costCenter = null;
        Iterator iterator = dys.entrySet().iterator();
        while (iterator.hasNext() && (costCenter = (DynamicObject)(entry = iterator.next()).getValue()) == null) {
        }
        if (model.getProperty(centerPropName) != null) {
            model.setValue(centerPropName, (Object)costCenter, rowIndex, parentRow);
        }
        if (costCenter == null && view.getModel().getProperty("entrycostcompany") != null) {
            model.setValue("entrycostcompany", null, rowIndex, parentRow);
        }
    }

    static {
        HashMap<String, ThreeTuple> temp = new HashMap<String, ThreeTuple>(3);
        temp.put("head", new ThreeTuple((Object)"costdept", (Object)"costcompany", (Object)"std_costcenter"));
        temp.put("expenseentryentity", new ThreeTuple((Object)"entrycostdept", (Object)"entrycostcompany", (Object)"std_entrycostcenter"));
        temp.put("expenseentryentity1", new ThreeTuple((Object)"entrycostdept", (Object)"entrycostcompany", (Object)"entrycostcenter"));
        temp.put("writeoffmoney", new ThreeTuple((Object)"sourceentrycostdept", (Object)"sourceentrycostcompany", (Object)"std_srcentrycostcenter"));
        temp.put("withholdingentry", new ThreeTuple((Object)"whentrycostdeptid", (Object)"whentrycostcompanytid", (Object)"whentrycostcenter"));
        temp.put("tripentry", new ThreeTuple((Object)"entrycostdept", (Object)"entrycostcompany", (Object)"std_entrycostcenter"));
        temp.put("entryentity", new ThreeTuple((Object)"travelcostdept", (Object)"travelcostcompany", (Object)"travelcostcenter"));
        temp.put("clearloanentry", new ThreeTuple((Object)"sourceentrycostdept", (Object)"sourceentrycostcompany", (Object)"std_srcentrycostcenter"));
        temp.put("expenseentryentity_rule", new ThreeTuple((Object)"entrycostdept_orgrule", (Object)"entrycostcompany_orgrule", (Object)"std_entrycostcenter_crule"));
        temp.put("sharedetailentry", new ThreeTuple((Object)"entrycostdept_orgrule", (Object)"entrycostcompany_orgrule", (Object)"sdstd_entrycostcenter"));
        COSTDEPT_COSTCENTER_MAP = Collections.unmodifiableMap(temp);
    }
}

