/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class JsonHelper {
    private static final Log logger = LogFactory.getLog(JsonHelper.class);

    public static String s(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    public static String initJSON(String json) {
        try {
            JSON.parseObject((String)JsonHelper.s(json));
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u62a5\u6587\u793a\u4f8b\u683c\u5f0f\u53ea\u80fd\u662f\u4e3aJsonObject\u3002", (String)"FieldmappingBillSaveOp_16", (String)"fi-er-opplugin", (Object[])new Object[0]));
        }
        Map jsonDataMap = (Map)JSON.parseObject((String)JsonHelper.s(json), Map.class);
        TreeNode root = new TreeNode("", "", "JSON");
        HashMap<String, Object> rootData = new HashMap<String, Object>();
        rootData.put("name", "JSON");
        rootData.put("type", "STRUCT");
        rootData.put("isArray", Boolean.FALSE);
        rootData.put("required", Boolean.FALSE);
        rootData.put("description", "jsonp");
        rootData.put("default_value", "");
        root.setData(rootData);
        for (String jsonKey : jsonDataMap.keySet()) {
            TreeNode node = new TreeNode(root.getId(), root.getId().isEmpty() ? jsonKey : root.getId() + "." + jsonKey, jsonKey);
            HashMap<String, Object> nodeData = new HashMap<String, Object>();
            nodeData.put("name", jsonKey);
            nodeData.put("description", jsonKey);
            nodeData.put("required", Boolean.FALSE);
            nodeData.put("default_value", null);
            JsonHelper.innerSetNodeData(jsonDataMap, jsonKey, node, nodeData, "type");
            root.addChild(node);
            node.setData(nodeData);
        }
        String jsonString = SerializationUtils.toJsonString((Object)root);
        return jsonString;
    }

    public static void jsonMapToApiTreeNode(Map<String, Object> jsonDataMap, TreeNode rootNode) {
        if (jsonDataMap == null) {
            return;
        }
        for (String jsonKey : jsonDataMap.keySet()) {
            TreeNode node = new TreeNode(rootNode.getId(), rootNode.getId() + "." + jsonKey, jsonKey);
            HashMap<String, Object> nodeData = new HashMap<String, Object>();
            nodeData.put("name", jsonKey);
            nodeData.put("description", jsonKey);
            nodeData.put("required", Boolean.FALSE);
            nodeData.put("default_value", null);
            JsonHelper.innerSetNodeData(jsonDataMap, jsonKey, node, nodeData, "type");
            rootNode.addChild(node);
            node.setData(nodeData);
        }
    }

    public static void innerSetNodeData(Map<String, Object> jsonDataMap, String jsonKey, TreeNode node, Map<String, Object> nodeData, String typeField) {
        Object o = jsonDataMap.get(jsonKey);
        if (o instanceof Map) {
            nodeData.put(typeField, "STRUCT");
            Map childMap = (Map)jsonDataMap.get(jsonKey);
            JsonHelper.jsonMapToApiTreeNode(childMap, node);
        } else if (o instanceof List) {
            List entrylists = (List)o;
            nodeData.put(typeField, "STRUCT");
            JsonHelper.setDataFromList(node, nodeData, entrylists, typeField, jsonKey);
        } else {
            JsonHelper.setDefaultType(jsonKey, nodeData, typeField, o);
        }
    }

    public static void setDefaultType(String jsonKey, Map<String, Object> nodeData, String typeField, Object o) {
        if (o instanceof Integer) {
            nodeData.put(typeField, "int");
        } else if (o instanceof Boolean) {
            nodeData.put(typeField, "boolean");
        } else if (o == null || o instanceof String) {
            nodeData.put(typeField, "string");
        } else if (o instanceof Long) {
            nodeData.put(typeField, "long");
        } else if (o instanceof Double) {
            nodeData.put(typeField, "double");
        } else if (o instanceof BigDecimal) {
            nodeData.put(typeField, "decimal");
        } else {
            throw new IllegalArgumentException(String.format(ResManager.loadKDString((String)"\u8be5json\u6570\u636e\u89e3\u6790\u540e\u65e0\u6cd5\u8fdb\u884c\u5339\u914d\uff0c\u5b57\u6bb5\u5185\u5bb9\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u3002%1$s%2$s", (String)"TripSyncPullSelPlugin_13", (String)"fi-er-business", (Object[])new Object[0]), jsonKey, o));
        }
    }

    public static void setDataFromList(TreeNode node, Map<String, Object> nodeData, List entrylists, String typeField, String jsonKey) {
        nodeData.put("isArray", Boolean.TRUE);
        String id = node.getId().replace(jsonKey, "");
        jsonKey = jsonKey + ".[0]";
        node.setParentid(id);
        node.setId(id.isEmpty() ? jsonKey : id + jsonKey);
        node.setText(jsonKey);
        nodeData.put("name", jsonKey);
        nodeData.put("description", jsonKey);
        if (!entrylists.isEmpty()) {
            Object list = entrylists.get(0);
            if (list instanceof Map) {
                JsonHelper.jsonMapToApiTreeNode((Map)list, node);
            } else {
                JsonHelper.setDefaultType(jsonKey, nodeData, typeField, list);
            }
        }
    }

    public static Map<String, Object> parseParam(Set<String> stringSet, List<Map<String, Object>> list, Object row) {
        LinkedHashMap<String, Object> ret = new LinkedHashMap<String, Object>();
        if (stringSet.isEmpty()) {
            return ret;
        }
        for (String fields : stringSet) {
            if (fields.isEmpty()) continue;
            ArrayList<Map<String, Object>> subList = new ArrayList<Map<String, Object>>(list.size());
            HashSet subSet = Sets.newHashSetWithExpectedSize((int)list.size());
            for (Map<String, Object> map : list) {
                String[] fieldarr;
                HashMap<String, Object> m = new HashMap<String, Object>(2);
                String field = map.getOrDefault("field", "").toString();
                if (!field.startsWith(fields)) continue;
                Object value = map.get("value");
                String subfield = field.replace(fields, "");
                if (subfield.startsWith(".")) {
                    subfield = subfield.replaceFirst("\\.", "");
                }
                if ((fieldarr = subfield.split("\\.")).length == 0) continue;
                subSet.add(fieldarr[0]);
                m.put("field", subfield);
                m.put("value", value);
                subList.add(m);
            }
            for (Map<String, Object> map : list) {
                String field = map.getOrDefault("field", "").toString();
                if (!field.startsWith(fields)) continue;
                Object value = map.get("value");
                String subfield = field.replace(fields, "");
                if (subfield.startsWith(".")) {
                    subfield = subfield.replaceFirst("\\.", "");
                }
                if (!subfield.isEmpty()) {
                    Map<String, Object> innerMap = JsonHelper.parseParam(subSet, subList, row);
                    JsonHelper.dealList(fields, ret, innerMap, row);
                    continue;
                }
                JsonHelper.dealList(fields, ret, value, row);
            }
        }
        return ret;
    }

    public static void dealList(String field, Map<String, Object> ret, Object obj, Object row) {
        if (field.startsWith("[")) {
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(obj);
            String head = field.replaceAll("\\[", "").replaceAll("]", "");
            ret.put(head, list);
            return;
        }
        if (null == row) {
            ret.put(field, obj);
            return;
        }
        if (obj instanceof DynamicObject) {
            DynamicObject dynamicObject = (DynamicObject)obj;
            Row data = (Row)row;
            String mapstatus = dynamicObject.getString("mapstatus");
            if (!mapstatus.equals("1")) {
                return;
            }
            String maptype = dynamicObject.getString("maptype");
            String mapdesign = dynamicObject.getString("mapdesign");
            String mapsourcefield = dynamicObject.getString("mapsourcefield");
            Boolean mapprimarykey = dynamicObject.getBoolean("mapprimarykey");
            if (null != dynamicObject.getString("maptypeext") && !dynamicObject.getString("maptypeext").isEmpty() || null != dynamicObject.getString("mapdesignext") && !dynamicObject.getString("mapdesignext").isEmpty() || null != dynamicObject.getString("mapsourcefieldext") && !dynamicObject.getString("mapsourcefieldext").isEmpty()) {
                maptype = dynamicObject.getString("maptypeext");
                mapdesign = dynamicObject.getString("mapdesignext");
                mapsourcefield = dynamicObject.getString("mapsourcefieldext");
            }
            switch (maptype) {
                case "1": {
                    ret.put(field, data.getString(mapsourcefield));
                    break;
                }
                case "2": {
                    ret.put(field, mapsourcefield);
                    break;
                }
                case "3": {
                    ret.put(field, mapdesign);
                    break;
                }
                case "4": {
                    Object object = null;
                    try {
                        Class<?> o = Class.forName(mapdesign.substring(0, mapdesign.lastIndexOf(".")));
                        Object o1 = o.newInstance();
                        Method plugin = o.getMethod(mapdesign.substring(mapdesign.lastIndexOf(".") + 1), Row.class, String.class);
                        object = plugin.invoke(o1, data, mapsourcefield);
                    }
                    catch (Exception e) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6620\u5c04\uff0c\u5904\u7406\u7c7b\u4e0d\u5b58\u5728\u6216\u5904\u7406\u7c7b\u6ca1\u6709\u65e0\u53c2\u6784\u9020\u5668,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u5e76\u91cd\u65b0\u90e8\u7f72\u5904\u7406\u7c7b\u3002", (String)"TripServiceFactory_3", (String)"fi-er-business", (Object[])new Object[0]));
                    }
                    ret.put(field, object);
                }
            }
            return;
        }
        ret.put(field, obj);
    }

    public static JSONObject compareTwoJson(String oldJsonStr, String newJsonStr, String filtercondition) {
        LinkedHashMap<String, Object> oldJsonToMap = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> newJsonToMap = new LinkedHashMap<String, Object>();
        JsonHelper.convertJsonToMap(JSON.parseObject((String)oldJsonStr), "", oldJsonToMap);
        JsonHelper.convertJsonToMap(JSON.parseObject((String)newJsonStr), "", newJsonToMap);
        Map<String, Object> differenceMap = JsonHelper.compareTwoMaps(oldJsonToMap, newJsonToMap, filtercondition);
        return JsonHelper.convertMapToJson(differenceMap);
    }

    public static void convertJsonToMap(Object json, String root, Map<String, Object> jsonToMap) {
        if (json instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)json;
            for (Object key : jsonObject.keySet()) {
                Object value = jsonObject.get(key);
                String newRoot = "".equals(root) ? key + "" : root + "." + key;
                JsonHelper.fillInResultMap(value, newRoot, jsonToMap);
            }
        } else if (json instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)json;
            Iterator iterator = jsonArray.iterator();
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (null != next && (!(next instanceof JSONObject) || !((JSONObject)next).entrySet().isEmpty()) && (!(next instanceof JSONArray) || !((JSONArray)next).isEmpty())) continue;
                iterator.remove();
            }
            Stream.iterate(0, integer -> integer + 1).limit(jsonArray.size()).forEach(index -> {
                Object value = jsonArray.get(index.intValue());
                String newRoot = "".equals(root) ? "[" + index + "]" : root + ".[" + index + "]";
                JsonHelper.fillInResultMap(value, newRoot, jsonToMap);
            });
        }
    }

    public static void fillInResultMap(Object value, String newRoot, Map<String, Object> jsonToMap) {
        if (value instanceof JSONObject || value instanceof JSONArray) {
            JsonHelper.convertJsonToMap(value, newRoot, jsonToMap);
        } else {
            jsonToMap.put(newRoot, value);
        }
    }

    private static Map<String, Object> mergeTwoMaps(Map<String, Object> oldJsonMap, Map<String, Object> newJsonMap, String pkey) {
        String lastkey = "";
        if (pkey.indexOf("]") != -1) {
            lastkey = pkey.substring(0, pkey.lastIndexOf(".[")) + ".[";
        }
        Integer index = JsonHelper.getMaxIndex(newJsonMap, lastkey);
        for (Map.Entry<String, Object> next : oldJsonMap.entrySet()) {
            String k = next.getKey();
            String key = JsonHelper.getKey(lastkey, index + 1, k);
            if (!key.startsWith(lastkey)) continue;
            newJsonMap.put(key, next.getValue());
        }
        return newJsonMap;
    }

    public static String getKey(String lastkey, int i, String key) {
        if (null != lastkey && !lastkey.isEmpty() && key.startsWith(lastkey)) {
            key = key.replace(lastkey, "");
            String ik = key.substring(0, key.indexOf("]"));
            String ks = key.substring(key.indexOf("]"));
            Integer indexkey = 0;
            if (!ik.isEmpty()) {
                indexkey = Integer.parseInt(ik) + i;
            }
            key = lastkey + indexkey + ks;
        }
        return key;
    }

    public static Integer getMaxIndex(Map<String, Object> newJsonMap, String lastkey) {
        Iterator<Map.Entry<String, Object>> iterator = newJsonMap.entrySet().iterator();
        Integer index = 0;
        while (iterator.hasNext()) {
            Integer indexkey;
            Map.Entry<String, Object> next = iterator.next();
            String key = next.getKey();
            if (!key.startsWith(lastkey)) continue;
            key = key.replace(lastkey, "");
            if ((key = key.substring(0, key.indexOf("]"))).isEmpty() || (indexkey = Integer.valueOf(key)) <= index) continue;
            index = indexkey;
        }
        return index;
    }

    public static Map<String, Object> compareTwoMaps(Map<String, Object> oldJsonMap, Map<String, Object> newJsonMap, String filtercondition) {
        ArrayList keys = new ArrayList(oldJsonMap.size());
        AtomicInteger i = new AtomicInteger();
        for (Map.Entry<String, Object> newnext : newJsonMap.entrySet()) {
            String k = newnext.getKey();
            Object v = newnext.getValue();
            ArrayList<String> keyList = new ArrayList<String>(oldJsonMap.size());
            for (Map.Entry<String, Object> oldnext : oldJsonMap.entrySet()) {
                String key = oldnext.getKey();
                if (!JsonHelper.getZeroKey(key).equals(JsonHelper.getZeroKey(k))) continue;
                Object vo = oldnext.getValue();
                Boolean iscondition = Boolean.FALSE;
                if (null == filtercondition) {
                    iscondition = vo.toString().equals(v.toString());
                } else {
                    switch (filtercondition) {
                        case "=": {
                            iscondition = vo.toString().equals(v.toString());
                            break;
                        }
                        case ">": {
                            if (vo instanceof Date && v instanceof Date) {
                                iscondition = ((Date)vo).after((Date)v);
                                break;
                            }
                            iscondition = new BigDecimal(vo.toString()).compareTo(new BigDecimal(v.toString())) > 0;
                            break;
                        }
                        case "<": {
                            if (vo instanceof Date && v instanceof Date) {
                                iscondition = ((Date)vo).before((Date)v);
                                break;
                            }
                            iscondition = new BigDecimal(vo.toString()).compareTo(new BigDecimal(v.toString())) < 0;
                            break;
                        }
                        case "!=": {
                            iscondition = !vo.toString().equals(v.toString());
                            break;
                        }
                        case "in": {
                            iscondition = Arrays.asList(v.toString().split(",")).contains(vo.toString());
                            break;
                        }
                        case "is null": {
                            iscondition = vo == null || vo.toString().isEmpty();
                            break;
                        }
                        case "is not null": {
                            iscondition = vo != null && !vo.toString().isEmpty();
                        }
                    }
                }
                if (!iscondition.booleanValue()) continue;
                String curLastkey = "";
                if (key.contains("].")) {
                    curLastkey = key.substring(0, key.lastIndexOf("].") + 2);
                }
                keyList.add(curLastkey);
            }
            if (i.get() == 0) {
                keys.addAll(keyList);
            } else if (keyList.size() > 0) {
                keys.retainAll(keyList);
            } else {
                keys.clear();
            }
            i.getAndIncrement();
        }
        Iterator<Map.Entry<String, Object>> iterator = oldJsonMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> next = iterator.next();
            String key = next.getKey();
            for (String k : keys) {
                if (!key.startsWith(k)) continue;
                iterator.remove();
            }
        }
        return oldJsonMap;
    }

    private static List<String> likeMapKeyList(Map<String, Object> oldJsonMap, String lastkey) {
        ArrayList<String> keyList = new ArrayList<String>(oldJsonMap.size());
        for (Map.Entry<String, Object> next : oldJsonMap.entrySet()) {
            String key = next.getKey();
            if (!key.startsWith(lastkey)) continue;
            keyList.add(key);
        }
        return keyList;
    }

    public static JSONObject convertMapToJson(Map<String, Object> map) {
        JSONObject resultJSONObject = new JSONObject();
        for (Map.Entry<String, Object> item : map.entrySet()) {
            String key = item.getKey();
            Object value = item.getValue();
            String[] paths = key.split("\\.");
            int i = 0;
            Object remarkObject = new Object();
            int indexAll = paths.length - 1;
            while (i <= paths.length - 1) {
                String path = paths[i];
                if (i == 0) {
                    if (resultJSONObject.containsKey((Object)path)) {
                        remarkObject = resultJSONObject.get((Object)path);
                    } else if (indexAll > i) {
                        remarkObject = paths[i + 1].indexOf("]") != -1 ? new JSONArray() : new JSONObject();
                        resultJSONObject.put(path, remarkObject);
                    } else {
                        resultJSONObject.put(path, value);
                    }
                    ++i;
                    continue;
                }
                if (path.contains("]")) {
                    int startIndex = path.lastIndexOf("[");
                    int endIndext = path.lastIndexOf("]");
                    int index = Integer.parseInt(path.substring(startIndex + 1, endIndext));
                    if (indexAll > i) {
                        if (paths[i + 1].contains("]")) {
                            while (((JSONArray)remarkObject).size() <= index) {
                                if (((JSONArray)remarkObject).size() == index) {
                                    ((JSONArray)remarkObject).add(index, (Object)new JSONArray());
                                    continue;
                                }
                                ((JSONArray)remarkObject).add(null);
                            }
                        } else {
                            while (((JSONArray)remarkObject).size() <= index) {
                                if (((JSONArray)remarkObject).size() == index) {
                                    ((JSONArray)remarkObject).add(index, (Object)new JSONObject());
                                    continue;
                                }
                                ((JSONArray)remarkObject).add(null);
                            }
                        }
                        remarkObject = ((JSONArray)remarkObject).get(index);
                    } else {
                        while (((JSONArray)remarkObject).size() <= index) {
                            if (((JSONArray)remarkObject).size() == index) {
                                ((JSONArray)remarkObject).add(index, value);
                                continue;
                            }
                            ((JSONArray)remarkObject).add(null);
                        }
                    }
                } else if (indexAll > i) {
                    if (paths[i + 1].contains("]")) {
                        if (!((JSONObject)remarkObject).containsKey((Object)path)) {
                            ((JSONObject)remarkObject).put(path, (Object)new JSONArray());
                        }
                    } else if (!((JSONObject)remarkObject).containsKey((Object)path)) {
                        ((JSONObject)remarkObject).put(path, (Object)new JSONObject());
                    }
                    remarkObject = ((JSONObject)remarkObject).get((Object)path);
                } else {
                    ((JSONObject)remarkObject).put(path, value);
                }
                ++i;
            }
        }
        return resultJSONObject;
    }

    public static JSONObject newConvertMapToJson(Map<String, Object> map) {
        String mapStr = JSON.toJSONString(map);
        JSONObject jsonObject = JSONObject.parseObject((String)mapStr);
        HashMap<String, String[]> keyArray = JsonHelper.getKeyArray(map);
        JSONObject assembledJson = new JSONObject();
        for (Map.Entry<String, String[]> entry : keyArray.entrySet()) {
            String key = entry.getKey();
            JsonHelper.assembleJson(assembledJson, key, jsonObject.get((Object)key));
        }
        return assembledJson;
    }

    private static HashMap<String, String[]> getKeyArray(Map<String, Object> map) {
        LinkedHashMap<String, String[]> hashMap = new LinkedHashMap<String, String[]>();
        for (String key : map.keySet()) {
            String[] keys = key.split("\\.");
            hashMap.put(key, keys);
        }
        return hashMap;
    }

    public static void assembleJson(JSONObject json, String keyPath, Object value) {
        String[] keys = keyPath.split("\\.");
        JSONObject current = json;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (i == keys.length - 1) {
                if (value != null && value.toString().startsWith("[")) {
                    JSONArray jsonArray = JSONArray.parseArray((String)value.toString());
                    current.put(key, (Object)jsonArray);
                    continue;
                }
                current.put(key, value);
                continue;
            }
            if (key.endsWith("]")) {
                JSONObject nestedJsonObject;
                int index = Integer.parseInt(key.substring(key.indexOf(91) + 1, key.indexOf(93)));
                JSONArray jsonArray = current.getJSONArray(keys[i - 1]);
                if (jsonArray == null) {
                    jsonArray = new JSONArray();
                    current.put(keys[i - 1], (Object)jsonArray);
                }
                if (jsonArray.size() > index) {
                    nestedJsonObject = jsonArray.getJSONObject(index);
                } else {
                    nestedJsonObject = new JSONObject();
                    jsonArray.add((Object)nestedJsonObject);
                }
                current = nestedJsonObject;
                continue;
            }
            if (i + 1 < keys.length && keys[i + 1].endsWith("]")) continue;
            if (!current.containsKey((Object)key)) {
                current.put(key, (Object)new JSONObject());
            }
            current = current.getJSONObject(key);
        }
    }

    public static <k, v> List mapByKeyToSort(Map<k, v> map, final Comparator keySort) {
        ArrayList<Map.Entry<k, v>> entryList = new ArrayList<Map.Entry<k, v>>(map.entrySet());
        Collections.sort(entryList, new Comparator<Map.Entry<k, v>>(){

            @Override
            public int compare(Map.Entry<k, v> o1, Map.Entry<k, v> o2) {
                return keySort.compare(o1.getKey(), o2.getKey());
            }
        });
        return entryList;
    }

    public static JSONArray jsonArrayToSort(JSONArray jsonArray, final String fildName, final boolean isAsc) {
        JSONArray afterSortJsonArray = new JSONArray();
        ArrayList objectList = new ArrayList();
        jsonArray.forEach(obj -> objectList.add((JSONObject)obj));
        Collections.sort(objectList, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                String fildValueA = o1.getString(fildName);
                String fildValueB = o2.getString(fildName);
                if (isAsc) {
                    return fildValueA.compareTo(fildValueB);
                }
                return fildValueB.compareTo(fildValueA);
            }
        });
        objectList.forEach(obj -> afterSortJsonArray.add(obj));
        return afterSortJsonArray;
    }

    public static String getJkey(String lastkey, String pkey, String mapsourcefield) {
        String lastfieldkey = mapsourcefield;
        String field = JsonHelper.getZeroKey(mapsourcefield);
        if (mapsourcefield.contains(lastkey + ".[")) {
            lastfieldkey = field.substring(0, field.lastIndexOf(lastkey + ".[") + lastkey.length());
        }
        if (lastkey.equals(lastfieldkey)) {
            field = pkey.substring(0, pkey.lastIndexOf("].")) + mapsourcefield.substring(lastkey.length() + ".[0".length());
        }
        return field;
    }

    public static String getAddKey(String pkey, Map<String, Object> jsonToMap, String patch) {
        StringBuilder newkey = new StringBuilder();
        if (!pkey.contains("]")) {
            return newkey.toString();
        }
        String[] s = pkey.split("\\.");
        for (int i = 0; i < s.length; ++i) {
            String s1 = s[i];
            if (!s1.contains("]")) {
                newkey = new StringBuilder(newkey.length() == 0 ? s1 : newkey.append(".").append(s1));
                continue;
            }
            if (newkey.length() == 0) {
                newkey.append(s1).append(".[").append(i).append("]");
                continue;
            }
            if (s[i - 1].equals(patch)) {
                int startIndex = s1.lastIndexOf("[");
                int endIndext = s1.lastIndexOf("]");
                int index = Integer.parseInt(s1.substring(startIndex + 1, endIndext));
                newkey.append(".[").append(index + 1).append("]");
                continue;
            }
            if (pkey.indexOf(s[i - 1]) < pkey.indexOf(patch)) {
                newkey.append(".").append(s1);
                continue;
            }
            newkey.append(".[0]");
        }
        if (jsonToMap.containsKey(newkey.toString())) {
            return newkey.toString();
        }
        if ((patch = JsonHelper.getPatch(pkey, patch)).isEmpty() || pkey.startsWith(patch + ".") && !pkey.startsWith(patch + ".[")) {
            return "";
        }
        return JsonHelper.getAddKey(newkey.toString(), jsonToMap, patch);
    }

    public static String getPatch(String pkey, String patch) {
        if (patch.isEmpty() && pkey.contains(".[")) {
            patch = pkey.substring(0, pkey.lastIndexOf(".["));
            String[] c = patch.split("\\.");
            patch = c[c.length - 1];
        } else {
            String[] c;
            if (pkey.lastIndexOf(patch) == 0) {
                return "";
            }
            patch = pkey.substring(0, pkey.lastIndexOf(patch) - 1);
            for (String s : c = patch.split("\\.")) {
                if (s.contains("]")) continue;
                patch = s;
            }
        }
        return patch;
    }

    public static String getZeroKey(String key) {
        if (key.contains("]")) {
            String[] s;
            String newkey = "";
            for (String s1 : s = key.split("\\.")) {
                if (s1.contains("]")) {
                    if (newkey.isEmpty()) {
                        newkey = s1 + ".[0]";
                        continue;
                    }
                    newkey = newkey + ".[0]";
                    continue;
                }
                newkey = newkey.isEmpty() ? s1 : newkey + "." + s1;
            }
            return newkey;
        }
        return key;
    }
}

