/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ReceiveEntryPropChange {
    private IDataModel getValueModel;
    private IDataModel setValueModel;
    protected static Log logger = LogFactory.getLog(ReceiveEntryPropChange.class);
    private BigDecimal diff = ErStdConfig.getAccentryDiffRange();

    public ReceiveEntryPropChange(IDataModel getValueModel, IDataModel setValueModel) {
        this.getValueModel = getValueModel;
        this.setValueModel = setValueModel;
    }

    public ReceiveEntryPropChange(IDataModel model) {
        this(model, model);
    }

    public void orireceiveamountChange(Object propValue, int rowIndex) {
        this.refreshAmount(rowIndex);
        this.handleDiiff("accountentry", "receiveamount", "orireceiveamount", "accexchangerate", "currency");
    }

    public void accExchangeRateChange(Object propValue, int rowIndex, IFormView view) {
        if (this.needReForwardCalc()) {
            this.refreshOriAmount(propValue, rowIndex, view);
        } else {
            this.orireceiveamountChange(propValue, rowIndex);
        }
    }

    private boolean needReForwardCalc() {
        Object isCurrency = this.getValueModel.getValue("iscurrency");
        boolean needReForwardCalc = false;
        if (Boolean.TRUE.equals(isCurrency)) {
            int rowCount = 0;
            DynamicObjectCollection first = this.getValueModel.getDataEntity(true).getDynamicObjectCollection("accountentry");
            if (this.pageSplit()) {
                HashSet idSet = Sets.newHashSet();
                DynamicObjectCollection second = this.setValueModel.getDataEntity(true).getDynamicObjectCollection("accountentry");
                if (first.size() <= 1 && second.size() <= 1) {
                    second.forEach(v -> idSet.add(v.getPkValue()));
                    first.forEach(v -> idSet.add(v.getPkValue()));
                }
                rowCount = idSet.size();
            } else {
                rowCount = first.stream().toArray().length;
            }
            needReForwardCalc = rowCount == 1;
        }
        return needReForwardCalc;
    }

    private boolean pageSplit() {
        return !this.getValueModel.equals(this.setValueModel);
    }

    public void refreshOriAmount(Object propValue, int rowIndex, IFormView view) {
        BigDecimal oriamount;
        BigDecimal encashAmount = AmountChangeUtil.getCashAmount(this.getValueModel);
        BigDecimal exchangeRate = (BigDecimal)propValue;
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            exchangeRate = BigDecimal.ONE;
        }
        DynamicObject accountcurrency = (DynamicObject)this.setValueModel.getValue("accountcurrency", 0);
        String accQuoteType = (String)this.setValueModel.getValue("accquotetype", 0);
        BigDecimal accountRate = (BigDecimal)this.setValueModel.getValue("accexchangerate", 0);
        if (this.loanEntryEleSame(accountcurrency) && this.allCurrencyEleSame(accountcurrency, accQuoteType, accountRate)) {
            oriamount = ReceiveEntryPropChange.directAmount(this.getValueModel, true);
            BigDecimal amount = ReceiveEntryPropChange.directAmount(this.getValueModel, false);
            if (amount.compareTo(encashAmount) != 0) {
                AmountChangeUtil.setCashAmount(this.getValueModel, amount);
                encashAmount = amount;
            }
        } else {
            String quoteType = this.setValueModel.getProperty("accquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)this.setValueModel.getValue("accquotetype", rowIndex)), (Object)"0");
            DynamicObject accountCurrency = (DynamicObject)this.setValueModel.getValue("accountcurrency", rowIndex);
            int amtprecision = accountCurrency == null ? ((DynamicObject)this.setValueModel.getValue("currency")).getInt("amtprecision") : accountCurrency.getInt("amtprecision");
            oriamount = AmountUtils.getOriAmount(encashAmount, exchangeRate, amtprecision, quoteType);
        }
        this.setValueModel.beginInit();
        this.setValueModel.setValue("orireceiveamount", (Object)oriamount, rowIndex);
        this.setValueModel.endInit();
        view.updateView("orireceiveamount", rowIndex);
        this.setValueModel.setValue("receiveamount", (Object)encashAmount, rowIndex);
        this.setValueModel.setValue("accnotpayamount", (Object)encashAmount, rowIndex);
        this.setValueModel.setValue("oriaccnotpayamount", (Object)oriamount, rowIndex);
        view.updateView("accnotpayamount", rowIndex);
        Label encashLabel = (Label)view.getControl("totalencashamountlabel");
        if (encashLabel != null) {
            if (this.getValueModel.getProperty("currency") != null) {
                DynamicObject currency = (DynamicObject)this.getValueModel.getValue("currency");
                if (currency != null) {
                    String formatMoneyByUser = AmountUtils.formatMoneyByUser(Long.valueOf(RequestContext.get().getUserId()), currency.getString("sign"), currency.getInt("amtprecision"), encashAmount.setScale(currency.getInt("amtprecision"), RoundingMode.HALF_UP));
                    encashLabel.setText(formatMoneyByUser);
                }
            } else {
                encashLabel.setText(encashAmount.toString());
            }
        }
    }

    public void handleDiiff(String accountentry, String accReceiveamount, String accOriReceiveAmount, String accExchangeRate, String currency) {
        if (!this.needReForwardCalc()) {
            logger.info(">>>>>>>>>>>>>>...>>>>\u5f00\u59cb\u5904\u7406\u5c3e\u5dee>>>>");
            boolean flag = this.isExchangerateNotOne(accountentry, accExchangeRate);
            if (!flag) {
                return;
            }
            int currencyPrecision = AmountUtils.getCurrencyPrecision(this.getValueModel, currency);
            int accountEntrySize = this.setValueModel.getEntryRowCount(accountentry);
            BigDecimal totalEntryReceiveAmount = BigDecimal.ZERO;
            int lastRowIndex = -1;
            for (int rowIndex = 0; rowIndex < accountEntrySize; ++rowIndex) {
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)this.setValueModel.getValue(accExchangeRate, rowIndex)), (Object)BigDecimal.ONE);
                BigDecimal oriReceiveAmount = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)this.setValueModel.getValue(accOriReceiveAmount, rowIndex)), (Object)BigDecimal.ZERO);
                if (exchangeRate.compareTo(BigDecimal.ONE) != 0 && oriReceiveAmount.compareTo(BigDecimal.ZERO) != 0) {
                    lastRowIndex = rowIndex;
                }
                String quoteType = this.setValueModel.getProperty("accquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)this.setValueModel.getValue("accquotetype", rowIndex)), (Object)"0");
                BigDecimal receiveAmount = AmountUtils.getCurrencyAmount(oriReceiveAmount, exchangeRate, currencyPrecision, quoteType);
                this.setValueModel.setValue(accReceiveamount, (Object)receiveAmount, rowIndex);
                this.setValueModel.setValue("accnotpayamount", (Object)receiveAmount, rowIndex);
                totalEntryReceiveAmount = totalEntryReceiveAmount.add(receiveAmount);
            }
            BigDecimal encashamount = AmountChangeUtil.getCashAmount(this.getValueModel);
            BigDecimal tailDiff = encashamount.subtract(totalEntryReceiveAmount);
            logger.info(">>>>>>totalEntryReceiveAmount\uff1a" + totalEntryReceiveAmount + ">>>>> encashamount:" + encashamount + ">>>>>tailDiff:" + tailDiff);
            if (lastRowIndex != -1 && accountEntrySize > 0 && tailDiff.compareTo(this.diff) <= 0 && tailDiff.compareTo(this.diff.multiply(BigDecimal.valueOf(-1L))) >= 0) {
                BigDecimal lastExchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)this.setValueModel.getValue(accExchangeRate, lastRowIndex)), (Object)BigDecimal.ONE);
                BigDecimal lastOriAmount = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)this.setValueModel.getValue(accOriReceiveAmount, lastRowIndex)), (Object)BigDecimal.ZERO);
                String quoteType = this.setValueModel.getProperty("accquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)this.setValueModel.getValue("accquotetype", lastRowIndex)), (Object)"0");
                BigDecimal lastRowAmount = AmountUtils.getCurrencyAmount(lastOriAmount, lastExchangeRate, currencyPrecision, quoteType);
                this.setValueModel.setValue(accReceiveamount, (Object)tailDiff.add(lastRowAmount), lastRowIndex);
                this.setValueModel.setValue("accnotpayamount", (Object)tailDiff.add(lastRowAmount), lastRowIndex);
                logger.info(">>>>>>>>>>>>>>...>>>>\u5c3e\u5dee\u5904\u7406\u7ed3\u675f>>>>");
            }
        }
    }

    public boolean isExchangerateNotOne(String entryName, String exchangerateName) {
        DynamicObjectCollection entry = this.getValueModel.getEntryEntity(entryName);
        boolean flag = false;
        for (DynamicObject detail : entry) {
            BigDecimal exchangerate = detail.getBigDecimal(exchangerateName);
            if (exchangerate == null || exchangerate.compareTo(BigDecimal.ONE) == 0) continue;
            flag = true;
            break;
        }
        return flag;
    }

    private void refreshAmount(int rowIndex) {
        this.refreshEntryAmount("accountentry", "orireceiveamount", "receiveamount", "accexchangerate", "accquotetype", rowIndex);
        BigDecimal oriPayedAmount = BigDecimal.ZERO;
        BigDecimal payedAmount = BigDecimal.ZERO;
        if (this.setValueModel.getProperty("oriaccpayedamount") != null) {
            oriPayedAmount = (BigDecimal)this.setValueModel.getValue("oriaccpayedamount", rowIndex);
        }
        if (this.setValueModel.getProperty("accpayedamount") != null) {
            payedAmount = (BigDecimal)this.setValueModel.getValue("accpayedamount", rowIndex);
        }
        BigDecimal oriRecAmount = (BigDecimal)this.setValueModel.getValue("orireceiveamount", rowIndex);
        BigDecimal recAmount = (BigDecimal)this.setValueModel.getValue("receiveamount", rowIndex);
        this.setValueModel.setValue("oriaccnotpayamount", (Object)oriRecAmount.subtract(oriPayedAmount), rowIndex);
        this.setValueModel.setValue("accnotpayamount", (Object)recAmount.subtract(payedAmount), rowIndex);
    }

    @Deprecated
    public void refreshEntryAmount(String entryField, String oriAmountField, String amountField, String exchangeRateField, int rowIndex) {
        int rowNum;
        if (rowIndex == -1) {
            rowIndex = 0;
        }
        if ((rowNum = this.setValueModel.getEntryRowCount(entryField)) == 0) {
            return;
        }
        BigDecimal oriAmount = (BigDecimal)this.setValueModel.getValue(oriAmountField, rowIndex);
        BigDecimal exchangeRate = (BigDecimal)this.setValueModel.getValue(exchangeRateField, rowIndex);
        if (exchangeRate == null) {
            exchangeRate = BigDecimal.ONE;
        }
        BigDecimal amount = oriAmount.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision(this.setValueModel, "currency"), 4);
        this.setValueModel.setValue(amountField, (Object)amount, rowIndex);
    }

    public void refreshEntryAmount(String entryField, String oriAmountField, String amountField, String exchangeRateField, String quoteTypeField, int rowIndex) {
        int rowNum;
        if (rowIndex == -1) {
            rowIndex = 0;
        }
        if ((rowNum = this.setValueModel.getEntryRowCount(entryField)) == 0) {
            return;
        }
        BigDecimal oriAmount = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)this.setValueModel.getValue(oriAmountField, rowIndex)), (Object)BigDecimal.ZERO);
        BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)this.setValueModel.getValue(exchangeRateField, rowIndex)), (Object)BigDecimal.ONE);
        String quoteType = this.setValueModel.getProperty(quoteTypeField) == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)this.setValueModel.getValue(quoteTypeField, rowIndex)), (Object)"0");
        BigDecimal amount = AmountUtils.getCurrencyAmount(oriAmount, exchangeRate, AmountUtils.getCurrencyPrecision(this.setValueModel, "currency"), quoteType);
        this.setValueModel.setValue(amountField, (Object)amount, rowIndex);
    }

    public static BigDecimal directAmount(IDataModel model, boolean isOri) {
        BigDecimal sumApprveAmount = BigDecimal.ZERO;
        BigDecimal sumAccloanAmount = BigDecimal.ZERO;
        BigDecimal sumProxyAmount = BigDecimal.ZERO;
        if (model.getProperty("expenseentryentity") != null) {
            String ApprveAmount = isOri ? "expeapproveamount" : "expeapprovecurramount";
            String accloanamount = isOri ? "accloanamount" : "curraccloanamount";
            String proxyamt = isOri ? "proxyamt" : "curproxyamt";
            String monthSettleAmt = isOri ? "tripbookamount" : "tripbookcuramount";
            sumApprveAmount = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity").stream().map(v -> v.getBigDecimal(ApprveAmount)).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            if (model.getProperty("writeoffmoney") != null) {
                sumAccloanAmount = model.getDataEntity(true).getDynamicObjectCollection("writeoffmoney").stream().map(v -> v.getBigDecimal(accloanamount)).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            }
            if (model.getProperty(proxyamt) != null && ((Boolean)model.getValue("proxytax")).booleanValue()) {
                sumProxyAmount = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity").stream().map(v -> v.getBigDecimal(proxyamt)).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            }
            if (model.getProperty(monthSettleAmt) != null) {
                BigDecimal monthSettleAmount = AmountUtils.getEntryAmount(model, "expenseentryentity", monthSettleAmt);
                sumApprveAmount = sumApprveAmount.subtract(monthSettleAmount);
            }
        } else if (model.getProperty("entryentity") != null) {
            String ApprveAmount = isOri ? "orientryappamount" : "entryappamount";
            String accloanamount = isOri ? "loanclearoriamount" : "loanclearamount";
            String reqAmount = isOri ? "triporiaccappamount" : "tripaccappamount";
            sumApprveAmount = ErEntityTypeUtils.isTripReqBill(model.getDataEntityType().getName()) ? model.getEntryEntity("tripentry").stream().map(v -> v.getBigDecimal(reqAmount)).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO) : model.getEntryEntity("tripentry").stream().flatMap(tripEntry -> tripEntry.getDynamicObjectCollection("entryentity").stream().filter(v -> !"2".equals(v.getString("settlementtype"))).map(v -> v.getBigDecimal(ApprveAmount))).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            if (model.getProperty("clearloanentry") != null) {
                sumAccloanAmount = model.getEntryEntity("clearloanentry").stream().map(v -> v.getBigDecimal(accloanamount)).reduce((a, b) -> a.add((BigDecimal)b)).orElse(BigDecimal.ZERO);
            }
        }
        return sumApprveAmount.subtract(sumAccloanAmount).subtract(sumProxyAmount);
    }

    private boolean checkAllCurrencyEleIsAccCurrency(IDataModel model, String entryName, String eleName, Object accEle, boolean defaultFlag) {
        Stream stream;
        if (model.getProperty(entryName) == null || model.getProperty(eleName) == null) {
            return defaultFlag;
        }
        DynamicObjectCollection entry = model.getEntryEntity(entryName);
        if (entry.size() == 0) {
            return defaultFlag;
        }
        switch (entryName) {
            case "tripentry": {
                if (!ErEntityTypeUtils.isTripReqBill(model.getDataEntityType().getName())) {
                    stream = entry.stream().flatMap(tripEntry -> tripEntry.getDynamicObjectCollection("entryentity").stream()).filter(x -> !"2".equals(x.getString("settlementtype"))).collect(Collectors.toList()).stream();
                    break;
                }
            }
            case "clearloanentry": 
            case "expenseentryentity": 
            case "writeoffmoney": {
                stream = entry.stream();
                break;
            }
            default: {
                return false;
            }
        }
        return !stream.anyMatch(v -> {
            if (accEle instanceof String) {
                return !StringUtils.equals((CharSequence)((String)accEle), (CharSequence)v.getString(eleName));
            }
            if (accEle instanceof BigDecimal) {
                return v.getBigDecimal(eleName).compareTo((BigDecimal)accEle) != 0;
            }
            if (accEle instanceof DynamicObject) {
                DynamicObject entryCurrency = v.getDynamicObject(eleName);
                return entryCurrency != null && entryCurrency.getLong("id") != ErCommonUtils.getPk(accEle).longValue();
            }
            return false;
        });
    }

    @Deprecated
    public boolean entryAllRateIsAccRate(IDataModel model, String entryName, String rateName, BigDecimal accRate, Boolean defaultFlag) {
        return this.checkAllCurrencyEleIsAccCurrency(model, entryName, rateName, accRate, defaultFlag);
    }

    private boolean allCurrencyEleSame(DynamicObject accCurrency, String accQuoteType, BigDecimal exchangeRate) {
        String entryName = "expenseentryentity";
        String accQuoteName = "expquotetype";
        String rateName = "exchangerate";
        String currencyName = "entrycurrency";
        if (this.getValueModel.getProperty("expenseentryentity") == null) {
            entryName = "tripentry";
            if (ErEntityTypeUtils.isTripReqBill(this.getValueModel.getDataEntityType().getName())) {
                currencyName = "tripcurrency";
                accQuoteName = "tripquotetype";
                rateName = "tripexchangerate";
            } else {
                accQuoteName = "detailquotetype";
                rateName = "exchangerate";
                currencyName = "entrycurrency";
            }
        }
        boolean currencyFlag = this.checkAllCurrencyEleIsAccCurrency(this.getValueModel, entryName, currencyName, accCurrency, false);
        boolean rateTypeFlag = this.checkAllCurrencyEleIsAccCurrency(this.getValueModel, entryName, rateName, exchangeRate, false);
        boolean QuoteTypeFlag = this.checkAllCurrencyEleIsAccCurrency(this.getValueModel, entryName, accQuoteName, accQuoteType, false);
        return currencyFlag && QuoteTypeFlag && rateTypeFlag;
    }

    private boolean loanEntryEleSame(DynamicObject accCurrency) {
        boolean writeOffFlag = true;
        if (this.getValueModel.getProperty("expenseentryentity") != null && this.getValueModel.getProperty("writeofftype") != null && !(writeOffFlag = this.getValueModel.getDataEntity(true).getDynamicObjectCollection("writeoffmoney").size() == 0 || this.getValueModel.getEntryEntity("writeoffmoney").stream().allMatch(row -> row.getBigDecimal("accloanamount").compareTo(BigDecimal.ZERO) == 0)) && StringUtils.equals((CharSequence)((String)this.getValueModel.getValue("writeofftype")), (CharSequence)"1")) {
            writeOffFlag = this.checkAllCurrencyEleIsAccCurrency(this.getValueModel, "writeoffmoney", "loancurrency", accCurrency, true);
        } else if (this.getValueModel.getProperty("loanchecktype") != null && !(writeOffFlag = this.getValueModel.getDataEntity(true).getDynamicObjectCollection("clearloanentry").size() == 0 || this.getValueModel.getEntryEntity("clearloanentry").stream().allMatch(row -> row.getBigDecimal("loanclearoriamount").compareTo(BigDecimal.ZERO) == 0)) && StringUtils.equals((CharSequence)((String)this.getValueModel.getValue("loanchecktype")), (CharSequence)"1")) {
            writeOffFlag = this.checkAllCurrencyEleIsAccCurrency(this.getValueModel, "clearloanentry", "loancurrency", accCurrency, true);
        }
        return writeOffFlag;
    }

    public boolean pubAllCurrencyEleSame(DynamicObject accCurrency, String accQuoteType, BigDecimal exchangeRate) {
        return this.allCurrencyEleSame(accCurrency, accQuoteType, exchangeRate) && this.loanEntryEleSame(accCurrency);
    }
}

