/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.invoicecloud.kingdee.InvoiceTypeEnum;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.formplugin.web.tripstandard.util.PlaneSeatUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ReimburseUtils {
    private static final Log log = LogFactory.getLog(ReimburseUtils.class);

    public static String validataCostCompanyAndInvoiceBuyerCompnay(DynamicObject dataEntity, DynamicObject orgDO) {
        return "";
    }

    public static BigDecimal sumOffsetAmount(IDataModel model, IFormView view) {
        int deductibleTaxShowType = (Integer)model.getValue("deductibletaxshowtype");
        if (deductibleTaxShowType == 0) {
            CommonServiceHelper.getDeductibleTaxShowType(model, view);
            deductibleTaxShowType = (Integer)model.getValue("deductibletaxshowtype");
        }
        String entityId = model.getDataEntityType().getName();
        String entryKey = null;
        String offsetamountKey = null;
        switch (deductibleTaxShowType) {
            case 2: {
                entryKey = "invoiceentry";
                offsetamountKey = "offsetamount";
                break;
            }
            default: {
                if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
                    entryKey = "tripentry";
                } else if (ErEntityTypeUtils.isDailyReimburseBill(entityId) || ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
                    entryKey = "expenseentryentity";
                }
                offsetamountKey = "deductibletax";
            }
        }
        if (entryKey == null) {
            String errorInfo = ResManager.loadKDString((String)"\u4e8c\u5f00\u7ee7\u627f\u6807\u51c6\u5355\u636e\uff0c\u5982\u9700\u4f7f\u7528\u6807\u51c6\u63d2\u4ef6\u529f\u80fd\u8bf7\u7ef4\u62a4\u5f00\u53d1\u5e73\u53f0\uff1a\u8d39\u7528\u5355\u636e\u5b9e\u4f53\u7c7b\u578b\u8bbe\u7f6e\u3002", (String)"ReimburseUtils_1", (String)"fi-er-business", (Object[])new Object[0]);
            throw new KDBizException(errorInfo);
        }
        DynamicObjectCollection entries = model.getEntryEntity(entryKey);
        String finalOffsetamountKey = offsetamountKey;
        BigDecimal finalOffsetamount = BigDecimal.ZERO;
        if (ErEntityTypeUtils.isTripReimburseBill(entityId) && StringUtils.equals((CharSequence)entryKey, (CharSequence)"tripentry")) {
            for (DynamicObject tripentry : entries) {
                DynamicObjectCollection entrys = tripentry.getDynamicObjectCollection("entryentity");
                BigDecimal totalOffsetAmount = entrys.stream().map(v -> v.getBigDecimal(finalOffsetamountKey)).reduce(BigDecimal.ZERO, BigDecimal::add);
                finalOffsetamount = finalOffsetamount.add(totalOffsetAmount);
            }
        } else {
            finalOffsetamount = entries.stream().map(v -> v.getBigDecimal(finalOffsetamountKey)).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return finalOffsetamount;
    }

    public static void sumTripDeduxibleAmount(IDataModel model, int tripRowIndex) {
        DynamicObject tripDetail = model.getEntryRowEntity("tripentry", tripRowIndex);
        DynamicObjectCollection expenseDetail = tripDetail.getDynamicObjectCollection("entryentity");
        BigDecimal tripDeduxibletax = expenseDetail.stream().map(m -> m.getBigDecimal("deductibletax")).reduce(BigDecimal.ZERO, BigDecimal::add);
        model.beginInit();
        boolean ischanged = model.getDataChanged();
        model.setValue("tripdeductibletax", (Object)tripDeduxibletax, tripRowIndex);
        model.setDataChanged(ischanged);
        model.endInit();
    }

    public static Map getSeatGrade(List<DynamicObject> groupedInvoiceHeadEntryDOs) {
        HashMap seatGrades = new HashMap(4);
        Set airSeatGrade = groupedInvoiceHeadEntryDOs.stream().filter(invoice -> StringUtils.equalsAny((CharSequence)invoice.getString("invoicetype"), (CharSequence[])new CharSequence[]{InvoiceTypeEnum.key_10.getValue(), InvoiceTypeEnum.key_28.getValue()})).map(invoice -> invoice.getString("seatgrade")).collect(Collectors.toSet());
        seatGrades.put("2", airSeatGrade);
        Set trainSeatGrade = groupedInvoiceHeadEntryDOs.stream().filter(invoice -> StringUtils.equalsAny((CharSequence)invoice.getString("invoicetype"), (CharSequence[])new CharSequence[]{InvoiceTypeEnum.key_9.getValue(), InvoiceTypeEnum.key_29.getValue()})).map(invoice -> invoice.getString("seatgrade")).collect(Collectors.toSet());
        seatGrades.put("4", trainSeatGrade);
        Set shipSeatGrade = groupedInvoiceHeadEntryDOs.stream().filter(invoice -> StringUtils.equals((CharSequence)invoice.getString("invoicetype"), (CharSequence)InvoiceTypeEnum.key_20.getValue())).map(invoice -> invoice.getString("seatgrade")).collect(Collectors.toSet());
        seatGrades.put("7", shipSeatGrade);
        return seatGrades;
    }

    public static void setSeatGrades(IDataModel dataModel, int index, int tripEntryIndex, Map<String, Set<String>> sourceSeatGrade) {
        DynamicObject expenseitem = (DynamicObject)dataModel.getValue("expenseitem", index, tripEntryIndex);
        DynamicObjectCollection existSeats = (DynamicObjectCollection)dataModel.getValue("mulseatgrade", index, tripEntryIndex);
        if (expenseitem != null) {
            String attribute = expenseitem.getString("attribute");
            Set<String> seats = sourceSeatGrade.get(attribute);
            log.info("seats : {}", seats);
            if (CollectionUtils.isEmpty(seats) && existSeats.size() > 0 || CollectionUtils.isNotEmpty(seats) && seats.size() != existSeats.size()) {
                existSeats.clear();
                DynamicObject[] seatGradeArr = PlaneSeatUtil.findSeatByAttribute(expenseitem.getString("attribute"), seats);
                if (seatGradeArr != null && seatGradeArr.length > 0) {
                    Object[] seatPks = Arrays.stream(seatGradeArr).map(seat -> seat.getPkValue()).toArray();
                    dataModel.setValue("mulseatgrade", (Object)seatPks, index, tripEntryIndex);
                }
            }
        }
    }
}

