/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.FieldAp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.er.business.trip.util.TripSyncConfigUtil;
import kd.fi.er.business.utils.ErCommonUtils;

public class TripReqBillUtil {
    public static void setMultiTravelers(DynamicObject dynamicObject, DynamicObjectCollection tripEntrys) {
        boolean emParameter = TripSyncConfigUtil.getBoolean("Reservation_ personnel_range");
        if (!emParameter) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)tripEntrys)) {
            return;
        }
        DynamicObjectCollection multiTravelers = dynamicObject.getDynamicObjectCollection("multitravelers");
        multiTravelers.clear();
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", TripReqBillUtil.getPks(tripEntrys))});
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        for (DynamicObject user : users) {
            DynamicObject bases = new DynamicObject(multiTravelers.getDynamicObjectType());
            bases.set("fbasedataid", (Object)user);
            dynamicObjects.add((Object)bases);
        }
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            dynamicObject.set("multitravelers", (Object)dynamicObjects);
        }
    }

    public static void synProjectOwer(DynamicObject dynamicObject, DynamicObjectCollection tripEntrys) {
        boolean emParameter = TripSyncConfigUtil.getBoolean("Reservation_ personnel_range");
        if (!emParameter) {
            return;
        }
        if (CollectionUtils.isEmpty((Collection)tripEntrys)) {
            return;
        }
        DynamicObjectCollection projectower = dynamicObject.getDynamicObjectCollection("projectower");
        Set<Object> ids = TripReqBillUtil.getPks(tripEntrys);
        projectower.forEach(obj -> ids.add(ErCommonUtils.getPk(obj.get("fbasedataid"))));
        DynamicObject[] users = BusinessDataServiceHelper.load((String)"bos_user", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        projectower.clear();
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        for (DynamicObject user : users) {
            DynamicObject bases = new DynamicObject(projectower.getDynamicObjectType());
            bases.set("fbasedataid", (Object)user);
            dynamicObjects.add((Object)bases);
        }
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjects)) {
            dynamicObject.set("projectower", (Object)dynamicObjects);
        }
    }

    public static Set<Object> getPks(DynamicObjectCollection tripEntrys) {
        HashSet<Object> ids = new HashSet<Object>(tripEntrys.size());
        for (DynamicObject tripEntry : tripEntrys) {
            DynamicObjectCollection travelers = tripEntry.getDynamicObjectCollection("travelers");
            Set pks = travelers.stream().filter(Objects::nonNull).map(travel -> ErCommonUtils.getPk(travel.get("fbasedataid"))).collect(Collectors.toSet());
            ids.addAll(pks);
        }
        return ids;
    }

    public static List<ControlAp<?>> getMetaItems(String entityId) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        FormMetadata taskMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityType.getName(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        return taskMeta.getItems();
    }

    public static Boolean judgeIsExistProp(List<ControlAp<?>> metaItems, String prop) {
        for (ControlAp<?> metaItem : metaItems) {
            if (!(metaItem instanceof FieldAp) || !metaItem.getKey().equalsIgnoreCase(prop)) continue;
            return true;
        }
        return false;
    }
}

