/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.business.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MobileFormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.er.business.servicehelper.TrialOrgServiceHelper;
import kd.fi.er.business.trip.service.factory.TripServiceFactory;
import kd.fi.er.business.trip.service.iservice.ITripService;
import kd.fi.er.business.trip.supplier.Supplier;
import kd.fi.er.business.trip.util.TripCommonUtil;
import kd.fi.er.business.trip.v2.server.gtrip.GtripFieldMappingInvoke;
import kd.fi.er.business.trip.v2.server.number.TripMappingNumber;
import kd.fi.er.business.utils.ActionLocalCache;
import kd.fi.er.business.utils.ErCommonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TripUserGrantUtils {
    private static final String SELECT_PROPS = "grantuserno,grantusername,grantservers,grant,grantcontent,granttime,grantip,grantmodel,billstatus,grantuser";
    private static final Log logger = LogFactory.getLog(TripUserGrantUtils.class);
    private static final Map<String, String> trialMap = Maps.newHashMapWithExpectedSize((int)8);
    private static final String[] userNewTripServers = new String[]{Supplier.GAODE.name(), Supplier.TONGCHENG.name(), Supplier.ALI.name(), Supplier.QICHENG.name(), Supplier.MEIYA.name()};
    private static final Logger log = LoggerFactory.getLogger(TripUserGrantUtils.class);

    public static DynamicObjectCollection queryUserGrantInfos(List<String> userNos) {
        QFilter[] qFilters = new QFilter[]{new QFilter("grantuserno", "in", userNos), new QFilter("grant", "=", (Object)"1")};
        return TripUserGrantUtils.queryUserGrantInfosCach(qFilters);
    }

    private static DynamicObjectCollection queryUserGrantInfosCach(QFilter[] qFilters) {
        Map userGrantInfosCachMap = BusinessDataServiceHelper.loadFromCache((String)"er_trip_usergrant", (String)SELECT_PROPS, (QFilter[])qFilters);
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        if (userGrantInfosCachMap.isEmpty()) {
            return dynamicObjects;
        }
        Set entries = userGrantInfosCachMap.entrySet();
        for (Map.Entry entry : entries) {
            dynamicObjects.add(entry.getValue());
        }
        return dynamicObjects;
    }

    public static DynamicObjectCollection queryUserGrantInfosByServer(List<String> serverNumbers) {
        QFilter[] qFilters = new QFilter[]{new QFilter("grantservers", "in", serverNumbers), new QFilter("grant", "=", (Object)"1")};
        return TripUserGrantUtils.queryUserGrantInfosCach(qFilters);
    }

    public static boolean judgeIsOpenPage(DynamicObjectCollection enables) {
        List<DynamicObject> newEnables = TripUserGrantUtils.judgeTrial(enables);
        if (CollectionUtils.isEmpty(newEnables)) {
            return Boolean.FALSE;
        }
        long auth = newEnables.stream().filter(dynamicObject -> dynamicObject.getBoolean("authorizresyncuser")).count();
        if (auth == 0L) {
            return false;
        }
        DynamicObjectCollection dynamicObjects = TripUserGrantUtils.queryUserGrantInfos(Collections.singletonList(TripUserGrantUtils.getCurrentUserNo()));
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return Boolean.TRUE;
        }
        if (CollectionUtils.isEmpty((Collection)enables)) {
            return Boolean.FALSE;
        }
        Set grantServers = dynamicObjects.stream().map(dynamicObject -> dynamicObject.getString("grantservers")).collect(Collectors.toSet());
        Set servers = newEnables.stream().map(dynamicObject -> dynamicObject.getString("number")).collect(Collectors.toSet());
        servers.removeAll(grantServers);
        if (CollectionUtils.isEmpty(servers)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static List<DynamicObject> judgeTrial(DynamicObjectCollection enables) {
        Map<String, String> tmpMap = trialMap;
        ArrayList<String> trialList = new ArrayList<String>(tmpMap.keySet());
        QFilter qB = new QFilter("function", "in", trialList);
        ArrayList serverNameList = Lists.newArrayListWithCapacity((int)3);
        QFilter[] qFilters = new QFilter[]{qB};
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"er_trialorg", (String)"id,function, trialstyle, entryentity.trialorg,enable", (QFilter[])qFilters);
        Set functionMap = dynamicObjectMap.entrySet();
        Set function = functionMap.stream().map(en -> ((DynamicObject)en.getValue()).getString("function")).collect(Collectors.toSet());
        for (Map.Entry entry : functionMap) {
            DynamicObject value = (DynamicObject)entry.getValue();
            if (value.getBoolean("enable")) continue;
            trialList.remove(value.getString("function"));
            serverNameList.add(tmpMap.get(value.getString("function")));
        }
        Map<String, Boolean> permissionMap = TrialOrgServiceHelper.functionPermissionToUseNew(RequestContext.get().getCurrUserId(), trialList, false);
        Set<Map.Entry<String, Boolean>> entries = permissionMap.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            Boolean permit = (Boolean)entry.getValue();
            if (!permit.booleanValue()) continue;
            String serverName = tmpMap.get(key);
            serverNameList.add(serverName);
        }
        trialList.removeAll(new ArrayList(function));
        for (String string : trialList) {
            serverNameList.add(tmpMap.get(string));
        }
        List<DynamicObject> newEnables = enables.stream().filter(dynamicObject -> serverNameList.contains(dynamicObject.getString("number"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(newEnables)) {
            return new ArrayList<DynamicObject>();
        }
        return newEnables;
    }

    public static DynamicObjectCollection getNotGrantServers(String serverNumber) {
        DynamicObjectCollection servers = TripUserGrantUtils.getServers(serverNumber);
        String number = TripUserGrantUtils.getCurrentUserNo();
        DynamicObjectCollection tmpGrantServers = TripUserGrantUtils.queryUserGrantInfos(Collections.singletonList(number));
        if (CollectionUtils.isEmpty((Collection)tmpGrantServers)) {
            return servers;
        }
        Set grantServerNumbers = tmpGrantServers.stream().map(dynamicObject -> dynamicObject.getString("grantservers")).collect(Collectors.toSet());
        servers.removeIf(next -> grantServerNumbers.contains(next.getString("number")));
        return servers;
    }

    public static String getCurrentUserNo() {
        RequestContext context = RequestContext.get();
        long currUserId = context.getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_user", (String)"number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)currUserId)});
        return user.getString("number");
    }

    private static boolean openPage(IFormView view, DynamicObjectCollection enables, boolean isPc, String server) {
        boolean openPage = TripUserGrantUtils.judgeIsOpenPage(enables);
        if (openPage) {
            TripUserGrantUtils.openRemindPage(view, isPc, server);
        }
        return openPage;
    }

    public static void openRemindPage(IFormView view, boolean isPc, String server) {
        Map<String, Object> para = TripUserGrantUtils.getFormIdParam(isPc);
        if (isPc) {
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("server", (Object)server);
            view.showForm(showParameter);
        } else {
            MobileFormShowParameter showParameter = (MobileFormShowParameter)MobileFormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("server", (Object)server);
            HashMap<String, String> m = new HashMap<String, String>(1);
            m.put("position", "center");
            showParameter.getOpenStyle().setCustParam(m);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    public static void openRemindPage(boolean callBack, IFormView view, boolean isPc, String server, IFormPlugin plugin, String loginExternalPlat) {
        Map<String, Object> para = TripUserGrantUtils.getFormIdParam(isPc);
        if (isPc) {
            FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("server", (Object)server);
            showParameter.setCustomParam("continue", (Object)"false");
            showParameter.setCustomParam("loginExternalPlatforms", (Object)loginExternalPlat);
            FormShowParameter formShowParameter = view.getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            if (customParams.containsKey("applyBillId")) {
                showParameter.setCustomParam("applyBillId", customParams.get("applyBillId"));
            } else {
                showParameter.setCustomParam("applyBillId", formShowParameter.getCustomParam("applyBillId"));
            }
            if (callBack) {
                showParameter.setCloseCallBack(new CloseCallBack(plugin, "temp_jump"));
            }
            view.showForm(showParameter);
        } else {
            MobileFormShowParameter showParameter = (MobileFormShowParameter)MobileFormShowParameter.createFormShowParameter(para);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setCustomParam("server", (Object)server);
            showParameter.setCustomParam("continue", (Object)"false");
            showParameter.setCustomParam("loginExternalPlatforms", (Object)loginExternalPlat);
            FormShowParameter formShowParameter = view.getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            if (customParams.containsKey("applyBillId")) {
                showParameter.setCustomParam("applyBillId", customParams.get("applyBillId"));
            } else {
                showParameter.setCustomParam("applyBillId", formShowParameter.getCustomParam("applyBillId"));
            }
            if (callBack) {
                showParameter.setCloseCallBack(new CloseCallBack(plugin, "temp_jump"));
            }
            HashMap<String, String> m = new HashMap<String, String>(1);
            m.put("position", "center");
            showParameter.getOpenStyle().setCustParam(m);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    private static Map<String, Object> getFormIdParam(boolean isPc) {
        HashMap<String, Object> para = new HashMap<String, Object>();
        if (isPc) {
            para.put("formId", "er_serverauth_remind_pc");
        } else {
            para.put("formId", "er_serverauth_remind");
        }
        return para;
    }

    public static DynamicObjectCollection getServers(String serverNumber) {
        QFilter[] qFilters = null;
        qFilters = StringUtils.isEmpty((String)serverNumber) ? new QFilter[]{new QFilter("authorizresyncuser", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1")} : new QFilter[]{new QFilter("authorizresyncuser", "=", (Object)"1"), new QFilter("enable", "=", (Object)"1"), new QFilter("number", "=", (Object)serverNumber)};
        Map enableServersMap = BusinessDataServiceHelper.loadFromCache((String)"er_biz_info", (String)"number,authorizresyncuser,authroziedcontent,authroziedcontent_tag", (QFilter[])qFilters);
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        if (enableServersMap.isEmpty()) {
            return dynamicObjects;
        }
        Set entries = enableServersMap.entrySet();
        for (Map.Entry entry : entries) {
            dynamicObjects.add(entry.getValue());
        }
        return dynamicObjects;
    }

    public static boolean checkServerAuth(IFormView view, String serverNumber, boolean isPc) {
        if (view == null) {
            return false;
        }
        DynamicObjectCollection enables = TripUserGrantUtils.getServers(serverNumber);
        if (CollectionUtils.isEmpty((Collection)enables)) {
            return false;
        }
        return TripUserGrantUtils.openPage(view, enables, isPc, serverNumber);
    }

    public static void syncData(List<DynamicObject> needDatas, Object loginExternalPlats, Object billId) {
        long currUserId = RequestContext.get().getCurrUserId();
        DynamicObject[] reqBills = billId != null ? BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)"id,bizdate,billno,org,company,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", billId)}, (String)"bizdate desc") : BusinessDataServiceHelper.load((String)"er_tripreqbill", (String)"id,bizdate,billno,org,company,billstatus", (QFilter[])new QFilter[]{new QFilter("applier", "=", (Object)currUserId), new QFilter("billstatus", "=", (Object)"E")}, (String)"bizdate desc");
        QFilter qFilter = null;
        Object paramValue = ErCommonUtils.getEMParameter(RequestContext.get().getOrgId(), "syncvehiclebilltotrip");
        if (Objects.isNull(paramValue) || "0".equals(paramValue.toString())) {
            qFilter = new QFilter("billstatus", "=", (Object)"E");
        } else if ("1".equals(paramValue.toString())) {
            ArrayList billStatusList = Lists.newArrayListWithCapacity((int)3);
            billStatusList.add("E");
            billStatusList.add("B");
            billStatusList.add("C");
            qFilter = new QFilter("billstatus", "in", (Object)billStatusList);
        } else {
            qFilter = new QFilter("billstatus", "=", (Object)"E");
        }
        DynamicObject[] vehicleBills = BusinessDataServiceHelper.load((String)"er_dailyvehiclebill", (String)"id,bizdate,billno,org,company", (QFilter[])new QFilter[]{new QFilter("applier", "=", (Object)currUserId), qFilter}, (String)"bizdate desc");
        Map<String, String> standtripname = TripCommonUtil.getStandtripname();
        String cTripResultCode = "";
        for (DynamicObject dynamicObject2 : needDatas) {
            try {
                Object list;
                Object list2;
                String server = dynamicObject2.getString("grantservers");
                HashMap<String, Object> params = new HashMap<String, Object>(1);
                if (!Arrays.asList(userNewTripServers).contains(server)) {
                    String resultCode;
                    String tripServiceName = standtripname.get(server);
                    ITripService iTripService = TripServiceFactory.getTripService(tripServiceName);
                    list2 = new ArrayList<Long>(1);
                    list2.add(currUserId);
                    params.put("userList", list2);
                    params.put("didi", "1");
                    if (Supplier.DIDI.name().equals(server)) {
                        if (loginExternalPlats != null && !"false".equals(loginExternalPlats.toString()) || !org.apache.commons.lang3.StringUtils.equals((CharSequence)"200", (CharSequence)(resultCode = iTripService.synUserToTrip(params)))) continue;
                        try {
                            logger.info("\u6ef4\u6ef4\u7ebf\u7a0b\u5f00\u59cb\u4f11\u7720");
                            Thread.sleep(7000L);
                            logger.info("\u6ef4\u6ef4\u7ebf\u7a0b\u4f11\u7720\u7ed3\u675f");
                        }
                        catch (InterruptedException e) {
                            logger.error("\u6ef4\u6ef4 \u7ebf\u7a0b\u4f11\u7720\u5f02\u5e38:", (Throwable)e);
                        }
                        TripUserGrantUtils.syncApplyBill(reqBills, vehicleBills, iTripService, server);
                        continue;
                    }
                    resultCode = iTripService.synUserToTrip(params);
                    if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)"200", (CharSequence)resultCode)) continue;
                    if (Supplier.XIECHENG.name().equals(server)) {
                        cTripResultCode = resultCode;
                        continue;
                    }
                    TripUserGrantUtils.syncApplyBill(reqBills, vehicleBills, iTripService, server);
                    continue;
                }
                QFilter qall = new QFilter("id", "=", (Object)currUserId);
                params.put("qall", qall);
                if (Supplier.GAODE.name().equals(server)) {
                    String fieldMappingNumber = "G_SyncUser_BatchUpsert";
                    list2 = GtripFieldMappingInvoke.syncUser(fieldMappingNumber, params);
                    TripUserGrantUtils.newTripSyncApplyBill(list2, server, reqBills, vehicleBills);
                }
                if (Supplier.TONGCHENG.name().equals(server)) {
                    list = TripCommonUtil.invoke(Supplier.TONGCHENG.getValue(), "bos_user", null, TripMappingNumber.DTG_SYNC_USER.getCode(), params);
                    TripUserGrantUtils.newTripSyncApplyBill(list, server, reqBills, vehicleBills);
                    continue;
                }
                if (Supplier.ALI.name().equals(server)) {
                    list = TripCommonUtil.invoke(Supplier.ALI.getValue(), "bos_user", null, TripMappingNumber.ALI_SYNC_USER.getCode(), params);
                    TripUserGrantUtils.newTripSyncApplyBill(list, server, reqBills, vehicleBills);
                    continue;
                }
                if (Supplier.QICHENG.name().equals(server)) {
                    list = TripCommonUtil.invoke(Supplier.QICHENG.getValue(), "bos_user", null, TripMappingNumber.Q_SYNC_USER.getCode(), params);
                    TripUserGrantUtils.newTripSyncApplyBill(list, server, reqBills, vehicleBills);
                    continue;
                }
                if (!Supplier.MEIYA.name().equals(server)) continue;
                list = TripCommonUtil.invoke(Supplier.MEIYA.getValue(), "bos_user", null, TripMappingNumber.M_SYNC_USER.getCode(), params);
                TripUserGrantUtils.newTripSyncApplyBill(list, server, reqBills, vehicleBills);
            }
            catch (Exception ex) {
                logger.error("\u6388\u6743\u540c\u6b65\u540e \u540c\u6b65\u5931\u8d25:", (Throwable)ex);
            }
        }
        boolean exist = needDatas.stream().anyMatch(dynamicObject -> dynamicObject.getString("grantservers").equals(Supplier.XIECHENG.name()));
        logger.info("\u5f53\u524d\u643a\u7a0b\u662f\u5426\u542f\u7528:{}", (Object)exist);
        logger.info("\u5f53\u524d\u8fd4\u56de\u7801:{}", (Object)cTripResultCode);
        if (StringUtils.isNotEmpty((String)cTripResultCode) && org.apache.commons.lang3.StringUtils.equals((CharSequence)"200", (CharSequence)cTripResultCode) && exist) {
            try {
                logger.info("\u7ebf\u7a0b\u5f00\u59cb\u4f11\u7720");
                Thread.sleep(70000L);
                logger.info("\u7ebf\u7a0b\u4f11\u7720\u7ed3\u675f");
            }
            catch (InterruptedException e) {
                logger.error("\u7ebf\u7a0b\u4f11\u7720\u5f02\u5e38:", (Throwable)e);
            }
            TripUserGrantUtils.syncApplyBill(reqBills, vehicleBills, TripServiceFactory.getTripService(standtripname.get(Supplier.XIECHENG.name())), Supplier.XIECHENG.name());
            TripUserGrantUtils.syncCTripBudget(reqBills);
        }
    }

    private static void newTripSyncApplyBill(Object list, String server, DynamicObject[] reqBills, DynamicObject[] vehicleBills) {
        Object data;
        ArrayList returnData;
        Map result;
        List ls;
        if (list instanceof List && (ls = (List)list).size() > 0 && null != (result = (Map)ls.get(0)) && result.containsKey("data") && result.get("data") instanceof ArrayList && (returnData = (ArrayList)(data = result.get("data"))).size() > 0 && returnData.get(0) instanceof JSONObject) {
            JSONArray data1;
            Object obj = returnData.get(0);
            JSONObject returnJson = (JSONObject)obj;
            String resultKey = "";
            Boolean resultStatus = Boolean.FALSE;
            if (Supplier.GAODE.name().equals(server)) {
                resultKey = "result";
            } else if (Supplier.TONGCHENG.name().equals(server) || Supplier.ALI.name().equals(server)) {
                resultKey = "success";
            } else if (Supplier.MEIYA.name().equals(server)) {
                if ("10000".equals(returnJson.getString("code"))) {
                    resultStatus = Boolean.TRUE;
                }
            } else if (Supplier.QICHENG.name().equals(server) && "200".equals(returnJson.getString("code")) && (data1 = returnJson.getJSONArray("data")) != null && !data1.isEmpty() && "200".equals(data1.getJSONObject(0).getString("code"))) {
                resultStatus = Boolean.TRUE;
            }
            String returnResult = returnJson.getString(resultKey);
            if (StringUtils.isNotEmpty((String)returnResult) && Boolean.parseBoolean(returnResult) || resultStatus.booleanValue()) {
                HashMap orgIdAndCompanyIdMap;
                try {
                    logger.info("\u5b57\u6bb5\u6620\u5c04 \u7533\u8bf7\u5355\u540c\u6b65 \u7ebf\u7a0b\u5f00\u59cb\u4f11\u7720");
                    Thread.sleep(70000L);
                    logger.info("\u5b57\u6bb5\u6620\u5c04 \u7533\u8bf7\u5355\u540c\u6b65  \u7ebf\u7a0b\u4f11\u7720\u7ed3\u675f");
                }
                catch (InterruptedException e) {
                    logger.error("\u5b57\u6bb5\u6620\u5c04 \u7533\u8bf7\u5355\u540c\u6b65  \u7ebf\u7a0b\u4f11\u7720\u5f02\u5e38:", (Throwable)e);
                }
                if (reqBills != null && reqBills.length > 0) {
                    HashMap reqParams = Maps.newHashMapWithExpectedSize((int)4);
                    DynamicObject reqBill = reqBills[0];
                    reqParams.put("id", String.valueOf(reqBill.getLong("id")));
                    reqParams.put("billno", reqBill.getString("billno"));
                    reqParams.put("status", "1");
                    orgIdAndCompanyIdMap = Maps.newHashMapWithExpectedSize((int)2);
                    orgIdAndCompanyIdMap.put("orgId", reqBill.getDynamicObject("org") == null ? 0L : reqBill.getDynamicObject("org").getLong("id"));
                    orgIdAndCompanyIdMap.put("companyId", reqBill.getDynamicObject("company") == null ? 0L : reqBill.getDynamicObject("company").getLong("id"));
                    Boolean isContinue = Boolean.TRUE;
                    if (!TripCommonUtil.checkIsNeedBill(server, orgIdAndCompanyIdMap, "er_tripreqbill")) {
                        logger.info("\u5f53\u524d\u670d\u52a1\u5546{}\u4e0d\u6ee1\u8db3\u670d\u52a1\u5546\u8bbe\u7f6e\u7533\u8bf7\u5355\u540c\u6b65\u5206\u5f55", (Object)server);
                        isContinue = Boolean.FALSE;
                    }
                    if (isContinue.booleanValue()) {
                        if (Supplier.GAODE.name().equals(server)) {
                            GtripFieldMappingInvoke.syncReqBill(null, "1", reqParams);
                        } else if (Supplier.TONGCHENG.name().equals(server) || Supplier.ALI.name().equals(server) || Supplier.QICHENG.name().equals(server)) {
                            TripCommonUtil.invoke(server, "er_tripreqbill", null, null, reqParams);
                        } else if (Supplier.MEIYA.name().equals(server)) {
                            ActionLocalCache localCache = ActionLocalCache.get();
                            localCache.put("SyncReq.operationType", "submit");
                            localCache.put("SyncReq.billType", "er_tripreqbill");
                            TripCommonUtil.reqPush(reqBill.getString("billno"), String.valueOf(reqBill.getLong("id")), server, "");
                            return;
                        }
                    }
                }
                if (vehicleBills != null && vehicleBills.length > 0) {
                    DynamicObject vehicleBill = vehicleBills[0];
                    HashMap vehicleParams = Maps.newHashMapWithExpectedSize((int)4);
                    vehicleParams.put("id", String.valueOf(vehicleBill.getLong("id")));
                    vehicleParams.put("billno", vehicleBill.getString("billno"));
                    vehicleParams.put("status", "1");
                    orgIdAndCompanyIdMap = Maps.newHashMapWithExpectedSize((int)2);
                    orgIdAndCompanyIdMap.put("orgId", vehicleBill.getDynamicObject("org") == null ? 0L : vehicleBill.getDynamicObject("org").getLong("id"));
                    orgIdAndCompanyIdMap.put("companyId", vehicleBill.getDynamicObject("company") == null ? 0L : vehicleBill.getDynamicObject("company").getLong("id"));
                    if (!TripCommonUtil.checkIsNeedBill(server, orgIdAndCompanyIdMap, "er_dailyvehiclebill")) {
                        logger.info("\u4e0d\u6ee1\u8db3\u670d\u52a1\u5546\u7533\u8bf7\u5355\u540c\u6b65\u5206\u5f55\u7684\u8bbe\u7f6e");
                        return;
                    }
                    if (Supplier.GAODE.name().equals(server)) {
                        GtripFieldMappingInvoke.syncDailyVehicleBill(null, "1", vehicleParams);
                    } else if (Supplier.TONGCHENG.name().equals(server)) {
                        TripCommonUtil.invoke(server, "er_dailyvehiclebill", null, TripMappingNumber.DTG_SYNC_VEHICLE.getCode(), vehicleParams);
                    }
                }
            }
        }
    }

    private static void syncApplyBill(DynamicObject[] reqBills, DynamicObject[] vehicleBills, ITripService iTripService, String server) {
        HashMap orgIdAndCompanyIdMap;
        try {
            if (reqBills != null && reqBills.length != 0) {
                DynamicObject reqBill = reqBills[0];
                orgIdAndCompanyIdMap = Maps.newHashMapWithExpectedSize((int)2);
                orgIdAndCompanyIdMap.put("orgId", reqBill.getDynamicObject("org") == null ? 0L : reqBill.getDynamicObject("org").getLong("id"));
                orgIdAndCompanyIdMap.put("companyId", reqBill.getDynamicObject("company") == null ? 0L : reqBill.getDynamicObject("company").getLong("id"));
                if (TripCommonUtil.checkIsNeedBill(server, orgIdAndCompanyIdMap, "er_tripreqbill")) {
                    logger.info("\u6ee1\u8db3\u7533\u8bf7\u5355\u540c\u6b65\u5206\u5f55\u8bbe\u7f6e");
                    iTripService.synReqbillToTrip(ErCommonUtils.getPk(reqBill), "1");
                }
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u51fa\u5dee\u7533\u8bf7\u5355\u5931\u8d25:", (Throwable)e);
        }
        try {
            if (vehicleBills != null && vehicleBills.length != 0) {
                DynamicObject vehicleBill = vehicleBills[0];
                orgIdAndCompanyIdMap = Maps.newHashMapWithExpectedSize((int)2);
                orgIdAndCompanyIdMap.put("orgId", vehicleBill.getDynamicObject("org") == null ? 0L : vehicleBill.getDynamicObject("org").getLong("id"));
                orgIdAndCompanyIdMap.put("companyId", vehicleBill.getDynamicObject("company") == null ? 0L : vehicleBill.getDynamicObject("company").getLong("id"));
                if (!TripCommonUtil.checkIsNeedBill(server, orgIdAndCompanyIdMap, "er_dailyvehiclebill")) {
                    logger.info("\u4e0d\u6ee1\u8db3\u670d\u52a1\u5546\u7533\u8bf7\u5355\u540c\u6b65\u5206\u5f55\u7684\u8bbe\u7f6e");
                    return;
                }
                iTripService.synDilyVehicleToTrip(ErCommonUtils.getPk(vehicleBill), "1");
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u7528\u8f66\u7533\u8bf7\u5355\u5931\u8d25:", (Throwable)e);
        }
    }

    public static String getViewParamServer(FormShowParameter formShowParameter) {
        Object server = formShowParameter.getCustomParam("server");
        String serverStr = "";
        if (server != null && StringUtils.isNotEmpty((String)server.toString())) {
            serverStr = server.toString();
        }
        return serverStr;
    }

    private static void syncCTripBudget(DynamicObject[] reqBills) {
        try {
            if (reqBills != null && reqBills.length != 0) {
                DynamicObject reqBill = reqBills[0];
                TripCommonUtil.tripBudgetPush(ErCommonUtils.getPk(reqBill), reqBill.getString("billno"), Supplier.XIECHENG.name(), "1");
            }
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u643a\u7a0b\u9884\u7b97\u5931\u8d25:", (Throwable)e);
        }
    }

    static {
        trialMap.put("corp_usergrant", Supplier.XIECHENG.name());
        trialMap.put("didi_usergrant", Supplier.DIDI.name());
        trialMap.put("travelnoone_usergrant", Supplier.CHAILVYIHAO.name());
        trialMap.put("meituan_usergrant", Supplier.MEITUAN.name());
        trialMap.put("gaode_usergrant", Supplier.GAODE.name());
        trialMap.put("dtg_usergrant", Supplier.TONGCHENG.name());
        trialMap.put("ali_usergrant", Supplier.ALI.name());
        trialMap.put("qicheng_usergrant", Supplier.QICHENG.name());
        trialMap.put("meiya_usergrant", Supplier.MEIYA.name());
    }
}

