/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.fi.er.common.utils.Er;
import kd.fi.er.common.utils.ThrowableHelper;

public class UIWithF7UtilFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"f7util"});
        this.addItemClickListeners(new String[]{"tbmain"});
        IPageCache pageCache = this.getPageCache();
        String f7Key = pageCache.get("er.f7util.f7key");
        final String basedataid = pageCache.get("er.f7util.basedataid");
        final String basedatano = pageCache.get("er.f7util.basedatano");
        pageCache.remove("er.f7util.f7key");
        pageCache.remove("er.f7util.basedataid");
        pageCache.remove("er.f7util.basedatano");
        if (f7Key == null) {
            return;
        }
        final BasedataEdit basedataEdit = (BasedataEdit)this.getControl(f7Key);
        if (basedataEdit != null) {
            basedataEdit.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent event) {
                    Field field = null;
                    try {
                        Class<?> clazz = Class.forName("kd.bos.form.field.BasedataEdit");
                        field = clazz.getDeclaredField("beforeF7SelectListeners");
                        field.setAccessible(true);
                        List listeners = (List)field.get(basedataEdit);
                        String join = Er.join((Collection)listeners, (String)",");
                        FormShowParameter formShowParameter = event.getFormShowParameter();
                        formShowParameter.getCustomParams().put("er.f7util.beforeF7SelectListeners", join);
                        if (basedataid != null) {
                            formShowParameter.getCustomParams().put("er.f7util.basedataid", basedataid);
                        }
                        if (basedatano != null) {
                            formShowParameter.getCustomParams().put("er.f7util.basedatano", basedatano);
                        }
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                        throw new KDException(ThrowableHelper.toString((Exception)e));
                    }
                    finally {
                        if (field != null) {
                            field.setAccessible(false);
                        }
                    }
                }
            });
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("f7util".equalsIgnoreCase(itemKey)) {
            this.showF7UtilForm();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control btn = (Control)evt.getSource();
        String key = btn.getKey();
        if ("f7util".equalsIgnoreCase(key)) {
            this.showF7UtilForm();
        }
    }

    private void showF7UtilForm() {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("er_f7util");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "er_f7util"));
        this.getView().showForm(formShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("er_f7util".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            this.handleOKResult(closedCallBackEvent);
        }
    }

    private void handleOKResult(ClosedCallBackEvent closedCallBackEvent) {
        String basedatano;
        Object returnData = closedCallBackEvent.getReturnData();
        Map ret = (Map)returnData;
        IPageCache pageCache = this.getPageCache();
        pageCache.put("er.f7util.f7key", (String)ret.get("f7key"));
        String basedataid = (String)ret.get("basedataid");
        if (basedataid != null) {
            pageCache.put("er.f7util.basedataid", basedataid);
        }
        if ((basedatano = (String)ret.get("basedatano")) != null) {
            pageCache.put("er.f7util.basedatano", basedatano);
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u57cb\u70b9\u3002", (String)"UIWithF7UtilFormPlugin_0", (String)"fi-er-business", (Object[])new Object[0]));
    }
}

