/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.daily.web.tips;

import java.text.SimpleDateFormat;
import java.time.Month;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid8;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Label;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ReimburseControlUtils;
import kd.fi.er.common.enums.BillSettingControlFieldEnum;
import kd.fi.er.model.FormModel;

public class ReimburseTipsUtils {
    public static final String TIPS_ER_REIMBURSETIPS = "er_reimbursetips";
    public static final String TIPS_SHOW_CLOSE_FLEX = "tips_show_close_flex";
    public static final String TIPS_LBL_SHOW = "lbl_showreimburtips";
    public static final String TIPS_LBL_CLOSE = "lbl_closereimburtips";
    public static final String TIPS_LBL_REIMBURSETIPS_SIMPLE = "lbl_reimbursetips_simple";
    public static final String TIPS_LBL_REIMBURSETIPS_DETAILS = "lbl_reimbursetips_details";
    public static final String TIPS_TEXT_TIPS = "text_tips";
    public static final String TIPS_REIMBUESETIPSFLEX = "reimbuesetipsflex";
    public static final String ER_REIMBURSETIPS = "er_reimtipsfirstshowpage";
    public static final String TIPS_LBL_TIPS = "lbl_tips";
    public static final String TIPS_ALLTIPSFLEX = "alltipsflex";
    private static final Log log = LogFactory.getLog(ReimburseTipsUtils.class);

    public static void refreshPcTips(boolean isSpecialType, String detailTips, IDataModel model, IFormView view) {
        if (StringUtils.isNotBlank((CharSequence)detailTips)) {
            String billstatus = (String)model.getValue("billstatus");
            if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"A") || StringUtils.equals((CharSequence)billstatus, (CharSequence)"D")) {
                ReimburseTipsUtils.showFirstLoginPagePc(view, detailTips);
            }
            ReimburseTipsUtils.setTipsPc(detailTips, view, model);
        } else {
            ReimburseTipsUtils.showTipsAllControl(Boolean.FALSE, view);
        }
    }

    public static void refreshMobTips(boolean isSpecialType, String detailTips, IDataModel model, IFormView view) {
        if (StringUtils.isNotBlank((CharSequence)detailTips)) {
            String billstatus = (String)model.getValue("billstatus");
            if (StringUtils.equals((CharSequence)billstatus, (CharSequence)"A") || StringUtils.equals((CharSequence)billstatus, (CharSequence)"D")) {
                ReimburseTipsUtils.showFirstLoginPageMob(view, detailTips, ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a", (String)"ReimburseTipsUtils_0", (String)"fi-er-business", (Object[])new Object[0]));
            }
            ReimburseTipsUtils.setTipsMob(detailTips, view);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{TIPS_ALLTIPSFLEX});
        }
    }

    public static DynamicObject gainReimburseTips(Long companyId, String entityId) {
        if (companyId == null) {
            return null;
        }
        DynamicObject[] tipsEntry = ReimburseTipsUtils.excute(companyId, entityId);
        if (tipsEntry != null && tipsEntry.length >= 1) {
            log.info("\u5f53\u524d\u5355\u636e\u53ef\u7528\u62a5\u9500\u63d0\u9192\u6709" + tipsEntry.length + "\u6761");
            List tipsEntryList = Arrays.stream(tipsEntry).filter(tips -> tips.getDynamicObject("createorg") != null && Objects.equals(tips.getDynamicObject("createorg").getPkValue(), companyId)).collect(Collectors.toList());
            if (tipsEntryList.isEmpty() || tipsEntryList.size() > 1) {
                tipsEntryList = Arrays.stream(tipsEntry).filter(tips -> StringUtils.equals((CharSequence)tips.getString("ctrlstrategy"), (CharSequence)"7")).collect(Collectors.toList());
            }
            if (tipsEntryList.isEmpty()) {
                tipsEntryList = Arrays.stream(tipsEntry).filter(tips -> StringUtils.equals((CharSequence)tips.getString("ctrlstrategy"), (CharSequence)"1") || StringUtils.equals((CharSequence)tips.getString("ctrlstrategy"), (CharSequence)"2")).collect(Collectors.toList());
            }
            if (tipsEntryList.isEmpty()) {
                tipsEntryList = Arrays.stream(tipsEntry).filter(tips -> StringUtils.equals((CharSequence)tips.getString("ctrlstrategy"), (CharSequence)"6")).collect(Collectors.toList());
            }
            if (tipsEntryList.isEmpty()) {
                tipsEntryList = Arrays.stream(tipsEntry).filter(tips -> StringUtils.equals((CharSequence)tips.getString("ctrlstrategy"), (CharSequence)"5")).collect(Collectors.toList());
            }
            if (tipsEntryList.isEmpty()) {
                return null;
            }
            Date modifyDate = ((DynamicObject)tipsEntryList.get(0)).getDate("modifytime");
            int index = 0;
            for (int i = 1; i < tipsEntryList.size(); ++i) {
                DynamicObject tips2 = (DynamicObject)tipsEntryList.get(i);
                if (!modifyDate.before(tips2.getDate("modifytime"))) continue;
                index = i;
            }
            DynamicObjectCollection tipsinfo = ((DynamicObject)tipsEntryList.get(index)).getDynamicObjectCollection("tipsinfoentry");
            List tipsList = tipsinfo.stream().filter(tips -> StringUtils.equals((CharSequence)entityId, (CharSequence)tips.getString("billtype"))).collect(Collectors.toList());
            DynamicObject tipsNewCache = (DynamicObject)tipsList.get(0);
            return tipsNewCache;
        }
        return null;
    }

    public static final String gainReimburseSimpleTips(String detailTips) {
        if (StringUtils.contains((CharSequence)detailTips, (int)10)) {
            String simple = StringUtils.substring((String)detailTips, (int)0, (int)StringUtils.indexOf((CharSequence)detailTips, (int)10));
            return simple;
        }
        return detailTips;
    }

    @Deprecated
    public static final String changeEntity2Enum(String entityId) {
        return "";
    }

    public static DynamicObject[] excute(Long companyId, String entityId) {
        QFilter queryFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        String selectPropties = "id,createorg,number,name,ctrlstrategy,tipsinfoentry.billtype,tipsinfoentry.tipscontent,tipsinfoentry.isdefaultshow,tipsinfoentry.multtipscontent,modifytime";
        queryFilter.and("tipsinfoentry.billtype", "in", (Object)entityId);
        Map obj = BaseDataServiceHelper.queryBaseDataFromCache((String)TIPS_ER_REIMBURSETIPS, (Long)companyId, (QFilter)queryFilter, (String)selectPropties);
        DynamicObject[] tipsEntry = obj.values().toArray(new DynamicObject[obj.size()]);
        return tipsEntry;
    }

    public static void setTipsPc(String tips, IFormView view, IDataModel model) {
        String simpleTips = ReimburseTipsUtils.gainReimburseSimpleTips(tips);
        ReimburseTipsUtils.setLabelText(simpleTips, TIPS_LBL_REIMBURSETIPS_SIMPLE, view);
        if (model.getProperty(TIPS_TEXT_TIPS) != null) {
            boolean dataChanged = model.getDataChanged();
            model.setValue(TIPS_TEXT_TIPS, (Object)tips);
            model.setDataChanged(dataChanged);
        } else {
            view.setVisible(Boolean.FALSE, new String[]{TIPS_TEXT_TIPS, TIPS_LBL_CLOSE, TIPS_LBL_SHOW});
            view.setVisible(Boolean.TRUE, new String[]{TIPS_LBL_REIMBURSETIPS_SIMPLE});
        }
    }

    public static void setTipsMob(String tips, IFormView view) {
        ReimburseTipsUtils.setLabelText(tips, TIPS_LBL_REIMBURSETIPS_SIMPLE, view);
    }

    public static String pageCacheTips(AbstractFormPlugin formPlugin) {
        return ReimburseTipsUtils.pageCacheTips(formPlugin, false);
    }

    public static String pageCacheTips(AbstractFormPlugin formPlugin, boolean isMob) {
        DynamicObject company = (DynamicObject)formPlugin.getView().getModel().getValue("company");
        Long companyId = null;
        if (company != null) {
            companyId = (Long)company.getPkValue();
        }
        String normalEntityId = formPlugin.getView().getFormShowParameter().getFormId();
        if (isMob && !"er_tripreim_grid_mb".equals(normalEntityId)) {
            normalEntityId = formPlugin.getView().getEntityId();
        }
        if ("er_tripreim_grid_mb".equals(normalEntityId)) {
            normalEntityId = "er_tripreimbill_grid";
        }
        String entityId = ReimburseTipsUtils.checkLoan(normalEntityId, formPlugin.getView());
        String tips = null;
        String specialbill = (String)formPlugin.getView().getFormShowParameter().getCustomParam("specialbill");
        if (specialbill == null) {
            String reimbursetype;
            specialbill = reimbursetype = (String)formPlugin.getView().getFormShowParameter().getCustomParam("reimbursetype");
        }
        DynamicObject tipsinfoentry = null;
        if (specialbill != null) {
            tipsinfoentry = ReimburseTipsUtils.gainReimburseTips(companyId, entityId + "_" + specialbill);
        } else {
            IDataModel dataModel = formPlugin.getView().getModel();
            boolean bill = false;
            if (dataModel.getProperty(BillSettingControlFieldEnum.REIMBURSE_TYPE.getValue()) != null) {
                String reimbursetype = (String)dataModel.getValue(BillSettingControlFieldEnum.REIMBURSE_TYPE.getValue());
                reimbursetype = reimbursetype == null ? "" : reimbursetype;
                tipsinfoentry = ReimburseTipsUtils.gainReimburseTips(companyId, entityId + "_" + reimbursetype);
                bill = tipsinfoentry == null;
            } else {
                bill = true;
            }
            if (bill) {
                tipsinfoentry = ReimburseTipsUtils.gainReimburseTips(companyId, entityId);
            }
        }
        if (tipsinfoentry != null) {
            tips = tipsinfoentry.getLocaleString("multtipscontent").toString();
            Boolean isDefaultShow = tipsinfoentry.getBoolean("isdefaultshow");
            log.info("\u5f53\u524d\u5355\u636e\u62a5\u9500\u63d0\u9192\u7f13\u5b58\uff0ctips : " + tips + "\uff0cisdefaultshow : " + isDefaultShow);
            formPlugin.getPageCache().put(companyId + entityId + "isdefaultshow", isDefaultShow.toString());
        }
        return tips;
    }

    public static Boolean pageCacheDefaultShow(AbstractFormPlugin formPlugin) {
        return ReimburseTipsUtils.pageCacheDefaultShow(formPlugin, false);
    }

    public static Boolean pageCacheDefaultShow(AbstractFormPlugin formPlugin, boolean isMob) {
        IPageCache pageCache = formPlugin.getPageCache();
        DynamicObject company = (DynamicObject)formPlugin.getView().getModel().getValue("company");
        Long companyId = null;
        if (company != null) {
            companyId = (Long)company.getPkValue();
        }
        String normalEntityId = formPlugin.getView().getFormShowParameter().getFormId();
        if (isMob && !"er_tripreim_grid_mb".equals(normalEntityId)) {
            normalEntityId = formPlugin.getView().getEntityId();
        }
        if ("er_tripreim_grid_mb".equals(normalEntityId)) {
            normalEntityId = "er_tripreimbill_grid";
        }
        String entityId = ReimburseTipsUtils.checkLoan(normalEntityId, formPlugin.getView());
        Boolean isDefaultShow = Boolean.parseBoolean(pageCache.get(companyId + entityId + "isdefaultshow"));
        return isDefaultShow;
    }

    public static void showTipsAllControl(Boolean isShow, IFormView view) {
        view.setVisible(isShow, new String[]{TIPS_REIMBUESETIPSFLEX});
    }

    public static void showDetailsControl(Boolean isShow, IFormView view) {
        view.setVisible(isShow, new String[]{TIPS_TEXT_TIPS, TIPS_LBL_CLOSE});
        view.setVisible(Boolean.valueOf(isShow == false), new String[]{TIPS_LBL_REIMBURSETIPS_SIMPLE, TIPS_LBL_SHOW});
    }

    public static void setLabelText(String controlContent, String controlName, IFormView view) {
        Label label = (Label)view.getControl(controlName);
        if (label != null) {
            label.setText(controlContent);
        } else {
            log.info("\u62a5\u9500\u63d0\u9192\u8d4b\u503c\uff1a----controlName : " + controlName + ", controlName : " + controlName);
        }
    }

    public static void showFirstLoginPagePc(IFormView view, String tips) {
        String normalEntityId = view.getFormShowParameter().getFormId();
        String formId = ReimburseTipsUtils.checkLoan(normalEntityId, view);
        RequestContext requestContext = RequestContext.get();
        Long userId = Long.valueOf(requestContext.getUserId());
        if (ReimburseTipsUtils.isFirstLogin(userId, formId).booleanValue()) {
            FormModel formModel = new FormModel(ER_REIMBURSETIPS, ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a", (String)"ReimburseTipsUtils_0", (String)"fi-er-business", (Object[])new Object[0]), "1", true);
            formModel.setShowType(ShowType.Modal);
            HashMap<String, String> customParam = new HashMap<String, String>();
            customParam.put("formid", formId);
            customParam.put("tips", tips);
            formModel.setCustomParam(customParam);
            FormShowParameter formShowParameter = formModel.getFormShowParameter();
            view.showForm(formShowParameter);
            ReimburseTipsUtils.updateFirstLoginFlag(userId, formId);
        }
    }

    public static Date getLastTimeLoginDate() {
        return ReimburseTipsUtils.getLasTimeLoginDate(CommonServiceHelper.getCurrentUserID());
    }

    public static Date getLasTimeLoginDate(Long userId) {
        return new Date();
    }

    public static void showFirstLoginPageMob(IFormView view, String tips, String headName) {
        RequestContext requestContext;
        Long userId;
        String formId = ReimburseTipsUtils.checkLoan(view.getEntityId(), view) + "_mob";
        String normalEntityId = view.getFormShowParameter().getFormId();
        if ("er_tripreim_grid_mb".equals(normalEntityId)) {
            formId = "er_tripreim_grid_mb";
        }
        if (ReimburseTipsUtils.isFirstLogin(userId = Long.valueOf((requestContext = RequestContext.get()).getUserId()), formId).booleanValue()) {
            ReimburseTipsUtils.showDetailsMob(view, tips, headName);
            ReimburseTipsUtils.updateFirstLoginFlag(userId, formId);
        }
    }

    private static String checkLoan(String entityId, IFormView view) {
        boolean isloan;
        if (ErEntityTypeUtils.isTripReqBill(entityId) && (isloan = view.getModel().getDataEntity().getBoolean("isloan"))) {
            entityId = entityId + "_loan";
        }
        return entityId;
    }

    public static void showSpecialOrTips(AbstractFormPlugin formPlugin) {
        IFormView view = formPlugin.getView();
        IDataModel model = view.getModel();
        boolean isSpecialType = ReimburseTipsUtils.isSpecialType(view, model);
        String tips = "";
        String headName = "";
        tips = ReimburseTipsUtils.pageCacheTips(formPlugin, true);
        headName = ResManager.loadKDString((String)"\u6e29\u99a8\u63d0\u793a", (String)"ReimburseTipsUtils_0", (String)"fi-er-business", (Object[])new Object[0]);
        ReimburseTipsUtils.showDetailsMob(view, tips, headName);
    }

    public static void showDetailsMob(IFormView view, String tips, String headName) {
        String formId = ReimburseTipsUtils.checkLoan(view.getEntityId(), view) + "_mob";
        FormModel formModel = new FormModel("er_reimbursetips_mb", headName, "1", true);
        formModel.setShowType(ShowType.Modal);
        HashMap<String, String> customParam = new HashMap<String, String>();
        customParam.put("formid", formId);
        customParam.put("tips", tips);
        customParam.put("headname", headName);
        formModel.setCustomParam(customParam);
        FormShowParameter formShowParameter = formModel.getFormShowParameter();
        view.showForm(formShowParameter);
    }

    public static Boolean isFirstLogin(Long userId, String formId) {
        QFilter userFilter = new QFilter("userid", "=", (Object)userId);
        if (formId.contains("_mob")) {
            formId = formId.replace("_mob", "");
        }
        QFilter formIdFilter = new QFilter("pageid", "=", (Object)formId);
        QFilter[] filters = new QFilter[]{userFilter, formIdFilter};
        DynamicObject useInfo = QueryServiceHelper.queryOne((String)"bos_devp_firstlogin", (String)"isfirstlogin", (QFilter[])filters);
        return useInfo == null || !useInfo.getBoolean("isfirstlogin");
    }

    public static void updateFirstLoginFlag(long userId, String formId) {
        QFilter userFilter = new QFilter("userid", "=", (Object)userId);
        if (formId.contains("_mob")) {
            formId = formId.replace("_mob", "");
        }
        QFilter formIdFilter = new QFilter("pageid", "=", (Object)formId);
        QFilter[] filters = new QFilter[]{userFilter, formIdFilter};
        DynamicObject useInfo = BusinessDataServiceHelper.loadSingle((String)"bos_devp_firstlogin", (String)"isfirstlogin", (QFilter[])filters);
        if (useInfo == null) {
            useInfo = BusinessDataServiceHelper.newDynamicObject((String)"bos_devp_firstlogin");
            String id = Uuid8.generateShortUuid();
            useInfo.set("id", (Object)id);
            useInfo.set("userid", (Object)userId);
            useInfo.set("pageid", (Object)formId);
        }
        useInfo.set("isfirstlogin", (Object)"1");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{useInfo});
    }

    public static boolean isSpecialType(IFormView view, IDataModel model) {
        boolean isSpecialType = false;
        if (model.getProperty("specialbill") != null) {
            FormShowParameter parameter = view.getFormShowParameter();
            String specialType = (String)parameter.getCustomParams().get("specialbill");
            String string = specialType = specialType == null ? (String)model.getValue("specialbill") : specialType;
            if (StringUtils.isNotBlank((CharSequence)specialType)) {
                isSpecialType = true;
            }
        }
        return isSpecialType;
    }

    @Deprecated
    public static String initLableOfUsefulLife(IDataModel model, IFormView view) {
        DynamicObject erItem;
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            ReimburseTipsUtils.showTipsAllControl(Boolean.FALSE, view);
            return null;
        }
        Long companyId = (Long)company.getPkValue();
        boolean allowOverYear = ReimburseControlUtils.isAllowPreviousYear(companyId);
        Month deadlineMonth = ReimburseControlUtils.deadlineMonthOfAllowPreviousYes(companyId);
        int usefulLife = ReimburseControlUtils.reimUsefulLife(companyId);
        int years = Integer.parseInt(new SimpleDateFormat("yyyy").format(new Date()));
        boolean isMaxLength = years % 4 == 0 && years % 100 != 0 || years % 400 == 0;
        String monthAndDay = deadlineMonth.getValue() + "." + deadlineMonth.length(isMaxLength);
        DynamicObjectCollection erItemColl = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        DynamicObject erExpItemInfo = null;
        if (erItemColl != null && erItemColl.size() > 0 && (erItem = (DynamicObject)erItemColl.get(0)) != null) {
            erExpItemInfo = erItem.getDynamicObject("expenseitem");
        }
        String tipA = String.format(ResManager.loadKDString((String)"\u4e0a\u5e74\u989d\u5ea6\u9700\u5728\u672c\u5e74%s\u524d\u62a5\u9500\u5b8c\u6bd5\u3002", (String)"ReimburseTipsUtils_1", (String)"fi-er-business", (Object[])new Object[0]), monthAndDay);
        String tipB = String.format(ResManager.loadKDString((String)"\u672c\u5e74\u6bcf\u6708\u989d\u5ea6\u9700\u5728%s\u4e2a\u6708\u5185\u62a5\u9500\u5b8c\u6bd5\u3002", (String)"ReimburseTipsUtils_2", (String)"fi-er-business", (Object[])new Object[0]), usefulLife);
        Boolean showTipA = true;
        Boolean showTipB = true;
        if (!allowOverYear) {
            showTipA = false;
        } else {
            Month currentMonth = ReimburseControlUtils.currentLocalDate().getMonth();
            if (deadlineMonth.compareTo(Month.DECEMBER) == 0 || deadlineMonth.compareTo(currentMonth) < 0) {
                showTipA = false;
            }
        }
        if (erExpItemInfo != null) {
            String ctlMethod = erExpItemInfo.getString("reimburseamountctlmethod");
            if (!"D".equals(ctlMethod) && !"B".equals(ctlMethod)) {
                showTipB = false;
            }
        } else {
            showTipB = false;
        }
        if (usefulLife >= 11) {
            showTipB = false;
        }
        String showTip = "";
        if (showTipA.booleanValue()) {
            showTip = showTip + tipA;
        }
        if (showTipB.booleanValue()) {
            showTip = showTip + tipB;
        }
        log.info("\u4e13\u9879\u62a5\u9500\u5355----showTip : " + showTip + ", showA : " + showTipA + ", showB : " + showTipB);
        if (!showTipB.booleanValue() && !showTipA.booleanValue()) {
            ReimburseTipsUtils.showTipsAllControl(Boolean.FALSE, view);
            return null;
        }
        return showTip;
    }
}

