/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud;

import java.io.UnsupportedEncodingException;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class XbrlHelperFormPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(XbrlHelperFormPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("query".equalsIgnoreCase(itemKey)) {
            this.query();
        } else if ("getjson".equalsIgnoreCase(itemKey)) {
            this.getjson(true);
        } else if ("getjsonnew".equalsIgnoreCase(itemKey)) {
            this.getjson(false);
        } else if ("getseqnoandjson".equalsIgnoreCase(itemKey)) {
            String param = (String)this.getModel().getValue("textareafield");
            this.getModel().setValue("textareafield", (Object)this.getseqnoandjson(param, true));
        } else if ("getseqnoandjsonnew".equalsIgnoreCase(itemKey)) {
            String param = (String)this.getModel().getValue("textareafield");
            this.getModel().setValue("textareafield", (Object)this.getseqnoandjson(param, false));
        } else if ("invoice".equalsIgnoreCase(itemKey)) {
            String json = (String)this.getModel().getValue("largetextfield");
            logger.info("\u83b7\u53d6\u53d1\u7968\u4fe1\u606f\uff1a {}", (Object)json);
            Map map = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
            Object result = DispatchServiceHelper.invokeBizService((String)"fi", (String)"er", (String)"erGetBizBillInfoImpl", (String)"getSeqNoAndJson", (Object[])new Object[]{map});
            this.getModel().setValue("largetextfield", (Object)SerializationUtils.toJsonString((Object)result));
        }
    }

    private void getjson(boolean oldInterface) {
        IDataModel model = this.getModel();
        IFormView view = this.getView();
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        if (selectRows.length == 0) {
            return;
        }
        long billid = (Long)model.getValue("billid", selectRows[0]);
        String billType = model.getValue("billtype").toString();
        HashSet<Long> billIds = new HashSet<Long>(1);
        billIds.add(billid);
        String method = "getBizBillTicketList";
        if (!oldInterface) {
            method = "getBizBillTicketListNew";
        }
        Map bizBillTicketList = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"er", (String)"erGetBizBillInfoImpl", (String)method, (Object[])new Object[]{billType, billIds});
        try {
            String content = SerializationUtils.toJsonString((Object)bizBillTicketList);
            String appNumberFile = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl("ErGetBizBillInfoImpl.json", content.getBytes("utf-8"), 5000);
            view.openUrl(appNumberFile);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void query() {
        IDataModel model = this.getModel();
        model.deleteEntryData("entryentity");
        String billtype = model.getValue("billtype").toString();
        String billno = model.getValue("billno").toString();
        QFilter[] filters = new QFilter("billno", "=", (Object)billno).toArray();
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"algo", (String)billtype, (String)"id,applier,createtime", (QFilter[])filters, null);){
            for (Row row : ds) {
                int rowIndex = model.createNewEntryRow("entryentity");
                model.setValue("billid", row.get("id"), rowIndex);
                model.setValue("billno1", (Object)billno, rowIndex);
                model.setValue("applier", row.get("applier"), rowIndex);
                model.setValue("createtime", row.get("createtime"), rowIndex);
            }
        }
    }

    private String getseqnoandjson(String json, boolean oldInterface) {
        String method = "getSeqNoAndJson";
        if (!oldInterface) {
            method = "getSeqNoAndJsonNew";
        }
        logger.info("getseqnoandjson \u5165\u53c2\uff1a {}", (Object)json);
        Map map = (Map)SerializationUtils.fromJsonString((String)json, Map.class);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"er", (String)"erGetBizBillInfoImpl", (String)method, (Object[])new Object[]{map});
        return SerializationUtils.toJsonString((Object)result);
    }
}

