/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.invoicecloud.v2.util;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.control.EntryGrid;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.fi.er.business.invoicecloud.ItemFrom;
import kd.fi.er.business.invoicecloud.util.InvoiceTypeUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.common.invoice.model.InvoiceRelation;
import kd.fi.er.common.invoice.model.RelationMainView;
import kd.fi.er.common.invoice.utils.InvoiceUtils2;
import kd.fi.er.common.model.invoice.ItemInvoiceRelationEnum;
import kd.fi.er.common.model.invoice.bill.BillExpenseInfoFildKeyType;
import kd.fi.er.common.model.invoice.bill.BillOfInvoice;
import kd.fi.er.formplugin.util.OffsetUtils;

public class RelateExpenseOrTripItemAndInvoiceUtil {
    private static final Log logger = LogFactory.getLog(RelateExpenseOrTripItemAndInvoiceUtil.class);

    public static void mapExpenseEntryAndInvoiceEntry(IFormView view, BillOfInvoice bill) {
        RelateExpenseOrTripItemAndInvoiceUtil.mapExpenseEntryAndInvoiceEntry(view, bill, null, null);
    }

    public static void mapExpenseEntryAndInvoiceEntry(IFormView view, BillOfInvoice bill, List<Long> expenseEntryIds, List<Long> invoiceEntryIds) {
        long costCompany;
        String info;
        IDataModel model = view.getModel();
        if (expenseEntryIds == null) {
            expenseEntryIds = RelateExpenseOrTripItemAndInvoiceUtil.setAndGetSelectedRowEntryId(view, bill);
        }
        if (invoiceEntryIds == null) {
            invoiceEntryIds = RelateExpenseOrTripItemAndInvoiceUtil.setAndGetSelectedRowEntryId(view, "invoiceentry");
        }
        String expenseIdsLog = ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u5173\u8054\u53d1\u7968\u4fe1\u606f\uff0c\u660e\u7ec6id\uff1a%s", (String)"RelateExpenseOrTripItemAndInvoiceUtil_10", (String)"fi-er-formplugin", (Object[])new Object[0]);
        String invoiceIdsLog = ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u5173\u8054\u53d1\u7968\u4fe1\u606f\uff0c\u53d1\u7968\u4fe1\u606fid\uff1a%s", (String)"RelateExpenseOrTripItemAndInvoiceUtil_11", (String)"fi-er-formplugin", (Object[])new Object[0]);
        logger.info(String.format(expenseIdsLog, expenseEntryIds));
        logger.info(String.format(invoiceIdsLog, invoiceEntryIds));
        String msg = RelateExpenseOrTripItemAndInvoiceUtil.checkRelate(view, bill, expenseEntryIds, invoiceEntryIds);
        if (StringUtils.isNotEmpty((CharSequence)msg)) {
            view.showTipNotification(msg);
            return;
        }
        RelateExpenseOrTripItemAndInvoiceUtil.resetInvoiceInfo(model, expenseEntryIds, invoiceEntryIds);
        RelateExpenseOrTripItemAndInvoiceUtil.mapExpenseEntryAndInvoiceEntryBy(view, bill, expenseEntryIds, invoiceEntryIds);
        if (invoiceEntryIds.isEmpty()) {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u5173\u8054\u6210\u529f\u3002", (String)"RelateExpenseOrTripItemAndInvoiceUtil_3", (String)"fi-er-formplugin", (Object[])new Object[0]));
        } else {
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5173\u8054\u6210\u529f\u3002", (String)"RelateExpenseOrTripItemAndInvoiceUtil_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
        }
        InvoiceUtils.BillEntityType type = InvoiceUtils.BillEntityType.DailyReimburse;
        if (bill == BillOfInvoice.TripReimburseBill) {
            type = InvoiceUtils.BillEntityType.TripReimburse;
        }
        if (!CollectionUtils.isEmpty(invoiceEntryIds) && StringUtils.isNotBlank((CharSequence)(info = InvoiceUtils.refreshTaxAmountShare(model, costCompany = ErCommonUtils.getPk(view.getModel().getValue("costcompany")).longValue(), invoiceEntryIds, expenseEntryIds, type)))) {
            view.showTipNotification(info);
        }
        boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer(view.getModel());
        if (BillOfInvoice.DailyReimburseBill == bill && !isOrgOffset) {
            DynamicObjectCollection entryEntity = model.getEntryEntity("expenseentryentity");
            for (int expenseIndex = 0; expenseIndex < entryEntity.size(); ++expenseIndex) {
                Long parentId;
                DynamicObject expenseItem = (DynamicObject)entryEntity.get(expenseIndex);
                Long pkValue = (Long)expenseItem.getPkValue();
                String splitline = expenseItem.getString("splitline");
                Long l = parentId = org.apache.commons.lang.StringUtils.isEmpty((String)splitline) ? null : Long.valueOf(Long.parseLong(splitline));
                if (!expenseEntryIds.contains(pkValue) && !expenseEntryIds.contains(parentId)) continue;
                OffsetUtils.calculateOffset(expenseIndex, false, view.getModel(), view);
            }
        }
    }

    public static String checkRelate(IFormView view, BillOfInvoice bill, List<Long> expenseEntryIds, List<Long> invoiceEntryIds) {
        Set<Object> expCurrencySet;
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        String msg = "";
        if (expenseEntryIds.isEmpty()) {
            String entityDisplayName = ((EntityType)model.getDataEntityType().getAllEntities().get(bill.getExpenseEntryEntityName())).getDisplayName().toString();
            msg = String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u201c%1$s\u201d%2$s", (String)"RelateExpenseOrTripItemAndInvoiceUtil_5", (String)"fi-er-formplugin", (Object[])new Object[0]), entityDisplayName, ResManager.loadKDString((String)"\u540e\u518d\u5173\u8054\u3002", (String)"RelateExpenseOrTripItemAndInvoiceUtil_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return msg;
        }
        boolean noMapInvoice = expenseEntryIds.stream().allMatch(entryId -> RelateExpenseOrTripItemAndInvoiceUtil.getInvoiceEntrysByExpenseEntryId(dataEntity, entryId).isEmpty());
        if (noMapInvoice && invoiceEntryIds.isEmpty()) {
            msg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u4e2d\u53d1\u7968\u4fe1\u606f\u5206\u5f55\uff0c\u518d\u8fdb\u884c\u5173\u8054\u3002", (String)"RelateExpenseOrTripItemAndInvoiceUtil_1", (String)"fi-er-formplugin", (Object[])new Object[0]);
            return msg;
        }
        if (bill == BillOfInvoice.DailyReimburseBill) {
            DynamicObjectCollection expenseEntryEntity = (DynamicObjectCollection)bill.getExpenseEntryEntities(dataEntity);
            expCurrencySet = expenseEntryEntity.stream().filter(expenseEntry -> expenseEntryIds.contains(expenseEntry.getPkValue())).map(expenseEntry -> {
                DynamicObject expCurrencyObj = expenseEntry.getDynamicObject("entrycurrency");
                if (expCurrencyObj == null) {
                    return null;
                }
                return (Long)expCurrencyObj.getPkValue();
            }).collect(Collectors.toSet());
        } else if (bill == BillOfInvoice.TripReimburseBill) {
            Map tripMap = (Map)bill.getExpenseEntryEntities(dataEntity);
            List expenseEntryEntity = tripMap.entrySet().stream().flatMap(trip -> ((DynamicObjectCollection)trip.getValue()).stream()).collect(Collectors.toList());
            expCurrencySet = expenseEntryEntity.stream().filter(expenseEntry -> expenseEntryIds.contains(expenseEntry.getPkValue())).map(expenseEntry -> {
                DynamicObject expCurrencyObj = expenseEntry.getDynamicObject("entrycurrency");
                if (expCurrencyObj == null) {
                    return null;
                }
                return (Long)expCurrencyObj.getPkValue();
            }).collect(Collectors.toSet());
        } else {
            expCurrencySet = new HashSet(1);
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            if (currency != null) {
                expCurrencySet.add((Long)currency.getPkValue());
            }
        }
        if (expCurrencySet.size() != 1) {
            String entityDisplayName = ((EntityType)model.getDataEntityType().getAllEntities().get(bill.getExpenseEntryEntityName())).getDisplayName().toString();
            msg = String.format(ResManager.loadKDString((String)"\u5173\u8054\u7684%1s\u5b58\u5728\u591a\u4e2a\u5e01\u79cd\uff0c\u4e0d\u80fd\u5173\u8054\u3002", (String)"RelateExpenseOrTripItemAndInvoiceUtil_7", (String)"fi-er-formplugin", (Object[])new Object[0]), entityDisplayName);
            return msg;
        }
        DynamicObjectCollection invoiceEntryEntity = dataEntity.getDynamicObjectCollection("invoiceentry");
        if (CollectionUtils.isEmpty((Collection)invoiceEntryEntity) || invoiceEntryIds.isEmpty()) {
            return msg;
        }
        Set invCurrencySet = invoiceEntryEntity.stream().filter(invoiceEntry -> invoiceEntryIds.contains(invoiceEntry.getPkValue())).map(invoiceEntry -> {
            DynamicObject invoiceCurrencyObj = invoiceEntry.getDynamicObject("invoicecurrency");
            if (invoiceCurrencyObj == null) {
                return null;
            }
            return (Long)invoiceCurrencyObj.getPkValue();
        }).collect(Collectors.toSet());
        if (invCurrencySet.size() != 1) {
            msg = ResManager.loadKDString((String)"\u5173\u8054\u7684\u53d1\u7968\u4fe1\u606f\u5b58\u5728\u591a\u4e2a\u5e01\u79cd\uff0c\u4e0d\u80fd\u5173\u8054\u3002", (String)"RelateExpenseOrTripItemAndInvoiceUtil_8", (String)"fi-er-formplugin", (Object[])new Object[0]);
            return msg;
        }
        Long expCurrency = (Long)expCurrencySet.iterator().next();
        Long invCurrency = (Long)invCurrencySet.iterator().next();
        if (expCurrency == null || invCurrency == null || !expCurrency.equals(invCurrency)) {
            msg = ResManager.loadKDString((String)"\u5173\u8054\u8d39\u7528\u660e\u7ec6\u4e0e\u53d1\u7968\u4fe1\u606f\u884c\u5e01\u79cd\u4e0d\u4e00\u81f4\uff0c\u4e0d\u80fd\u5173\u8054\u3002", (String)"RelateExpenseOrTripItemAndInvoiceUtil_9", (String)"fi-er-formplugin", (Object[])new Object[0]);
            return msg;
        }
        if (!RelateExpenseOrTripItemAndInvoiceUtil.checkIsAllowMapTripOrExpenseEntry(view, invoiceEntryIds)) {
            msg = ResManager.loadKDString((String)"\u6240\u9009\u4e2d\u7684\u53d1\u7968\u5fc5\u987b\u4e3a\u540c\u4e00\u7c7b\u578b\u3002", (String)"RelateExpenseOrTripItemAndInvoiceUtil_2", (String)"fi-er-formplugin", (Object[])new Object[0]);
            return msg;
        }
        return msg;
    }

    public static List<DynamicObject> getInvoiceEntrysByExpenseEntryId(DynamicObject dataEntity, Long expenseEntryId) {
        DynamicObjectCollection invoiceEntrys = dataEntity.getDynamicObjectCollection("invoiceentry");
        DynamicObjectCollection invoiceAndExpenseEntrys = dataEntity.getDynamicObjectCollection("invoiceandexpense");
        Set invoiceEntryIds = invoiceAndExpenseEntrys.stream().filter(entry -> Objects.equals(entry.getLong("expenseentryid"), expenseEntryId)).map(entry -> entry.getLong("invoiceentryid")).collect(Collectors.toSet());
        List<DynamicObject> filterInvoiceEntrys = invoiceEntrys.stream().filter(entry -> invoiceEntryIds.contains(entry.getPkValue())).collect(Collectors.toList());
        return filterInvoiceEntrys;
    }

    private static boolean checkIsAllowMapTripOrExpenseEntry(IFormView view, List<Long> invoiceEntryIds) {
        boolean isMustSameType = ErStdConfig.isMustSameInvoiceTypeInRelatingInvoice();
        if (!isMustSameType) {
            return true;
        }
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceEntryDOs = dataEntity.getDynamicObjectCollection("invoiceentry");
        if (invoiceEntryDOs.isEmpty()) {
            return true;
        }
        long invoiceTypeCount = invoiceEntryDOs.stream().filter(entry -> invoiceEntryIds.contains(ErCommonUtils.getPk(entry))).map(entry -> entry.getString("invoicetype")).distinct().count();
        return invoiceTypeCount <= 1L;
    }

    public static List<Long> setAndGetSelectedRowEntryId(IFormView view, BillOfInvoice bill) {
        DynamicObjectCollection expenseEntryEntity;
        IDataModel model = view.getModel();
        EntryGrid grid = (EntryGrid)view.getControl(bill.getExpenseEntryEntityName());
        int[] rowIndexs = grid.getSelectRows();
        if (bill == BillOfInvoice.TripReimburseBill) {
            EntryGrid tripGrid = (EntryGrid)view.getControl("tripentry");
            int[] tripIndex = tripGrid.getSelectRows();
            int selectRowIndex = tripIndex.length == 0 ? view.getModel().getEntryCurrentRowIndex("tripentry") : tripIndex[0];
            Map tripMap = (Map)bill.getExpenseEntryEntities(model.getDataEntity(true));
            expenseEntryEntity = (DynamicObjectCollection)tripMap.get(selectRowIndex);
        } else {
            expenseEntryEntity = (DynamicObjectCollection)bill.getExpenseEntryEntities(model.getDataEntity(true));
        }
        if (CollectionUtils.isEmpty((Collection)expenseEntryEntity)) {
            return new ArrayList<Long>();
        }
        Arrays.stream(rowIndexs).mapToObj(rowIndex -> (DynamicObject)expenseEntryEntity.get(rowIndex)).forEach(entry -> {
            Long entryId = (Long)entry.getPkValue();
            if (Objects.equals(entryId, 0L)) {
                entryId = ORM.create().genLongId(view.getEntityId());
                entry.set("id", (Object)entryId);
            }
        });
        List<Long> expenseEntryIds = Arrays.stream(rowIndexs).mapToObj(rowIndex -> (DynamicObject)expenseEntryEntity.get(rowIndex)).filter(expenseEntry -> !Objects.equals(expenseEntry.getPkValue(), 0L)).map(entry -> (Long)entry.getPkValue()).collect(Collectors.toList());
        return expenseEntryIds;
    }

    private static List<Long> setAndGetSelectedRowEntryId(IFormView view, String entityName) {
        IDataModel model = view.getModel();
        EntryGrid grid = (EntryGrid)view.getControl(entityName);
        int[] rowIndexs = grid.getSelectRows();
        DynamicObjectCollection expenseEntryEntity = model.getDataEntity(true).getDynamicObjectCollection(entityName);
        List<Long> expenseEntryIds = new ArrayList<Long>();
        if (expenseEntryEntity != null && !expenseEntryEntity.isEmpty() && rowIndexs.length <= expenseEntryEntity.size()) {
            Arrays.stream(rowIndexs).mapToObj(rowIndex -> (DynamicObject)expenseEntryEntity.get(rowIndex)).forEach(entry -> {
                Long entryId = (Long)entry.getPkValue();
                if (Objects.equals(entryId, 0L)) {
                    entryId = ORM.create().genLongId(view.getEntityId());
                    entry.set("id", (Object)entryId);
                }
            });
            expenseEntryIds = Arrays.stream(rowIndexs).mapToObj(rowIndex -> (DynamicObject)expenseEntryEntity.get(rowIndex)).filter(expenseEntry -> !Objects.equals(expenseEntry.getPkValue(), 0L)).map(entry -> (Long)entry.getPkValue()).collect(Collectors.toList());
        }
        return expenseEntryIds;
    }

    public static void mapExpenseEntryAndInvoiceEntryBy(IFormView view, BillOfInvoice bill, List<Long> expenseEntryIds, List<Long> invoiceEntryIds) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        Map oldExpenseRelationGroup = InvoiceUtils2.getAllInvoiceRelationGroup((IFormView)view, (RelationMainView)RelationMainView.VIEW_EXPENSE);
        DynamicObjectCollection invoiceAndExpenseEntrys = model.getEntryEntity("invoiceandexpense");
        DynamicObjectCollection invoiceEntrys = model.getEntryEntity("invoiceentry");
        ArrayList needDelIndexs = Lists.newArrayList();
        for (int i = 0; i < invoiceAndExpenseEntrys.size(); ++i) {
            if (!expenseEntryIds.contains(((DynamicObject)invoiceAndExpenseEntrys.get(i)).getLong("expenseentryid"))) continue;
            needDelIndexs.add(i);
        }
        model.deleteEntryRows("invoiceandexpense", needDelIndexs.stream().mapToInt(Integer::intValue).toArray());
        int totalCount = expenseEntryIds.size() * invoiceEntryIds.size();
        if (totalCount != 0) {
            int newRowIndex = 0;
            model.beginInit();
            int[] batchIds = model.batchCreateNewEntryRow("invoiceandexpense", totalCount);
            for (int i = 0; i < expenseEntryIds.size(); ++i) {
                for (int j = 0; j < invoiceEntryIds.size(); ++j) {
                    model.setValue("expenseentryid", (Object)expenseEntryIds.get(i), batchIds[newRowIndex]);
                    model.setValue("invoiceentryid", (Object)invoiceEntryIds.get(j), batchIds[newRowIndex]);
                    if (model.getProperty("invoiceexpserialno") != null && j < invoiceEntrys.size()) {
                        model.setValue("invoiceexpserialno", ((DynamicObject)invoiceEntrys.get(j)).get("serialno"), batchIds[newRowIndex]);
                    }
                    ++newRowIndex;
                }
            }
            model.endInit();
        }
        String createLog = ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6\u5173\u8054\u53d1\u7968\u4fe1\u606f\uff0c\u5171\u521b\u5efa\u53d1\u7968\u5173\u8054\u5173\u7cfb\uff1a%s\u884c\u3002", (String)"RelateExpenseOrTripItemAndInvoiceUtil_12", (String)"fi-er-formplugin", (Object[])new Object[0]);
        logger.info(String.format(createLog, totalCount));
        String unionInvoiceCode = invoiceEntrys.stream().filter(entry -> invoiceEntryIds.contains(entry.getPkValue())).map(entry -> entry.getString("invoicecode")).collect(Collectors.joining(","));
        String unionInvoiceNo = invoiceEntrys.stream().filter(entry -> invoiceEntryIds.contains(entry.getPkValue())).map(entry -> entry.getString("invoiceno")).collect(Collectors.joining(","));
        ItemFrom itemFrom = invoiceEntryIds.isEmpty() ? ItemFrom.Manual : ItemFrom.InvoiceCloud;
        Boolean isAutomapinvoice = (Boolean)model.getValue("automapinvoice");
        ThreadCache.put((Object)"isAutomapinvoice", (Object)isAutomapinvoice);
        DynamicObjectCollection expenseEntryDOs = null;
        ArrayList<Integer> cards = new ArrayList<Integer>(4);
        if (BillOfInvoice.TripReimburseBill == bill) {
            Map map = (Map)bill.getExpenseEntryEntities(dataEntity);
            for (Map.Entry entry2 : map.entrySet()) {
                Integer k = (Integer)entry2.getKey();
                cards.add(k);
                expenseEntryDOs = (DynamicObjectCollection)entry2.getValue();
                for (int rowIndex = 0; rowIndex < expenseEntryDOs.size(); ++rowIndex) {
                    DynamicObject expenseEntryDO = (DynamicObject)expenseEntryDOs.get(rowIndex);
                    if (!expenseEntryIds.contains(ErCommonUtils.getPk(expenseEntryDO))) continue;
                    model.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo(unionInvoiceNo), rowIndex, k.intValue());
                    model.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode(unionInvoiceCode), rowIndex, k.intValue());
                    model.setValue("itemfrom", (Object)itemFrom.getValue(), rowIndex, k.intValue());
                }
            }
        } else {
            Iterator expenseEntryEntities = bill.getExpenseEntryEntities(dataEntity);
            if (expenseEntryEntities instanceof DynamicObjectCollection) {
                cards.add(-1);
                expenseEntryDOs = (DynamicObjectCollection)expenseEntryEntities;
                for (int rowIndex = 0; rowIndex < expenseEntryDOs.size(); ++rowIndex) {
                    DynamicObject expenseEntryDO = (DynamicObject)expenseEntryDOs.get(rowIndex);
                    if (!expenseEntryIds.contains(ErCommonUtils.getPk(expenseEntryDO))) continue;
                    model.setValue("invoiceno_entry", (Object)InvoiceUtils.getLimitedInvoiceNo(unionInvoiceNo), rowIndex);
                    model.setValue("invoicelink", (Object)InvoiceUtils.getLimitedInvoiceCode(unionInvoiceCode), rowIndex);
                    model.setValue("itemfrom", (Object)itemFrom.getValue(), rowIndex);
                }
            }
        }
        InvoiceUtils2.clearCacheRelation();
        for (Integer c : cards) {
            InvoiceOffsetUtils.refreshAll(model, c);
        }
        if (BillOfInvoice.TripReimburseBill == bill && view instanceof IMobileView) {
            InvoiceOffsetUtils.refreshAllInvoiceOffsetAndOutAmount(view, invoiceEntryIds, BillExpenseInfoFildKeyType.TripReimburse);
        } else {
            InvoiceOffsetUtils.refreshAllInvoiceOffsetAndOutAmount(view, 0);
        }
        view.updateView(bill.getExpenseEntryEntityName());
        RelateExpenseOrTripItemAndInvoiceUtil.updateIsMapExpense(view, dataEntity);
        view.updateView(bill.getExpenseEntryEntityName());
        if (bill == BillOfInvoice.DailyReimburseBill) {
            HashSet<Long> mayUpdateInvoiceSet = new HashSet<Long>();
            for (Long expenseEntryId : expenseEntryIds) {
                Set oldInvoiceHeadIdSet;
                InvoiceRelation relation = (InvoiceRelation)oldExpenseRelationGroup.get(expenseEntryId);
                if (relation == null || CollectionUtils.isEmpty((Collection)(oldInvoiceHeadIdSet = relation.getOtherViewIds()))) continue;
                mayUpdateInvoiceSet.addAll(oldInvoiceHeadIdSet);
            }
            mayUpdateInvoiceSet.addAll(invoiceEntryIds);
            RelateExpenseOrTripItemAndInvoiceUtil.updateInvoiceInfoCurrentExpenseAmountByInvoiceId(view, mayUpdateInvoiceSet);
        }
    }

    public static void updateInvoiceInfoCurrentExpenseAmount(IDataModel dataModel, int[] expenseRowIndexes, int invoiceRowIndex) {
        if (invoiceRowIndex == -1) {
            return;
        }
        if (dataModel.getProperty("ismutilreimburse") != null) {
            BigDecimal oriReimburseAmount = (BigDecimal)dataModel.getValue("totalamount", invoiceRowIndex);
            Object invCurrency = dataModel.getValue("invoicecurrency", invoiceRowIndex);
            if (expenseRowIndexes.length != 0) {
                DynamicObjectCollection entryEntity = dataModel.getEntryEntity("expenseentryentity");
                Optional<BigDecimal> reduce = Arrays.stream(expenseRowIndexes).filter(index -> invCurrency == ((DynamicObject)entryEntity.get(index)).get("entrycurrency")).mapToObj(index -> ((DynamicObject)entryEntity.get(index)).getBigDecimal("expeapproveamount")).reduce(BigDecimal::add);
                if (reduce.isPresent()) {
                    oriReimburseAmount = reduce.get();
                }
            }
            dataModel.setValue("poolreimburseamount", (Object)oriReimburseAmount, invoiceRowIndex);
        }
    }

    public static void updateIsMapExpense(IFormView view, DynamicObject dataEntity) {
        IDataModel model = view.getModel();
        Set invoiceHeadEntryIds = dataEntity.getDynamicObjectCollection("invoiceandexpense").stream().map(entry -> entry.getLong("invoiceentryid")).collect(Collectors.toSet());
        DynamicObjectCollection invoiceHeadEntrys = dataEntity.getDynamicObjectCollection("invoiceentry");
        for (int i = 0; i < invoiceHeadEntrys.size(); ++i) {
            DynamicObject entry2 = (DynamicObject)invoiceHeadEntrys.get(i);
            if (invoiceHeadEntryIds.contains(entry2.getPkValue())) {
                model.setValue("ismapexpense", (Object)"1", i);
                continue;
            }
            model.setValue("ismapexpense", (Object)"0", i);
        }
    }

    public static void selectedRelateInvoiceEntryByClickExpenseEntry(IFormView view, BillOfInvoice bill) {
        IDataModel model = view.getModel();
        DynamicObject dataEntity = model.getDataEntity(true);
        List<Long> expenseEntryIds = RelateExpenseOrTripItemAndInvoiceUtil.setAndGetSelectedRowEntryId(view, bill);
        EntryGrid invoiceHeadGrid = (EntryGrid)view.getControl("invoiceentry");
        Set<Long> invoiceIdSet = InvoiceUtils.getInvoiceIdsOfItems(model, expenseEntryIds.stream().collect(Collectors.toSet()));
        invoiceHeadGrid.selectRows(new int[0], -1);
        DynamicObjectCollection invoiceHeadEntryEntity = dataEntity.getDynamicObjectCollection("invoiceentry");
        ArrayList invoiceHeadRowIndexs = Lists.newArrayList();
        for (int i = 0; i < invoiceHeadEntryEntity.size(); ++i) {
            if (!invoiceIdSet.contains(((DynamicObject)invoiceHeadEntryEntity.get(i)).getPkValue())) continue;
            invoiceHeadRowIndexs.add(i);
        }
        if (invoiceHeadRowIndexs != null && invoiceHeadRowIndexs.size() > 0) {
            invoiceHeadGrid = (EntryGrid)view.getControl("invoiceentry");
            int[] invoiceRows = invoiceHeadRowIndexs.stream().mapToInt(Integer::intValue).toArray();
            invoiceHeadGrid.selectRows(invoiceRows, -1);
        }
    }

    public static void resetInvoiceInfo(IDataModel model, List<Long> expenseEntryIds, List<Long> invoiceEntryIds) {
        int invoiceDownCount = model.getEntryRowCount("invoiceentry");
        for (Long expenseEntryId : expenseEntryIds) {
            List<DynamicObject> mapInvoiceInfo = RelateExpenseOrTripItemAndInvoiceUtil.getInvoiceEntrysByExpenseEntryId(model.getDataEntity(true), expenseEntryId);
            if (CollectionUtils.isEmpty(mapInvoiceInfo)) continue;
            List invoiceHeadIds = mapInvoiceInfo.stream().map(info -> (Long)info.getPkValue()).collect(Collectors.toList());
            if (invoiceEntryIds == null || invoiceEntryIds.contains(invoiceHeadIds.get(0))) continue;
            for (int i = 0; i < invoiceDownCount; ++i) {
                Long invoiceObjID = (Long)((DynamicObject)((DynamicObjectCollection)model.getValue("invoiceentry")).get(i)).getPkValue();
                if (!invoiceHeadIds.contains(invoiceObjID)) continue;
                model.setValue("islinkagedetail", (Object)false, i);
            }
        }
    }

    public static void clearDirtExpenseAndInvoiceEntry(IFormView billView, BillOfInvoice billType) {
        DynamicObject dataEntity = billView.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceAndExpenseEntry = dataEntity.getDynamicObjectCollection("invoiceandexpense");
        Set invoiceEntryIds = dataEntity.getDynamicObjectCollection("invoiceentry").stream().map(entry -> (Long)entry.getPkValue()).collect(Collectors.toSet());
        Set<Object> expenseEntryIds = new HashSet(16);
        if (billType == BillOfInvoice.DailyReimburseBill) {
            DynamicObjectCollection expenseEntryEntity = (DynamicObjectCollection)billType.getExpenseEntryEntities(dataEntity);
            expenseEntryIds = expenseEntryEntity.stream().map(entry -> (Long)entry.getPkValue()).collect(Collectors.toSet());
        } else {
            Map map = (Map)billType.getExpenseEntryEntities(dataEntity);
            for (Map.Entry m : map.entrySet()) {
                expenseEntryIds.addAll(((DynamicObjectCollection)m.getValue()).stream().map(entry -> (Long)entry.getPkValue()).collect(Collectors.toSet()));
            }
        }
        ArrayList delIndexs = Lists.newArrayList();
        for (int i = 0; i < invoiceAndExpenseEntry.size(); ++i) {
            DynamicObject entry2 = (DynamicObject)invoiceAndExpenseEntry.get(i);
            long expenseEntryId = entry2.getLong("expenseentryid");
            long invoiceEntryId = entry2.getLong("invoiceentryid");
            if (invoiceEntryIds.contains(invoiceEntryId) && expenseEntryIds.contains(expenseEntryId) || billView.getModel().getProperty("invoiceexpisunbind") != null && ((Boolean)billView.getModel().getValue("invoiceexpisunbind", i)).booleanValue()) continue;
            delIndexs.add(i);
        }
        billView.getModel().deleteEntryRows("invoiceandexpense", delIndexs.stream().mapToInt(Integer::intValue).toArray());
        RelateExpenseOrTripItemAndInvoiceUtil.updateIsMapExpense(billView, dataEntity);
        RelateExpenseOrTripItemAndInvoiceUtil.updateInvoiceNoAndCodeInExpenseEntry(billView, dataEntity, billType);
    }

    private static String getInvoiceNosByExpenseEntryId(DynamicObject dataEntity, Long expenseEntryId) {
        List<DynamicObject> invoiceEntrys = RelateExpenseOrTripItemAndInvoiceUtil.getInvoiceEntrysByExpenseEntryId(dataEntity, expenseEntryId);
        String unionInvoiceNo = invoiceEntrys.stream().map(entry -> entry.getString("invoiceno")).collect(Collectors.joining(","));
        return InvoiceUtils.getLimitedInvoiceNo(unionInvoiceNo);
    }

    private static String getInvoiceCodesByExpenseEntryId(DynamicObject dataEntity, Long expenseEntryId) {
        List<DynamicObject> invoiceEntrys = RelateExpenseOrTripItemAndInvoiceUtil.getInvoiceEntrysByExpenseEntryId(dataEntity, expenseEntryId);
        String unionInvoiceCode = invoiceEntrys.stream().map(entry -> entry.getString("invoicecode")).collect(Collectors.joining(","));
        return InvoiceUtils.getLimitedInvoiceCode(unionInvoiceCode);
    }

    private static void updateInvoiceNoAndCodeInExpenseEntry(IFormView billView, DynamicObject dataEntity, BillOfInvoice bill) {
        IDataModel model = billView.getModel();
        Object obj = bill.getExpenseEntryEntities(dataEntity);
        Map<Integer, DynamicObjectCollection> map = new HashMap(2);
        if (BillOfInvoice.TripReimburseBill == bill && obj instanceof Map) {
            map = (Map)bill.getExpenseEntryEntities(dataEntity);
        } else {
            Object expenseEntryEntities = bill.getExpenseEntryEntities(dataEntity);
            if (expenseEntryEntities instanceof DynamicObjectCollection) {
                map.put(-1, (DynamicObjectCollection)expenseEntryEntities);
            }
        }
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            int parentIndex = (Integer)entry.getKey();
            DynamicObjectCollection expenseEntrys = (DynamicObjectCollection)entry.getValue();
            for (int i = 0; i < expenseEntrys.size(); ++i) {
                DynamicObject expenseEntry = (DynamicObject)expenseEntrys.get(i);
                String itemFrom = expenseEntry.getString("itemfrom");
                Long expenseEntryId = (Long)expenseEntry.getPkValue();
                String unionInvoiceNos = RelateExpenseOrTripItemAndInvoiceUtil.getInvoiceNosByExpenseEntryId(dataEntity, expenseEntryId);
                String unionInvoiceCodes = RelateExpenseOrTripItemAndInvoiceUtil.getInvoiceCodesByExpenseEntryId(dataEntity, expenseEntryId);
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)unionInvoiceNos) && org.apache.commons.lang3.StringUtils.equals((CharSequence)itemFrom, (CharSequence)ItemFrom.EntryImport.getValue())) continue;
                model.setValue("invoiceno_entry", (Object)unionInvoiceNos, i, parentIndex);
                model.setValue("invoicelink", (Object)unionInvoiceCodes, i, parentIndex);
                List<DynamicObject> invoiceEntrysByExpenseEntryId = RelateExpenseOrTripItemAndInvoiceUtil.getInvoiceEntrysByExpenseEntryId(dataEntity, expenseEntryId);
                if (!invoiceEntrysByExpenseEntryId.isEmpty()) continue;
                model.setValue("itemfrom", (Object)ItemFrom.Manual.getValue(), i, parentIndex);
            }
        }
    }

    public static void clearDirtyExpenseAndInvoiceEntry(IFormView billView, Long invoiceEntryId) {
        DynamicObject entry;
        int i;
        DynamicObject dataEntity = billView.getModel().getDataEntity(true);
        DynamicObjectCollection invoiceAndExpenseEntrys = dataEntity.getDynamicObjectCollection("invoiceandexpense");
        DynamicObjectCollection invoiceItemEntrys = dataEntity.getDynamicObjectCollection("invoiceitementry");
        DynamicObjectCollection invoiceEntrys = dataEntity.getDynamicObjectCollection("invoiceentry");
        ArrayList unbindExpensIds = Lists.newArrayList();
        for (i = 0; i < invoiceAndExpenseEntrys.size(); ++i) {
            entry = (DynamicObject)invoiceAndExpenseEntrys.get(i);
            long expenseEntryId = entry.getLong("expenseentryid");
            long invoiceentryid = entry.getLong("invoiceentryid");
            if (invoiceentryid != invoiceEntryId || invoiceEntryId == 0L) continue;
            entry.set("invoiceentryid", (Object)0);
            entry.set("expenseentryid", (Object)0);
            entry.set("invoiceexpisunbind", (Object)true);
            unbindExpensIds.add(expenseEntryId);
        }
        for (i = 0; i < invoiceItemEntrys.size(); ++i) {
            entry = (DynamicObject)invoiceItemEntrys.get(i);
            long invoiceentryid = entry.getLong("invoiceheadentryid");
            if (invoiceentryid != invoiceEntryId || invoiceEntryId == 0L) continue;
            entry.set("itementryid", (Object)0);
            entry.set("invoiceheadentryid", (Object)0);
            entry.set("invoiceitemisunbind", (Object)true);
        }
        DynamicObjectCollection expenseEntrys = dataEntity.getDynamicObjectCollection("expenseentryentity");
        if (expenseEntrys != null && expenseEntrys.size() > 0 && unbindExpensIds.size() > 0) {
            for (int i2 = 0; i2 < expenseEntrys.size(); ++i2) {
                String[] invoiceNoArr;
                DynamicObject expenseEntry = (DynamicObject)expenseEntrys.get(i2);
                if (!unbindExpensIds.contains(expenseEntry.getPkValue())) continue;
                expenseEntry.set("expischangeinvoice", (Object)true);
                String unionInvoiceNos = RelateExpenseOrTripItemAndInvoiceUtil.getInvoiceNosByExpenseEntryId(dataEntity, (Long)expenseEntry.getPkValue());
                String unionInvoiceCodes = RelateExpenseOrTripItemAndInvoiceUtil.getInvoiceCodesByExpenseEntryId(dataEntity, (Long)expenseEntry.getPkValue());
                expenseEntry.set("invoiceno_entry", (Object)unionInvoiceNos);
                expenseEntry.set("invoicelink", (Object)unionInvoiceCodes);
                expenseEntry.set("taxclasscode", null);
                expenseEntry.set("expensegoodsname", (Object)"");
                String invoiceno_entry = expenseEntry.getString("invoiceno_entry");
                expenseEntry.set("invoicetypeitem", (Object)0);
                expenseEntry.set("is_special_invoice", (Object)false);
                if (!StringUtils.isEmpty((CharSequence)invoiceno_entry) && (invoiceNoArr = invoiceno_entry.split(",")) != null && invoiceNoArr.length > 0 && invoiceEntrys != null && invoiceEntrys.size() > 0) {
                    HashSet invoiceTypeSet = new HashSet(1);
                    for (String invoiceNo : invoiceNoArr) {
                        Set invoiceSubTypeSet = invoiceEntrys.stream().filter(v -> v.getString("invoiceno").equals(invoiceNo)).map(v -> v.getString("invoicetype")).collect(Collectors.toSet());
                        if (invoiceSubTypeSet == null || invoiceSubTypeSet.size() <= 0) continue;
                        invoiceTypeSet.addAll(invoiceSubTypeSet);
                    }
                    if (invoiceTypeSet != null && invoiceTypeSet.size() == 1) {
                        expenseEntry.set("invoicetypeitem", invoiceTypeSet.iterator().next());
                        Set<String> specialInvoiceTypes = InvoiceTypeUtils.loadSpecialInvoiceTypes();
                        if (specialInvoiceTypes != null && specialInvoiceTypes.size() > 0 && specialInvoiceTypes.contains(invoiceTypeSet.iterator().next())) {
                            expenseEntry.set("is_special_invoice", (Object)true);
                        }
                    }
                }
                billView.updateView("taxclasscode", i2);
                billView.updateView("expensegoodsname", i2);
                billView.updateView("invoicetypeitem", i2);
                billView.updateView("is_special_invoice", i2);
                billView.updateView("expischangeinvoice", i2);
                billView.updateView("invoiceno_entry", i2);
                billView.updateView("invoicelink", i2);
            }
        }
    }

    @Deprecated
    public static void clearDirtExpenseAndInvoiceEntry(IFormView view) {
        RelateExpenseOrTripItemAndInvoiceUtil.clearDirtExpenseAndInvoiceEntry(view, BillOfInvoice.DailyReimburseBill);
    }

    public static void updateInvoiceInfoCurrentExpenseAmountByInvoiceId(IFormView view, Set<Long> invoiceHeadIdSet) {
        IDataModel model = view.getModel();
        Map newInvoiceRelationGroup = InvoiceUtils2.getAllInvoiceRelationGroup((IFormView)view, (RelationMainView)RelationMainView.VIEW_INVOICE);
        for (Long invoiceHeadId : invoiceHeadIdSet) {
            InvoiceRelation relation = (InvoiceRelation)newInvoiceRelationGroup.get(invoiceHeadId);
            int[] invoiceIndexes = InvoiceUtils2.getIndexes((IDataModel)model, (String)"invoiceentry", Collections.singleton(invoiceHeadId));
            if (invoiceIndexes.length == 0) continue;
            int invoiceRowIndex = invoiceIndexes[0];
            if (relation == null || relation.getRelationEnum() == null) {
                boolean isMutilReim = false;
                if (model.getProperty("ismutilreimburse") != null) {
                    isMutilReim = (Boolean)model.getValue("ismutilreimburse", invoiceRowIndex);
                }
                if (isMutilReim) {
                    model.setValue("poolreimburseamount", (Object)BigDecimal.ZERO, invoiceRowIndex);
                    continue;
                }
                RelateExpenseOrTripItemAndInvoiceUtil.updateInvoiceInfoCurrentExpenseAmount(model, new int[0], invoiceRowIndex);
                continue;
            }
            if (ItemInvoiceRelationEnum.IsOneForOne == relation.getRelationEnum() || ItemInvoiceRelationEnum.IsNForOne == relation.getRelationEnum()) {
                int[] expenseIndexes = InvoiceUtils2.getIndexes((IDataModel)model, (String)"expenseentryentity", (Set)relation.getOtherViewIds());
                RelateExpenseOrTripItemAndInvoiceUtil.updateInvoiceInfoCurrentExpenseAmount(model, expenseIndexes, invoiceRowIndex);
                continue;
            }
            boolean isMutilReim = false;
            if (model.getProperty("ismutilreimburse") != null) {
                isMutilReim = (Boolean)model.getValue("ismutilreimburse", invoiceRowIndex);
            }
            if (isMutilReim) {
                model.setValue("poolreimburseamount", (Object)BigDecimal.ZERO, invoiceRowIndex);
                continue;
            }
            RelateExpenseOrTripItemAndInvoiceUtil.updateInvoiceInfoCurrentExpenseAmount(model, new int[0], invoiceRowIndex);
        }
    }
}

