/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.util;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.IMobileView;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.er.business.daily.reimburse.topublic.AccountInfo;
import kd.fi.er.business.daily.reimburse.topublic.PublicReimbursePayerAcctUtils;
import kd.fi.er.business.servicehelper.BaseCurrencyServiceHelper;
import kd.fi.er.business.servicehelper.CommonServiceHelper;
import kd.fi.er.business.servicehelper.CoreBaseBillServiceHelper;
import kd.fi.er.business.servicehelper.ExpenseItemServiceHelper;
import kd.fi.er.business.servicehelper.PayeeServiceHelper;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.AmountFormatsUtil;
import kd.fi.er.business.utils.AmountUtils;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.business.utils.ErCostCenterUtil;
import kd.fi.er.business.utils.ErEntityTypeUtils;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.common.PayerTypeEnum;
import kd.fi.er.formplugin.daily.web.util.WriteOffMoneyUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class DataCopyUtils {
    private static final Log logger = LogFactory.getLog(DataCopyUtils.class);
    private static final String ENABLE = "enable";
    private static final String[] needDeleteEntry = new String[]{"caspayentry", "clearloanentry", "invoiceentry", "invoiceitementry", "invoiceandexpense", "writeoffapply", "writeoffmoney", "withholdingentry", "writeofftriprelate", "sharedetailentry"};

    public static Boolean isCopyBill(IFormView view) {
        Boolean isCopy = (Boolean)view.getFormShowParameter().getCustomParam("iscopy");
        if (isCopy != null && isCopy.booleanValue()) {
            return true;
        }
        return false;
    }

    public static boolean isPCView(IFormView view) {
        boolean isPCView = false;
        if (!(view instanceof IMobileView)) {
            isPCView = true;
        }
        return isPCView;
    }

    public static boolean isMobView(IFormView view) {
        boolean isMobView = false;
        if (view instanceof IMobileView) {
            isMobView = true;
        }
        return isMobView;
    }

    public static void handleData(IDataModel model, IFormView view) {
        MainEntityType entityType = model.getDataEntityType();
        String entityId = entityType.getName();
        DataCopyUtils.setOriginValue(view);
        DataCopyUtils.updateUserInfo(model, view);
        DataCopyUtils.checkCostDept(model, view);
        if (model.getValue("company") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u6216\u90e8\u95e8\u4fe1\u606f\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DataCopyUtils_2", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        if (model.getValue("costcompany") != null) {
            Long newCurrency = BaseCurrencyServiceHelper.getBaseCurrencyId(model.getValue("company"), model.getValue("costcompany"));
            model.setValue("currency", (Object)newCurrency);
        }
        logger.info("kd.fi.er.formplugin.util.DataCopyUtils.handleData\u590d\u5236 - " + entityId);
        if (ErEntityTypeUtils.isTripReqBill(entityId)) {
            DataCopyUtils.copyReqBill(model, view);
        } else if (ErEntityTypeUtils.isTripReimburseBill(entityId)) {
            DataCopyUtils.copyReimburseBill(model, view);
            DataCopyUtils.refreshOffset(model, view);
        } else if (ErEntityTypeUtils.isDailyLoanBill(entityId)) {
            DataCopyUtils.copyDailyLoanBill(model, view);
        } else if (ErEntityTypeUtils.isDailyReimburseBill(entityId)) {
            model.beginInit();
            DataCopyUtils.copyDailyReimBill(model, view);
            model.endInit();
            DataCopyUtils.refreshOffset(model, view);
            CommonServiceHelper.getDeductibleTaxShowType(model, view);
            DataCopyUtils.expItemHandle(model, view);
        } else if (ErEntityTypeUtils.isDailyApplyBill(entityId)) {
            DataCopyUtils.copyDailyApplyBill(model, view);
        } else if (ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
            DataCopyUtils.copyPublicReimburseBill(model, view);
            DataCopyUtils.refreshOffset(model, view);
        } else if (ErEntityTypeUtils.isWithholdingBill(entityId)) {
            DataCopyUtils.copyWithholdingBill(model, view);
        } else if (ErEntityTypeUtils.isPrePayBill(entityId)) {
            DataCopyUtils.copyPrePayBill(model, view);
        }
        Object company = model.getValue("company");
        if (company != null) {
            IDataEntityProperty writeOffType = model.getProperty("writeofftype");
            IDataEntityProperty loanCheckType = model.getProperty("loanchecktype");
            String typeFlag = (String)ErCommonUtils.getEMParameter(ErCommonUtils.getPk(company), "er010");
            if (writeOffType != null) {
                model.setValue("writeofftype", (Object)typeFlag);
            }
            if (loanCheckType != null) {
                model.setValue("loanchecktype", (Object)typeFlag);
            }
        }
        String isgetaccountcurrency = "0";
        if (model.getValue("company") != null) {
            isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((DynamicObject)model.getValue("company")).getPkValue());
        }
        if ("1".equals(isgetaccountcurrency)) {
            model.setValue("iscurrency", (Object)Boolean.TRUE);
        }
        if (ErEntityTypeUtils.isDailyLoanBill(entityId) || ErEntityTypeUtils.isDailyReimburseBill(entityId) || ErEntityTypeUtils.isPrePayBill(entityId) || ErEntityTypeUtils.isPublicReimburseBill(entityId)) {
            DataCopyUtils.dailyReimAfterCopyData(model, view, entityId);
        }
        if (ErEntityTypeUtils.isTripReimburseBill(entityId) || ErEntityTypeUtils.isTripReqBill(entityId)) {
            DataCopyUtils.tripReimAfterCopyData(model, view);
        }
        view.getFormShowParameter().getCustomParams().remove("iscopy");
        view.cacheFormShowParameter();
    }

    private static void copyPublicReimburseBill(IDataModel model, IFormView view) {
        DataCopyUtils.updateExpEntry(model, view);
        DataCopyUtils.expItemHandle(model, view);
        DataCopyUtils.updateAccountEntry(model, view);
        DataCopyUtils.checkProject(model, view);
        CommonServiceHelper.getDeductibleTaxShowType(model, view);
        model.deleteEntryData("contractentry");
    }

    private static void checkProject(IDataModel model, IFormView view) {
    }

    public static void setOriginValue(IFormView view) {
        IDataModel model = view.getModel();
        if (model.getDataEntity().getDataEntityType().getProperties().get((Object)"origin") != null) {
            if (DataCopyUtils.isMobView(view)) {
                model.setValue("origin", (Object)2);
            } else if (DataCopyUtils.isPCView(view)) {
                model.setValue("origin", (Object)1);
            }
        }
    }

    private static void copyReqBill(IDataModel model, IFormView view) {
        DynamicObject currency;
        DynamicObject tripType;
        model.setValue("editentry", (Object)0);
        Boolean isLoan = (Boolean)model.getValue("isloan");
        isLoan = isLoan == null ? Boolean.FALSE : isLoan;
        Boolean isCurrncy = (Boolean)model.getValue("iscurrency");
        if (isCurrncy == null) {
            isCurrncy = Boolean.FALSE;
        }
        if ((tripType = (DynamicObject)model.getValue("triptype")) != null && !DataCopyUtils.checkTripType(tripType.getLong("id")).booleanValue()) {
            model.setValue("triptype", null);
            view.showTipNotification(ResManager.loadKDString((String)"\u51fa\u5dee\u7c7b\u578b\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DataCopyUtils_0", (String)"fi-er-business", (Object[])new Object[0]));
        }
        if ((currency = (DynamicObject)model.getValue("currency")) == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"DataCopyUtils_1", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u6216\u90e8\u95e8\u4fe1\u606f\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DataCopyUtils_2", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        if (isLoan.booleanValue() && isCurrncy.booleanValue()) {
            DynamicObjectCollection tripEntry = model.getEntryEntity("tripentry");
            int currencyPrecision = AmountUtils.getCurrencyPrecision(model, "currency");
            BigDecimal loanAmount = BigDecimal.ZERO;
            Object costCompany = model.getValue("costcompany");
            for (int rowIndex = 0; rowIndex < tripEntry.size(); ++rowIndex) {
                DynamicObject tripCurrency = (DynamicObject)model.getValue("tripcurrency", rowIndex);
                Map<String, Object> exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams(company, costCompany, tripCurrency.getLong("id"), currency.getLong("id"), model);
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateAndQuoteType.get("exchangeRate")), (Object)BigDecimal.ONE);
                String tripQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteType.get("quoteType")), (Object)"0");
                model.setValue("tripexchangerate", (Object)exchangeRate, rowIndex);
                BigDecimal tripOriAmount = (BigDecimal)model.getValue("triporiamount", rowIndex);
                BigDecimal tripAmount = AmountUtils.getCurrencyAmount(tripOriAmount, (BigDecimal)model.getValue("tripexchangerate", rowIndex), currencyPrecision, tripQuoteType);
                loanAmount = loanAmount.add(tripAmount);
                model.setValue("tripquotetype", (Object)tripQuoteType, rowIndex);
                model.setValue("tripamount", (Object)tripAmount, rowIndex);
                model.setValue("tripaccappamount", (Object)tripAmount, rowIndex);
            }
            model.setValue("loanamount", (Object)loanAmount);
            model.setValue("approveamount", (Object)loanAmount);
            model.setValue("amount", (Object)loanAmount);
            DataCopyUtils.updateAccountEntry(model, view);
        }
        StringBuilder rowReccorder = new StringBuilder();
        DynamicObjectCollection tripEntry = model.getEntryEntity("tripentry");
        Set<Long> validItemIDSet = DataCopyUtils.validateNonLeafExpItem(tripEntry, "tripexpenseitem");
        for (int rowIndex = 0; rowIndex < tripEntry.size(); ++rowIndex) {
            Object tripexpenseitemOb = model.getValue("tripexpenseitem", rowIndex);
            if (tripexpenseitemOb == null) continue;
            DynamicObject tripexpenseitem = (DynamicObject)tripexpenseitemOb;
            String enable = tripexpenseitem.getString(ENABLE);
            if (enable.equals("0")) {
                model.setValue("tripexpenseitem", null, rowIndex);
                rowReccorder.append(rowIndex + 1);
                rowReccorder.append('\uff0c');
                continue;
            }
            if (validItemIDSet.contains(ErCommonUtils.getPk(tripexpenseitem))) continue;
            model.setValue("tripexpenseitem", null, rowIndex);
        }
        if (rowReccorder.length() != 0) {
            String rows = rowReccorder.toString().substring(0, rowReccorder.lastIndexOf("\uff0c"));
            String format = String.format(ResManager.loadKDString((String)"\u884c\u7a0b\u4fe1\u606f\u7b2c%s\u884c\u5b58\u5728\u7981\u7528\u7684\u8d39\u7528\u9879\u76ee\uff0c\u5df2\u6e05\u7a7a\u5904\u7406\u3002", (String)"DataCopyUtils_3", (String)"fi-er-business", (Object[])new Object[0]), rows);
            view.showTipNotification(format);
        }
        DataCopyUtils.setRePayDate(model);
    }

    private static void copyReimburseBill(IDataModel model, IFormView view) {
        DynamicObject currency;
        model.setValue("editentry", (Object)0);
        DynamicObject tripType = (DynamicObject)model.getValue("triptype");
        if (tripType != null && !DataCopyUtils.checkTripType(tripType.getLong("id")).booleanValue()) {
            model.setValue("triptype", null);
            view.showTipNotification(ResManager.loadKDString((String)"\u51fa\u5dee\u7c7b\u578b\u4e0d\u53ef\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DataCopyUtils_0", (String)"fi-er-business", (Object[])new Object[0]));
        }
        DataCopyUtils.updateAccountEntry(model, view);
        Boolean isCurrncy = (Boolean)model.getValue("iscurrency");
        if (isCurrncy == null) {
            isCurrncy = Boolean.FALSE;
        }
        if ((currency = (DynamicObject)model.getValue("currency")) == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"DataCopyUtils_4", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u6216\u90e8\u95e8\u4fe1\u606f\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DataCopyUtils_2", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        if (isCurrncy.booleanValue()) {
            DynamicObjectCollection tripEntry = model.getEntryEntity("tripentry");
            Object costCompany = model.getValue("costcompany");
            int currencyPrecision = AmountUtils.getCurrencyPrecision(model, "currency");
            for (int rowIndex = 0; rowIndex < tripEntry.size(); ++rowIndex) {
                DynamicObject trip = (DynamicObject)tripEntry.get(rowIndex);
                DynamicObject tripCurrency = trip.getDynamicObject("tripcurrency");
                if (tripCurrency != null && tripCurrency != currency) {
                    Map<String, Object> exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams(company, costCompany, tripCurrency.getLong("id"), currency.getLong("id"), model);
                    BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateAndQuoteType.get("exchangeRate")), (Object)BigDecimal.ONE);
                    String tripQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteType.get("quoteType")), (Object)"0");
                    logger.info(">>>>>\u884c\u7a0b\u6c47\u7387 " + exchangeRate);
                    model.setValue("tripexchangerate", (Object)exchangeRate, rowIndex);
                    BigDecimal tripOriAmount = (BigDecimal)model.getValue("triporiamount", rowIndex);
                    BigDecimal tripAmount = AmountUtils.getCurrencyAmount(tripOriAmount, (BigDecimal)model.getValue("tripexchangerate", rowIndex), currencyPrecision, tripQuoteType);
                    model.setValue("tripquotetype", (Object)tripQuoteType, rowIndex);
                    model.setValue("tripamount", (Object)tripAmount, rowIndex);
                    model.setValue("tripappamount", (Object)tripAmount, rowIndex);
                }
                boolean isMonthly = false;
                DynamicObjectCollection expenseDetail = trip.getDynamicObjectCollection("entryentity");
                for (int expRowIndex = 0; expRowIndex < expenseDetail.size(); ++expRowIndex) {
                    DynamicObject expItem = (DynamicObject)expenseDetail.get(expRowIndex);
                    String setType = expItem.getString("settlementtype");
                    if ("2".equals(setType)) {
                        isMonthly = true;
                        break;
                    }
                    DynamicObject expCurrency = expItem.getDynamicObject("entrycurrency");
                    if (expCurrency == null || expCurrency == currency) continue;
                    Map<String, Object> exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams(company, costCompany, expCurrency.getLong("id"), currency.getLong("id"), model);
                    BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateAndQuoteType.get("exchangeRate")), (Object)BigDecimal.ONE);
                    String detailQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteType.get("quoteType")), (Object)"0");
                    model.setValue("detailquotetype", (Object)detailQuoteType, expRowIndex, rowIndex);
                    model.setValue("exchangerate", (Object)exchangeRate, expRowIndex, rowIndex);
                }
                if (!isMonthly) continue;
                view.showTipNotification(ResManager.loadKDString((String)"\u884c\u7a0b\u4e2d\u5305\u542b\u6708\u7ed3\uff0c\u4e0d\u5141\u8bb8\u590d\u5236\u3002", (String)"DataCopyUtils_5", (String)"fi-er-business", (Object[])new Object[0]));
                tripEntry.clear();
                view.updateView("tripentry");
                break;
            }
        }
        CommonServiceHelper.getDeductibleTaxShowType(model, view);
        String formId = view.getFormShowParameter().getFormId();
        StringBuilder rowReccorder = new StringBuilder();
        String detailMsgs = "";
        String headMsgs = "";
        Object headexpenseitemOb = model.getValue("headexpenseitem");
        if (headexpenseitemOb != null) {
            DynamicObject headexpenseitem = (DynamicObject)headexpenseitemOb;
            String enable = headexpenseitem.getString(ENABLE);
            if (enable.equals("0")) {
                model.setValue("headexpenseitem", null);
                headMsgs = String.format(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u5b58\u5728\u7981\u7528\u7684\u8d39\u7528\u9879\u76ee\uff0c\u5df2\u6e05\u7a7a\u5904\u7406\u3002", (String)"DataCopyUtils_6", (String)"fi-er-business", (Object[])new Object[0]), new Object[0]);
            } else {
                DynamicObject item = BusinessDataServiceHelper.loadSingleFromCache((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", headexpenseitem.get("id")), new QFilter("isleaf", "=", (Object)Boolean.TRUE)});
                if (item == null) {
                    model.setValue("headexpenseitem", null);
                }
            }
        }
        DynamicObjectCollection tripEntry = model.getEntryEntity("tripentry");
        int tripEntryIndex = model.getEntryCurrentRowIndex("tripentry");
        Set<Long> validItemIDSet = DataCopyUtils.validateNonLeafExpItem(tripEntry, "tripexpenseitem");
        for (int rowIndex = 0; rowIndex < tripEntry.size(); ++rowIndex) {
            DynamicObjectCollection reimburseDetails;
            Object tripexpenseitemOb = model.getValue("tripexpenseitem", rowIndex);
            if (tripexpenseitemOb != null) {
                DynamicObject tripexpenseitem = (DynamicObject)tripexpenseitemOb;
                String enable = tripexpenseitem.getString(ENABLE);
                if (enable.equals("0")) {
                    model.setValue("tripexpenseitem", null, rowIndex);
                    rowReccorder.append(rowIndex + 1);
                    rowReccorder.append('\uff0c');
                } else if (!validItemIDSet.contains(ErCommonUtils.getPk(tripexpenseitem))) {
                    model.setValue("tripexpenseitem", null, rowIndex);
                }
            }
            if ((reimburseDetails = ((DynamicObject)tripEntry.get(rowIndex)).getDynamicObjectCollection("entryentity")).size() <= 0) continue;
            ArrayList needRemoveRows = Lists.newArrayList();
            DynamicObjectCollection needRemoveObs = new DynamicObjectCollection();
            StringBuilder detailReccorder = new StringBuilder();
            for (int j = 0; j < reimburseDetails.size(); ++j) {
                String enable;
                DynamicObject reimburseDetail = (DynamicObject)reimburseDetails.get(j);
                DynamicObject tripItemDO = reimburseDetail.getDynamicObject("expenseitem");
                if (tripItemDO != null && (enable = tripItemDO.getString(ENABLE)).equals("0")) {
                    if (tripEntryIndex == rowIndex) {
                        needRemoveRows.add(j);
                    } else {
                        needRemoveObs.add((Object)reimburseDetail);
                    }
                    detailReccorder.append(j + 1);
                    detailReccorder.append('\uff0c');
                }
                BigDecimal orientryamount = ((DynamicObject)reimburseDetails.get(j)).getBigDecimal("orientryamount");
                model.setValue("orientryamount", (Object)orientryamount.subtract(BigDecimal.ONE), j, rowIndex);
                model.setValue("orientryamount", (Object)orientryamount, j, rowIndex);
            }
            if (!needRemoveRows.isEmpty()) {
                model.deleteEntryRows("entryentity", needRemoveRows.stream().mapToInt(Integer::intValue).toArray());
            }
            if (!needRemoveObs.isEmpty()) {
                reimburseDetails.removeAll((Collection)needRemoveObs);
            }
            if (detailReccorder.length() == 0) continue;
            String rows = detailReccorder.toString().substring(0, detailReccorder.lastIndexOf("\uff0c"));
            detailMsgs = "er_tripreimbill_grid".equals(formId) ? String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5dee\u65c5\u660e\u7ec6\u5b58\u5728\u7981\u7528\u7684\u5dee\u65c5\u9879\u76ee\uff0c\u5df2\u6e05\u7a7a\u5904\u7406\u3002", (String)"DataCopyUtils_7", (String)"fi-er-business", (Object[])new Object[0]), rows) : (detailMsgs.length() != 0 ? detailMsgs + "\r\n" + String.format(ResManager.loadKDString((String)"\u884c\u7a0b\u4fe1\u606f\u7b2c%1$s\u884c\u4e2d\u7b2c%2$s\u884c\u5dee\u65c5\u660e\u7ec6\u5b58\u5728\u7981\u7528\u7684\u5dee\u65c5\u9879\u76ee\uff0c\u5df2\u6e05\u7a7a\u5904\u7406\u3002", (String)"DataCopyUtils_8", (String)"fi-er-business", (Object[])new Object[0]), rowIndex + 1, rows) : detailMsgs + String.format(ResManager.loadKDString((String)"\u884c\u7a0b\u4fe1\u606f\u7b2c%1$s\u884c\u4e2d\u7b2c%2$s\u884c\u5dee\u65c5\u660e\u7ec6\u5b58\u5728\u7981\u7528\u7684\u5dee\u65c5\u9879\u76ee\uff0c\u5df2\u6e05\u7a7a\u5904\u7406\u3002", (String)"DataCopyUtils_8", (String)"fi-er-business", (Object[])new Object[0]), rowIndex + 1, rows));
        }
        String msgs = "";
        if (rowReccorder.length() != 0 && !"er_tripreimbill_grid".equals(formId)) {
            String rows = rowReccorder.toString().substring(0, rowReccorder.lastIndexOf("\uff0c"));
            msgs = String.format(ResManager.loadKDString((String)"\u884c\u7a0b\u4fe1\u606f\u7b2c%s\u884c\u5b58\u5728\u7981\u7528\u7684\u8d39\u7528\u9879\u76ee\uff0c\u5df2\u6e05\u7a7a\u5904\u7406\u3002", (String)"DataCopyUtils_3", (String)"fi-er-business", (Object[])new Object[0]), rows);
        }
        if (msgs.length() != 0 && detailMsgs.length() == 0) {
            view.showTipNotification(msgs);
        } else if (msgs.length() == 0 && detailMsgs.length() != 0) {
            if (headMsgs.length() != 0) {
                detailMsgs = headMsgs + "\r\n" + detailMsgs;
            }
            view.showTipNotification(detailMsgs);
        } else if (msgs.length() != 0 && detailMsgs.length() != 0) {
            view.showTipNotification(msgs + "\r\n" + detailMsgs);
        } else if (headMsgs.length() != 0) {
            view.showTipNotification(headMsgs);
        }
        DataCopyUtils.setRePayDate(model);
    }

    private static void copyDailyLoanBill(IDataModel model, IFormView view) {
        DataCopyUtils.refreshRepaymentDate(model);
        model.beginInit();
        DataCopyUtils.updateExpEntry(model, view);
        DataCopyUtils.updateAccountEntry(model, view);
        model.endInit();
    }

    private static void copyDailyReimBill(IDataModel model, IFormView view) {
        DataCopyUtils.updateAccountEntry(model, view);
        DataCopyUtils.updateExpEntry(model, view);
    }

    private static void copyDailyApplyBill(IDataModel model, IFormView view) {
        DataCopyUtils.updateApplyBillExpEntry(model, view);
        DataCopyUtils.updateExpEntry(model, view);
    }

    private static void copyWithholdingBill(IDataModel model, IFormView view) {
        DynamicObject withholdingType = (DynamicObject)model.getValue("withholdingtype");
        if (withholdingType != null && !DataCopyUtils.checkWithholdingType(withholdingType.getLong("id")).booleanValue()) {
            model.setValue("withholdingtype", null);
            view.showTipNotification(ResManager.loadKDString((String)"\u5355\u5934\u5b58\u5728\u7981\u7528\u7684\u9884\u63d0\u7c7b\u578b\uff0c\u5df2\u6e05\u7a7a\u5904\u7406\u3002", (String)"DataCopyUtils_20", (String)"fi-er-business", (Object[])new Object[0]));
        }
        view.updateView("withholdingtype");
        DataCopyUtils.updateExpEntry(model, view);
        DataCopyUtils.checkProject(model, view);
    }

    private static void copyPrePayBill(IDataModel model, IFormView view) {
        DataCopyUtils.updateExpEntry(model, view);
        DataCopyUtils.updateAccountEntry(model, view);
        DataCopyUtils.updateExepenseItem(model, view);
    }

    private static void updateExepenseItem(IDataModel model, IFormView view) {
        DynamicObjectCollection entry = model.getDataEntity(true).getDynamicObjectCollection("expenseentryentity");
        HashMap<Long, Map<Long, Set>> expenseItemMap = new HashMap<Long, Map<Long, Set>>(3);
        for (int i = 0; i < entry.size(); ++i) {
            Set relExpItems;
            Map<Long, Set> temp;
            DynamicObject row = (DynamicObject)entry.get(i);
            DynamicObject entryCostDept = row.getDynamicObject("entrycostdept");
            DynamicObject entryCostCompany = row.getDynamicObject("entrycostcompany");
            DynamicObject expenseitem = row.getDynamicObject("expenseitem");
            if (entryCostDept == null || entryCostCompany == null || expenseitem == null) {
                model.setValue("expenseitem", null, i);
                continue;
            }
            BiFunction<Long, Long, Set> queryFun = (costDeptPk, costCompany) -> {
                QFilter relExpItemsFilter = ExpenseItemServiceHelper.getRelExpItemsFilter("er_prepaybill", costDeptPk);
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)costCompany);
                relExpItemsFilter.and(baseDataFilter);
                return QueryServiceHelper.query((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{relExpItemsFilter}).stream().map(e -> e.getLong("id")).collect(Collectors.toSet());
            };
            Long costDeptPk2 = ErCommonUtils.getPk(entryCostDept);
            Long costCompanyPk = ErCommonUtils.getPk(entryCostCompany);
            if (!expenseItemMap.containsKey(costDeptPk2)) {
                temp = new HashMap();
                relExpItems = queryFun.apply(costDeptPk2, costCompanyPk);
                ((HashMap)temp).put(costCompanyPk, relExpItems);
                expenseItemMap.put(costDeptPk2, temp);
            } else {
                temp = (Map)expenseItemMap.get(costDeptPk2);
                relExpItems = (Set)temp.get(costCompanyPk);
                if (relExpItems == null) {
                    relExpItems = queryFun.apply(costDeptPk2, costCompanyPk);
                    temp.put(costCompanyPk, relExpItems);
                }
            }
            if (relExpItems.contains(ErCommonUtils.getPk(expenseitem))) continue;
            model.setValue("expenseitem", null, i);
        }
    }

    public static void updateUserInfo(IDataModel model, IFormView view) {
        String telStr = null;
        String deptStr = null;
        String positionStr = null;
        Object applierPicUrl = null;
        String nameStr = null;
        DynamicObject applier = (DynamicObject)model.getValue("applier");
        Long applierId = applier.getLong("id");
        Long currentUserID = CommonServiceHelper.getCurrentUserID();
        Object keepapplier = ErCommonUtils.getEMParameter(OrgUnitServiceHelper.getRootOrgId(), "keepapplier");
        if (applierId.longValue() != currentUserID.longValue()) {
            QFilter trustReimFilter = new QFilter("trustee", "=", (Object)currentUserID);
            trustReimFilter.and(new QFilter("consignor", "=", (Object)applierId));
            trustReimFilter.and(new QFilter(ENABLE, "=", (Object)true));
            Date currentDate = new Date();
            trustReimFilter.and(new QFilter("startdate", "<=", (Object)currentDate));
            trustReimFilter.and(new QFilter("enddate", ">=", (Object)currentDate));
            DynamicObject trustReim = BusinessDataServiceHelper.loadSingleFromCache((String)"er_entrustreimburse", (String)"consignor.id", (QFilter[])new QFilter[]{trustReimFilter});
            if (trustReim == null && !"copy".equals(keepapplier)) {
                view.showTipNotification(ResManager.loadKDString((String)"\u59d4\u6258\u5173\u7cfb\u5df2\u4e0d\u5b58\u5728\uff0c\u5df2\u91cd\u7f6e\u5355\u636e\u7533\u8bf7\u4eba\u4fe1\u606f\u4e3a\u767b\u5f55\u4eba\u5458\u7684\u4fe1\u606f\u3002", (String)"DataCopyUtils_9", (String)"fi-er-business", (Object[])new Object[0]));
                applierId = currentUserID;
                Map<String, Object> userMap = CommonServiceHelper.getUserMap(applierId);
                DynamicObject org = (DynamicObject)userMap.get("org");
                if (org == null) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u7ec4\u7ec7\u4fe1\u606f\u5f02\u5e38\u3002", (String)"DataCopyUtils_10", (String)"fi-er-business", (Object[])new Object[0]));
                } else {
                    model.setValue("org", (Object)ErCommonUtils.getPk(org));
                }
                model.setValue("applier", (Object)applierId);
                Map<String, Object> billMap = CoreBaseBillServiceHelper.createNewData(Long.valueOf(RequestContext.get().getUserId()));
                Object costdept = billMap.get("costdept");
                Object costcompany = billMap.get("costcompany");
                model.setValue("costdept", ErCommonUtils.getObjectValue(costdept));
                model.setValue("costcompany", ErCommonUtils.getObjectValue(costcompany));
                DataCopyUtils.initAccountEntry(model, view);
            }
            if (DataCopyUtils.isPCView(view)) {
                Image applierPic = (Image)view.getControl("applierpic");
                applierPic.setUrl(ErCommonUtils.getUserImageFullPath(applierId));
            } else {
                Control imageap_photo = view.getControl("imageap_photo");
                if (imageap_photo != null) {
                    ((Image)imageap_photo).setUrl(ErCommonUtils.getUserImageFullPath(applierId));
                }
            }
        }
        Map<String, Object> userMap = CommonServiceHelper.getUserMap(applierId);
        nameStr = ((OrmLocaleValue)userMap.get("name")).getLocaleValue();
        telStr = (String)userMap.get("tel");
        DynamicObject org = (DynamicObject)model.getValue("org");
        if (org == null) {
            org = (DynamicObject)userMap.get("org");
            positionStr = (String)userMap.get("applierpositionstr");
        } else {
            QFilter filter = new QFilter("user.id", "=", (Object)applierId);
            filter.and(new QFilter("org.id", "=", (Object)org.getLong("id")));
            DynamicObject userPosition = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_userposition", (String)"org,position", (QFilter[])new QFilter[]{filter});
            if (userPosition == null) {
                view.showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4fe1\u606f\u5df2\u53d8\u66f4\uff0c\u7533\u8bf7\u4eba\u516c\u53f8\u90e8\u95e8\u4fe1\u606f\u5df2\u91cd\u7f6e\u3002", (String)"DataCopyUtils_11", (String)"fi-er-business", (Object[])new Object[0]));
                org = (DynamicObject)userMap.get("org");
                positionStr = (String)userMap.get("applierpositionstr");
            } else {
                try {
                    ILocaleString position = userPosition.getLocaleString("position");
                    positionStr = position.getLocaleValue();
                }
                catch (Exception e) {
                    view.showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u804c\u4f4d\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DataCopyUtils_12", (String)"fi-er-business", (Object[])new Object[0]));
                }
            }
        }
        if (org == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u4eba\u5458\u90e8\u95e8\u4fe1\u606f\u3002", (String)"DataCopyUtils_13", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        logger.info("model\u4e2d\u7684org\uff1a" + ErCommonUtils.getPk(model.getValue("org")) + ",setvalue\u7684org\uff1a" + ErCommonUtils.getPk(org));
        model.setValue("org", (Object)ErCommonUtils.getPk(org));
        model.beginInit();
        deptStr = org.getString("name");
        Long deptId = org.getLong("id");
        Long companyId = CoreBaseBillServiceHelper.initCompanyByDept(deptId);
        if (companyId != null && companyId != 0L) {
            model.setValue("company", (Object)companyId);
        }
        model.setValue("tel", (Object)telStr);
        model.setValue("applierpositionstr", (Object)positionStr);
        model.endInit();
        view.updateView("tel");
        if (DataCopyUtils.isPCView(view)) {
            DataCopyUtils.lableSetting(view, "orgv", deptStr);
            DataCopyUtils.lableSetting(view, "telv", telStr);
            DataCopyUtils.lableSetting(view, "applierv", nameStr);
            DataCopyUtils.lableSetting(view, "applierpositionv", positionStr);
        } else {
            DataCopyUtils.lableSetting(view, "lb_org", deptStr);
            if (ErEntityTypeUtils.isTripReqBill(view.getEntityId()) || ErEntityTypeUtils.isTripReimburseBill(view.getEntityId())) {
                DataCopyUtils.lableSetting(view, "label_appiler", nameStr);
            } else {
                DataCopyUtils.lableSetting(view, "lb_name", nameStr);
            }
        }
    }

    private static void lableSetting(IFormView view, String controlName, String controlValue) {
        Control control = view.getControl(controlName);
        if (control instanceof Label) {
            ((Label)control).setText(controlValue);
        }
    }

    private static void checkCostDept(IDataModel model, IFormView view) {
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        if (costCompany != null) {
            if (!DataCopyUtils.checkOrg(costCompany.getLong("id")).booleanValue()) {
                model.setValue("costcompany", null);
                model.setValue("costdept", null);
                view.showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u516c\u53f8\u5df2\u88ab\u5c01\u5b58\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DataCopyUtils_14", (String)"fi-er-business", (Object[])new Object[0]));
            } else {
                DynamicObject costDept = (DynamicObject)model.getValue("costdept");
                if (costDept != null && !DataCopyUtils.checkOrg(costDept.getLong("id")).booleanValue()) {
                    model.setValue("costdept", null);
                    view.showTipNotification(ResManager.loadKDString((String)"\u8d39\u7528\u627f\u62c5\u90e8\u95e8\u5df2\u88ab\u5c01\u5b58\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"DataCopyUtils_15", (String)"fi-er-business", (Object[])new Object[0]));
                }
            }
        }
    }

    public static Boolean checkOrg(Long orgId) {
        QFilter freeze = new QFilter("isfreeze", "=", (Object)Boolean.TRUE);
        QFilter orgFilter = new QFilter("org.id", "=", (Object)orgId);
        QFilter viewType = new QFilter("view.id", "=", (Object)1);
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org_structure", (String)"id", (QFilter[])new QFilter[]{freeze, orgFilter, viewType});
        if (org != null) {
            return false;
        }
        return true;
    }

    public static Boolean checkTripType(Long triptypeid) {
        QFilter tripTypeFilter = new QFilter("id", "=", (Object)triptypeid);
        tripTypeFilter.and(new QFilter(ENABLE, "=", (Object)true));
        DynamicObject tripType = BusinessDataServiceHelper.loadSingleFromCache((String)"er_triptype", (String)"id", (QFilter[])new QFilter[]{tripTypeFilter});
        if (tripType != null) {
            return true;
        }
        return false;
    }

    public static Boolean checkWithholdingType(Long withholdingtypeid) {
        QFilter qFilter = new QFilter("id", "=", (Object)withholdingtypeid);
        qFilter.and(new QFilter(ENABLE, "=", (Object)Boolean.TRUE));
        DynamicObject withholdingType = BusinessDataServiceHelper.loadSingleFromCache((String)"er_withholdingtype", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (withholdingType != null) {
            return true;
        }
        return false;
    }

    public static void expItemHandle(IDataModel model, IFormView view) {
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            return;
        }
        Object isShowParentBillExpItem = ErCommonUtils.getEMParameter(ErCommonUtils.getPk(company), "isshowparentbillexpitem");
        DynamicObjectCollection expEntry = model.getEntryEntity("expenseentryentity");
        HashMap recorderOfExpItem = new HashMap();
        HashSet<Long> expenseItemSet = new HashSet<Long>();
        for (int rowIndex = 0; rowIndex < expEntry.size(); ++rowIndex) {
            Object expenseItem = model.getValue("expenseitem", rowIndex);
            if (expenseItem == null) continue;
            DynamicObject expenseItemId = (DynamicObject)expenseItem;
            expenseItemSet.add((Long)expenseItemId.getPkValue());
            Set indexes = recorderOfExpItem.containsKey(expenseItemId) ? (Set)recorderOfExpItem.get(expenseItemId) : new HashSet();
            indexes.add(rowIndex);
            recorderOfExpItem.put(expenseItemId, indexes);
        }
        if (recorderOfExpItem.size() != 0 && isShowParentBillExpItem != null && StringUtils.equalsIgnoreCase((CharSequence)"1", (CharSequence)isShowParentBillExpItem.toString())) {
            List<Long> relatedExpenseItemByBillType = CommonServiceHelper.getRelatedExpenseItemForBillType(view.getEntityId(), expenseItemSet);
            recorderOfExpItem.entrySet().stream().filter(e -> !relatedExpenseItemByBillType.contains(ErCommonUtils.getPk(e.getKey()))).flatMap(e -> ((Set)e.getValue()).stream()).collect(Collectors.toSet()).forEach(r -> model.setValue("expenseitem", null, r.intValue()));
        }
    }

    private static void updateExpEntry(IDataModel model, IFormView view) {
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (currency == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"DataCopyUtils_16", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        DynamicObject company = (DynamicObject)model.getValue("company");
        if (company == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u516c\u53f8\u6216\u90e8\u95e8\u4fe1\u606f\u5b58\u5728\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"DataCopyUtils_2", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        boolean fromItem = SystemParamterUtil.manuallyaddexpenseoffset(ErCommonUtils.getPk(company));
        DynamicObjectCollection expEntry = model.getEntryEntity("expenseentryentity");
        StringBuilder rowReccorder = new StringBuilder();
        Map<Object, Object> validItemMap = new HashMap(0);
        Set validItemIDSet = null;
        if (ErEntityTypeUtils.isDailyLoanBill(view.getEntityId())) {
            validItemMap = DataCopyUtils.validateExpItem(model, expEntry, "expenseitem");
        } else {
            validItemIDSet = DataCopyUtils.validateNonLeafExpItem(expEntry, "expenseitem");
        }
        int currencyPrecision = AmountUtils.getCurrencyPrecision(model, "currency");
        for (int rowIndex = 0; rowIndex < expEntry.size(); ++rowIndex) {
            DynamicObject expenseItem;
            BigDecimal expAmount = (BigDecimal)model.getValue("expenseamount", rowIndex);
            expAmount = expAmount == null ? BigDecimal.ZERO : expAmount;
            model.setValue("expenseamount", (Object)BigDecimal.ZERO, rowIndex);
            model.setValue("expenseamount", (Object)expAmount, rowIndex);
            DynamicObject entrycurrency = (DynamicObject)model.getValue("entrycurrency", rowIndex);
            if (entrycurrency != null && currency != entrycurrency) {
                Map<String, Object> exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams(company, model.getValue("costcompany"), entrycurrency.getLong("id"), currency.getLong("id"), model);
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateAndQuoteType.get("exchangeRate")), (Object)BigDecimal.ONE);
                String expQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteType.get("quoteType")), (Object)"0");
                model.setValue("expquotetype", (Object)expQuoteType, rowIndex);
                model.setValue("exchangerate", (Object)exchangeRate, rowIndex);
                BigDecimal expOrrAmount = AmountUtils.getCurrencyAmount(expAmount, (BigDecimal)model.getValue("exchangerate", rowIndex), currencyPrecision, expQuoteType);
                model.setValue("currexpenseamount", (Object)expOrrAmount, rowIndex);
                model.setValue("expeapproveamount", (Object)expAmount, rowIndex);
                model.setValue("expeapprovecurramount", (Object)expOrrAmount, rowIndex);
            }
            if ((expenseItem = (DynamicObject)model.getValue("expenseitem", rowIndex)) != null) {
                String enable = expenseItem.getString(ENABLE);
                if (enable.equals("0")) {
                    model.setValue("expenseitem", null, rowIndex);
                    rowReccorder.append(rowIndex + 1);
                    rowReccorder.append("\uff0c");
                    continue;
                }
                if (ErEntityTypeUtils.isDailyLoanBill(view.getEntityId())) {
                    validItemIDSet = (Set)validItemMap.get(rowIndex);
                }
                if (validItemIDSet != null && !validItemIDSet.contains(ErCommonUtils.getPk(expenseItem)) && !DataCopyUtils.specialBill(model)) {
                    model.setValue("expenseitem", null, rowIndex);
                }
            }
            if (model.getProperty("taxamount") != null) {
                BigDecimal taxAmount = (BigDecimal)model.getValue("taxamount", rowIndex);
                model.setValue("taxamount", (Object)BigDecimal.ZERO, rowIndex);
                model.setValue("taxamount", (Object)taxAmount, rowIndex);
            }
            if (model.getProperty("approvetax") != null) {
                model.setValue("approvetax", model.getValue("taxamount", rowIndex), rowIndex);
            }
            if (model.getProperty("offset") == null) continue;
            boolean offset = false;
            DynamicObject newExpenseItem = (DynamicObject)model.getValue("expenseitem", rowIndex);
            if (newExpenseItem != null && fromItem && newExpenseItem.containsProperty("offset")) {
                offset = newExpenseItem.getBoolean("offset");
            }
            model.setValue("offset", (Object)offset, rowIndex);
            if (offset) {
                if (model.getProperty("deductibletax") != null) {
                    model.setValue("deductibletax", model.getValue("taxamount", rowIndex), rowIndex);
                }
                if (model.getProperty("iteminoutamount") == null) continue;
                model.setValue("iteminoutamount", (Object)BigDecimal.ZERO, rowIndex);
                continue;
            }
            if (model.getProperty("deductibletax") != null) {
                model.setValue("deductibletax", (Object)BigDecimal.ZERO, rowIndex);
            }
            if (model.getProperty("iteminoutamount") == null) continue;
            model.setValue("iteminoutamount", model.getValue("taxamount", rowIndex), rowIndex);
        }
        if (rowReccorder.length() != 0) {
            String rows = rowReccorder.toString().substring(0, rowReccorder.lastIndexOf("\uff0c"));
            String entryName = DataCopyUtils.getEntryName(model.getDataEntityType().getName());
            String format = String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c\u5b58\u5728\u7981\u7528\u7684\u8d39\u7528\u9879\u76ee\uff0c\u5df2\u6e05\u7a7a\u5904\u7406\u3002", (String)"DataCopyUtils_17", (String)"fi-er-business", (Object[])new Object[0]), entryName, rows);
            view.showTipNotification(format);
        }
        view.updateView("expenseentryentity");
    }

    private static Map<Integer, Set<Long>> validateExpItem(IDataModel model, DynamicObjectCollection entry, String itemPropName) {
        Set expenseItemIdSet = entry.stream().filter(row -> row.getDynamicObject(itemPropName) != null).map(row -> row.getDynamicObject(itemPropName).getLong("id")).collect(Collectors.toSet());
        QFilter validateFilter = new QFilter("isleaf", "=", (Object)Boolean.TRUE);
        validateFilter.and("id", "in", expenseItemIdSet);
        validateFilter.and(ExpenseItemServiceHelper.getRelBillFilter("er_dailyloanbill"));
        List<Long> upBillItem = ExpenseItemServiceHelper.getUpBillExpItemId(model.getDataEntity(true));
        validateFilter.or("id", "in", upBillItem);
        String entryName = entry.getDynamicObjectType().getName();
        HashMap<Integer, Set<Long>> expItemIds = new HashMap<Integer, Set<Long>>(entry.size());
        for (int rowIndex = 0; rowIndex < entry.size(); ++rowIndex) {
            DynamicObject dyn = (DynamicObject)entry.get(rowIndex);
            Long deptId = 0L;
            Long useId = 0L;
            ThreeTuple<String, String, String> tuple = ErCostCenterUtil.COSTDEPT_COSTCENTER_MAP.get(entryName);
            if (tuple != null) {
                String deptProp = (String)tuple.item1;
                String userProp = (String)tuple.item2;
                deptId = dyn.getDynamicObject(deptProp) != null ? (Long)dyn.getDynamicObject(deptProp).getPkValue() : Long.valueOf("0");
                useId = dyn.getDynamicObject(userProp) != null ? (Long)dyn.getDynamicObject(userProp).getPkValue() : Long.valueOf("0");
            }
            QFilter deptFilter = ExpenseItemServiceHelper.getRelDeptFilter(deptId);
            QFilter userFilter = BaseDataServiceHelper.getBaseDataFilter((String)"er_expenseitemedit", (Long)useId);
            deptFilter.and(userFilter);
            Map entryItemMap = BusinessDataServiceHelper.loadFromCache((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{deptFilter.and(validateFilter)});
            expItemIds.put(rowIndex, entryItemMap.entrySet().stream().map(item -> (Long)item.getKey()).collect(Collectors.toSet()));
        }
        return expItemIds;
    }

    private static boolean specialBill(IDataModel model) {
        Object reimbursetype;
        return model.getProperty("reimbursetype") != null && !"expense".equals(reimbursetype = model.getValue("reimbursetype")) && !"asset".equals(reimbursetype);
    }

    private static String getEntryName(String billType) {
        if (ErEntityTypeUtils.isPrePayBill(billType)) {
            return ResManager.loadKDString((String)"\u9884\u4ed8\u4fe1\u606f", (String)"DataCopyUtils_21", (String)"fi-er-business", (Object[])new Object[0]);
        }
        if (ErEntityTypeUtils.isDailyLoanBill(billType)) {
            return ResManager.loadKDString((String)"\u501f\u6b3e\u660e\u7ec6", (String)"DataCopyUtils_22", (String)"fi-er-business", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u8d39\u7528\u660e\u7ec6", (String)"DataCopyUtils_23", (String)"fi-er-business", (Object[])new Object[0]);
    }

    private static void updateAccountEntry(IDataModel model, IFormView view) {
        DynamicObject company = (DynamicObject)model.getValue("company");
        Long companyId = company == null ? OrgUnitServiceHelper.getRootOrgId() : company.getLong("id");
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        if (currency == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u8bbe\u7f6e\u672c\u4f4d\u5e01\u3002", (String)"DataCopyUtils_18", (String)"fi-er-business", (Object[])new Object[0]));
            return;
        }
        DynamicObjectCollection accEntryEntity = model.getEntryEntity("accountentry");
        for (int rowIndex = 0; rowIndex < accEntryEntity.size(); ++rowIndex) {
            DynamicObject paymode;
            DynamicObject accEntryCurrency = (DynamicObject)model.getValue("accountcurrency", rowIndex);
            if (accEntryCurrency != null && currency != accEntryCurrency) {
                Map<String, Object> exchangeRateAndQuoteType = CommonServiceHelper.getExchangeRateFromSysParams(companyId, model.getValue("costcompany"), accEntryCurrency.getLong("id"), currency.getLong("id"), model);
                BigDecimal exchangeRate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangeRateAndQuoteType.get("exchangeRate")), (Object)BigDecimal.ONE);
                String accQuoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangeRateAndQuoteType.get("quoteType")), (Object)"0");
                model.setValue("accquotetype", (Object)accQuoteType, rowIndex);
                model.setValue("accexchangerate", (Object)exchangeRate, rowIndex);
            }
            if ((paymode = (DynamicObject)model.getValue("paymode", rowIndex)) == null || (paymode = BusinessDataServiceHelper.loadSingleFromCache((Object)paymode.getPkValue(), (String)"bd_settlementtype", (String)ENABLE)) != null && paymode.getBoolean(ENABLE)) continue;
            paymode = PayeeServiceHelper.getDefaultPayMode();
            model.setValue("paymode", (Object)paymode, rowIndex);
        }
    }

    private static void initAccountEntry(IDataModel model, IFormView view) {
        String formId = view.getFormShowParameter().getFormId();
        Boolean isLoan = Boolean.FALSE;
        if (ErEntityTypeUtils.isTripReqBill(formId) && (isLoan = (Boolean)model.getValue("isloan")) == null) {
            isLoan = Boolean.FALSE;
        }
        if (isLoan.booleanValue() || ErEntityTypeUtils.isTripReimburseBill(formId) || ErEntityTypeUtils.isDailyReimburseBill(formId) || ErEntityTypeUtils.isDailyLoanBill(formId)) {
            model.deleteEntryData("accountentry");
            DynamicObject applier = (DynamicObject)model.getValue("applier");
            Long applierId = applier.getLong("id");
            if (applierId == null || applierId == 0L) {
                applierId = Long.valueOf(RequestContext.get().getUserId());
            }
            DynamicObject defaultAccount = PayeeServiceHelper.getDefaultAccount(applierId);
            int rowIndex = model.createNewEntryRow("accountentry");
            CoreBaseBillServiceHelper.fillAccountEntry(model, rowIndex, defaultAccount);
        }
    }

    private static Set<Long> validateNonLeafExpItem(DynamicObjectCollection entry, String entryNumber) {
        Set expenseItemIdSet = entry.stream().filter(row -> row.getDynamicObject(entryNumber) != null).map(row -> row.getDynamicObject(entryNumber).getLong("id")).collect(Collectors.toSet());
        Map expItemMap = BusinessDataServiceHelper.loadFromCache((String)"er_expenseitemedit", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", expenseItemIdSet), new QFilter("isleaf", "=", (Object)Boolean.TRUE)});
        return expItemMap.entrySet().stream().map(item -> (Long)item.getKey()).collect(Collectors.toSet());
    }

    private static void setRePayDate(IDataModel model) {
        Date payDate;
        Long companyId = ErCommonUtils.getPk(model.getValue("company"));
        Date baseDate = (Date)model.getValue("bizdate");
        if (baseDate == null) {
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(baseDate);
        if (SystemParamterUtil.getRepaymentDateBase(companyId) == 1 && (payDate = (Date)model.getValue("head_paydate")) != null) {
            calendar.setTime(payDate);
        }
        calendar.add(2, SystemParamterUtil.getExpectedRepaymentDate(companyId));
        model.setValue("repaymentdate", (Object)calendar.getTime());
    }

    private static void updateApplyBillExpEntry(IDataModel model, IFormView view) {
        DynamicObjectCollection expenseEntry;
        if (StringUtils.equalsIgnoreCase((CharSequence)"A", (CharSequence)model.getValue("billStatus").toString()) && (expenseEntry = model.getEntryEntity("expenseentryentity")) != null && expenseEntry.size() > 0) {
            model.beginInit();
            BigDecimal balanceamount = BigDecimal.ZERO;
            for (int i = 0; i < expenseEntry.size(); ++i) {
                DynamicObject expnese = (DynamicObject)expenseEntry.get(i);
                BigDecimal entryApplyAmount = expnese.getBigDecimal("expenseamount");
                BigDecimal entryApplyCurrAmount = expnese.getBigDecimal("currexpenseamount");
                model.setValue("expeapproveamount", (Object)entryApplyAmount, i);
                model.setValue("expeapprovecurramount", (Object)entryApplyCurrAmount, i);
                model.setValue("orgiexpebalanceamount", (Object)entryApplyAmount, i);
                model.setValue("expebalanceamount", (Object)entryApplyCurrAmount, i);
                model.setValue("canloanamount", (Object)entryApplyAmount, i);
                model.setValue("canloancurramount", (Object)entryApplyCurrAmount, i);
                balanceamount = balanceamount.add(entryApplyCurrAmount);
            }
            model.setValue("applyamount", (Object)balanceamount);
            model.setValue("approveamount", (Object)balanceamount);
            model.setValue("balanceamount", (Object)balanceamount);
            model.setValue("billcanloanamount", (Object)balanceamount);
            if (model.getProperty("cancontractamount") != null) {
                model.setValue("cancontractamount", (Object)balanceamount);
            }
            model.endInit();
            view.updateView("expenseentryentity");
        }
    }

    private static void dailyReimAfterCopyData(IDataModel model, IFormView view, String entityId) {
        model.beginInit();
        DataCopyUtils.setExpenseAmount(model, entityId);
        DataCopyUtils.setReceiveAmount(model);
        model.endInit();
        view.updateView("expenseentryentity");
        view.updateView("accountentry");
        view.updateView("approveamount");
        if (StringUtils.equals((CharSequence)"er_dailyreimbursebill", (CharSequence)entityId)) {
            model.setValue("payamount", (Object)AmountUtils.getEntryAmount(model, "expenseentryentity", "expeapprovecurramount"));
            WriteOffMoneyUtils.showPayAmount(model, DataCopyUtils.isPCView(view) ? (Label)view.getControl("totalencashamountlabel") : (Label)view.getControl("label_account_amount"));
            if (view instanceof IMobileView) {
                model.setValue("origin", (Object)2);
            } else {
                model.setValue("origin", (Object)1);
            }
        }
    }

    private static void tripReimAfterCopyData(IDataModel model, IFormView view) {
        int entryRowCount;
        model.beginInit();
        DataCopyUtils.setTripAmount(model, view);
        DataCopyUtils.setReceiveAmount(model);
        model.endInit();
        view.updateView("tripentry");
        view.updateView("encashamount");
        view.updateView("accountentry");
        if (DataCopyUtils.isMobView(view) && (entryRowCount = model.getEntryRowCount("tripentry")) > 0) {
            view.setVisible(Boolean.valueOf(false), new String[]{"next"});
        }
    }

    private static void refreshRepaymentDate(IDataModel model) {
        model.setValue("repaymentdate", (Object)CoreBaseBillServiceHelper.computeRepaymentDate(model));
    }

    private static void setExpenseAmount(IDataModel model, String entityId) {
        DynamicObjectCollection expenseEntry = model.getEntryEntity("expenseentryentity");
        if (expenseEntry != null && !expenseEntry.isEmpty()) {
            for (int i = 0; i < expenseEntry.size(); ++i) {
                DynamicObject expnese = (DynamicObject)expenseEntry.get(i);
                model.setValue("expeapproveamount", expnese.get("expenseamount"), i);
                DataCopyUtils.setPrice(model, i, expnese);
                model.setValue("expeapprovecurramount", expnese.get("currexpenseamount"), i);
                if (ErEntityTypeUtils.isDailyReimburseBill(entityId) || ErEntityTypeUtils.isPublicReimburseBill(entityId)) continue;
                model.setValue("orgiexpebalanceamount", expnese.get("expenseamount"), i);
                model.setValue("expebalanceamount", expnese.get("currexpenseamount"), i);
            }
        }
        model.setValue("approveamount", (Object)AmountUtils.getEntryAmount(model, "expenseentryentity", "expeapprovecurramount"));
    }

    private static void setPrice(IDataModel model, int rowIndex, DynamicObject expnese) {
        if (model.getProperty("price") != null) {
            String formulaType = ErStdConfig.getApproveTaxFormulaType();
            BigDecimal price = BigDecimal.ZERO;
            BigDecimal expeapproveAmount = expnese.getBigDecimal("expeapproveamount");
            if (StringUtils.equals((CharSequence)formulaType, (CharSequence)"1")) {
                BigDecimal deductibleTax = expnese.getBigDecimal("deductibletax");
                price = expeapproveAmount.subtract(deductibleTax);
            } else {
                BigDecimal approveTax = expnese.getBigDecimal("approvetax");
                price = expeapproveAmount.subtract(approveTax);
            }
            model.setValue("price", (Object)price, rowIndex);
            IDataEntityProperty curPriceProp = model.getProperty("curprice");
            if (price != null & curPriceProp != null) {
                BigDecimal exchangeRate = expnese.getBigDecimal("exchangerate");
                exchangeRate = exchangeRate.compareTo(BigDecimal.ZERO) != 0 ? exchangeRate : BigDecimal.ONE;
                BigDecimal curPrice = BigDecimal.ZERO;
                String quoteType = StringUtils.isEmpty((CharSequence)"expquotetype") || model.getProperty("expquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("expquotetype", rowIndex)), (Object)"0");
                curPrice = StringUtils.equals((CharSequence)"1", (CharSequence)quoteType) ? price.divide(exchangeRate, AmountUtils.getCurrencyPrecision(model, "currency"), RoundingMode.HALF_UP) : price.multiply(exchangeRate).setScale(AmountUtils.getCurrencyPrecision(model, "currency"), RoundingMode.HALF_UP);
                model.setValue("curprice", (Object)curPrice, rowIndex);
            }
        }
    }

    private static void setReceiveAmount(IDataModel model) {
        DynamicObjectCollection accountEntry = model.getEntryEntity("accountentry");
        BigDecimal notpayamount = BigDecimal.ZERO;
        if (accountEntry != null && accountEntry.size() > 0) {
            if (accountEntry.size() == 1) {
                BigDecimal approveAmount = (BigDecimal)model.getValue("approveamount");
                model.setValue("receiveamount", (Object)approveAmount, 0);
                BigDecimal exchangeRate = (BigDecimal)model.getValue("accexchangerate", 0);
                exchangeRate = exchangeRate == null || exchangeRate.abs().compareTo(BigDecimal.valueOf(1.0E-8)) < 0 ? BigDecimal.ONE : exchangeRate;
                DynamicObject currency = (DynamicObject)model.getValue("accountcurrency", 0);
                int amtprecision = currency == null ? ((DynamicObject)model.getValue("currency")).getInt("amtprecision") : currency.getInt("amtprecision");
                String accQuoteType = model.getProperty("accquotetype") == null ? "0" : (String)ObjectUtils.defaultIfNull((Object)((String)model.getValue("accquotetype", 0)), (Object)"0");
                BigDecimal approveAmountOri = AmountUtils.getOriAmount(approveAmount, exchangeRate, amtprecision, accQuoteType);
                model.setValue("orireceiveamount", (Object)approveAmountOri, 0);
            }
            for (int i = 0; i < accountEntry.size(); ++i) {
                DynamicObject account = (DynamicObject)accountEntry.get(i);
                model.setValue("oriaccnotpayamount", account.get("orireceiveamount"), i);
                model.setValue("accnotpayamount", account.get("receiveamount"), i);
                BigDecimal accnotpayamount = (BigDecimal)account.get("accnotpayamount");
                notpayamount = notpayamount.add(accnotpayamount);
            }
            model.setValue("notpayamount", (Object)notpayamount);
        }
    }

    private static void setTripAmount(IDataModel model, IFormView view) {
        DynamicObjectCollection tripEntry = model.getDataEntity(true).getDynamicObjectCollection("tripentry");
        if (tripEntry != null && tripEntry.size() > 0) {
            for (int i = 0; i < tripEntry.size(); ++i) {
                DynamicObject trip = (DynamicObject)tripEntry.get(i);
                if (ErEntityTypeUtils.isTripReimburseBill(view.getEntityId())) {
                    DynamicObjectCollection entrys = trip.getDynamicObjectCollection("entryentity");
                    model.setValue("tripapporiamount", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)entrys, "orientryappamount"), i);
                    model.setValue("tripappamount", (Object)AmountChangeUtil.sumAmountBy((Collection<DynamicObject>)entrys, "entryappamount"), i);
                    continue;
                }
                if (!ErEntityTypeUtils.isTripReqBill(view.getEntityId())) continue;
                model.setValue("tripaccappamount", trip.get("tripamount"), i);
                model.setValue("triporiaccappamount", trip.get("triporiamount"), i);
            }
        }
        BigDecimal encashAmount = BigDecimal.ZERO;
        if (ErEntityTypeUtils.isTripReimburseBill(view.getEntityId())) {
            model.setValue("approveamount", (Object)AmountUtils.getEntryAmount(model, "tripentry", "tripappamount"));
            BigDecimal settleAmount = (BigDecimal)model.getValue("monthsettleamount");
            BigDecimal approveAmount = (BigDecimal)model.getValue("approveamount");
            settleAmount = settleAmount == null ? BigDecimal.ZERO : settleAmount;
            approveAmount = approveAmount == null ? BigDecimal.ZERO : approveAmount;
            BigDecimal amount = encashAmount = approveAmount.subtract(settleAmount);
            Label encashamountlabel = DataCopyUtils.isPCView(view) ? (Label)view.getControl("totalencashamountlabel") : (Label)view.getControl("label_account_amount");
            String currencySign = "";
            int amountPrecition = 4;
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            if (currency != null) {
                currencySign = currency.getString("sign");
                amountPrecition = currency.getInt("amtprecision");
                amount = amount.setScale(amountPrecition, 4);
            }
            String amountStr = AmountFormatsUtil.getLabelAmountAfterFormat(currencySign, amount, amountPrecition);
            encashamountlabel.setText(amountStr);
        } else if (ErEntityTypeUtils.isTripReqBill(view.getEntityId())) {
            model.setValue("approveamount", (Object)AmountUtils.getEntryAmount(model, "tripentry", "tripaccappamount"));
            if (Boolean.TRUE.equals(model.getValue("isloan"))) {
                encashAmount = (BigDecimal)model.getValue("approveamount");
            }
        }
        model.setValue("encashamount", (Object)encashAmount);
    }

    public static void afterCopyBill(IDataModel model, IFormView view) {
        if (model.getProperty("accountentry") != null) {
            if (ErStdConfig.getNumCopyAccountEntry() == 0) {
                model.deleteEntryData("accountentry");
            } else {
                int index;
                if (ErStdConfig.getNumCopyAccountEntry() == 2) {
                    block12: for (index = 0; index < model.getEntryRowCount("accountentry"); ++index) {
                        String payertype;
                        switch (payertype = (String)model.getValue("payertype", index)) {
                            case "bd_supplier": {
                                DataCopyUtils.setAccountInfoByPayer(model, view, "bd_supplier", "supplier", index);
                                continue block12;
                            }
                            case "bd_customer": {
                                DataCopyUtils.setAccountInfoByPayer(model, view, "bd_customer", "customer", index);
                                continue block12;
                            }
                            case "bos_org": {
                                DataCopyUtils.setAccountInfoByPayer(model, view, "bos_org", "casorg", index);
                                continue block12;
                            }
                            case "er_payeer": {
                                DataCopyUtils.setAccountInfoByPayer(model, view, "er_payeer", "payer", index);
                            }
                        }
                    }
                }
                for (index = 0; index < model.getEntryRowCount("accountentry"); ++index) {
                    model.setValue("orireceiveamount", (Object)0, index);
                    model.setValue("receiveamount", (Object)0, index);
                }
            }
        }
        for (String entry : needDeleteEntry) {
            if (model.getProperty(entry) == null) continue;
            model.deleteEntryData(entry);
        }
        if (ErEntityTypeUtils.isPublicReimburseBill(view.getEntityId()) || ErEntityTypeUtils.isDailyReimburseBill(view.getEntityId())) {
            String entityProp = ErEntityTypeUtils.isShareBill(view.getEntityId()) ? "expenseentryentity_wait" : "expenseentryentity";
            DynamicObjectCollection rules = model.getEntryEntity("expenseentryentity_rule");
            DynamicObjectCollection expenses = model.getEntryEntity(entityProp);
            Object shareMethod = model.getValue("sharemethod");
            Object shareRule = model.getValue("sharerule");
            if ((StringUtils.equals((CharSequence)"amount", (CharSequence)String.valueOf(shareMethod)) || StringUtils.equals((CharSequence)"expenseitemrule", (CharSequence)String.valueOf(shareRule))) && rules.size() > 0 && expenses.size() > 0) {
                ORM orm = ORM.create();
                long[] ids = orm.genLongIds(view.getEntityId(), rules.size());
                int i = 0;
                for (DynamicObject r : rules) {
                    int seq = r.getInt("sharewaitseq_comrule");
                    if (seq <= 0 || seq > expenses.size()) continue;
                    Long entryId = (Long)((DynamicObject)expenses.get(seq - 1)).getPkValue();
                    if (Objects.equals(entryId, 0L)) {
                        entryId = ids[i];
                        ++i;
                        ((DynamicObject)expenses.get(seq - 1)).set("id", (Object)entryId);
                    }
                    r.set("sharewaitid_comrule", (Object)entryId);
                }
            }
            for (DynamicObject r : rules) {
                r.set("shareappamount_comrule", (Object)r.getBigDecimal("shareamount_comrule"));
            }
        }
        DataCopyUtils.setOriginValue(view);
    }

    private static void setAccountInfoByPayer(IDataModel model, IFormView view, String payertype, String payername, int index) {
        String format;
        DynamicObject payer = (DynamicObject)model.getValue(payername, index);
        if (payer == null) {
            return;
        }
        if (payertype.equals(PayerTypeEnum.PAYER.getType())) {
            DynamicObject payerObj = QueryServiceHelper.queryOne((String)payertype, (String)"payer,payeraccount,payeraccountname,payerbank,currency", (QFilter[])new QFilter[]{new QFilter("payer.number", "=", payer.get("payer.number")), new QFilter("isdefault", "=", (Object)Character.valueOf('1')), new QFilter(ENABLE, "=", (Object)Character.valueOf('1'))});
            if (payerObj == null) {
                model.setValue("payer", null, index);
                model.setValue("payeraccount", null, index);
                model.setValue("payeraccountname", null, index);
                model.setValue("payerbank", null, index);
                model.setValue("accountcurrency", null, index);
                format = String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u6536\u6b3e\u4fe1\u606f\uff0c\u8bf7\u624b\u52a8\u6dfb\u52a0\u3002", (String)"DataCopyUtils_19", (String)"fi-er-business", (Object[])new Object[0]), model.getValue("payername", index));
                view.showTipNotification(format);
            } else {
                model.setValue("payer", payerObj.get("payer"), index);
                model.setValue("payeraccount", payerObj.get("payeraccount"), index);
                DataCopyUtils.refreshPayerAcount(model, index, payerObj.get("payeraccount"));
                model.setValue("payeraccountname", payerObj.get("payeraccountname"), index);
                model.setValue("payerbank", payerObj.get("payerbank"), index);
                String isgetaccountcurrency = "0";
                if (model.getValue("company") != null) {
                    isgetaccountcurrency = SystemParamterUtil.isgetaccountcurrency((Long)((DynamicObject)model.getValue("company")).getPkValue());
                }
                if ("1".equals(isgetaccountcurrency)) {
                    model.setValue("accountcurrency", payerObj.get("currency"), index);
                    DataCopyUtils.accountCurrencyChange(index, (DynamicObject)model.getValue("accountcurrency", index), model);
                }
            }
        }
        if (payertype.equals(PayerTypeEnum.SUPPLIER.getType()) || payertype.equals(PayerTypeEnum.CUSTOMER.getType()) || payertype.equals(PayerTypeEnum.CASORG.getType())) {
            AccountInfo accountInfo = PublicReimbursePayerAcctUtils.getPayerDefaultInfo(payertype, (Long)payer.getPkValue());
            PublicReimbursePayerAcctUtils.fillBankInfo(model, accountInfo, index);
            if (accountInfo == null) {
                format = String.format(ResManager.loadKDString((String)"%s\u672a\u8bbe\u7f6e\u9ed8\u8ba4\u6536\u6b3e\u4fe1\u606f\uff0c\u8bf7\u624b\u52a8\u6dfb\u52a0\u3002", (String)"DataCopyUtils_19", (String)"fi-er-business", (Object[])new Object[0]), model.getValue("payername", index));
                view.showTipNotification(format);
            }
        }
        PayeeServiceHelper.clearLimitInfo(model);
    }

    public static void accountCurrencyChange(int rowIndex, DynamicObject accountCurrency, IDataModel model) {
        Map<String, Object> exchangerateMap = DataCopyUtils.refreshExchangeRate("accexchangerate", accountCurrency, model);
        BigDecimal accexchangerate = (BigDecimal)ObjectUtils.defaultIfNull((Object)((BigDecimal)exchangerateMap.get("exchangeRate")), (Object)BigDecimal.ONE);
        String quoteType = (String)ObjectUtils.defaultIfNull((Object)((String)exchangerateMap.get("quoteType")), (Object)"0");
        if (accexchangerate == null && accountCurrency != null) {
            logger.info(String.format("\u5e01\u79cdid:%s \u672a\u8bbe\u7f6e\u6c47\u7387", accountCurrency.getPkValue()));
            accexchangerate = BigDecimal.ONE;
        }
        if (model.getProperty("accquotetype") != null) {
            model.setValue("accquotetype", (Object)quoteType, rowIndex);
        }
        model.setValue("accexchangerate", (Object)accexchangerate, rowIndex);
    }

    protected static Map<String, Object> refreshExchangeRate(String exchangeRateProp, DynamicObject entryCurrency, IDataModel model) {
        DynamicObject currency = (DynamicObject)model.getValue("currency");
        DynamicObject company = (DynamicObject)model.getValue("company");
        DynamicObject costCompany = (DynamicObject)model.getValue("costcompany");
        if (entryCurrency != null && currency != null && company != null) {
            Long srcCurrencyId = (Long)entryCurrency.getPkValue();
            Long targetCurrencyId = (Long)currency.getPkValue();
            return CommonServiceHelper.getExchangeRateFromSysParams(company, costCompany, srcCurrencyId, targetCurrencyId, model);
        }
        return new HashMap<String, Object>();
    }

    public static void refreshPayerAcount(IDataModel model, int rowIndex, Object propValue) {
        Map<String, String> map = PayeeServiceHelper.getAllTypePayerAccount((String)propValue);
        model.setValue("payeraccount01", (Object)map.get("payeraccount01"), rowIndex);
        model.setValue("payeraccount02", (Object)map.get("payeraccount02"), rowIndex);
    }

    public static void refreshOffset(IDataModel model, IFormView view) {
        block7: {
            boolean isOrgOffset;
            boolean expenseOffset;
            block6: {
                DynamicObject company = (DynamicObject)model.getValue("company");
                if (company == null) {
                    return;
                }
                expenseOffset = SystemParamterUtil.manuallyaddexpenseoffset((Long)company.getPkValue());
                isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer(model);
                if (model.getProperty("expenseentryentity") == null) break block6;
                DynamicObjectCollection expEntry = model.getEntryEntity("expenseentryentity");
                for (int rowIndex = 0; rowIndex < expEntry.size(); ++rowIndex) {
                    Object expenseItem = model.getValue("expenseitem", rowIndex);
                    if (model.getProperty("offset") == null || model.getProperty("expenseitem") == null) continue;
                    if (expenseOffset && isOrgOffset) {
                        if (expenseItem == null) continue;
                        Object offset = ((DynamicObject)expenseItem).get("offset");
                        model.setValue("offset", offset, rowIndex);
                        continue;
                    }
                    model.setValue("offset", (Object)false, rowIndex);
                }
                break block7;
            }
            if (model.getProperty("tripentry") == null) break block7;
            DynamicObjectCollection tripEntry = model.getEntryEntity("tripentry");
            for (int parentIndex = 0; parentIndex < tripEntry.size(); ++parentIndex) {
                DynamicObjectCollection entryEntity = ((DynamicObject)tripEntry.get(parentIndex)).getDynamicObjectCollection("entryentity");
                for (int rowIndex = 0; rowIndex < entryEntity.size(); ++rowIndex) {
                    Object expenseItem = model.getValue("expenseitem", rowIndex, parentIndex);
                    if (model.getProperty("offset") == null || model.getProperty("expenseitem") == null) continue;
                    if (expenseOffset && isOrgOffset) {
                        if (expenseItem == null) continue;
                        Object offset = ((DynamicObject)expenseItem).get("isoffset");
                        model.setValue("offset", offset, rowIndex, parentIndex);
                        continue;
                    }
                    model.setValue("offset", (Object)false, rowIndex, parentIndex);
                }
            }
        }
    }
}

