/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.util;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.property.SubEntryProp;
import kd.fi.er.business.utils.DataChangeUtils;

public class EntryCopyUtil {
    public static void copyEntry2TargetColl(DynamicObjectCollection targetColl, DynamicObject srcentry) {
        DynamicObjectCollection thisColl = new DynamicObjectCollection(srcentry.getDynamicObjectType(), srcentry.getParent());
        thisColl.add((Object)srcentry);
        EntryCopyUtil.copyColl2TargetColl(targetColl, thisColl, targetColl.size());
    }

    public static void copyColl2TargetColl(DynamicObjectCollection targetColl, DynamicObjectCollection thisColl) {
        EntryCopyUtil.copyColl2TargetColl(targetColl, thisColl, targetColl.size());
    }

    public static void copyColl2TargetColl(DynamicObjectCollection targetColl, DynamicObjectCollection thisColl, int rowIndex) {
        DynamicObjectType parentType = targetColl.getDynamicObjectType();
        DynamicObjectType thisType = thisColl.getDynamicObjectType();
        DataEntityPropertyCollection properties = parentType.getProperties();
        for (DynamicObject thisentry : thisColl) {
            DynamicObject entry = (DynamicObject)parentType.createInstance();
            targetColl.add(rowIndex++, entry);
            for (IDataEntityProperty property : properties) {
                if (thisType.getProperty(property.getName()) == null) continue;
                if (property instanceof SubEntryProp) {
                    DynamicObjectCollection childColl = (DynamicObjectCollection)thisentry.get(property.getName());
                    childColl.sort((u, v) -> u.getInt("seq") - v.getInt("seq"));
                    DynamicObjectCollection targetChildColl = new DynamicObjectCollection(((SubEntryProp)property).getDynamicCollectionItemPropertyType(), (Object)entry);
                    EntryCopyUtil.copyColl2TargetColl(targetChildColl, childColl);
                    property.setValueFast((Object)entry, (Object)targetChildColl);
                    continue;
                }
                property.setValueFast((Object)entry, thisentry.get(property.getName()));
                DataChangeUtils.setKeyDirty(entry, property.getName());
            }
        }
    }

    public static void copyDifColl2TargetColl(DynamicObjectCollection targetColl, DynamicObjectCollection thisColl, int rowIndex) {
        DynamicObjectType parentType = targetColl.getDynamicObjectType();
        DynamicObjectType thisType = thisColl.getDynamicObjectType();
        DataEntityPropertyCollection properties = parentType.getProperties();
        for (DynamicObject thisEntry : thisColl) {
            long id = thisEntry.getLong("id");
            if (targetColl.stream().anyMatch(target -> id == target.getLong("id"))) continue;
            DynamicObject entry = (DynamicObject)parentType.createInstance();
            targetColl.add(rowIndex++, entry);
            for (IDataEntityProperty property : properties) {
                if (thisType.getProperty(property.getName()) == null) continue;
                if (property instanceof SubEntryProp) {
                    DynamicObjectCollection childColl = (DynamicObjectCollection)thisEntry.get(property.getName());
                    childColl.sort(Comparator.comparingInt(u -> u.getInt("seq")));
                    DynamicObjectCollection targetChildColl = new DynamicObjectCollection(((SubEntryProp)property).getDynamicCollectionItemPropertyType(), (Object)entry);
                    EntryCopyUtil.copyColl2TargetColl(targetChildColl, childColl);
                    property.setValueFast((Object)entry, (Object)targetChildColl);
                    continue;
                }
                property.setValueFast((Object)entry, thisEntry.get(property.getName()));
                DataChangeUtils.setKeyDirty(entry, property.getName());
            }
        }
    }

    public static void copyDynamicObject(DynamicObject src, DynamicObject dest, Set<String> excludePropertyName) {
        DynamicObjectType srcType = src.getDynamicObjectType();
        DynamicObjectType destType = dest.getDynamicObjectType();
        for (IDataEntityProperty property : destType.getProperties()) {
            if (!srcType.getProperties().containsKey((Object)property.getName()) || excludePropertyName.contains(property.getName())) continue;
            if (property instanceof SubEntryProp) {
                DynamicObjectCollection srcSubEntries = (DynamicObjectCollection)src.get(property);
                DynamicObjectCollection destSubEntries = (DynamicObjectCollection)dest.get(property);
                destSubEntries.clear();
                destSubEntries.addAll((Collection)srcSubEntries);
                continue;
            }
            dest.set(property.getName(), src.get(property.getName()));
        }
    }

    public static void updateColl2TargetColl(DynamicObjectCollection targetColl, DynamicObjectCollection thisColl, int rowIndex) {
        if (rowIndex == 0 && targetColl.isEmpty()) {
            targetColl.addNew();
        }
        DynamicObject item = (DynamicObject)targetColl.get(rowIndex);
        long targetId = (Long)item.getPkValue();
        DynamicObjectType parentType = targetColl.getDynamicObjectType();
        DynamicObjectType thisType = thisColl.getDynamicObjectType();
        DataEntityPropertyCollection properties = parentType.getProperties();
        boolean oldItemIsDeleted = true;
        for (DynamicObject thisentry : thisColl) {
            DynamicObject entry = (DynamicObject)parentType.createInstance();
            if ((Long)thisentry.getPkValue() == targetId) {
                entry = item;
                oldItemIsDeleted = false;
            } else {
                targetColl.add(targetColl.size(), entry);
            }
            for (IDataEntityProperty property : properties) {
                if (thisType.getProperty(property.getName()) == null) continue;
                if (property instanceof SubEntryProp) {
                    DynamicObjectCollection childColl = (DynamicObjectCollection)thisentry.get(property.getName());
                    DynamicObjectCollection targetChildColl = new DynamicObjectCollection(((SubEntryProp)property).getDynamicCollectionItemPropertyType(), (Object)entry);
                    if ((Long)thisentry.getPkValue() == targetId) {
                        targetChildColl = entry.getDynamicObjectCollection(property.getName());
                        EntryCopyUtil.newCollCoverTargetColl(targetChildColl, childColl);
                        continue;
                    }
                    EntryCopyUtil.newCollCoverTargetColl(targetChildColl, childColl);
                    property.setValueFast((Object)entry, (Object)targetChildColl);
                    continue;
                }
                property.setValueFast((Object)entry, thisentry.get(property.getName()));
            }
        }
        if (oldItemIsDeleted) {
            targetColl.remove(rowIndex);
        }
    }

    public static void newCollCoverTargetColl(DynamicObjectCollection targetColl, DynamicObjectCollection newColl) {
        Set targetCollSet = targetColl.stream().map(item -> (Long)item.getPkValue()).collect(Collectors.toSet());
        Set newCollSet = newColl.stream().map(item -> (Long)item.getPkValue()).collect(Collectors.toSet());
        Set needUpadateSet = targetCollSet.stream().filter(itemId -> newCollSet.contains(itemId)).collect(Collectors.toSet());
        Set needDelteSet = targetCollSet.stream().filter(itemId -> !newCollSet.contains(itemId)).collect(Collectors.toSet());
        DynamicObjectType parentType = targetColl.getDynamicObjectType();
        DynamicObjectType thisType = newColl.getDynamicObjectType();
        DataEntityPropertyCollection properties = parentType.getProperties();
        int size = targetColl.size();
        for (int i = 0; i < size; ++i) {
            DynamicObject target = (DynamicObject)targetColl.get(i);
            Long id = (Long)target.getPkValue();
            if (!needDelteSet.contains(id)) continue;
            targetColl.remove(i);
            --i;
            --size;
        }
        Map<Long, Integer> targetCollMap = EntryCopyUtil.getIdMapIndex(targetColl);
        for (DynamicObject thisentry : newColl) {
            Long thisid = (Long)thisentry.getPkValue();
            DynamicObject entry = (DynamicObject)parentType.createInstance();
            if (needUpadateSet.contains(thisid)) {
                entry = (DynamicObject)targetColl.get(targetCollMap.get(thisid).intValue());
            } else {
                targetColl.add(size++, entry);
            }
            for (IDataEntityProperty property : properties) {
                if (thisType.getProperty(property.getName()) == null) continue;
                if (property instanceof SubEntryProp) {
                    DynamicObjectCollection childColl = (DynamicObjectCollection)thisentry.get(property.getName());
                    DynamicObjectCollection targetChildColl = new DynamicObjectCollection(((SubEntryProp)property).getDynamicCollectionItemPropertyType(), (Object)entry);
                    EntryCopyUtil.newCollCoverTargetColl(targetChildColl, childColl);
                    property.setValueFast((Object)entry, (Object)targetChildColl);
                    continue;
                }
                property.setValueFast((Object)entry, thisentry.get(property.getName()));
            }
        }
    }

    public static Map<Long, Integer> getIdMapIndex(DynamicObjectCollection coll) {
        HashMap result = Maps.newHashMapWithExpectedSize((int)coll.size());
        for (int i = 0; i < coll.size(); ++i) {
            result.put((Long)((DynamicObject)coll.get(i)).getPkValue(), i);
        }
        return result;
    }
}

