/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.fi.er.business.utils.AmountChangeUtil;
import kd.fi.er.business.utils.ErStdConfig;
import kd.fi.er.business.utils.InvoiceOffsetUtils;
import kd.fi.er.business.utils.InvoiceUtils;
import kd.fi.er.business.utils.SystemParamterUtil;
import kd.fi.er.business.utils.model.ChangeField;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;

public class OffsetAndTaxRateUtils {
    public static void setOffsetAndTaxRate(DynamicObject targetBill) {
        DynamicObject company = targetBill.getDynamicObject("company");
        DynamicObject costcompany = targetBill.getDynamicObject("costcompany");
        boolean configOffset = false;
        boolean isOrgOffset = InvoiceOffsetUtils.deductibleOfTaxPayer(targetBill);
        if (company != null) {
            Long companyId = (Long)company.getPkValue();
            configOffset = SystemParamterUtil.manuallyaddexpenseoffset(companyId);
        }
        DynamicObjectCollection expenseentryentity = targetBill.getDynamicObjectCollection("expenseentryentity");
        for (DynamicObject expenseEntry : expenseentryentity) {
            BigDecimal price;
            Set<Long> invoiceIds;
            BigDecimal approveTax;
            DynamicObject expenseitem = expenseEntry.getDynamicObject("expenseitem");
            if (expenseitem == null) continue;
            BigDecimal expenseTaxrate = expenseitem.getBigDecimal("taxrate");
            if (!isOrgOffset) {
                expenseTaxrate = BigDecimal.ZERO;
            }
            BigDecimal computeTaxrate = expenseTaxrate.divide(BigDecimal.valueOf(100L), 4, RoundingMode.HALF_EVEN);
            boolean expenseOffset = expenseitem.getBoolean("offset");
            BigDecimal expeapproveAmount = (BigDecimal)expenseEntry.get("expeapproveamount");
            DynamicObject expenseCurrencyDO = expenseEntry.getDynamicObject("entrycurrency");
            int precision = expenseCurrencyDO.getInt("amtprecision");
            BigDecimal exchangeRate = expenseEntry.getBigDecimal("exchangerate");
            if (expenseTaxrate.compareTo(BigDecimal.ZERO) != 0 && (expenseEntry.getBigDecimal("taxrate") == null || expenseEntry.getBigDecimal("taxrate").compareTo(BigDecimal.ZERO) == 0)) {
                BigDecimal expenseAmount = expenseEntry.getBigDecimal("expenseamount");
                BigDecimal airportConstructionAmount = expenseEntry.getBigDecimal("airportconstructionfee");
                BigDecimal taxAmount = expenseAmount.subtract(airportConstructionAmount).multiply(computeTaxrate).divide(BigDecimal.ONE.add(computeTaxrate), precision, RoundingMode.HALF_EVEN);
                BigDecimal noTaxAmount = expenseAmount.subtract(taxAmount);
                expenseEntry.set("taxamount", (Object)taxAmount);
                expenseEntry.set("taxrate", (Object)expenseTaxrate);
                expenseEntry.set("orientryamount", (Object)noTaxAmount);
                approveTax = expeapproveAmount.subtract(airportConstructionAmount).multiply(computeTaxrate).divide(BigDecimal.ONE.add(computeTaxrate), precision, RoundingMode.HALF_EVEN);
                expenseEntry.set("approvetax", (Object)approveTax);
            }
            Boolean offset = isOrgOffset && expenseOffset && configOffset;
            Long expenseId = (Long)expenseEntry.getPkValue();
            if (expenseId != null && expenseId != 0L && targetBill.getDynamicObjectType().getProperties().get((Object)"invoiceentry") != null && !(invoiceIds = InvoiceUtils.mapInvoiceSet(targetBill, expenseId)).isEmpty()) {
                List invoiceList = targetBill.getDynamicObjectCollection("invoiceentry").stream().filter(invoiceItem -> invoiceIds.contains(invoiceItem.getPkValue())).collect(Collectors.toList());
                boolean isInvoiceOffset = invoiceList.stream().allMatch(invoiceItem -> invoiceItem.getBoolean("offset_invoice"));
                offset = isOrgOffset && expenseOffset && isInvoiceOffset;
            }
            if (offset.booleanValue()) {
                expenseEntry.set("offset", (Object)expenseOffset);
                BigDecimal deductibletaxAmount = (BigDecimal)expenseEntry.get("taxamount");
                expenseEntry.set("deductibletax", (Object)deductibletaxAmount);
            } else {
                expenseEntry.set("offset", (Object)false);
                expenseEntry.set("deductibletax", (Object)BigDecimal.ZERO);
            }
            AmountChangeUtil.updateInOutAmount(expenseEntry, costcompany, company, ChangeField.All);
            String formulaType = ErStdConfig.getApproveTaxFormulaType();
            if (StringUtils.equals((String)formulaType, (String)"1")) {
                BigDecimal deductibleTax = expenseEntry.getBigDecimal("deductibletax");
                price = expeapproveAmount.subtract(deductibleTax);
            } else {
                approveTax = expenseEntry.getBigDecimal("approvetax");
                price = expeapproveAmount.subtract(approveTax);
            }
            expenseEntry.set("price", (Object)price);
            String quoteType = (String)ObjectUtils.defaultIfNull((Object)expenseEntry.getString("expquotetype"), (Object)"0");
            BigDecimal curPrice = StringUtils.equals((String)"1", (String)quoteType) ? price.divide(exchangeRate, precision, RoundingMode.HALF_UP) : price.multiply(exchangeRate).setScale(precision, RoundingMode.HALF_UP);
            expenseEntry.set("curprice", (Object)curPrice);
        }
    }
}

