/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.dataprocesshandle;

import com.google.common.collect.Lists;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.er.business.trip.task.tripboards.OrderSummaryTask;
import kd.fi.er.formplugin.web.tripboards.manager.CacheManager;
import kd.fi.er.formplugin.web.tripboards.manager.ThreadPoolManager;
import kd.fi.er.formplugin.web.tripboards.model.SummaryModel;
import kd.fi.er.formplugin.web.tripboards.template.ProcessHandleTemplate;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public abstract class DataProcessHandle
extends ProcessHandleTemplate {
    private static final Log logger = LogFactory.getLog(DataProcessHandle.class);

    public DataProcessHandle() {
    }

    public DataProcessHandle(Map<String, Object> paramMap) {
        this.setParam(paramMap);
        Map<String, Object> param = this.getParam();
        if (paramMap.containsKey("beginDate") && param.get("beginDate") instanceof Date) {
            Date startDateObj = (Date)param.get("beginDate");
            LocalDate startDate = TripBoardsUtil.convertDateToLocalDate(startDateObj);
            startDate = startDate.with(TemporalAdjusters.firstDayOfMonth());
            param.put("beginDate", startDate);
        }
        if (paramMap.containsKey("endDate") && param.get("endDate") instanceof Date) {
            Date endDateObj = (Date)param.get("endDate");
            LocalDate endDate = TripBoardsUtil.convertDateToLocalDate(endDateObj);
            endDate = endDate.with(TemporalAdjusters.lastDayOfMonth());
            param.put("endDate", endDate);
        }
    }

    @Override
    public QFilter[] getFilters(Map<String, Object> filterMap) {
        return null;
    }

    @Override
    public String getFormId() {
        return null;
    }

    @Override
    public String getSelectProps() {
        return null;
    }

    @Override
    public String getCacheKey() {
        return null;
    }

    @Override
    protected String getResultKey() {
        return null;
    }

    @Override
    public abstract Object dataFilter(Object var1);

    @Override
    public abstract void dataHandle(Object var1);

    private List<DynamicObject> endQueryData(Collection<DynamicObject> queue, Map<String, Object> newParam) {
        RequestContext.copyAndSet((RequestContext)((RequestContext)newParam.get("context")));
        newParam.put("orgIds", this.getParam().get("orgIds"));
        String formId = this.getFormId();
        String selectProps = this.getSelectProps();
        QFilter[] filters = this.getFilters(newParam);
        queue.addAll((Collection<DynamicObject>)QueryServiceHelper.query((String)formId, (String)selectProps, (QFilter[])filters));
        return (List)this.dataFilter(new ArrayList<DynamicObject>(queue));
    }

    @Override
    public Object queryData(RequestContext context) {
        Semaphore semaphore = ThreadPoolManager.getSemaphore();
        Map<String, Object> param = this.getParam();
        if (param.containsKey("isReal") && this.isNeedDB().booleanValue()) {
            List<OrderSummaryTask.DateRange> pairs = TripBoardsUtil.getPairs(param);
            HashMap<String, List<DynamicObject>> dataMap = new HashMap<String, List<DynamicObject>>(16);
            long start = System.currentTimeMillis();
            ArrayList<Callable<List<DynamicObject>>> currentTasks = new ArrayList<Callable<List<DynamicObject>>>(16);
            for (OrderSummaryTask.DateRange dateRange : pairs) {
                currentTasks.add(() -> {
                    Map<String, Object> newParam = TripBoardsUtil.createParamMap(dateRange.getStart(), dateRange.getEnd(), context);
                    return this.endQueryData(new ConcurrentLinkedQueue<DynamicObject>(), newParam);
                });
            }
            if (this.getNeedYoY().booleanValue()) {
                ArrayList<Callable<List<DynamicObject>>> compareTasks = new ArrayList<Callable<List<DynamicObject>>>(16);
                for (OrderSummaryTask.DateRange pair : pairs) {
                    compareTasks.add(() -> {
                        Map<String, Object> compareParamMap = TripBoardsUtil.createParamMap(pair.getStart().minusMonths(12L), pair.getEnd().minusMonths(12L), context);
                        return this.endQueryData(new ConcurrentLinkedQueue<DynamicObject>(), compareParamMap);
                    });
                }
                List<DynamicObject> list = DataProcessHandle.executeTasks(compareTasks, semaphore, TaskType.ER_LOG_TASK);
                dataMap.put("compare", list);
                if (this.getNeedCache().booleanValue()) {
                    CacheManager.put(this.getCacheKey() + "_compare", list, DataProcessHandle.getPageQueryMap(this.getParam()));
                }
            }
            List<DynamicObject> currentList = DataProcessHandle.executeTasks(currentTasks, semaphore, TaskType.ER_LOG_TASK);
            dataMap.put("current", currentList);
            long l = System.currentTimeMillis();
            logger.info("\u67e5\u8be2\u4f7f\u7528\u65f6\u95f4: {}", (Object)(l - start));
            if (this.getNeedCache().booleanValue()) {
                CacheManager.put(this.getCacheKey(), currentList, DataProcessHandle.getPageQueryMap(this.getParam()));
            }
            return dataMap;
        }
        RequestContext.copyAndSet((RequestContext)context);
        HashMap<String, List<DynamicObject>> dataMap = new HashMap<String, List<DynamicObject>>();
        if (this.isNeedDB().booleanValue()) {
            LocalDate localBeginDate = (LocalDate)param.get("beginDate");
            LocalDate localEndDate = (LocalDate)param.get("endDate");
            List<OrderSummaryTask.DateRange> pairs = TripBoardsUtil.getMonthlyDateRanges(localBeginDate, localEndDate);
            long start = System.currentTimeMillis();
            List<DynamicObject> list = DataProcessHandle.executeTasks(this.getCurrentTasks(context, pairs), semaphore, TaskType.ER_TRIP_TASK);
            dataMap.put("current", list);
            Map<String, Object> pageQueryMap = DataProcessHandle.getPageQueryMap(param);
            if (this.getNeedCache().booleanValue()) {
                List summaryModels = list.parallelStream().map(dynamicObject -> new SummaryModel(dynamicObject.getLong("id"), dynamicObject.getBigDecimal("summaryamount"), dynamicObject.getString("orgid"), dynamicObject.getDate("summarystart"), dynamicObject.getDate("summaryend"), dynamicObject.getString("orgtype"), "")).collect(Collectors.toList());
                CacheManager.put(this.getCacheKey(), summaryModels, pageQueryMap);
            }
            if (this.getNeedYoY().booleanValue()) {
                List<LocalDate> months = DataProcessHandle.getOverlapDates(localBeginDate, localEndDate);
                List<DynamicObject> compareCombinedResults = DataProcessHandle.executeTasks(this.getCompareTasks(context, pairs, months), semaphore, TaskType.ER_LOG_TASK);
                dataMap.put("compare", compareCombinedResults);
                if (this.getNeedCache().booleanValue()) {
                    List summaryModels = compareCombinedResults.parallelStream().map(dynamicObject -> new SummaryModel(dynamicObject.getLong("id"), dynamicObject.getBigDecimal("summaryamount"), dynamicObject.getString("orgid"), dynamicObject.getDate("summarystart"), dynamicObject.getDate("summaryend"), dynamicObject.getString("orgtype"), "")).collect(Collectors.toList());
                    CacheManager.put(this.getCacheKey() + "_compare", summaryModels, pageQueryMap);
                }
            }
            long end = System.currentTimeMillis();
            logger.info("\u67e5\u8be2\u4f7f\u7528\u65f6\u95f4: {}", (Object)(end - start));
        }
        return dataMap;
    }

    protected static List<LocalDate> getOverlapDates(LocalDate localBeginDate, LocalDate localEndDate) {
        LocalDate compareBeginDate = localBeginDate.minusMonths(12L);
        LocalDate compareEndDate = localEndDate.minusMonths(12L);
        LocalDate overlapStart = localBeginDate.isAfter(compareBeginDate) ? localBeginDate : compareBeginDate;
        LocalDate overlapEnd = localEndDate.isBefore(compareEndDate) ? localEndDate : compareEndDate;
        ArrayList<LocalDate> months = new ArrayList<LocalDate>();
        if (overlapStart.isBefore(overlapEnd) || overlapStart.equals(overlapEnd)) {
            LocalDate current = overlapStart.withDayOfMonth(1);
            while (!current.isAfter(overlapEnd)) {
                months.add(current);
                current = current.plusMonths(1L);
            }
        }
        return months;
    }

    protected List<DynamicObject> getCurrentAlgox(RequestContext context, List<OrderSummaryTask.DateRange> pairs) {
        JobSession tripBoards = AlgoX.createSession((String)"TripBoards_current");
        List<Object> result = new ArrayList<DynamicObject>();
        ArrayList inputs = Lists.newArrayListWithCapacity((int)16);
        for (OrderSummaryTask.DateRange pair : pairs) {
            Map<String, Object> compareParamMap = TripBoardsUtil.createParamMap(pair.getStart(), pair.getEnd(), context);
            compareParamMap.put("orgIds", this.getParam().get("orgIds"));
            OrmInput ormInput = new OrmInput(this.getClass().getName(), this.getFormId(), this.getSelectProps(), this.getFilters(compareParamMap));
            inputs.add(ormInput);
        }
        DataSetX dataSetX = tripBoards.fromInput(inputs.toArray(new Input[0]));
        RowMeta rowMeta = dataSetX.getRowMeta();
        DataSetOutput dataSetOutput = new DataSetOutput(rowMeta);
        try {
            long start = System.currentTimeMillis();
            dataSetX.output((Output)dataSetOutput);
            tripBoards.commit(600, TimeUnit.SECONDS);
            DataSet rows = tripBoards.readDataSet(dataSetOutput.getId());
            DynamicObjectCollection plainDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(rows);
            result = (List)this.dataFilter(plainDynamicObjectCollection);
            logger.info("algox used {},algox size {}", (Object)(System.currentTimeMillis() - start), (Object)result.size());
        }
        catch (Exception ex) {
            logger.error("algox error", (Throwable)ex);
        }
        return result;
    }

    protected List<DynamicObject> getCompareAlgox(RequestContext context, List<OrderSummaryTask.DateRange> pairs, List<LocalDate> months) {
        JobSession tripBoards = AlgoX.createSession((String)"TripBoards_compare");
        List<Object> result = new ArrayList<DynamicObject>();
        ArrayList<OrmInput> inputs = new ArrayList<OrmInput>();
        for (OrderSummaryTask.DateRange pair : pairs) {
            LocalDate beginDate = pair.getStart().minusMonths(12L);
            LocalDate endDate = pair.getEnd().minusMonths(12L);
            if (months.contains(beginDate)) continue;
            Map<String, Object> compareParamMap = TripBoardsUtil.createParamMap(beginDate, endDate, context);
            compareParamMap.put("orgIds", this.getParam().get("orgIds"));
            OrmInput ormInput = new OrmInput(this.getClass().getName(), this.getFormId(), this.getSelectProps(), this.getFilters(compareParamMap));
            inputs.add(ormInput);
        }
        DataSetX dataSetX = tripBoards.fromInput(inputs.toArray(new Input[0]));
        RowMeta rowMeta = dataSetX.getRowMeta();
        DataSetOutput dataSetOutput = new DataSetOutput(rowMeta);
        try {
            long start = System.currentTimeMillis();
            dataSetX.output((Output)dataSetOutput);
            tripBoards.commit(600, TimeUnit.SECONDS);
            DataSet rows = tripBoards.readDataSet(dataSetOutput.getId());
            DynamicObjectCollection plainDynamicObjectCollection = ORM.create().toPlainDynamicObjectCollection(rows);
            result = (List)this.dataFilter(plainDynamicObjectCollection);
            logger.info("algox used{},algox size{}", (Object)(System.currentTimeMillis() - start), (Object)result.size());
        }
        catch (Exception ex) {
            logger.error("algox error", (Throwable)ex);
        }
        return result;
    }

    protected static Map<String, Object> getPageQueryMap(Map<String, Object> param) {
        HashMap<String, Object> queryMap = new HashMap<String, Object>(16);
        queryMap.put("starttime", param.get("beginDate"));
        queryMap.put("endtime", param.get("endDate"));
        queryMap.put("orgid", param.get("rootOrg"));
        if (param.containsKey("isReal")) {
            queryMap.put("isReal", param.get("isReal"));
        }
        return queryMap;
    }

    private static List<DynamicObject> executeTasks(List<Callable<List<DynamicObject>>> tasks, Semaphore semaphore, TaskType taskType) {
        ConcurrentLinkedQueue combinedResults = new ConcurrentLinkedQueue();
        long endL = System.currentTimeMillis();
        tasks.parallelStream().forEach(task -> {
            try {
                semaphore.acquire();
                combinedResults.addAll((Collection)ThreadService.submit((Callable)task, (TaskType)taskType).get());
            }
            catch (Exception e) {
                logger.error("executeTasks error", (Throwable)e);
            }
            finally {
                semaphore.release();
            }
        });
        return new ArrayList<DynamicObject>(combinedResults);
    }

    protected void combineData(List<LocalDate> months, List<DynamicObject> currentList, List<DynamicObject> compareList) {
        if (months.isEmpty()) {
            return;
        }
        LocalDate localDate = months.get(0);
        LocalDate endDate = months.get(months.size() - 1).with(TemporalAdjusters.lastDayOfMonth());
        compareList.addAll(currentList.parallelStream().filter(obj -> {
            if (obj == null) {
                return false;
            }
            LocalDate summaryStart = TripBoardsUtil.convertDateToLocalDate(obj.getDate("summarystart"));
            LocalDate summaryEnd = TripBoardsUtil.convertDateToLocalDate(obj.getDate("summaryend"));
            return !summaryStart.isBefore(localDate) && !summaryEnd.isAfter(endDate);
        }).collect(Collectors.toList()));
    }

    private List<Callable<List<DynamicObject>>> getCurrentTasks(RequestContext context, List<OrderSummaryTask.DateRange> pairs) {
        return pairs.stream().map(pair -> () -> this.querySummaryDBData(context, pair.getStart(), pair.getEnd())).collect(Collectors.toList());
    }

    private List<Callable<List<DynamicObject>>> getCompareTasks(RequestContext context, List<OrderSummaryTask.DateRange> pairs, List<LocalDate> months) {
        return pairs.stream().map(pair -> () -> this.querySummaryDBData(context, pair.getStart().minusMonths(12L), pair.getEnd().minusMonths(12L))).collect(Collectors.toList());
    }

    public List<DynamicObject> querySummaryDBData(RequestContext context, LocalDate start, LocalDate end) {
        ArrayList resultList = null;
        try {
            Map<String, Object> compareParamMap = TripBoardsUtil.createParamMap(start, end, context);
            compareParamMap.put("orgIds", this.getParam().get("orgIds"));
            RequestContext.copyAndSet((RequestContext)context);
            String formId = this.getFormId();
            String selectProps = this.getSelectProps();
            QFilter[] filters = this.getFilters(compareParamMap);
            DynamicObjectCollection query = QueryServiceHelper.query((String)formId, (String)selectProps, (QFilter[])filters);
            resultList = new ArrayList(query.size());
            resultList.addAll((List)this.dataFilter(new ArrayList(query)));
        }
        catch (Exception e) {
            logger.error("\u65f6\u95f4\u6bb5\u67e5\u8be2\u5931\u8d25", (Throwable)e);
        }
        return resultList;
    }

    @Override
    public Boolean isNeedDB() {
        return Boolean.TRUE;
    }
}

