/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.dataprocesshandle;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.OrmInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.login.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ConfigurationUtil;
import kd.fi.er.business.trip.task.tripboards.OrderSummaryTask;
import kd.fi.er.formplugin.web.tripboards.dataprocesshandle.DataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.model.Indicator;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class TripOrderDataProcessHandle
extends DataProcessHandle {
    public static Map<String, Indicator> INDICATORS = Maps.newConcurrentMap();

    public TripOrderDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.TRUE);
    }

    public TripOrderDataProcessHandle() {
        this.setNeedYoY(Boolean.TRUE);
    }

    public QFilter[] getCommonFilters(String timeKey, String companyKey, String deptKey, Map<String, Object> filterMap) {
        String inThreshold = ConfigurationUtil.getString((String)"orm.opt.in.threshold");
        if (StringUtils.isEmpty((String)inThreshold)) {
            inThreshold = "10000";
        }
        if (this.getParam().containsKey("isReal")) {
            LocalDate beginDate = (LocalDate)filterMap.get("beginDate");
            LocalDate endDate = (LocalDate)filterMap.get("endDate");
            QFilter startFilter = new QFilter(timeKey, ">=", (Object)beginDate.atTime(LocalTime.MIN));
            QFilter endFilter = new QFilter(timeKey, "<=", (Object)endDate.atTime(LocalTime.MAX));
            QFilter current = startFilter.and(endFilter);
            Set orgIds = (Set)this.getParam().get("orgIds");
            if (orgIds != null && orgIds.size() <= Integer.parseInt(inThreshold)) {
                this.setOrgFilter(Boolean.TRUE);
                return new QFilter[]{current, new QFilter(companyKey, "in", (Object)orgIds).or(new QFilter(deptKey, "in", (Object)orgIds))};
            }
            return new QFilter[]{current};
        }
        Set orgIds = (Set)filterMap.get("orgIds");
        LocalDate beginDate = (LocalDate)filterMap.get("beginDate");
        LocalDate endDate = (LocalDate)filterMap.get("endDate");
        QFilter startFilter = new QFilter("summarystart", "=", (Object)beginDate);
        QFilter endFilter = new QFilter("summaryend", "=", (Object)endDate);
        QFilter current = startFilter.and(endFilter);
        if (orgIds != null && orgIds.size() <= Integer.parseInt(inThreshold)) {
            this.setOrgFilter(Boolean.TRUE);
            current.and(new QFilter("orgid", "in", orgIds.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())));
        }
        return new QFilter[]{current};
    }

    @Override
    public Object dataFilter(Object data) {
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)4);
        Map<String, Object> param = this.getParam();
        if (param.containsKey("isReal")) {
            if (data instanceof Map) {
                Set orgIds;
                Map returnData = (Map)data;
                if (returnData.containsKey("current")) {
                    List<DynamicObject> currentData = (List<DynamicObject>)returnData.get("current");
                    if (!this.isOrgFilter()) {
                        orgIds = (Set)param.get("orgIds");
                        currentData = TripBoardsUtil.orgFilterFun(currentData, orgIds);
                    }
                    resultMap.put("current", currentData);
                }
                if (returnData.containsKey("compare")) {
                    List<DynamicObject> compareData = (List<DynamicObject>)returnData.get("compare");
                    if (!this.isOrgFilter()) {
                        orgIds = (Set)param.get("orgIds");
                        compareData = TripBoardsUtil.orgFilterFun(compareData, orgIds);
                    }
                    resultMap.put("compare", compareData);
                }
            } else if (data instanceof Collection) {
                List<DynamicObject> dataList = (List<DynamicObject>)data;
                if (!this.isOrgFilter()) {
                    Set orgIds = (Set)param.get("orgIds");
                    dataList = TripBoardsUtil.orgFilterFun(dataList, orgIds);
                    return dataList;
                }
                return dataList;
            }
            return resultMap;
        }
        if (data instanceof Collection && !this.isOrgFilter()) {
            List dataList = (List)data;
            Set orgIds = (Set)this.getParam().get("orgIds");
            dataList = dataList.parallelStream().filter(obj -> StringUtils.isNotBlank((String)obj.getString("orgId")) && orgIds.contains(Long.parseLong(obj.getString("orgId")))).collect(Collectors.toList());
            return dataList;
        }
        return data;
    }

    @Override
    public void dataHandle(Object data) {
    }

    public void rateDeal(Map<String, Object> resultMap, Map<String, Object> compareResultMap) {
        for (Map.Entry<String, Indicator> entry : INDICATORS.entrySet()) {
            Indicator indicator = entry.getValue();
            Object compareValue = compareResultMap.getOrDefault(indicator.getCompareKey(), "-");
            Object value = resultMap.getOrDefault(indicator.getResultKey(), "-");
            TripBoardsUtil.dealRateResult(resultMap, compareValue, value, indicator.getArrowKey(), indicator.getRateKey());
        }
    }

    public String getNewAmountTitle(double totalamount, String amountTitle, String tenThousandTitle) {
        String amountUnit = TripBoardsUtil.getAmountUnit(BigDecimal.valueOf(totalamount));
        return "tenThousand".equals(amountUnit) ? tenThousandTitle : amountTitle;
    }

    protected OrderInputs getResult(String timeKey) {
        Map<String, Object> param = this.getParam();
        LocalDate localBeginDate = (LocalDate)param.get("beginDate");
        LocalDate localEndDate = (LocalDate)param.get("endDate");
        long betweenMonth = ChronoUnit.MONTHS.between(localBeginDate, localEndDate) + 1L;
        param.put("isReal", "flag");
        this.setParam(param);
        Set orgIds = (Set)this.getParam().get("orgIds");
        List<OrderSummaryTask.DateRange> pairs = betweenMonth <= 1L ? TripBoardsUtil.getPairs(this.getParam()) : TripBoardsUtil.getMonthlyDateRanges(localBeginDate, localEndDate);
        ArrayList inputs = Lists.newArrayListWithCapacity((int)16);
        ArrayList compareInputs = Lists.newArrayListWithCapacity((int)16);
        for (OrderSummaryTask.DateRange pair : pairs) {
            QFilter startFilter = new QFilter(timeKey, ">=", (Object)pair.getStart().atTime(LocalTime.MIN));
            QFilter endFilter = new QFilter(timeKey, "<=", (Object)pair.getEnd().atTime(LocalTime.MAX));
            QFilter current = startFilter.and(endFilter);
            this.dealInputs(new ArrayList<Long>(orgIds), current, inputs);
            LocalDate beginDate = pair.getStart().minusMonths(12L);
            LocalDate endDate = pair.getEnd().minusMonths(12L);
            startFilter = new QFilter(timeKey, ">=", (Object)beginDate.atTime(LocalTime.MIN));
            endFilter = new QFilter(timeKey, "<=", (Object)endDate.atTime(LocalTime.MAX));
            current = startFilter.and(endFilter);
            this.dealInputs(new ArrayList<Long>(orgIds), current, compareInputs);
        }
        return new OrderInputs(inputs, compareInputs);
    }

    private void dealInputs(List<Long> orgGroup, QFilter current, List<Input> inputs) {
        QFilter orgFilter = new QFilter("expcommitcomnum", "in", orgGroup).or(new QFilter("expcommitdepnum", "in", orgGroup));
        OrmInput ormInput = new OrmInput(this.getClass().getName(), this.getFormId(), this.getSelectProps(), new QFilter[]{current, orgFilter});
        inputs.add((Input)ormInput);
    }

    protected static DataSet getResult(DataSetX sum, JobSession tripBoards) {
        RowMeta rowMeta = sum.getRowMeta();
        DataSetOutput dataSetOutput = new DataSetOutput(rowMeta);
        sum.output((Output)dataSetOutput);
        tripBoards.commit(600, TimeUnit.SECONDS);
        return tripBoards.readDataSet(dataSetOutput.getId());
    }

    protected String getAmountTitle() {
        return ResManager.loadKDString((String)"\u6708\u7ed3\u603b\u989d\uff08\u5143\uff09", (String)"TripBoard_5", (String)"fi-er-business", (Object[])new Object[0]);
    }

    protected String getTenThousandAmountTitle() {
        return ResManager.loadKDString((String)"\u6708\u7ed3\u603b\u989d\uff08\u4e07\u5143\uff09", (String)"TripBoard_5_1", (String)"fi-er-business", (Object[])new Object[0]);
    }

    protected String getServiceTitle() {
        return ResManager.loadKDString((String)"\u670d\u52a1\u8d39\uff08\u5143\uff09", (String)"TripBoard_8", (String)"fi-er-business", (Object[])new Object[0]);
    }

    protected String getTenThousandServiceTitle() {
        return ResManager.loadKDString((String)"\u670d\u52a1\u8d39\uff08\u4e07\u5143\uff09", (String)"TripBoard_8_1", (String)"fi-er-business", (Object[])new Object[0]);
    }

    protected String getChangeTitle() {
        return ResManager.loadKDString((String)"\u6539\u7b7e\u8d39\uff08\u5143\uff09", (String)"TripBoard_6", (String)"fi-er-business", (Object[])new Object[0]);
    }

    protected String getTenThousandChangeTitle() {
        return ResManager.loadKDString((String)"\u6539\u7b7e\u8d39\uff08\u4e07\u5143\uff09", (String)"TripBoard_6_1", (String)"fi-er-business", (Object[])new Object[0]);
    }

    protected String getRefundTitle() {
        return ResManager.loadKDString((String)"\u9000\u7968\u8d39\uff08\u5143\uff09", (String)"TripBoard_7", (String)"fi-er-business", (Object[])new Object[0]);
    }

    protected String getTenThousandRefundTitle() {
        return ResManager.loadKDString((String)"\u9000\u7968\u8d39\uff08\u4e07\u5143\uff09", (String)"TripBoard_7_1", (String)"fi-er-business", (Object[])new Object[0]);
    }

    protected static class OrderInputs {
        public final List<Input> inputs;
        public final List<Input> compareInputs;

        public OrderInputs(List<Input> inputs, List<Input> compareInputs) {
            this.inputs = inputs;
            this.compareInputs = compareInputs;
        }
    }
}

