/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.plugins;

import java.time.LocalDate;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.field.DateEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.business.utils.ErCommonUtils;
import kd.fi.er.formplugin.web.tripboards.listener.BeforeFinanceOrgF7SelectListener;
import kd.fi.er.formplugin.web.tripboards.listener.BeforeManageOrgF7SelectListener;
import kd.fi.er.formplugin.web.tripboards.listener.BeforeNormalOrgF7SelectListener;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class TripBoardPlugin
extends AbstractFormPlugin
implements ClickListener,
ItemClickListener {
    private static Log logger = LogFactory.getLog(TripBoardPlugin.class);

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"jumpplane"});
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Map customParams = formShowParameter.getCustomParams();
        String type = customParams.getOrDefault("type", "Finance").toString();
        OrgEdit orgF7 = (OrgEdit)this.getControl("org");
        try {
            if (orgF7 != null) {
                switch (type) {
                    case "Normal": {
                        orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeNormalOrgF7SelectListener());
                        break;
                    }
                    case "Manage": {
                        orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeManageOrgF7SelectListener());
                        break;
                    }
                    case "Finance": {
                        orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)new BeforeFinanceOrgF7SelectListener(this.getPageCache()));
                    }
                }
            }
        }
        catch (Exception ex) {
            logger.error("\u8bbe\u7f6e\u6743\u9650\u7ec4\u7ec7\u9519\u8bef,\u9ed8\u8ba4\u663e\u793a\u5f53\u524d\u7ec4\u7ec7\u6570\u636e:", (Throwable)ex);
            final long orgId = RequestContext.get().getOrgId();
            orgF7.addBeforeF7SelectListener(new BeforeF7SelectListener(){

                public void beforeF7Select(BeforeF7SelectEvent evt) {
                    FormShowParameter formShowParameter = evt.getFormShowParameter();
                    formShowParameter.setCustomParam("range", (Object)orgId);
                    formShowParameter.setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
                    if (formShowParameter instanceof ListShowParameter) {
                        ListShowParameter listShowParameter = (ListShowParameter)formShowParameter;
                        listShowParameter.setMultiSelect(Boolean.TRUE.booleanValue());
                    }
                }
            });
        }
    }

    public void afterCreateNewData(EventObject e) {
        Control control = this.getControl("dataperiod_enddate");
        this.setDate(control);
        IPageCache pageCache = this.getPageCache();
        TripBoardsUtil.setKeyFiguresToPageCache(pageCache);
        IDataModel model = this.getModel();
        model.setValue("org", (Object)Long.parseLong(pageCache.get("root")));
    }

    protected void setDate(Control dateControl) {
        if (dateControl instanceof DateEdit) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(2, -1);
            int days = cal.getActualMaximum(5);
            cal.set(5, days);
            this.getModel().setValue("dataperiod_enddate", (Object)cal.getTime());
            days = cal.getActualMinimum(5);
            cal.set(5, days);
            LocalDate now = LocalDate.now();
            DateEdit tripDate = (DateEdit)this.getControl("dataperiod_enddate");
            tripDate.setMaxDate(ErCommonUtils.getDateFromLocalDate(now));
            DateEdit startDate = (DateEdit)this.getControl("dataperiod_startdate");
            startDate.setMaxDate(ErCommonUtils.getDateFromLocalDate(now));
            this.getModel().setValue("dataperiod_startdate", (Object)cal.getTime());
        }
    }

    public void click(EventObject evt) {
        Label clickLabel;
        String key;
        Object source = evt.getSource();
        if (source instanceof Label && "jumpplane".equals(key = (clickLabel = (Label)source).getKey())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("er_trip_boards_plane");
            IDataModel model = this.getModel();
            showParameter.setCustomParam("type", (Object)"Finance");
            showParameter.setCustomParam("rootOrg", (Object)ErCommonUtils.getPk(model.getValue("org")));
            showParameter.setCustomParam("dataperiod_enddate", model.getValue("dataperiod_enddate"));
            showParameter.setCustomParam("dataperiod_startdate", model.getValue("dataperiod_startdate"));
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            this.getView().showForm(showParameter);
        }
    }
}

