/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.financeindex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.formplugin.web.tripboards.dataprocesshandle.TripOrderDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.model.Indicator;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class TrainDataProcessHandle
extends TripOrderDataProcessHandle {
    static Map<String, Object> DEFAULT_MAP_TRAIN = new HashMap<String, Object>(16);
    private static final String TOTAL_AMOUNT_KEY = "totalamount";
    private static final String SERVICE_FEE_KEY = "servicefee";
    private static final String REFUND_AMOUNT_KEY = "refundamount";
    private static final String ORDER_TYPE_KEY = "ordertype";
    private static final String PASSENGER_KEY = "passeger";
    private static final String TIME_KEY = "departtime";
    private static final String ID_KEY = "id";

    public TrainDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.TRUE);
        this.setDataResult(DEFAULT_MAP_TRAIN);
    }

    public TrainDataProcessHandle() {
        this.setNeedYoY(Boolean.TRUE);
        this.setDataResult(DEFAULT_MAP_TRAIN);
    }

    @Override
    public QFilter[] getFilters(Map<String, Object> filterMap) {
        return this.getCommonFilters(TIME_KEY, "expcommitcomnum", "expcommitdepnum", filterMap);
    }

    @Override
    public String getFormId() {
        if (this.getParam().containsKey("isReal")) {
            return "er_trainbill";
        }
        return "er_train_summary";
    }

    @Override
    public String getSelectProps() {
        if (this.getParam().containsKey("isReal")) {
            return "totalamount,servicefee,passeger,expcommitcomnum,expcommitdepnum,ordertype,refundamount,departtime,arrivecity,id";
        }
        return "id,summaryamount,summaryservicefee,summaryrefundamount,orgid,summarystart,summaryend,summaryactivepeople,ordernums,traveluser_tag,orgtype,otherdatasummary_tag";
    }

    @Override
    public void dataHandle(Object data) {
        if (this.getParam().containsKey("isReal")) {
            this.endDataProcess(data, Boolean.FALSE);
        } else {
            this.endDataProcess(data, Boolean.TRUE);
        }
    }

    public void dataDeal(Map<String, Object> resultMap, List<DynamicObject> handleData, Boolean isSummary) {
        double totalamount = 0.0;
        double servicefee = 0.0;
        double refundamount = 0.0;
        long nums = 0L;
        List<String> orderTypes = Arrays.asList("O", "G");
        if (isSummary.booleanValue()) {
            List summaryTag = handleData.parallelStream().map(dynamicObject -> dynamicObject.getString("otherdatasummary_tag")).collect(Collectors.toList());
            HashSet allOrderInfoSet = new HashSet(16);
            for (String s : summaryTag) {
                JSONObject jsonObject = JSONObject.parseObject((String)s);
                JSONArray orderArray = jsonObject.getJSONArray("orderNumsAndAmount");
                allOrderInfoSet.addAll(orderArray.stream().map(String::valueOf).collect(Collectors.toSet()));
            }
            for (String orderInfo : allOrderInfoSet) {
                String orderType;
                String[] info = orderInfo.split("\\$");
                int length = info.length;
                String totalamountStr = length >= 2 ? info[1] : "0";
                String servicefeeStr = length >= 3 ? info[2] : "0";
                String refundamountStr = length >= 4 ? info[3] : "0";
                String string = orderType = length >= 5 ? info[4] : "unknown";
                if (orderTypes.contains(orderType)) {
                    ++nums;
                }
                totalamount = Double.sum(totalamount, Double.parseDouble(totalamountStr));
                servicefee = Double.sum(servicefee, Double.parseDouble(servicefeeStr));
                refundamount = Double.sum(refundamount, Double.parseDouble(refundamountStr));
            }
        } else {
            totalamount = handleData.parallelStream().filter(obj -> obj.get(TOTAL_AMOUNT_KEY) != null && obj.getBigDecimal(TOTAL_AMOUNT_KEY).compareTo(ConvertUtil.getOrderAmountInit()) != 0).mapToDouble(obj -> Double.parseDouble(obj.get(TOTAL_AMOUNT_KEY).toString())).sum();
            servicefee = handleData.parallelStream().filter(obj -> obj.get(SERVICE_FEE_KEY) != null && obj.getBigDecimal(TOTAL_AMOUNT_KEY).compareTo(ConvertUtil.getOrderAmountInit()) != 0).mapToDouble(obj -> Double.parseDouble(obj.get(SERVICE_FEE_KEY).toString())).sum();
            refundamount = handleData.parallelStream().filter(obj -> obj.get(REFUND_AMOUNT_KEY) != null && obj.getBigDecimal(TOTAL_AMOUNT_KEY).compareTo(ConvertUtil.getOrderAmountInit()) != 0).mapToDouble(obj -> Double.parseDouble(obj.get(REFUND_AMOUNT_KEY).toString())).sum();
        }
        if (!isSummary.booleanValue()) {
            nums = handleData.parallelStream().filter(obj -> orderTypes.contains(obj.getString(ORDER_TYPE_KEY))).count();
        }
        long activePeople = 0L;
        if (!isSummary.booleanValue()) {
            activePeople = handleData.parallelStream().filter(obj -> obj.get(PASSENGER_KEY) != null).map(obj -> obj.getLong(PASSENGER_KEY)).distinct().count();
        } else {
            List userIdList = handleData.parallelStream().map(obj -> obj.getString("traveluser_tag")).collect(Collectors.toList());
            HashSet<String> userIdSet = new HashSet<String>();
            for (String userIdStr : userIdList) {
                String[] split = userIdStr.split(",");
                userIdSet.addAll(Arrays.asList(split));
            }
            activePeople = userIdSet.size();
        }
        this.getResultMap(resultMap, totalamount, nums, activePeople, refundamount, servicefee);
        TrainDataProcessHandle.putOriginValueMap(resultMap, totalamount, nums, activePeople, refundamount, servicefee);
    }

    private static void putOriginValueMap(Map<String, Object> resultMap, double totalamount, long nums, long activePeople, double refundamount, double servicefee) {
        HashMap<String, Number> originValueMap = new HashMap<String, Number>(16);
        originValueMap.put("t_month_amount", BigDecimal.valueOf(totalamount));
        originValueMap.put("t_order_nums", nums);
        originValueMap.put("t_active_people", activePeople);
        originValueMap.put("t_refund_fee", BigDecimal.valueOf(refundamount));
        originValueMap.put("t_service_fee", BigDecimal.valueOf(servicefee));
        resultMap.put("origin", originValueMap);
    }

    private void getResultMap(Map<String, Object> resultMap, double totalamount, long nums, long activePeople, double refundamount, double servicefee) {
        resultMap.put("t_month_amount", BigDecimal.valueOf(totalamount));
        resultMap.put("t_order_nums", nums);
        resultMap.put("t_active_people", activePeople);
        resultMap.put("t_refund_fee", BigDecimal.valueOf(refundamount));
        resultMap.put("t_service_fee", BigDecimal.valueOf(servicefee));
        resultMap.put("t_month_title", this.getNewAmountTitle(totalamount, this.getAmountTitle(), this.getTenThousandAmountTitle()));
        resultMap.put("t_service_title", this.getNewAmountTitle(servicefee, this.getServiceTitle(), this.getTenThousandServiceTitle()));
        resultMap.put("t_refund_title", this.getNewAmountTitle(refundamount, this.getRefundTitle(), this.getTenThousandRefundTitle()));
    }

    @Override
    public void rateDeal(Map<String, Object> resultMap, Map<String, Object> compareResultMap) {
        INDICATORS = new HashMap(16);
        INDICATORS.put("t_month_amount", new Indicator("t_month_amount", "t_month_amount", "t_month_arrow", "t_month_rate"));
        INDICATORS.put("t_refund_fee", new Indicator("t_refund_fee", "t_refund_fee", "t_refund_arrow", "t_refund_rate"));
        INDICATORS.put("t_service_fee", new Indicator("t_service_fee", "t_service_fee", "t_service_arrow", "t_service_rate"));
        INDICATORS.put("t_order_nums", new Indicator("t_order_nums", "t_order_nums", "t_ordernums_arrow", "t_ordernums_rate"));
        super.rateDeal(resultMap, compareResultMap);
    }

    @Override
    public String getCacheKey() {
        return RequestContext.get().getCurrUserId() + "_TRIP_FINANCE_DATA_TRAIN";
    }

    @Override
    protected String getResultKey() {
        return RequestContext.get().getCurrUserId() + "_TRIP_FINANCE_RESULT_TRAIN";
    }

    private void endDataProcess(Object data, Boolean isSummary) {
        if (data == null) {
            this.setDataResult(DEFAULT_MAP_TRAIN);
            return;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)8);
        HashMap compareResultMap = Maps.newHashMapWithExpectedSize((int)8);
        List handleData = (List)((Map)data).get("current");
        List compareHandleData = (List)((Map)data).get("compare");
        if (handleData.isEmpty() && compareHandleData.isEmpty()) {
            this.setDataResult(DEFAULT_MAP_TRAIN);
            return;
        }
        this.dataDeal(resultMap, handleData, isSummary);
        this.dataDeal(compareResultMap, compareHandleData, isSummary);
        this.rateDeal(resultMap, compareResultMap);
        TripBoardsUtil.formatDecimal(resultMap);
        this.setDataResult(resultMap);
    }

    @Override
    protected void calcByAlgoX() {
        TripOrderDataProcessHandle.OrderInputs result = this.getResult(TIME_KEY);
        JobSession tripBoards = AlgoX.createSession((String)"TripBoards-Train-Algox");
        DataSetX dataSetX = tripBoards.fromInput(result.inputs.toArray(new Input[0]));
        DataSetX compareDataSetX = tripBoards.fromInput(result.compareInputs.toArray(new Input[0]));
        DataSetX allDataSetX = dataSetX.select(new String[]{TOTAL_AMOUNT_KEY, SERVICE_FEE_KEY, REFUND_AMOUNT_KEY, ORDER_TYPE_KEY, PASSENGER_KEY, ID_KEY});
        DataSetX compareAllDataSetX = compareDataSetX.select(new String[]{TOTAL_AMOUNT_KEY, SERVICE_FEE_KEY, REFUND_AMOUNT_KEY, ORDER_TYPE_KEY, PASSENGER_KEY, ID_KEY});
        DataSetX amountSumDataSetX = TrainDataProcessHandle.getAmountSumDataSetX(allDataSetX);
        DataSetX compareAmountSumDataSetX = TrainDataProcessHandle.getAmountSumDataSetX(compareAllDataSetX);
        DataSetX numsSet = TrainDataProcessHandle.getNumsSet(allDataSetX);
        DataSetX compareNumsSet = TrainDataProcessHandle.getNumsSet(compareAllDataSetX);
        DataSetX activePeoples = TrainDataProcessHandle.getActivePeoples(dataSetX);
        DataSet amountSumDataSet = TrainDataProcessHandle.getResult(amountSumDataSetX, tripBoards);
        DataSet compareAmountSumDataSet = TrainDataProcessHandle.getResult(compareAmountSumDataSetX, tripBoards);
        DataSet currentTotalNums = TrainDataProcessHandle.getResult(numsSet, tripBoards);
        DataSet compareTotalNums = TrainDataProcessHandle.getResult(compareNumsSet, tripBoards);
        DataSet activePeoplesDataSet = TrainDataProcessHandle.getResult(activePeoples, tripBoards);
        HashMap<String, Object> resultMap = new HashMap<String, Object>(16);
        this.algoxResultDeal(resultMap, amountSumDataSet, currentTotalNums, activePeoplesDataSet);
        HashMap<String, Object> compareResultMap = new HashMap<String, Object>(16);
        this.algoxResultDeal(compareResultMap, compareAmountSumDataSet, compareTotalNums, activePeoplesDataSet);
        this.rateDeal(resultMap, compareResultMap);
        TripBoardsUtil.formatDecimal(resultMap);
        this.setDataResult(resultMap);
    }

    private static DataSetX getAmountSumDataSetX(DataSetX allDataSetX) {
        return allDataSetX.sum(TOTAL_AMOUNT_KEY).sum(SERVICE_FEE_KEY).sum(REFUND_AMOUNT_KEY);
    }

    private static DataSetX getNumsSet(DataSetX dataSetX) {
        return dataSetX.filter("ordertype in ('O','G')").count(ID_KEY);
    }

    private static DataSetX getActivePeoples(DataSetX allDataSetX) {
        return allDataSetX.select(new String[]{PASSENGER_KEY}).distinct(new String[]{PASSENGER_KEY}).count(PASSENGER_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void algoxResultDeal(Map<String, Object> resultMap, DataSet amountSumDataSetX, DataSet numsSet, DataSet activePeoples) {
        try {
            Iterator iterator = amountSumDataSetX.iterator();
            int orderNums = 0;
            for (Object row : numsSet) {
                orderNums = row.getInteger(ID_KEY);
            }
            int activePeople = 0;
            if (activePeoples.hasNext()) {
                for (Row people : activePeoples) {
                    activePeople = people.getInteger(PASSENGER_KEY);
                }
            }
            while (iterator.hasNext()) {
                Object row;
                row = (Row)iterator.next();
                this.getResultMap(resultMap, row.getDouble(TOTAL_AMOUNT_KEY), Long.parseLong(String.valueOf(orderNums)), Long.parseLong(String.valueOf(activePeople)), row.getDouble(REFUND_AMOUNT_KEY), row.getDouble(SERVICE_FEE_KEY));
                TrainDataProcessHandle.putOriginValueMap(resultMap, row.getDouble(TOTAL_AMOUNT_KEY), Long.parseLong(String.valueOf(orderNums)), Long.parseLong(String.valueOf(activePeople)), row.getDouble(REFUND_AMOUNT_KEY), row.getDouble(SERVICE_FEE_KEY));
            }
        }
        finally {
            amountSumDataSetX.close();
            numsSet.close();
            activePeoples.close();
        }
    }

    static {
        DEFAULT_MAP_TRAIN.put("t_active_people", 0);
        DEFAULT_MAP_TRAIN.put("t_month_arrow", "-");
        DEFAULT_MAP_TRAIN.put("t_month_amount", "-");
        DEFAULT_MAP_TRAIN.put("t_month_rate", "-");
        DEFAULT_MAP_TRAIN.put("t_order_nums", "-");
        DEFAULT_MAP_TRAIN.put("t_ordernums_arrow", "-");
        DEFAULT_MAP_TRAIN.put("t_ordernums_rate", "-");
        DEFAULT_MAP_TRAIN.put("t_refund_arrow", "-");
        DEFAULT_MAP_TRAIN.put("t_refund_rate", "-");
        DEFAULT_MAP_TRAIN.put("t_refund_fee", "-");
        DEFAULT_MAP_TRAIN.put("t_service_arrow", "-");
        DEFAULT_MAP_TRAIN.put("t_service_fee", "-");
        DEFAULT_MAP_TRAIN.put("t_service_rate", "-");
    }
}

