/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.financeindex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.er.formplugin.web.tripboards.dataprocesshandle.DataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.manager.CacheManager;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;
import org.apache.commons.lang3.StringUtils;

public class TripExpenseSpreadDataProcessHandle
extends DataProcessHandle {
    private static final Log logger = LogFactory.getLog(TripExpenseSpreadDataProcessHandle.class);
    private final String[] ITEM_NAMES = new String[]{ResManager.loadKDString((String)"\u673a\u7968", (String)"ErMessageServiceHelper_10", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u9152\u5e97", (String)"ErMessageServiceHelper_12", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u7528\u8f66", (String)"ErMessageServiceHelper_11", (String)"fi-er-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u706b\u8f66", (String)"ErMessageServiceHelper_13", (String)"fi-er-business", (Object[])new Object[0])};
    private static final String[] ITEM_KEYS = new String[]{"plane", "hotel", "vehicle", "train"};
    private static final String[] ITEM_COLORS = new String[]{"#1890FF", "#6682F5", "#45DAD1", "#FAC53E"};

    public TripExpenseSpreadDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.FALSE);
    }

    @Override
    public Object dataFilter(Object data) {
        return null;
    }

    @Override
    public void dataHandle(Object data) {
        JSONObject dataJson;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        String cachePrefix = RequestContext.get().getCurrUserId() + "";
        String planeResult = CacheManager.getSimpleDataCache(cachePrefix + "_TRIP_FINANCE_RESULT_PLANE", String.class);
        String hotelResult = CacheManager.getSimpleDataCache(cachePrefix + "_TRIP_FINANCE_RESULT_HOTEL", String.class);
        String trainResult = CacheManager.getSimpleDataCache(cachePrefix + "_TRIP_FINANCE_RESULT_TRAIN", String.class);
        String vehicleResult = CacheManager.getSimpleDataCache(cachePrefix + "_TRIP_FINANCE_RESULT_VEHICLE", String.class);
        String planeAmountStr = "";
        String hotelAmountStr = "";
        String trainAmountStr = "";
        String vehicleAmountStr = "";
        if (StringUtils.isNotEmpty((CharSequence)planeResult)) {
            JSONObject planeJson = JSONObject.parseObject((String)planeResult);
            dataJson = planeJson.getJSONObject("origin");
            String string = planeAmountStr = dataJson == null ? "-" : dataJson.getString("p_month_amount");
        }
        if (StringUtils.isNotEmpty((CharSequence)hotelResult)) {
            JSONObject hotelJson = JSONObject.parseObject((String)hotelResult);
            dataJson = hotelJson.getJSONObject("origin");
            String string = hotelAmountStr = dataJson == null ? "-" : dataJson.getString("h_month_amount");
        }
        if (StringUtils.isNotEmpty((CharSequence)trainResult)) {
            JSONObject trainJson = JSONObject.parseObject((String)trainResult);
            dataJson = trainJson.getJSONObject("origin");
            String string = trainAmountStr = dataJson == null ? "-" : dataJson.getString("t_month_amount");
        }
        if (StringUtils.isNotEmpty((CharSequence)vehicleResult)) {
            JSONObject vehicleJson = JSONObject.parseObject((String)vehicleResult);
            vehicleAmountStr = vehicleJson.getString("originValue");
        }
        if ("-".equals(planeAmountStr) && "-".equals(hotelAmountStr) && "-".equals(trainAmountStr) && "-".equals(vehicleAmountStr)) {
            returnMap.put("seriesData", new HashMap());
            this.setDataResult(returnMap);
            return;
        }
        BigDecimal planeAmount = StringUtils.equals((CharSequence)"-", (CharSequence)planeAmountStr) || StringUtils.isEmpty((CharSequence)planeAmountStr) ? BigDecimal.ZERO : TripBoardsUtil.digitalProcess(new BigDecimal(planeAmountStr));
        BigDecimal hotelAmount = StringUtils.equals((CharSequence)"-", (CharSequence)hotelAmountStr) || StringUtils.isEmpty((CharSequence)hotelAmountStr) ? BigDecimal.ZERO : TripBoardsUtil.digitalProcess(new BigDecimal(hotelAmountStr));
        BigDecimal trainAmount = StringUtils.equals((CharSequence)"-", (CharSequence)trainAmountStr) || StringUtils.isEmpty((CharSequence)trainAmountStr) ? BigDecimal.ZERO : TripBoardsUtil.digitalProcess(new BigDecimal(trainAmountStr));
        BigDecimal vehicleAmount = StringUtils.equals((CharSequence)"-", (CharSequence)vehicleAmountStr) || StringUtils.isEmpty((CharSequence)vehicleAmountStr) ? BigDecimal.ZERO : TripBoardsUtil.digitalProcess(new BigDecimal(vehicleAmountStr));
        HashSet amountUnitSet = Sets.newHashSetWithExpectedSize((int)16);
        for (int i = 0; i < ITEM_KEYS.length; ++i) {
            String itemKey = ITEM_KEYS[i];
            BigDecimal amount = this.getItemAmount(itemKey, planeAmount, hotelAmount, trainAmount, vehicleAmount);
            String amountUnit = TripBoardsUtil.getAmountUnit(amount);
            amountUnitSet.add(amountUnit);
        }
        JSONArray dataArray = new JSONArray();
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (int i = 0; i < this.ITEM_NAMES.length; ++i) {
            String itemName = this.ITEM_NAMES[i];
            String itemKey = ITEM_KEYS[i];
            String itemColor = ITEM_COLORS[i];
            BigDecimal amount = this.getItemAmount(itemKey, planeAmount, hotelAmount, trainAmount, vehicleAmount);
            JSONObject itemJson = new JSONObject();
            JSONObject itemItemJson = new JSONObject();
            itemItemJson.put("color", (Object)itemColor);
            itemJson.put("name", (Object)itemName);
            BigDecimal bigDecimal = amount == null ? BigDecimal.ZERO : (amountUnitSet.size() == 1 ? TripBoardsUtil.numberFormatter(amount) : amount);
            itemJson.put("value", (Object)bigDecimal);
            itemJson.put("itemStyle", (Object)itemItemJson);
            dataArray.add((Object)itemJson);
            if (bigDecimal == null || totalAmount == null) continue;
            totalAmount = totalAmount.add(bigDecimal);
        }
        String title = ResManager.loadKDString((String)"\u5546\u65c5\u8d39\u7528\u5206\u5e03\uff08\u5143\uff09", (String)"TripBoard_11", (String)"fi-er-business", (Object[])new Object[0]);
        String tenThousandTitle = ResManager.loadKDString((String)"\u5546\u65c5\u8d39\u7528\u5206\u5e03\uff08\u4e07\u5143\uff09", (String)"TripBoard_11_1", (String)"fi-er-business", (Object[])new Object[0]);
        ArrayList amountUnitList = new ArrayList(amountUnitSet);
        returnMap.put("seriesData", dataArray);
        returnMap.put("centerText", TripBoardsUtil.formatDecimal(totalAmount));
        returnMap.put("trip_expense_title", amountUnitSet.size() == 1 ? ("tenThousand".equals(amountUnitList.get(0)) ? tenThousandTitle : title) : title);
        this.setDataResult(returnMap);
    }

    @Override
    public String getCacheKey() {
        return RequestContext.get().getCurrUserId() + "_TRIP_FINANCE_travelexpense_pie";
    }

    @Override
    public Boolean isNeedDB() {
        return Boolean.FALSE;
    }

    private BigDecimal getItemAmount(String itemKey, BigDecimal planeAmount, BigDecimal hotelAmount, BigDecimal trainAmount, BigDecimal vehicleAmount) {
        switch (itemKey) {
            case "plane": {
                return planeAmount;
            }
            case "train": {
                return trainAmount;
            }
            case "hotel": {
                return hotelAmount;
            }
            case "vehicle": {
                return vehicleAmount;
            }
        }
        return BigDecimal.ZERO;
    }
}

