/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.financeindex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.FourTuple;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.er.business.trip.task.tripboards.OrderSummaryTask;
import kd.fi.er.business.trip.util.TripCityUtil;
import kd.fi.er.formplugin.web.tripboards.dataprocesshandle.TripOrderDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.model.Indicator;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class TripTravelDataProcessHandle
extends TripOrderDataProcessHandle {
    private static final Log logger = LogFactory.getLog(TripTravelDataProcessHandle.class);
    static Map<String, Object> DEFAULT_MAP_MAP = new HashMap<String, Object>(16);
    private static final String SOURCE_TRAVELER_ID_KEY = "sourcetravelerid";
    private static final String PASSENGER_KEY = "passeger";
    private static final String HOTEL_CITY_KEY = "cityname";
    private static final String TRAIN_CITY_KEY = "arrivecity";
    private static final String PLANE_CITY_KEY = "tocityname";
    private static final String TOTAL_AMOUNT_KEY = "totalamount";
    private static final String PLANE_FROM_CITY_KEY = "fromcityname";
    private static final String SUMMARY_ACTIVE_PEOPLE_KEY = "summaryactivepeople";
    private static final String SUMMARY_AMOUNT_KEY = "summaryamount";
    private static final String SUMMARY_ROUTES_KEY = "routes";
    private static final String SUMMARY_ORDERNUMS_KEY = "ordernums";
    private static final String SUMMARY_CITYNAME_KEY = "cityname";
    private static final String[] KEYS = new String[]{"_TRIP_FINANCE_DATA_PLANE", "_TRIP_FINANCE_DATA_HOTEL", "_TRIP_FINANCE_DATA_TRAIN"};

    public TripTravelDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        DEFAULT_MAP_MAP.put("j_people_numbers", 0);
        DEFAULT_MAP_MAP.put("j_city_numbers", 0);
        HashMap<String, JSONArray> propsData = new HashMap<String, JSONArray>(16);
        propsData.put("mapData", new JSONArray());
        propsData.put("lineData", new JSONArray());
        DEFAULT_MAP_MAP.put("returnData", propsData);
    }

    public TripTravelDataProcessHandle() {
        DEFAULT_MAP_MAP.put("j_people_numbers", 0);
        DEFAULT_MAP_MAP.put("j_city_numbers", 0);
        HashMap<String, JSONArray> propsData = new HashMap<String, JSONArray>(16);
        propsData.put("mapData", new JSONArray());
        propsData.put("lineData", new JSONArray());
        DEFAULT_MAP_MAP.put("returnData", propsData);
    }

    @Override
    public Object queryData(RequestContext context) {
        Map<String, Object> param = this.getParam();
        LocalDate localBeginDate = (LocalDate)param.get("beginDate");
        LocalDate localEndDate = (LocalDate)param.get("endDate");
        long between = ChronoUnit.MONTHS.between(localBeginDate, localEndDate) + 1L;
        param.remove("isReal");
        long orgId = Long.parseLong(param.get("rootOrg").toString());
        if (orgId == OrgUnitServiceHelper.getRootOrgId() && between > 10L) {
            List<OrderSummaryTask.DateRange> pairs = TripBoardsUtil.getMonthlyDateRanges(localBeginDate, localEndDate);
            List<LocalDate> overlapDates = TripTravelDataProcessHandle.getOverlapDates(localBeginDate, localEndDate);
            List<DynamicObject> currentData = this.getCurrentAlgox(context, pairs);
            List<DynamicObject> compareData = this.getCompareAlgox(context, pairs, overlapDates);
            this.combineData(overlapDates, currentData, compareData);
            HashMap<String, List<DynamicObject>> result = new HashMap<String, List<DynamicObject>>(4);
            result.put("current", currentData);
            result.put("compare", compareData);
            return result;
        }
        return super.queryData(context);
    }

    @Override
    public Object dataFilter(Object data) {
        return super.dataFilter(data);
    }

    @Override
    public void dataHandle(Object data) {
        this.endProcessData(data, Boolean.TRUE);
    }

    private static Object dealPopularRoutesData(List<FourTuple<String, Integer, BigDecimal, BigDecimal>> lineList, List<ThreeTuple<String, String, String>> latAndLon) {
        JSONArray flightRoutes = new JSONArray();
        HashMap<String, String[]> geoCoordMap = new HashMap<String, String[]>(16);
        JSONArray cityArray = new JSONArray();
        int rankIndex = 1;
        for (FourTuple<String, Integer, BigDecimal, BigDecimal> fourTuple : lineList) {
            String toName;
            JSONArray fromAndToData = new JSONArray();
            JSONObject json = new JSONObject();
            String routeKey = (String)fourTuple.item1;
            JSONObject cityJson = new JSONObject();
            cityJson.put("name", fourTuple.item1);
            cityJson.put("city", fourTuple.item1);
            cityJson.put("orders", fourTuple.item2);
            cityJson.put("percentage", (Object)(((BigDecimal)fourTuple.item3).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP) + "%"));
            cityJson.put("amount", fourTuple.item4);
            if (rankIndex == 1) {
                cityJson.put("className", (Object)"gold");
                cityJson.put("rank", (Object)"");
            } else if (rankIndex == 2) {
                cityJson.put("className", (Object)"silver");
                cityJson.put("rank", (Object)"");
            } else if (rankIndex == 3) {
                cityJson.put("className", (Object)"bronze");
                cityJson.put("rank", (Object)"");
            } else {
                cityJson.put("rank", (Object)rankIndex);
            }
            ++rankIndex;
            cityArray.add((Object)cityJson);
            String[] fromAndToArr = routeKey.split("-");
            String fromName = fromAndToArr[0];
            if (TripTravelDataProcessHandle.ifContinue(latAndLon, fromName, geoCoordMap) || TripTravelDataProcessHandle.ifContinue(latAndLon, toName = fromAndToArr[1], geoCoordMap)) continue;
            json.put("name", (Object)fromName);
            JSONObject toJson = new JSONObject();
            toJson.put("name", (Object)toName);
            toJson.put("value", fourTuple.item2);
            fromAndToData.add((Object)json);
            fromAndToData.add((Object)toJson);
            flightRoutes.add((Object)fromAndToData);
        }
        JSONObject returnData = new JSONObject();
        returnData.put(SUMMARY_ROUTES_KEY, (Object)flightRoutes);
        returnData.put("geoCoord", geoCoordMap);
        returnData.put("tableCityData", (Object)cityArray);
        return returnData;
    }

    private static boolean ifContinue(List<ThreeTuple<String, String, String>> latAndLon, String cityName, Map<String, String[]> geoCoordMap) {
        Optional<ThreeTuple> any = latAndLon.parallelStream().filter(obj -> {
            String lonAndLatCityName = TripCityUtil.judgeCityName((String)obj.item1);
            String orderCityName = TripCityUtil.judgeCityName(cityName);
            return lonAndLatCityName.equalsIgnoreCase(orderCityName);
        }).findAny();
        if (!any.isPresent()) {
            return true;
        }
        ThreeTuple tuple = any.get();
        String[] geoCoord = new String[]{(String)tuple.item2, (String)tuple.item3};
        geoCoordMap.put(cityName, geoCoord);
        return false;
    }

    private static JSONArray dealTravelOverViewData(List<FourTuple<String, Integer, BigDecimal, BigDecimal>> travelList, List<ThreeTuple<String, String, String>> latAndLon) {
        JSONArray dataArray = new JSONArray();
        int rankIndex = 1;
        for (FourTuple<String, Integer, BigDecimal, BigDecimal> fourTuple : travelList) {
            JSONObject json = new JSONObject();
            json.put("name", fourTuple.item1);
            json.put("city", fourTuple.item1);
            json.put("orders", fourTuple.item2);
            json.put("percentage", (Object)(((BigDecimal)fourTuple.item3).multiply(new BigDecimal(100)).setScale(2, RoundingMode.HALF_UP) + "%"));
            json.put("amount", fourTuple.item4);
            json.put("value", (Object)new Object[3]);
            if (rankIndex == 1) {
                json.put("className", (Object)"gold");
                json.put("rank", (Object)"");
            } else if (rankIndex == 2) {
                json.put("className", (Object)"silver");
                json.put("rank", (Object)"");
            } else if (rankIndex == 3) {
                json.put("className", (Object)"bronze");
                json.put("rank", (Object)"");
            } else {
                json.put("rank", (Object)rankIndex);
            }
            ++rankIndex;
            Optional<ThreeTuple> any = latAndLon.parallelStream().filter(obj -> {
                String lonAndLatCityName = TripCityUtil.judgeCityName((String)obj.item1);
                String orderCityName = TripCityUtil.judgeCityName((String)fourTuple.item1);
                return lonAndLatCityName.equalsIgnoreCase(orderCityName);
            }).findAny();
            if (!any.isPresent()) {
                dataArray.add((Object)json);
                logger.info("\u672a\u5339\u914d\u4e0a\u7ecf\u7eac\u5ea6:{}", (Object)((String)fourTuple.item1).toLowerCase());
                continue;
            }
            ThreeTuple tuple = any.get();
            Object[] coordinateAndData = new Object[]{tuple.item2, tuple.item3, fourTuple.item2};
            json.put("value", (Object)coordinateAndData);
            dataArray.add((Object)json);
        }
        return dataArray;
    }

    private void processData(Map<String, Object> resultMap, List<FourTuple<String, Integer, BigDecimal, BigDecimal>> returnDataList, String suffix) {
        Map travelTopCityAndCounts = (Map)resultMap.get("topCities" + suffix);
        Map travelTopCityAndAmounts = (Map)resultMap.get("topCitiesAmount" + suffix);
        Integer travelTotalOrderCount = (Integer)resultMap.get("totalOrderCount" + suffix);
        for (Map.Entry entry : travelTopCityAndCounts.entrySet()) {
            String cityName = (String)entry.getKey();
            Integer orderNums = (Integer)entry.getValue();
            BigDecimal monthAmount = (BigDecimal)travelTopCityAndAmounts.get(cityName);
            BigDecimal rate = BigDecimal.ZERO;
            if (travelTotalOrderCount != 0) {
                rate = new BigDecimal(orderNums).divide(new BigDecimal(travelTotalOrderCount), 4, RoundingMode.HALF_UP);
            }
            FourTuple fourTuple = new FourTuple((Object)cityName, (Object)orderNums, (Object)rate, (Object)TripBoardsUtil.digitalProcess(monthAmount));
            returnDataList.add((FourTuple<String, Integer, BigDecimal, BigDecimal>)fourTuple);
        }
    }

    @Override
    public void rateDeal(Map<String, Object> resultMap, Map<String, Object> compareResultMap) {
        INDICATORS = new HashMap(16);
        INDICATORS.put("j_people_numbers", new Indicator("j_people_numbers", "j_people_numbers", "j_peoplenums_arrow", "j_peoplenums_rate"));
        INDICATORS.put("j_city_numbers", new Indicator("j_city_numbers", "j_city_numbers", "j_city_arrow", "j_city_rate"));
        super.rateDeal(resultMap, compareResultMap);
    }

    public void dataDeal(Map<String, Object> handleData, Map<String, Object> resultMap, String suffix, Boolean isSummary) {
        long totalUserCount = 0L;
        long totalCityCount = 0L;
        HashMap<String, Integer> cityCountMap = new HashMap<String, Integer>(16);
        HashMap<String, BigDecimal> totalAmountCountMap = new HashMap<String, BigDecimal>(16);
        HashMap<String, BigDecimal> flightTotalAmountCountMap = new HashMap<String, BigDecimal>(16);
        LinkedHashMap<String, Integer> flightCountMap = new LinkedHashMap<String, Integer>(16);
        long currUserId = RequestContext.get().getCurrUserId();
        int countUserIndex = 0;
        HashSet userIds = new HashSet();
        for (String key : KEYS) {
            String fullKey = currUserId + key + suffix;
            Object dataObj = handleData.get(fullKey);
            if (dataObj != null) {
                String cityKey;
                List<DynamicObject> dataList = (List<DynamicObject>)dataObj;
                ArrayList<DynamicObject> lineList = new ArrayList();
                if (isSummary.booleanValue()) {
                    lineList = dataList.stream().filter(obj -> "Route".equals(obj.getString("datatype"))).collect(Collectors.toList());
                    dataList = dataList.stream().filter(obj -> "City".equals(obj.getString("datatype"))).collect(Collectors.toList());
                }
                String travelerKey = this.getTravelerKey(key);
                String string = cityKey = isSummary == false ? this.getCityKey(key) : "cityname";
                if (!isSummary.booleanValue()) {
                    userIds.addAll(dataList.stream().map(obj -> obj.getLong(travelerKey)).collect(Collectors.toSet()));
                    if (countUserIndex == KEYS.length - 1) {
                        totalUserCount += (long)userIds.size();
                    }
                } else if (countUserIndex == KEYS.length - 1) {
                    Map<String, Optional<DynamicObject>> orgActivePeople = dataList.parallelStream().collect(Collectors.groupingBy(obj -> obj.getString("orgId"), Collectors.maxBy(Comparator.comparingInt(obj -> obj.getInt(SUMMARY_ACTIVE_PEOPLE_KEY)))));
                    for (Map.Entry<String, Optional<DynamicObject>> entry : orgActivePeople.entrySet()) {
                        Optional<DynamicObject> value = entry.getValue();
                        if (!value.isPresent()) continue;
                        DynamicObject dynamicObject = value.get();
                        totalUserCount = Long.sum(Long.parseLong(dynamicObject.getString(SUMMARY_ACTIVE_PEOPLE_KEY)), totalUserCount);
                    }
                }
                totalCityCount += this.countUnique(dataList, cityKey);
                if (!fullKey.endsWith("_compare")) {
                    this.updateCityCounts(cityCountMap, dataList, cityKey);
                    this.updateTotalAmounts(totalAmountCountMap, dataList, cityKey, isSummary == false ? TOTAL_AMOUNT_KEY : SUMMARY_AMOUNT_KEY);
                    String planeDataCacheKey = currUserId + "_TRIP_FINANCE_DATA_PLANE";
                    if (fullKey.equals(planeDataCacheKey)) {
                        this.updateFlightCounts(flightCountMap, lineList, isSummary);
                        this.updateFlightTotalAmounts(flightTotalAmountCountMap, lineList, isSummary);
                    }
                }
            }
            ++countUserIndex;
        }
        if (StringUtils.isEmpty((String)suffix)) {
            this.addTopCities(resultMap, cityCountMap, totalAmountCountMap, "");
            this.addTopCities(resultMap, flightCountMap, flightTotalAmountCountMap, "line");
        }
        this.addTotalCounts(resultMap, cityCountMap, flightCountMap);
        resultMap.put("j_people_numbers", totalUserCount);
        resultMap.put("j_city_numbers", totalCityCount);
    }

    private String getTravelerKey(String key) {
        return key.equals(RequestContext.get().getCurrUserId() + "_TRIP_FINANCE_DATA_TRAIN") ? PASSENGER_KEY : SOURCE_TRAVELER_ID_KEY;
    }

    private String getCityKey(String key) {
        String cachePrefix = RequestContext.get().getCurrUserId() + "";
        if (key.equals(cachePrefix + "_TRIP_FINANCE_DATA_HOTEL")) {
            return "cityname";
        }
        if (key.equals(cachePrefix + "_TRIP_FINANCE_DATA_PLANE")) {
            return PLANE_CITY_KEY;
        }
        return TRAIN_CITY_KEY;
    }

    private long countUnique(List<DynamicObject> dataList, String key) {
        return dataList.parallelStream().filter(obj -> obj.get(key) != null).map(obj -> obj.get(key).toString()).distinct().count();
    }

    private void updateCityCounts(Map<String, Integer> cityCountMap, List<DynamicObject> dataList, String cityKey) {
        dataList.parallelStream().collect(Collectors.groupingBy(obj -> obj.getString(cityKey))).forEach((city, list) -> cityCountMap.merge((String)city, list.size(), Integer::sum));
    }

    private void updateTotalAmounts(Map<String, BigDecimal> totalAmountCountMap, List<DynamicObject> dataList, String cityKey, String amountKey) {
        dataList.parallelStream().filter(obj -> obj.get(amountKey) != null).collect(Collectors.groupingBy(obj -> obj.getString(cityKey))).forEach((city, list) -> {
            double sum = list.parallelStream().mapToDouble(obj -> obj.getBigDecimal(amountKey).doubleValue()).sum();
            totalAmountCountMap.merge((String)city, BigDecimal.valueOf(sum), BigDecimal::add);
        });
    }

    private void updateFlightTotalAmounts(Map<String, BigDecimal> totalAmountCountMap, List<DynamicObject> dataList, Boolean isSummary) {
        dataList.parallelStream().filter(obj -> obj.get(isSummary == false ? TOTAL_AMOUNT_KEY : SUMMARY_AMOUNT_KEY) != null).collect(Collectors.groupingBy(flight -> isSummary == false ? flight.getString(PLANE_FROM_CITY_KEY) + "-" + flight.getString(PLANE_CITY_KEY) : flight.getString(SUMMARY_ROUTES_KEY))).forEach((city, list) -> {
            double sum = list.parallelStream().mapToDouble(obj -> obj.getBigDecimal(isSummary == false ? TOTAL_AMOUNT_KEY : SUMMARY_AMOUNT_KEY).doubleValue()).sum();
            totalAmountCountMap.merge((String)city, BigDecimal.valueOf(sum), BigDecimal::add);
        });
    }

    private void updateFlightCounts(Map<String, Integer> flightCountMap, List<DynamicObject> dataList, Boolean isSummary) {
        dataList.parallelStream().collect(Collectors.groupingBy(flight -> isSummary == false ? flight.getString(PLANE_FROM_CITY_KEY) + "-" + flight.getString(PLANE_CITY_KEY) : flight.getString(SUMMARY_ROUTES_KEY))).forEach((route, list) -> flightCountMap.merge((String)route, list.size(), Integer::sum));
    }

    private void addTopCities(Map<String, Object> resultMap, Map<String, Integer> cityCountMap, Map<String, BigDecimal> totalAmountCountMap, String line) {
        Map topCitiesMap = cityCountMap.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).limit(10L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum, LinkedHashMap::new));
        resultMap.put("topCities" + line, topCitiesMap);
        Map<String, BigDecimal> topCitiesAmount = topCitiesMap.keySet().stream().collect(Collectors.toMap(city -> city, city -> totalAmountCountMap.getOrDefault(city, BigDecimal.ZERO), BigDecimal::add));
        resultMap.put("topCitiesAmount" + line, topCitiesAmount);
    }

    private void addTotalCounts(Map<String, Object> resultMap, Map<String, Integer> cityCountMap, Map<String, Integer> flightCountMap) {
        int totalOrderCount = cityCountMap.values().stream().mapToInt(Integer::intValue).sum();
        int totalFlightCount = flightCountMap.values().stream().mapToInt(Integer::intValue).sum();
        resultMap.put("totalOrderCount", totalOrderCount);
        resultMap.put("totalOrderCountline", totalFlightCount);
    }

    @Override
    public Boolean isNeedDB() {
        return Boolean.TRUE;
    }

    @Override
    public String getFormId() {
        return "er_city_routes_summary";
    }

    @Override
    public String getSelectProps() {
        return "id,orgid,summarystart,summaryend,datatype,cityjson_tag";
    }

    @Override
    public QFilter[] getFilters(Map<String, Object> filterMap) {
        Set orgIds = (Set)filterMap.get("orgIds");
        LocalDate beginDate = (LocalDate)filterMap.get("beginDate");
        LocalDate endDate = (LocalDate)filterMap.get("endDate");
        QFilter startFilter = new QFilter("summarystart", "=", (Object)beginDate);
        QFilter endFilter = new QFilter("summaryend", "=", (Object)endDate);
        QFilter current = startFilter.and(endFilter);
        if (orgIds.size() <= 500) {
            this.setOrgFilter(Boolean.TRUE);
            current.and(new QFilter("orgid", "in", orgIds.stream().filter(Objects::nonNull).map(String::valueOf).collect(Collectors.toList())));
        }
        return new QFilter[]{current};
    }

    private void endProcessData(Object data, Boolean isSummary) {
        if (data == null) {
            logger.info("data is null");
            return;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap compareResultMap = Maps.newHashMapWithExpectedSize((int)16);
        List latAndLon = (List)this.getParam().get("latAndLon");
        List<FourTuple<String, Integer, BigDecimal, BigDecimal>> travelList = new ArrayList<FourTuple<String, Integer, BigDecimal, BigDecimal>>(8);
        List<FourTuple<String, Integer, BigDecimal, BigDecimal>> lineList = new ArrayList<FourTuple<String, Integer, BigDecimal, BigDecimal>>(8);
        Map handleData = (Map)data;
        if (handleData.isEmpty()) {
            logger.info("handleData is null");
            return;
        }
        if (isSummary.booleanValue()) {
            List mapData = (List)handleData.get("current");
            List compareMapData = (List)handleData.get("compare");
            List<DynamicObject> routeData = mapData.parallelStream().filter(obj -> "Route".equals(obj.getString("datatype"))).collect(Collectors.toList());
            LinkedList<DynamicObject> linkedList = new LinkedList<DynamicObject>(mapData);
            HashSet smallSet = new HashSet(routeData);
            linkedList.removeIf(smallSet::contains);
            lineList = TripTravelDataProcessHandle.dealSummaryLineAndCity(routeData, SUMMARY_ROUTES_KEY);
            travelList = TripTravelDataProcessHandle.dealSummaryLineAndCity(linkedList, "cityname");
            this.dealSummaryCityAndPeople(resultMap, mapData);
            this.dealSummaryCityAndPeople(compareResultMap, compareMapData);
            this.rateDeal(resultMap, compareResultMap);
        } else {
            this.dataDeal(handleData, resultMap, "", isSummary);
            this.dataDeal(handleData, compareResultMap, "_compare", isSummary);
            this.rateDeal(resultMap, compareResultMap);
            this.processData(resultMap, travelList, "");
            this.processData(resultMap, lineList, "line");
        }
        HashMap<String, Object> propsData = new HashMap<String, Object>(16);
        propsData.put("mapData", TripTravelDataProcessHandle.dealTravelOverViewData(travelList, latAndLon));
        propsData.put("lineData", TripTravelDataProcessHandle.dealPopularRoutesData(lineList, latAndLon));
        resultMap.put("returnData", propsData);
        this.setDataResult(resultMap);
    }

    private void dealSummaryCityAndPeople(Map<String, Object> resultMap, List<DynamicObject> data) {
        ConcurrentHashMap.KeySetView travelUserSet = ConcurrentHashMap.newKeySet();
        ConcurrentHashMap.KeySetView cityNameSet = ConcurrentHashMap.newKeySet();
        data.parallelStream().forEach(datum -> {
            String routeTag = datum.getString("cityjson_tag");
            JSONArray array = JSONArray.parseArray((String)routeTag);
            for (Object o : array) {
                JSONObject obj = (JSONObject)o;
                JSONArray traveluser = obj.getJSONArray("traveluser");
                traveluser.forEach(userId -> travelUserSet.add(Long.parseLong(userId.toString())));
                cityNameSet.add(obj.getString("cityname"));
            }
        });
        resultMap.put("j_people_numbers", travelUserSet.size());
        resultMap.put("j_city_numbers", cityNameSet.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FourTuple<String, Integer, BigDecimal, BigDecimal>> dealSummaryLineAndCity(List<DynamicObject> data, String key) {
        Set entries;
        if (data.isEmpty()) {
            return new ArrayList<FourTuple<String, Integer, BigDecimal, BigDecimal>>();
        }
        LinkedHashMap routeMap = new LinkedHashMap();
        AtomicInteger totalOrders = new AtomicInteger();
        int cpuSize = Runtime.getRuntime().availableProcessors() * 2;
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(cpuSize);
        List<List<DynamicObject>> partitions = TripTravelDataProcessHandle.partitionList(data, cpuSize);
        CountDownLatch count = new CountDownLatch(partitions.size());
        partitions.forEach(partition -> executor.submit(() -> {
            try {
                partition.forEach(routeDatum -> {
                    String routeTag = routeDatum.getString("cityjson_tag");
                    JSONArray routeArray = JSONArray.parseArray((String)routeTag);
                    routeArray.forEach(o -> {
                        JSONObject obj = (JSONObject)o;
                        int orderNums = obj.getInteger(SUMMARY_ORDERNUMS_KEY);
                        BigDecimal amount = new BigDecimal(obj.getString(SUMMARY_AMOUNT_KEY));
                        totalOrders.addAndGet(orderNums);
                        routeMap.merge(obj.getString(key), new Tuple((Object)orderNums, (Object)amount), (existing, newEntry) -> {
                            BigDecimal newAmount = ((BigDecimal)existing.item2).add((BigDecimal)newEntry.item2);
                            return new Tuple((Object)((Integer)existing.item1 + (Integer)newEntry.item1), (Object)newAmount);
                        });
                    });
                });
            }
            finally {
                count.countDown();
            }
        }));
        try {
            boolean complete = count.await(20L, TimeUnit.SECONDS);
            if (!complete) {
                logger.info("time out map");
            }
        }
        catch (Exception ex) {
            logger.error("count  await\u62a5\u9519", (Throwable)ex);
        }
        executor.shutdown();
        PriorityQueue<Map.Entry> topN = new PriorityQueue<Map.Entry>(Comparator.comparing(entry -> (Integer)((Tuple)entry.getValue()).item1));
        Set set = entries = routeMap.entrySet();
        synchronized (set) {
            for (Map.Entry entry3 : entries) {
                topN.offer(entry3);
                if (topN.size() <= 10) continue;
                topN.poll();
            }
        }
        ArrayList<Map.Entry> rankData = new ArrayList<Map.Entry>(topN);
        rankData.sort((entry1, entry2) -> ((Integer)((Tuple)entry2.getValue()).item1).compareTo((Integer)((Tuple)entry1.getValue()).item1));
        ArrayList tupleList = Lists.newArrayListWithCapacity((int)16);
        for (Map.Entry rankDatum : rankData) {
            String lineName = (String)rankDatum.getKey();
            Tuple tuple = (Tuple)rankDatum.getValue();
            BigDecimal rate = BigDecimal.ZERO;
            if (totalOrders.get() > 0) {
                rate = new BigDecimal((Integer)tuple.item1).divide(new BigDecimal(totalOrders.get()), 4, RoundingMode.HALF_UP);
            }
            tupleList.add(new FourTuple((Object)lineName, tuple.item1, (Object)rate, (Object)TripBoardsUtil.digitalProcess(tuple.item2)));
        }
        return tupleList;
    }

    private static List<List<DynamicObject>> partitionList(List<DynamicObject> list, int partitionSize) {
        return LongStream.range(0L, (list.size() + partitionSize - 1) / partitionSize).mapToObj(i -> list.subList((int)(i * (long)partitionSize), (int)Math.min((i + 1L) * (long)partitionSize, (long)list.size()))).collect(Collectors.toList());
    }

    @Override
    public String getCacheKey() {
        return RequestContext.get().getCurrUserId() + "_TRIP_FINANCE_DATA_MAP";
    }
}

