/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.financeindex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.util.StringUtils;
import kd.fi.er.common.CarTypeEnum;
import kd.fi.er.formplugin.web.tripboards.dataprocesshandle.TripOrderDataProcessHandle;
import kd.fi.er.formplugin.web.tripboards.model.Indicator;
import kd.fi.er.formplugin.web.tripboards.utils.TripBoardsUtil;

public class VehicleDataProcessHandle
extends TripOrderDataProcessHandle {
    static Map<String, Object> DEFAULT_MAP_VEHICLE = new HashMap<String, Object>(16);
    static Map<String, String> vehicleTypeAndColorMap;
    private static final String ORDER_STATUS_KEY = "orderstatus";
    private static final String PASSENGER_KEY = "passeger";
    private static final String TOTAL_AMOUNT_KEY = "totalamount";
    private static final String DISTANCE_KEY = "distance";
    private static final String SUMMARY_AMOUNT_KEY = "summaryamount";
    private static final String SUMMARY_AVGMILE_PRICE_KEY = "summaryavmileprice";
    private static final String SUMMARY_ORDERNUM_KEY = "ordernums";
    private static final String SUMMARY_ACTIVE_PEOPLE_KEY = "summaryactivepeople";

    public VehicleDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.TRUE);
        this.setDataResult(DEFAULT_MAP_VEHICLE);
    }

    public VehicleDataProcessHandle() {
        this.setNeedYoY(Boolean.TRUE);
        this.setDataResult(DEFAULT_MAP_VEHICLE);
    }

    @Override
    public QFilter[] getFilters(Map<String, Object> filterMap) {
        return this.getCommonFilters("usetime", "expcommitcomnum", "expcommitdepnum", filterMap);
    }

    @Override
    public String getFormId() {
        if (this.getParam().containsKey("isReal")) {
            return "er_vehiclebill";
        }
        return "er_vehicle_summary";
    }

    @Override
    public String getSelectProps() {
        if (this.getParam().containsKey("isReal")) {
            return "totalamount,servicefee,expcommitcomnum,expcommitdepnum,passeger,vehicletype,orderstatus,distance,usetime";
        }
        return "id,summaryamount,orgid,summarystart,summaryend,summaryactivepeople,ordernums,summaryavmileprice,vehicletype,traveluser_tag,orgtype,otherdatasummary_tag";
    }

    @Override
    public void dataHandle(Object data) {
        if (this.getParam().containsKey("isReal")) {
            this.endDataProcess(data, Boolean.FALSE);
        } else {
            this.endDataProcess(data, Boolean.TRUE);
        }
    }

    public void dataDeal(Map<String, Object> resultMap, List<DynamicObject> handleData, Boolean isSummary) {
        long nums = 0L;
        nums = isSummary == false ? handleData.parallelStream().filter(obj -> !"Canceled".equals(obj.getString(ORDER_STATUS_KEY))).count() : handleData.parallelStream().filter(obj -> obj.get(SUMMARY_ORDERNUM_KEY) != null).mapToLong(obj -> Long.parseLong(obj.get(SUMMARY_ORDERNUM_KEY).toString())).sum();
        long activePeople = 0L;
        if (!isSummary.booleanValue()) {
            activePeople = handleData.parallelStream().filter(obj -> obj.get(PASSENGER_KEY) != null).map(obj -> obj.getLong(PASSENGER_KEY)).distinct().count();
        } else {
            List userIdList = handleData.parallelStream().map(obj -> obj.getString("traveluser_tag")).collect(Collectors.toList());
            HashSet<String> userIdSet = new HashSet<String>();
            for (String userIdStr : userIdList) {
                String[] split = userIdStr.split(",");
                userIdSet.addAll(Arrays.asList(split));
            }
            activePeople = userIdSet.size();
        }
        if (!isSummary.booleanValue()) {
            double sum = handleData.parallelStream().filter(obj -> "Successful".equals(obj.get(ORDER_STATUS_KEY))).mapToDouble(obj -> Double.parseDouble(obj.get(TOTAL_AMOUNT_KEY).toString())).summaryStatistics().getSum();
            double distanceSum = handleData.parallelStream().filter(obj -> "Successful".equals(obj.get(ORDER_STATUS_KEY))).mapToDouble(obj -> Double.parseDouble(obj.get(DISTANCE_KEY).toString())).summaryStatistics().getSum();
            if (sum == 0.0) {
                resultMap.put("v_avmile_price", "-");
            } else {
                BigDecimal totalAmount = BigDecimal.valueOf(sum);
                BigDecimal totalDistance = BigDecimal.valueOf(distanceSum);
                BigDecimal avgMilePrice = totalDistance.divide(totalAmount, 2, RoundingMode.HALF_UP);
                resultMap.put("v_avmile_price", avgMilePrice);
            }
        } else if (nums == 0L) {
            resultMap.put("v_avmile_price", "-");
        } else {
            Set avgMilePriceSet = handleData.parallelStream().filter(obj -> obj.get(SUMMARY_AVGMILE_PRICE_KEY) != null).map(obj -> obj.getBigDecimal(SUMMARY_AVGMILE_PRICE_KEY)).collect(Collectors.toSet());
            BigDecimal averageMilePrice = avgMilePriceSet.isEmpty() ? BigDecimal.ZERO : avgMilePriceSet.stream().reduce(BigDecimal.ZERO, BigDecimal::add).divide(BigDecimal.valueOf(nums), 2, RoundingMode.HALF_UP);
            resultMap.put("v_avmile_price", averageMilePrice);
        }
        resultMap.put("v_order_nums", nums);
        resultMap.put("v_active_people", activePeople);
    }

    @Override
    public void rateDeal(Map<String, Object> resultMap, Map<String, Object> compareResultMap) {
        INDICATORS = new HashMap(4);
        INDICATORS.put("v_avmile_price", new Indicator("v_avmile_price", "v_avmile_price", "v_avmile_arrow", "v_avmile_rate"));
        INDICATORS.put("v_order_nums", new Indicator("v_order_nums", "v_order_nums", "v_ordernums_arrow", "v_ordernums_rate"));
        super.rateDeal(resultMap, compareResultMap);
    }

    @Override
    public String getCacheKey() {
        return RequestContext.get().getCurrUserId() + "_TRIP_FINANCE_DATA_VEHICLE";
    }

    @Override
    protected String getResultKey() {
        return RequestContext.get().getCurrUserId() + "_TRIP_FINANCE_RESULT_VEHICLE";
    }

    private void endDataProcess(Object data, Boolean isSummary) {
        HashMap returnMap = Maps.newHashMapWithExpectedSize((int)4);
        returnMap.put("seriesData", new HashMap());
        returnMap.put("data", DEFAULT_MAP_VEHICLE);
        returnMap.put("centerText", "-");
        returnMap.put("originValue", "-");
        this.setDataResult(returnMap);
        if (data == null) {
            return;
        }
        HashMap resultMap = Maps.newHashMapWithExpectedSize((int)8);
        HashMap compareResultMap = Maps.newHashMapWithExpectedSize((int)8);
        List handleData = (List)((Map)data).get("current");
        List compareHandleData = (List)((Map)data).get("compare");
        if (handleData.isEmpty() && compareHandleData.isEmpty()) {
            return;
        }
        this.dataDeal(resultMap, handleData, isSummary);
        this.dataDeal(compareResultMap, compareHandleData, isSummary);
        this.rateDeal(resultMap, compareResultMap);
        TripBoardsUtil.formatDecimal(resultMap);
        Map<String, List<DynamicObject>> typeData = handleData.parallelStream().filter(obj -> StringUtils.isNotEmpty((String)obj.getString("vehicletype"))).collect(Collectors.groupingBy(obj -> obj.getString("vehicletype")));
        JSONArray jsonArray = new JSONArray();
        BigDecimal total = BigDecimal.ZERO;
        HashSet<String> unitSet = new HashSet<String>(16);
        for (Map.Entry<String, List<DynamicObject>> entry : typeData.entrySet()) {
            double totalamount = 0.0;
            String key = entry.getKey();
            CarTypeEnum vaule = CarTypeEnum.getVaule((String)key);
            if (vaule == null) continue;
            if (isSummary.booleanValue()) {
                HashSet allOrderInfoSet = new HashSet(16);
                List summaryTag = entry.getValue().parallelStream().map(dynamicObject -> dynamicObject.getString("otherdatasummary_tag")).collect(Collectors.toList());
                for (String s : summaryTag) {
                    JSONObject jsonObject = JSONObject.parseObject((String)s);
                    JSONArray orderArray = jsonObject.getJSONArray("orderNumsAndAmount");
                    allOrderInfoSet.addAll(orderArray.stream().map(String::valueOf).collect(Collectors.toSet()));
                }
                for (Object orderInfo : allOrderInfoSet) {
                    String[] info = ((String)orderInfo).split("\\$");
                    int length = info.length;
                    String totalamountStr = length >= 2 ? info[1] : "0";
                    totalamount = Double.sum(totalamount, Double.parseDouble(totalamountStr));
                }
            } else {
                totalamount = TripBoardsUtil.getTotalamount(entry.getValue());
            }
            BigDecimal bigDecimal = TripBoardsUtil.digitalProcess(totalamount);
            String amountUnit = TripBoardsUtil.getAmountUnit(bigDecimal);
            unitSet.add(amountUnit);
        }
        BigDecimal originValue = BigDecimal.ZERO;
        boolean isSingleUnit = unitSet.size() == 1;
        for (Map.Entry<String, List<DynamicObject>> entry : typeData.entrySet()) {
            String vehicleType = entry.getKey();
            double totalamount = 0.0;
            if (isSummary.booleanValue()) {
                HashSet allOrderInfoSet = new HashSet(16);
                List summaryTag = entry.getValue().parallelStream().map(dynamicObject -> dynamicObject.getString("otherdatasummary_tag")).collect(Collectors.toList());
                for (String s : summaryTag) {
                    JSONObject jsonObject = JSONObject.parseObject((String)s);
                    JSONArray orderArray = jsonObject.getJSONArray("orderNumsAndAmount");
                    allOrderInfoSet.addAll(orderArray.stream().map(String::valueOf).collect(Collectors.toSet()));
                }
                for (String orderInfo : allOrderInfoSet) {
                    String[] info = orderInfo.split("\\$");
                    int length = info.length;
                    String totalamountStr = length >= 2 ? info[1] : "0";
                    totalamount = Double.sum(totalamount, Double.parseDouble(totalamountStr));
                }
            } else {
                totalamount = TripBoardsUtil.getTotalamount(entry.getValue());
            }
            originValue = originValue.add(BigDecimal.valueOf(totalamount));
            BigDecimal bigDecimal = TripBoardsUtil.digitalProcess(totalamount);
            CarTypeEnum value = CarTypeEnum.getVaule((String)vehicleType);
            if (value == null) continue;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("name", (Object)value.getValue().loadKDString());
            jsonObject.put("value", (Object)(isSingleUnit ? TripBoardsUtil.numberFormatter(bigDecimal) : bigDecimal));
            JSONObject itemItemJson = new JSONObject();
            itemItemJson.put("color", (Object)vehicleTypeAndColorMap.get(vehicleType));
            jsonObject.put("itemStyle", (Object)itemItemJson);
            jsonArray.add((Object)jsonObject);
            total = total.add(isSingleUnit ? TripBoardsUtil.numberFormatter(bigDecimal) : bigDecimal);
        }
        returnMap.put("centerText", TripBoardsUtil.formatDecimal(total));
        returnMap.put("originValue", originValue);
        returnMap.put("seriesData", jsonArray);
        String title = ResManager.loadKDString((String)"\u7528\u8f66\u8d39\u7528\u7edf\u8ba1\uff08\u5143\uff09", (String)"TripBoard_14", (String)"fi-er-business", (Object[])new Object[0]);
        String tenThousandTitle = ResManager.loadKDString((String)"\u7528\u8f66\u8d39\u7528\u7edf\u8ba1\uff08\u4e07\u5143\uff09", (String)"TripBoard_14_1", (String)"fi-er-business", (Object[])new Object[0]);
        resultMap.put("v_title", isSingleUnit ? ("tenThousand".equals(new ArrayList(unitSet).get(0)) ? tenThousandTitle : title) : title);
        returnMap.put("data", resultMap);
        this.setDataResult(returnMap);
    }

    static {
        DEFAULT_MAP_VEHICLE.put("v_active_people", 0);
        DEFAULT_MAP_VEHICLE.put("v_order_nums", "-");
        DEFAULT_MAP_VEHICLE.put("v_ordernums_arrow", "-");
        DEFAULT_MAP_VEHICLE.put("v_ordernums_rate", "-");
        DEFAULT_MAP_VEHICLE.put("v_avmile_arrow", "-");
        DEFAULT_MAP_VEHICLE.put("v_avmile_price", "-");
        DEFAULT_MAP_VEHICLE.put("v_avmile_rate", "-");
        vehicleTypeAndColorMap = new HashMap<String, String>(16);
        vehicleTypeAndColorMap.put("1", "#1890FF");
        vehicleTypeAndColorMap.put("2", "#FAC53E");
        vehicleTypeAndColorMap.put("3", "#47DAD2");
        vehicleTypeAndColorMap.put("4", "#6682F5");
        vehicleTypeAndColorMap.put("6", "#F57582");
        vehicleTypeAndColorMap.put("7", "#73D13D");
        vehicleTypeAndColorMap = Collections.unmodifiableMap(vehicleTypeAndColorMap);
    }
}

