/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.planeindex;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.IPageCache;
import kd.bos.util.StringUtils;
import kd.fi.er.formplugin.web.tripboards.model.SummaryModel;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneTakeOffTimeDataProcessHandle;

public class TripPlaneBookInAdvanceDataProcessHandle
extends TripPlaneTakeOffTimeDataProcessHandle {
    private static final String JSON_KEY = "bookinadvance";
    private static final String JSON_TOTAL_DAYS = "totalDays";

    public TripPlaneBookInAdvanceDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.FALSE);
    }

    public TripPlaneBookInAdvanceDataProcessHandle() {
        this.setNeedYoY(Boolean.FALSE);
    }

    @Override
    public void dataHandle(Object data) {
        if (!this.getZipper().booleanValue()) {
            List<Object> convertData = this.getCacheData(this.getCacheKeys(this.getParam()));
            if (convertData.isEmpty()) {
                return;
            }
            List<SummaryModel> filterData = convertData.parallelStream().map(obj1 -> (SummaryModel)obj1).collect(Collectors.toList());
            filterData = this.getOtherSummaryTag(filterData.parallelStream().map(SummaryModel::getId).collect(Collectors.toList()));
            this.finalDataDeal(filterData);
        }
    }

    private void finalDataDeal(List<SummaryModel> filterData) {
        ConcurrentHashMap timePeriodAndOrderNumCount = new ConcurrentHashMap(16);
        AtomicInteger totalDays = new AtomicInteger(0);
        AtomicInteger orderNumCount = new AtomicInteger();
        ConcurrentHashMap dayAndTimePeriodMap = new ConcurrentHashMap(16);
        Set summaryTag = filterData.parallelStream().map(SummaryModel::getOtherSummary).collect(Collectors.toSet());
        Set allOrderSummaryTag = summaryTag.parallelStream().map(JSON::parseObject).filter(jsonObject -> jsonObject != null && jsonObject.containsKey((Object)"orderNumsAndAmount")).flatMap(jsonObject -> jsonObject.getJSONArray("orderNumsAndAmount").stream()).map(String::valueOf).collect(Collectors.toSet());
        List<String> ticketStatus = Arrays.asList("USED", "UNUSED", "CHANGED");
        allOrderSummaryTag.parallelStream().forEach(obj -> {
            String[] split = obj.split("\\$");
            if (split.length < 11) {
                return;
            }
            if (!ticketStatus.contains(split[5])) {
                return;
            }
            String days = split[9];
            int dataInt = Integer.parseInt(StringUtils.isEmpty((String)days) ? "0" : days);
            totalDays.getAndAdd(Math.max(dataInt, 0));
            String timePeriod = split[10];
            String[] timeSplit = timePeriod.split("-");
            dayAndTimePeriodMap.put(Integer.parseInt(timeSplit[0]), timePeriod);
            orderNumCount.getAndIncrement();
            timePeriodAndOrderNumCount.merge(timePeriod, 1, Integer::sum);
        });
        ArrayList timePoints = new ArrayList(dayAndTimePeriodMap.keySet());
        Collections.sort(timePoints);
        ArrayList<String> xAxisData = new ArrayList<String>(16);
        for (Integer timePoint : timePoints) {
            xAxisData.add((String)dayAndTimePeriodMap.get(timePoint));
        }
        JSONArray jsonArray = new JSONArray();
        JSONObject seriesJson = new JSONObject();
        ArrayList yAxisData = new ArrayList(16);
        for (Integer timePoint : timePoints) {
            yAxisData.add(timePeriodAndOrderNumCount.get(dayAndTimePeriodMap.get(timePoint)));
        }
        seriesJson.put("data", yAxisData);
        seriesJson.put("type", (Object)"bar");
        seriesJson.put("barWidth", (Object)"15");
        seriesJson.put("barMaxWidth", (Object)"25");
        jsonArray.add((Object)seriesJson);
        Map<String, Object> chart = this.createChart(jsonArray, xAxisData);
        Map map = (Map)chart.get("xAxis");
        map.put("name", ResManager.loadKDString((String)"\u5929", (String)"TripBoard_10", (String)"fi-er-business", (Object[])new Object[0]));
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(4);
        resultMap.put("command", chart);
        HashMap<String, Integer> daysMap = new HashMap<String, Integer>();
        daysMap.put("p_bookinadvanced_day", (Integer)(orderNumCount.get() == 0 ? Integer.valueOf(0) : new BigDecimal(totalDays.get()).divide(new BigDecimal(orderNumCount.get()), 2, RoundingMode.HALF_UP)));
        resultMap.put("flexData", daysMap);
        this.setDataResult(resultMap);
    }

    @Override
    public Object handleRequest(List<SummaryModel> filterData, List<SummaryModel> allData, IPageCache pageCache) {
        this.finalDataDeal(allData);
        return this.getDataResult();
    }
}

