/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.tripindex.planeindex;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.form.IPageCache;
import kd.fi.er.formplugin.web.tripboards.model.SummaryModel;
import kd.fi.er.formplugin.web.tripboards.tripindex.planeindex.TripPlaneTakeOffTimeDataProcessHandle;

public class TripPlaneFullTicketDataProcessHandle
extends TripPlaneTakeOffTimeDataProcessHandle {
    private static final String JSON_KEY = "fullticket";
    private static final String JSON_USERNAME_KEY = "userName";
    private static final String JSON_ORDERAMOUNT_KEY = "orderAmount";
    private static final String JSON_ORDERNUM_KEY = "orderNum";
    private static final String JSON_LINE_KEY = "lines";
    private static final String JSON_DISCOUNT_KEY = "discount";

    public TripPlaneFullTicketDataProcessHandle(Map<String, Object> paramMap) {
        super(paramMap);
        this.setNeedYoY(Boolean.FALSE);
    }

    public TripPlaneFullTicketDataProcessHandle() {
        this.setNeedYoY(Boolean.FALSE);
    }

    @Override
    public void dataHandle(Object data) {
        if (!this.getZipper().booleanValue()) {
            List<Object> convertData = this.getCacheData(this.getCacheKeys(this.getParam()));
            if (convertData.isEmpty()) {
                return;
            }
            List<SummaryModel> filterData = convertData.parallelStream().map(obj -> (SummaryModel)obj).collect(Collectors.toList());
            filterData = this.getOtherSummaryTag(filterData.parallelStream().map(SummaryModel::getId).collect(Collectors.toList()));
            this.finalDataDeal(filterData);
        }
    }

    private void finalDataDeal(List<SummaryModel> filterData) {
        ArrayList existOrderNums = new ArrayList();
        HashMap discountMap = new HashMap();
        JSONArray allJson = new JSONArray();
        for (SummaryModel convertDatum : filterData) {
            JSONObject jsonObject = JSONObject.parseObject((String)convertDatum.getOtherSummary());
            if (jsonObject == null || !jsonObject.containsKey((Object)JSON_KEY)) continue;
            allJson.addAll((Collection)JSONArray.parseArray((String)jsonObject.getString(JSON_KEY)));
        }
        Map<String, List<JSONObject>> discountGroupMap = allJson.stream().filter(obj -> obj instanceof JSONObject).map(obj -> (JSONObject)obj).collect(Collectors.groupingBy(obj -> {
            BigDecimal discount = obj.getBigDecimal(JSON_DISCOUNT_KEY);
            return this.getDiscountType(discount);
        }));
        discountGroupMap.forEach((key, values) -> {
            if ("valid".equals(key)) {
                return;
            }
            int seq = 0;
            JSONArray returnArray = new JSONArray();
            for (JSONObject dataJson : values) {
                String orderNum = dataJson.getString(JSON_ORDERNUM_KEY);
                if (existOrderNums.contains(orderNum)) continue;
                existOrderNums.add(orderNum);
                JSONObject fullJson = new JSONObject();
                fullJson.put("rank", (Object)(++seq));
                fullJson.put(JSON_USERNAME_KEY, (Object)dataJson.getString(JSON_USERNAME_KEY));
                fullJson.put(JSON_LINE_KEY, (Object)dataJson.getString(JSON_LINE_KEY));
                fullJson.put(JSON_ORDERAMOUNT_KEY, (Object)dataJson.getBigDecimal(JSON_ORDERAMOUNT_KEY).setScale(2, RoundingMode.HALF_UP));
                fullJson.put(JSON_ORDERNUM_KEY, (Object)orderNum);
                returnArray.add((Object)fullJson);
            }
            discountMap.merge(key, returnArray, (existingArray, newArray) -> {
                existingArray.addAll((Collection)newArray);
                return existingArray;
            });
        });
        HashMap resultMap = new HashMap(4);
        resultMap.put("data", discountMap);
        this.setDataResult(resultMap);
        IPageCache pageCache = this.getPageCache();
        pageCache.put("Full", JSONObject.toJSONString((Object)(discountMap.get("Full") == null ? new JSONArray() : discountMap.get("Full"))));
        pageCache.put("Seven", JSONObject.toJSONString((Object)(discountMap.get("Seven") == null ? new JSONArray() : discountMap.get("Seven"))));
        pageCache.put("Eight", JSONObject.toJSONString((Object)(discountMap.get("Eight") == null ? new JSONArray() : discountMap.get("Eight"))));
        pageCache.put("Nine", JSONObject.toJSONString((Object)(discountMap.get("Nine") == null ? new JSONArray() : discountMap.get("Nine"))));
    }

    @Override
    public Object handleRequest(List<SummaryModel> filterData, List<SummaryModel> allData, IPageCache pageCache) {
        this.setPageCache(pageCache);
        this.finalDataDeal(filterData);
        return this.getDataResult();
    }

    private String getDiscountType(BigDecimal discount) {
        if (discount == null) {
            return "valid";
        }
        if (new BigDecimal(70).compareTo(discount) <= 0 && discount.compareTo(new BigDecimal(80)) < 0) {
            return "Seven";
        }
        if (new BigDecimal(80).compareTo(discount) <= 0 && discount.compareTo(new BigDecimal(90)) < 0) {
            return "Eight";
        }
        if (new BigDecimal(90).compareTo(discount) <= 0 && discount.compareTo(new BigDecimal(100)) < 0) {
            return "Nine";
        }
        if (new BigDecimal(100).compareTo(discount) <= 0) {
            return "Full";
        }
        return "valid";
    }
}

