/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripboards.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcJsonSerializer;
import kd.bos.dataentity.serialization.DynamicObjectSerializationBinder;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.er.business.trip.supplier.ctrip.invoke.convert.ConvertUtil;
import kd.fi.er.business.trip.task.tripboards.OrderSummaryTask;
import kd.fi.er.business.utils.ErCommonUtils;
import org.apache.commons.lang.StringUtils;

public class TripBoardsUtil {
    private static final Log logger = LogFactory.getLog(TripBoardsUtil.class);
    public static final String DELIMITER = "_";
    public static final BigDecimal MILLION = new BigDecimal("1000000");
    public static final BigDecimal TEN_MILLION = new BigDecimal("10000000");
    public static final BigDecimal ONE_HUNDRED_THOUSAND = new BigDecimal("10000");
    public static final BigDecimal TEN_HUNDRED_THOUSAND = new BigDecimal("100000");

    public static String[] splitByDelimiter(String str) {
        return StringUtils.isEmpty((String)str) ? "".split(DELIMITER) : str.split(DELIMITER);
    }

    public static void setKeyFiguresToPageCache(IPageCache pageCache) {
        long userId = RequestContext.get().getCurrUserId();
        String appId = AppMetadataCache.getAppInfo((String)"em").getId();
        String entityNum = "er_trip_boards_finance";
        String permItemId = "47150e89000000ac";
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)appId, (String)entityNum, (String)permItemId);
        List hasPermOrgs = permOrgRs.getHasPermOrgs();
        if (permOrgRs.hasAllOrgPerm()) {
            long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
            pageCache.put("root", String.valueOf(rootOrgId));
        } else {
            int tmpSize = 200;
            Map<Object, Object> allOrgMap = Maps.newHashMapWithExpectedSize((int)hasPermOrgs.size());
            if (hasPermOrgs.size() > tmpSize) {
                List partition = Lists.partition((List)hasPermOrgs, (int)tmpSize);
                for (List orgIds : partition) {
                    allOrgMap.putAll(TripBoardsUtil.query(orgIds));
                }
                pageCache.put("root", String.valueOf(TripBoardsUtil.getRootOgrId((Map<Object, DynamicObject>)allOrgMap)));
            } else {
                allOrgMap = TripBoardsUtil.query(hasPermOrgs);
                pageCache.put("root", String.valueOf(TripBoardsUtil.getRootOgrId((Map<Object, DynamicObject>)allOrgMap)));
            }
        }
        pageCache.put("hasPermOrgs", StringUtils.join((Collection)hasPermOrgs, (String)"#"));
    }

    public static List<Long> getHasPermOrgResult() {
        long userId = RequestContext.get().getCurrUserId();
        String appId = AppMetadataCache.getAppInfo((String)"em").getId();
        String entityNum = "er_trip_boards_finance";
        String permItemId = "47150e89000000ac";
        HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"10", (String)appId, (String)entityNum, (String)permItemId, (boolean)Boolean.TRUE);
        HasPermOrgResult adminHasPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"01", (String)appId, (String)entityNum, (String)permItemId, (boolean)Boolean.TRUE);
        HasPermOrgResult sccHasPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"12", (String)appId, (String)entityNum, (String)permItemId, (boolean)Boolean.TRUE);
        List allHasPermOrgs = allPermOrgs.getHasPermOrgs();
        allHasPermOrgs.addAll(adminHasPermOrgs.getHasPermOrgs());
        allHasPermOrgs.addAll(sccHasPermOrgs.getHasPermOrgs());
        return allHasPermOrgs;
    }

    public static Map<Object, DynamicObject> query(List<Long> orgIds) {
        return BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)"fullname,org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("view", "=", (Object)15)});
    }

    public static long getRootOgrId(Map<Object, DynamicObject> orgMap) {
        int minLength = Integer.MAX_VALUE;
        long orgId = -1L;
        Set<Map.Entry<Object, DynamicObject>> entries = orgMap.entrySet();
        for (Map.Entry<Object, DynamicObject> entry : entries) {
            DynamicObject org = entry.getValue();
            String fullname = org.getString("fullname");
            Long id = ErCommonUtils.getPk(org.get("org"));
            int oldLen = TripBoardsUtil.splitByDelimiter(fullname).length;
            if (oldLen >= minLength) continue;
            minLength = oldLen;
            orgId = id == null ? 0L : id;
        }
        return orgId;
    }

    public static BigDecimal digitalProcess(Object digital) {
        if (digital == null) {
            return null;
        }
        BigDecimal bigDecimal = new BigDecimal(digital.toString());
        if ((bigDecimal = bigDecimal.setScale(2, RoundingMode.HALF_UP)).compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        return bigDecimal;
    }

    public static Boolean isCrossBar(Object compareObject, Object object) {
        if ("-".equals(compareObject) || "-".equals(object)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static BigDecimal getRate(Object compareData, Object data) {
        BigDecimal compareDecimal = new BigDecimal(compareData.toString());
        BigDecimal bigDecimal = new BigDecimal(data.toString());
        BigDecimal subtract = bigDecimal.subtract(compareDecimal);
        return subtract.divide(compareDecimal, 4, RoundingMode.HALF_UP);
    }

    public static void dealRateResult(Map<String, Object> resultMap, Object compareObject, Object object, String arrowKey, String rateKey) {
        if (!(TripBoardsUtil.isCrossBar(compareObject, object).booleanValue() || TripBoardsUtil.isZeroOrNull(compareObject) || Objects.isNull(object))) {
            BigDecimal rate = TripBoardsUtil.getRate(compareObject, object);
            if (rate.compareTo(BigDecimal.ZERO) < 0) {
                resultMap.put(arrowKey, "down");
                resultMap.put(rateKey + "_font", "eyJ0eXBlIjowLCJjb250ZW50IjoiXG5cbiQge1xuwqDCoGNvbG9yOiMwMEI5Mjg7XG4gIGZvbnQtd2VpZ2h0OjYwMDtcbiAgZm9udC1mYW1pbHk6UGluZ0ZhbmdTQy1TZW1pYm9sZDtcbsKgfVxuIn0=");
            } else if (rate.compareTo(BigDecimal.ZERO) > 0) {
                resultMap.put(arrowKey, "up");
                resultMap.put(rateKey + "_font", "eyJ0eXBlIjowLCJjb250ZW50IjoiXG5cbiQge1xuwqDCoGNvbG9yOiNGRjUyNTI7XG4gIGZvbnQtd2VpZ2h0OjYwMDtcbiAgZm9udC1mYW1pbHk6UGluZ0ZhbmdTQy1TZW1pYm9sZDtcbsKgfVxuIn0=");
            } else {
                resultMap.put(arrowKey, "eq");
                resultMap.put(rateKey + "_font", "eyJ0eXBlIjowLCJjb250ZW50IjoiXG5cbiQge1xuwqDCoGNvbG9yOiMwMDA7XG4gIGZvbnQtd2VpZ2h0OjYwMDtcbiAgZm9udC1mYW1pbHk6UGluZ0ZhbmdTQy1TZW1pYm9sZDtcbsKgfVxuIn0=");
            }
            resultMap.put(rateKey, TripBoardsUtil.formatDecimal(rate.abs().multiply(BigDecimal.valueOf(100L)).setScale(2, RoundingMode.HALF_UP)) + "%");
        } else {
            resultMap.put(rateKey, "-");
            resultMap.put(arrowKey, "null");
            resultMap.put(rateKey + "_font", "eyJ0eXBlIjowLCJjb250ZW50IjoiXG5cbiQge1xuwqDCoGNvbG9yOiMwMDA7XG4gIGZvbnQtd2VpZ2h0OjYwMDtcbiAgZm9udC1mYW1pbHk6UGluZ0ZhbmdTQy1TZW1pYm9sZDtcbsKgfVxuIn0=");
        }
    }

    private static boolean isZeroOrNull(Object compareObject) {
        if (compareObject == null) {
            return Boolean.TRUE;
        }
        BigDecimal compareDecimal = new BigDecimal(compareObject.toString());
        if (compareDecimal.compareTo(BigDecimal.ZERO) == 0) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static void formatDecimal(Map<String, Object> resultMap) {
        for (Map.Entry<String, Object> entry : resultMap.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof BigDecimal) {
                BigDecimal newValue = (BigDecimal)value;
                newValue = TripBoardsUtil.digitalProcess(TripBoardsUtil.numberFormatter(newValue));
                resultMap.put(entry.getKey(), TripBoardsUtil.formatDecimal(newValue));
                continue;
            }
            if (value != null) continue;
            resultMap.put(entry.getKey(), "-");
        }
    }

    public static String formatDecimal(BigDecimal value) {
        if (value == null) {
            value = BigDecimal.ZERO;
        }
        DecimalFormat format = new DecimalFormat("#,##0.00");
        return format.format(value);
    }

    public static BigDecimal numberFormatter(BigDecimal number) {
        if (TEN_HUNDRED_THOUSAND.compareTo(number) < 0) {
            number = number.divide(ONE_HUNDRED_THOUSAND, 2, RoundingMode.HALF_UP);
        }
        return number;
    }

    public static String getAmountUnit(BigDecimal number) {
        if (number != null && TEN_HUNDRED_THOUSAND.compareTo(number) < 0) {
            return "tenThousand";
        }
        return "yuan";
    }

    public static List<DynamicObject> orgFilterFun(List<DynamicObject> filterData, Set<Long> finalOrgIds) {
        filterData = filterData.parallelStream().filter(obj -> obj.get("expcommitcomnum") != null && finalOrgIds.contains(obj.getLong("expcommitcomnum")) || obj.get("expcommitdepnum") != null && finalOrgIds.contains(obj.getLong("expcommitdepnum"))).collect(Collectors.toList());
        return filterData;
    }

    @SafeVarargs
    public static double getTotalamount(List<DynamicObject> ... dataList) {
        double all = 0.0;
        for (List<DynamicObject> dynamicObjects : dataList) {
            all = Double.sum(dynamicObjects.parallelStream().filter(obj -> obj.get("totalamount") != null && obj.getBigDecimal("totalamount").compareTo(ConvertUtil.getOrderAmountInit()) != 0).mapToDouble(obj -> Double.parseDouble(obj.get("totalamount").toString())).summaryStatistics().getSum(), all);
        }
        return all;
    }

    public static Date converLocalDataToDate(LocalDate date) {
        return Date.from(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate convertDateToLocalDate(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static List<OrderSummaryTask.DateRange> getMonthlyDateRanges(LocalDate startDate, LocalDate endDate) {
        if (!startDate.isBefore(endDate = endDate.withDayOfMonth(endDate.lengthOfMonth()))) {
            return new ArrayList<OrderSummaryTask.DateRange>();
        }
        ArrayList<OrderSummaryTask.DateRange> dateRanges = new ArrayList<OrderSummaryTask.DateRange>(16);
        LocalDate firstStart = startDate;
        LocalDate firstEnd = startDate.withDayOfMonth(startDate.lengthOfMonth());
        dateRanges.add(new OrderSummaryTask.DateRange(firstStart, firstEnd, firstStart.atTime(LocalTime.MIN), endDate.atTime(LocalTime.MAX)));
        LocalDate currentStart = firstEnd.plusDays(1L);
        while (currentStart.isBefore(endDate.withDayOfMonth(1))) {
            LocalDate currentEnd = currentStart.withDayOfMonth(currentStart.lengthOfMonth());
            dateRanges.add(new OrderSummaryTask.DateRange(currentStart, currentEnd, currentStart.atTime(LocalTime.MIN), currentEnd.atTime(LocalTime.MAX)));
            currentStart = currentEnd.plusDays(1L);
        }
        if (currentStart.isBefore(endDate)) {
            dateRanges.add(new OrderSummaryTask.DateRange(currentStart, endDate, currentStart.atTime(LocalTime.MIN), endDate.atTime(LocalTime.MAX)));
        }
        return dateRanges;
    }

    public static Map<String, Object> getNullChartMap() {
        HashMap commandMap = Maps.newHashMapWithExpectedSize((int)16);
        HashMap legendMap = Maps.newHashMapWithExpectedSize((int)16);
        legendMap.put("data", new JSONArray());
        commandMap.put("legend", legendMap);
        commandMap.put("series", new JSONArray());
        commandMap.put("grid", new JSONObject());
        commandMap.put("isMerge", true);
        commandMap.put("graphic", new JSONArray());
        return commandMap;
    }

    public static List<OrderSummaryTask.DateRange> getPairs(Map<String, Object> param) {
        LocalDate endDate;
        LocalDate startDate = (LocalDate)param.get("beginDate");
        if (!startDate.isBefore(endDate = (LocalDate)param.get("endDate"))) {
            return new ArrayList<OrderSummaryTask.DateRange>();
        }
        int timeDays = 32;
        long totalDays = ChronoUnit.DAYS.between(startDate, endDate);
        if (totalDays < (long)timeDays) {
            timeDays = 12;
        }
        long averageDays = totalDays / (long)timeDays;
        ArrayList<OrderSummaryTask.DateRange> pairs = new ArrayList<OrderSummaryTask.DateRange>(timeDays);
        LocalDate currentStartDate = startDate;
        for (int i = 0; i < timeDays; ++i) {
            LocalDate currentEnd = i == timeDays - 1 ? endDate : currentStartDate.plusDays(averageDays - 1L);
            pairs.add(new OrderSummaryTask.DateRange(currentStartDate, currentEnd, currentStartDate.atTime(LocalTime.MIN), currentEnd.atTime(LocalTime.MAX)));
            currentStartDate = currentEnd.plusDays(1L);
        }
        return pairs;
    }

    public static Map<String, Object> createParamMap(LocalDate beginDate, LocalDate endDate, RequestContext context) {
        ConcurrentHashMap<String, Object> param = new ConcurrentHashMap<String, Object>(4);
        param.put("beginDate", beginDate);
        param.put("endDate", endDate);
        param.put("context", context);
        return param;
    }

    public static Map<Long, String> getOrganizationInfo(List<Long> orgIdList) {
        Future future = ThreadService.submit(() -> QueryServiceHelper.query((String)"bos_org", (String)"name,id", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)orgIdList)}), (TaskType)TaskType.ER_TRIP_TASK);
        try {
            DynamicObjectCollection orgs = (DynamicObjectCollection)future.get();
            return orgs.stream().collect(Collectors.toMap(obj -> obj.getLong("id"), obj -> obj.getString("name")));
        }
        catch (Exception ex) {
            return new HashMap<Long, String>();
        }
    }

    public static void convertDynamicObject(MainEntityType dataEntityType, List<LinkedHashMap> datas, List<Object> returnData) {
        if (datas.isEmpty()) {
            return;
        }
        List tempData = Collections.synchronizedList(new ArrayList());
        DynamicObjectSerializationBinder binder = new DynamicObjectSerializationBinder((DynamicObjectType)dataEntityType);
        binder.setOnlyDbProperty(false);
        binder.setSerializeDefaultValue(true);
        DcJsonSerializer jser = new DcJsonSerializer((DcBinder)binder);
        List partition = Lists.partition(datas, (int)10000);
        CountDownLatch count = new CountDownLatch(partition.size());
        for (int i = 0; i < partition.size(); ++i) {
            List linkedHashMaps = (List)partition.get(i);
            ThreadService.execute(() -> {
                try {
                    linkedHashMaps.forEach(linkedHashMap -> tempData.add((DynamicObject)jser.deserializeFromMap((Map)linkedHashMap, (Object)new DynamicObject((DynamicObjectType)dataEntityType))));
                }
                catch (Exception ex) {
                    logger.error("\u8f6c\u52a8\u6001\u5bf9\u8c61\u5931\u8d25:", (Throwable)ex);
                }
                finally {
                    count.countDown();
                }
            }, (TaskType)TaskType.ER_TRIP_TASK, (RequestContext)RequestContext.get());
        }
        try {
            count.await();
        }
        catch (Exception ex) {
            logger.error("\u7b49\u5f85\u5f02\u5e38:", (Throwable)ex);
        }
        returnData.addAll(tempData);
    }

    public static List<String> getMonthsBetweenDates(LocalDate startDate, LocalDate endDate, String pattern) {
        ArrayList<String> months = new ArrayList<String>(16);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(pattern);
        LocalDate current = startDate.withDayOfMonth(1);
        while (current.isBefore(endDate.withDayOfMonth(1).plusMonths(1L))) {
            months.add(current.format(formatter));
            current = current.plusMonths(1L);
        }
        return months;
    }
}

