/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.er.formplugin.web.tripstandard.util;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.cache.ThreadCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IPageCache;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.er.business.invoicecloud.v2.seatstd.TripVhcStdChangeUtils;
import kd.fi.er.business.tripstd.context.StdPreCalContext;
import kd.fi.er.business.tripstd.model.TripReimEntryValidateItem;
import kd.fi.er.business.tripstd.service.IErTripStdService;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceImp;
import kd.fi.er.business.tripstd.service.imp.ErTripStdServiceProxy;
import kd.fi.er.common.ControlMethodEnum;
import kd.fi.er.common.type.SubsidiesDayParamEnum;
import kd.fi.er.formplugin.web.tripstandard.util.PlaneSeatUtil;
import org.apache.commons.lang.StringUtils;

public class TripVehicleStandardUtils {
    private static Log logger = LogFactory.getLog(TripVehicleStandardUtils.class);
    private static final Long deafault = 91111111111111119L;
    private static final String VEHICLE_FORM = "er_tripstandard_vehicle";

    @Deprecated
    public static List<String> getTripVhcStd(List<Object> allTravlerId, String attribute, Long companyId) {
        HashSet cacheList = Sets.newHashSet();
        String vehicleType = TripVhcStdChangeUtils.attrib2Type(attribute);
        if (vehicleType == null) {
            return Lists.newArrayList();
        }
        logger.info("\u51fa\u5dee\u4ebaid\uff1a" + allTravlerId + ",\u516c\u53f8\uff1a" + companyId);
        for (Object travelerId : allTravlerId) {
            DynamicObject dObjVhcStd = new ErTripStdServiceImp().getVehicleStdByUserIdAndVehicleType((Long)travelerId, vehicleType, companyId);
            if (dObjVhcStd == null) continue;
            List<String> vhcStd = Arrays.asList(dObjVhcStd.getString("cabinstr").split(","));
            cacheList.addAll(vhcStd);
        }
        logger.info("\u51fa\u5dee\u4ebaid\uff1a" + allTravlerId + "\u7684\u4ea4\u901a\u6807\u51c6\u4e3a\uff1a" + JSONObject.toJSONString((Object)cacheList));
        return Lists.newArrayList((Iterable)cacheList);
    }

    @Deprecated
    public static List<String> getTripVhcStd(List<Object> allTravlerId, String attribute, Long companyId, IPageCache pageCache) {
        return TripVehicleStandardUtils.getTripVhcStd(allTravlerId, attribute, companyId, pageCache, null);
    }

    @Deprecated
    public static List<String> getTripVhcStd(List<Object> allTravlerId, String attribute, Long companyId, IPageCache pageCache, AbstractFormPlugin plugin) {
        return TripVehicleStandardUtils.getTripVhcStd(allTravlerId, attribute, companyId, pageCache, plugin, null);
    }

    public static List<String> getTripVhcStd(List<Object> allTravlerId, String attribute, Long companyId, IPageCache pageCache, AbstractFormPlugin plugin, Map<String, Object> extMap) {
        return TripVehicleStandardUtils.getTripVhcStd(allTravlerId, attribute, companyId, pageCache, plugin, extMap, null);
    }

    public static List<String> getTripVhcStd(List<Object> allTravlerId, String attribute, Long companyId, IPageCache pageCache, AbstractFormPlugin plugin, Map<String, Object> extMap, StdPreCalContext stdPreCalContext) {
        HashSet cacheList = Sets.newHashSet();
        String vehicleType = TripVhcStdChangeUtils.attrib2Type(attribute);
        if (vehicleType == null) {
            return Lists.newArrayList();
        }
        logger.info("\u51fa\u5dee\u4ebaid\uff1a" + allTravlerId + ",\u516c\u53f8\uff1a" + companyId);
        for (Object travelerId : allTravlerId) {
            DynamicObject dObjVhcStd;
            List<String> vhcStd = null;
            IErTripStdService instance = new ErTripStdServiceProxy(new ErTripStdServiceImp(), plugin == null ? null : plugin.getView().getModel().getDataEntity(), extMap).getInstance();
            if (stdPreCalContext != null) {
                ThreadCache.put((Object)"stdPreCalContext", (Object)stdPreCalContext);
            }
            if ((dObjVhcStd = instance.getVehicleStdByUserIdAndVehicleType((Long)travelerId, vehicleType, companyId)) != null) {
                vhcStd = Arrays.asList(dObjVhcStd.getString("cabinstr").split(","));
            }
            if (vhcStd == null) continue;
            if (extMap != null) {
                extMap.put(String.valueOf(travelerId), vhcStd);
            }
            cacheList.addAll(vhcStd);
        }
        logger.info("\u51fa\u5dee\u4ebaid\uff1a" + allTravlerId + "\u7684\u4ea4\u901a\u6807\u51c6\u4e3a\uff1a" + JSONObject.toJSONString((Object)cacheList));
        return Lists.newArrayList((Iterable)cacheList);
    }

    public static List<String> getStandardVehicleCabin(List<Object> tripEntryTravelers, Map<Long, List<Long>> specialUserMap, Map<Long, DynamicObject> specialUserOfStandardMap, Map<Long, DynamicObject> userReimburseLevelMap, Map<Long, List<DynamicObject>> rmbsLevelAndVehileMap, String tripItemAttribute, Long companyId) {
        HashSet cacheList = Sets.newHashSet();
        String vehicleType = TripVhcStdChangeUtils.attrib2Type(tripItemAttribute);
        if (vehicleType == null) {
            return Lists.newArrayList();
        }
        for (Object travelerId : tripEntryTravelers) {
            Long reimLevelId;
            List<DynamicObject> vehileList;
            List<Long> specialTripStandardList = specialUserMap.get((Long)travelerId);
            boolean specialExist = false;
            if (specialTripStandardList != null && specialTripStandardList.size() >= 1) {
                for (Long standardId : specialTripStandardList) {
                    String standardtype;
                    DynamicObject tripstandardVehicle = specialUserOfStandardMap.get(standardId);
                    if (tripstandardVehicle == null || !tripItemAttribute.equals(standardtype = tripstandardVehicle.getString("standardtype"))) continue;
                    List<String> cabinstrList = Arrays.asList(tripstandardVehicle.getString("cabinstr").split(","));
                    cacheList.addAll(cabinstrList);
                    specialExist = true;
                    break;
                }
            }
            if (specialExist) continue;
            DynamicObject reimburseLevel = userReimburseLevelMap.get((Long)travelerId);
            if (reimburseLevel == null) {
                reimburseLevel = userReimburseLevelMap.get(deafault);
            }
            if (reimburseLevel == null || (vehileList = rmbsLevelAndVehileMap.get(reimLevelId = (Long)reimburseLevel.getPkValue())) == null || vehileList.size() <= 0) continue;
            for (DynamicObject vehileObj : vehileList) {
                String standardtype = vehileObj.getString("standardtype");
                if (!standardtype.equals(vehicleType)) continue;
                List<String> vhcStd = Arrays.asList(vehileObj.getString("cabinstr").split(","));
                cacheList.addAll(vhcStd);
            }
        }
        return Lists.newArrayList((Iterable)cacheList);
    }

    public static void setExpenseSeatGrade(IDataModel model, long tripItemEntryId, int tripIndex, int expenseItemIndex, String attribute) {
        DynamicObject dataEntity = model.getDataEntity(true);
        Set invoiceHeadIds = dataEntity.getDynamicObjectCollection("invoiceitementry").stream().filter(invoiceItemEntry -> Objects.equals(tripItemEntryId, invoiceItemEntry.getLong("itementryid"))).map(invoiceItemEntry -> invoiceItemEntry.getLong("invoiceheadentryid")).collect(Collectors.toSet());
        Set<String> invoiceList = dataEntity.getDynamicObjectCollection("invoiceentry").stream().filter(invoiceEntry -> invoiceHeadIds.contains(invoiceEntry.getPkValue())).filter(invoiceEntry -> StringUtils.isNotBlank((String)invoiceEntry.getString("seatgrade"))).map(invoiceEntry -> invoiceEntry.getString("seatgrade")).collect(Collectors.toSet());
        if (!invoiceList.isEmpty()) {
            DynamicObject[] seatGradeArr = PlaneSeatUtil.findSeatByAttribute(attribute, invoiceList);
            if (seatGradeArr != null && seatGradeArr.length > 0) {
                Object[] seats = Arrays.stream(seatGradeArr).map(seat -> seat.get("id")).toArray();
                model.setValue("mulseatgrade", (Object)seats, expenseItemIndex, tripIndex);
            } else {
                model.setValue("mulseatgrade", null, expenseItemIndex, tripIndex);
            }
        }
    }

    public static void setVhcStdSeatText(IDataModel model, List<String> vhcStd, int tripItemIndex, int tripIndex) {
        String text = StringUtils.join(vhcStd, (String)"\uff0c");
        if (StringUtils.isBlank((String)text)) {
            text = ResManager.loadKDString((String)"\u672a\u8bbe\u7f6e\u6807\u51c6", (String)"TripVehicleStandardUtils_0", (String)"fi-er-business", (Object[])new Object[0]);
        }
        model.setValue("textvehiclestandard", (Object)(" " + text), tripItemIndex, tripIndex);
    }

    public static boolean setOverVhcStd(IDataModel model, ControlMethodEnum tripVhcCtrLv, List<String> vhcStd, int tripIndex, int tripItemIndex, String attribute) {
        List<String> seat;
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject tripEntry = (DynamicObject)dataEntity.getDynamicObjectCollection("tripentry").get(tripIndex);
        DynamicObject tripItemEntry = (DynamicObject)tripEntry.getDynamicObjectCollection("entryentity").get(tripItemIndex);
        boolean isOverStd = false;
        DynamicObjectCollection expItemSeatGrade = tripItemEntry.getDynamicObjectCollection("mulseatgrade");
        isOverStd = expItemSeatGrade == null || expItemSeatGrade.isEmpty() ? false : ((seat = expItemSeatGrade.stream().map(seatGrade -> seatGrade.getDynamicObject("fbasedataid").getString("name")).collect(Collectors.toList())) != null && !seat.isEmpty() ? !TripVhcStdChangeUtils.vhcStdContainAllSeatGrade(vhcStd, seat, attribute) : false);
        model.setValue("isovervhcstd", (Object)isOverStd, tripItemIndex, tripIndex);
        return isOverStd;
    }

    public static Map<Long, List<Long>> queryTripStandarSpecialUser(List<Object> allTravlerId, String sourceBillType) {
        String selectProperties = "id,tripstandard,sourcebilltype,billtype,entryentity.user";
        QFilter filter = new QFilter("entryentity.user", "in", allTravlerId);
        filter.and(new QFilter("sourcebilltype", "=", (Object)sourceBillType));
        DynamicObject[] includeEmployees = BusinessDataServiceHelper.load((String)"er_include_employee", (String)selectProperties, (QFilter[])new QFilter[]{filter});
        HashMap<Long, List<Long>> userSpecialMap = new HashMap<Long, List<Long>>(10);
        if (includeEmployees != null && includeEmployees.length > 0) {
            for (DynamicObject record : includeEmployees) {
                DynamicObjectCollection entryentity = record.getDynamicObjectCollection("entryentity");
                Long tripStandardId = record.getLong("tripstandard");
                for (DynamicObject entry : entryentity) {
                    DynamicObject user = entry.getDynamicObject("user");
                    Long userId = (Long)user.getPkValue();
                    if (!allTravlerId.contains(userId)) continue;
                    List standardListTmp = (List)userSpecialMap.get(userId);
                    if (standardListTmp != null) {
                        standardListTmp.add(tripStandardId);
                        userSpecialMap.put(userId, standardListTmp);
                        continue;
                    }
                    ArrayList<Long> tripStandardList = new ArrayList<Long>(2);
                    tripStandardList.add(tripStandardId);
                    userSpecialMap.put(userId, tripStandardList);
                }
            }
        }
        return userSpecialMap;
    }

    public static Map<Long, DynamicObject> getTripStandardOfSpecialUser(Map<Long, List<Long>> specialUserMap, Long companyId) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(20);
        ArrayList<Long> allStandardList = new ArrayList<Long>();
        for (Map.Entry<Long, List<Long>> specialEntry : specialUserMap.entrySet()) {
            Long userId = specialEntry.getKey();
            List<Long> list = specialEntry.getValue();
            allStandardList.addAll(list);
        }
        if (allStandardList.size() > 0) {
            String selectProperties = "id,cabinstr,standardtype,createorg";
            QFilter filter1 = new QFilter("id", "in", allStandardList);
            QFilter filter2 = new QFilter("company", "=", (Object)companyId);
            DynamicObjectCollection tripStandardVehicles = QueryServiceHelper.query((String)VEHICLE_FORM, (String)selectProperties, (QFilter[])new QFilter[]{filter1, filter2});
            for (DynamicObject vehicles : tripStandardVehicles) {
                map.put((Long)vehicles.get("id"), vehicles);
            }
        }
        return map;
    }

    @Deprecated
    public static Map<Long, DynamicObject> getReimburseLevelByUserId(List<Object> userList) {
        return null;
    }

    public static Map<Long, DynamicObject> getReimburseLevelByUserId(List<Object> userList, Long companyId) {
        ErTripStdServiceImp tripStdService = new ErTripStdServiceImp();
        HashMap reimburselevelMap = Maps.newHashMapWithExpectedSize((int)userList.size());
        for (Object userId : userList) {
            DynamicObject reimburseLevel = tripStdService.getReimburseLevelByUserId((Long)userId, companyId);
            reimburselevelMap.put((Long)userId, reimburseLevel);
        }
        return reimburselevelMap;
    }

    public static Map<Long, List<DynamicObject>> getReimbureseLevelOfAllTraveler(Map<Long, DynamicObject> userReimburseLevelMap, Long companyId) {
        HashMap<Long, List<DynamicObject>> map = new HashMap<Long, List<DynamicObject>>(20);
        ArrayList<Long> reimburseLevelList = new ArrayList<Long>(10);
        HashSet<Long> companySet = new HashSet<Long>(userReimburseLevelMap.size());
        for (Map.Entry<Long, DynamicObject> entry : userReimburseLevelMap.entrySet()) {
            DynamicObject reimburseLevel = entry.getValue();
            reimburseLevelList.add((Long)reimburseLevel.getPkValue());
            Long userId = entry.getKey();
            if (deafault.equals(userId)) continue;
            Long userMainCompanyId = ErTripStdServiceImp.getUserTripStdMainOrgByCompany(userId, companyId);
            if (userMainCompanyId == null) {
                userMainCompanyId = companyId;
            }
            companySet.add(userMainCompanyId);
        }
        if (!reimburseLevelList.isEmpty()) {
            QFilter baseDataFilter = null;
            for (Long userMainCompanyId : companySet) {
                QFilter companyBaseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)VEHICLE_FORM, (Long)userMainCompanyId);
                if (baseDataFilter != null && companyBaseDataFilter != null) {
                    baseDataFilter = baseDataFilter.or(companyBaseDataFilter);
                }
                if (baseDataFilter != null) continue;
                baseDataFilter = companyBaseDataFilter;
            }
            String string = "id,cabinstr,standardtype,createorg,reimburselevel";
            QFilter filter = new QFilter("reimburselevel.fbasedataid_id", "in", reimburseLevelList);
            if (baseDataFilter != null) {
                filter.and(baseDataFilter);
                filter.and(new QFilter("enable", "=", (Object)"1"));
            } else {
                filter.and(QFilter.of((String)"useorg =? and enable =? ", (Object[])new Object[]{companyId, "1"}));
            }
            DynamicObjectCollection vehicleStandard = QueryServiceHelper.query((String)VEHICLE_FORM, (String)string, (QFilter[])new QFilter[]{filter});
            for (DynamicObject vehicles : vehicleStandard) {
                DynamicObjectCollection reimburselevelColl = vehicles.getDynamicObjectCollection("reimburselevel");
                for (DynamicObject level : reimburselevelColl) {
                    Long levelId = level.getLong("fbasedataid_id");
                    List vehiclesList = (List)map.get(levelId);
                    if (vehiclesList != null) {
                        vehiclesList.add(vehicles);
                        map.put(levelId, vehiclesList);
                        continue;
                    }
                    ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>(2);
                    objectList.add(vehicles);
                    map.put(levelId, objectList);
                }
            }
        }
        return map;
    }

    public static BigDecimal calDaycount(Object dayCount, Long companyId, int subsidiesDayControl) {
        if (dayCount == null || companyId == null) {
            return BigDecimal.ZERO;
        }
        BigDecimal calDayCount = new BigDecimal(Integer.parseInt(dayCount.toString()));
        BigDecimal tripDays = BigDecimal.ZERO;
        if (subsidiesDayControl == SubsidiesDayParamEnum.NORMAL_CONTROL.getValue()) {
            tripDays = calDayCount;
        } else if (subsidiesDayControl == SubsidiesDayParamEnum.ADD_ONE_CONTROL.getValue()) {
            tripDays = calDayCount.add(BigDecimal.ONE);
        } else if (subsidiesDayControl == SubsidiesDayParamEnum.ADD_HALF_CONTROL.getValue()) {
            tripDays = calDayCount.add(BigDecimal.valueOf(0.5));
        }
        return tripDays;
    }

    public static Map<String, String> getOrderMapInfo(DynamicObjectCollection tripEntrys) {
        ArrayList<String> planeOrderNumList = new ArrayList<String>(10);
        ArrayList<String> trainOrderNumList = new ArrayList<String>(10);
        HashMap<String, String> orderNumSeatMap = new HashMap<String, String>(10);
        for (int tripEntryIndex = 0; tripEntryIndex < tripEntrys.size(); ++tripEntryIndex) {
            DynamicObject tripEntry = (DynamicObject)tripEntrys.get(tripEntryIndex);
            if (tripEntry == null) continue;
            DynamicObjectCollection entrys = tripEntry.getDynamicObjectCollection("entryentity");
            int entryCount = entrys.getRowCount();
            for (int i = 0; i < entryCount; ++i) {
                String attribute;
                DynamicObject entry = (DynamicObject)entrys.get(i);
                String ordernum = entry.getString("ordernum");
                String orderformid = entry.getString("orderformid");
                DynamicObject expenseItem = entry.getDynamicObject("expenseitem");
                if (expenseItem == null || StringUtils.equals((String)(attribute = expenseItem.getString("attribute")), (String)"5") || StringUtils.equals((String)attribute, (String)"1") || StringUtils.isBlank((String)ordernum) || StringUtils.isBlank((String)orderformid)) continue;
                if (StringUtils.equals((String)"er_planebill", (String)orderformid)) {
                    planeOrderNumList.add(ordernum);
                    continue;
                }
                if (!StringUtils.equals((String)"er_trainbill", (String)orderformid)) continue;
                trainOrderNumList.add(ordernum);
            }
        }
        if (!planeOrderNumList.isEmpty()) {
            QFilter[] filters = new QFilter[]{new QFilter("ordernum", "in", planeOrderNumList)};
            DynamicObjectCollection planeOrder = QueryServiceHelper.query((String)"er_planebill", (String)"ordernum,cabinclass", (QFilter[])filters);
            for (DynamicObject plane : planeOrder) {
                String key = "er_planebill" + plane.getString("ordernum");
                orderNumSeatMap.put(key, plane.getString("cabinclass"));
            }
        }
        if (!trainOrderNumList.isEmpty()) {
            QFilter[] filters = new QFilter[]{new QFilter("ordernum", "in", trainOrderNumList)};
            DynamicObjectCollection trainOrder = QueryServiceHelper.query((String)"er_trainbill", (String)"ordernum,trainseat", (QFilter[])filters);
            for (DynamicObject train : trainOrder) {
                String key = "er_trainbill" + train.getString("ordernum");
                orderNumSeatMap.put(key, train.getString("trainseat"));
            }
        }
        return orderNumSeatMap;
    }

    public static boolean checkTripStandardGroupedAmountIsOver(List<Long> travelerIds, TripReimEntryValidateItem validateItem, String tripStdCtrlType, DynamicObject tripEntry, String subsidiesDay, String sumCheck) {
        BigDecimal totalAmount;
        boolean isOver = false;
        BigDecimal tripDays = new BigDecimal(TripVehicleStandardUtils.getTripDays(tripEntry, subsidiesDay));
        BigDecimal reimburseAmount = validateItem.getReimAmount();
        BigDecimal stdAmount = validateItem.getStdAmount();
        DynamicObject tripExpenseItem = validateItem.getTripExpenseItem();
        String expenseAttribute = tripExpenseItem.getString("attribute");
        if (StringUtils.equals((String)expenseAttribute, (String)"5") && StringUtils.equals((String)"yes", (String)sumCheck)) {
            Date endDate = tripEntry.getDate("enddate");
            Date startdate = tripEntry.getDate("startdate");
            tripDays = new BigDecimal(TripVehicleStandardUtils.differentDaysByMillisecond(startdate, endDate));
        }
        if (StringUtils.equals((String)expenseAttribute, (String)"1") || StringUtils.equals((String)expenseAttribute, (String)"5") && StringUtils.equals((String)tripStdCtrlType, (String)"sum")) {
            totalAmount = stdAmount.multiply(tripDays);
            return reimburseAmount.compareTo(totalAmount) > 0;
        }
        if (StringUtils.equals((String)expenseAttribute, (String)"5") && StringUtils.equals((String)tripStdCtrlType, (String)"max")) {
            totalAmount = stdAmount.multiply(tripDays.multiply(new BigDecimal(travelerIds.size())));
            return reimburseAmount.compareTo(totalAmount) > 0;
        }
        return isOver;
    }

    private static String differentDaysByMillisecond(Date date1, Date date2) {
        int days = (int)((date2.getTime() - date1.getTime()) / 86400000L);
        return Integer.toString(days);
    }

    private static float getTripDays(DynamicObject tripEntry, String subsidiesDayCtl) {
        float tripDays = 0.0f;
        int subsidiesDayControl = Integer.parseInt(subsidiesDayCtl);
        Date endDate = tripEntry.getDate("enddate");
        Date startdate = tripEntry.getDate("startdate");
        if (subsidiesDayControl == SubsidiesDayParamEnum.NORMAL_CONTROL.getValue()) {
            tripDays = Float.parseFloat(TripVehicleStandardUtils.differentDaysByMillisecond(startdate, endDate));
        } else if (subsidiesDayControl == SubsidiesDayParamEnum.ADD_ONE_CONTROL.getValue()) {
            tripDays = Float.parseFloat(TripVehicleStandardUtils.differentDaysByMillisecond(startdate, endDate)) + 1.0f;
        } else if (subsidiesDayControl == SubsidiesDayParamEnum.ADD_HALF_CONTROL.getValue()) {
            tripDays = Float.parseFloat(TripVehicleStandardUtils.differentDaysByMillisecond(startdate, endDate)) + 0.5f;
        }
        return tripDays;
    }
}

