/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.util.CollectionUtils;
import kd.fi.evp.common.util.ReportUtil;

public class EleVoucherTypeEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"fieldname"});
        this.addItemClickListeners(new String[]{"advcontoolbarap", "syncgrpname"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof DeleteEntry) {
            this.deleteField();
            args.setCancel(true);
        }
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "fieldname": {
                this.chooseField();
                break;
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("syncgrpname".equals(itemKey)) {
            this.syncFieldGroupName();
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData == null) {
            return;
        }
        switch (actionId) {
            case "field_choose_close_call_back": {
                this.parseClosedCallBackInfo(returnData);
                break;
            }
        }
    }

    private void syncFieldGroupName() {
        String entityId = (String)this.getModel().getValue("number");
        if (StringUtils.isEmpty((CharSequence)entityId)) {
            return;
        }
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("fieldentity");
        if (entryEntity.isEmpty()) {
            return;
        }
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityId, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        for (DynamicObject row : entryEntity) {
            String fieldKey = row.getString("fieldnumber");
            if (StringUtils.isEmpty((CharSequence)fieldKey)) continue;
            formMeta.getItems().stream().filter(ctl -> ctl.getKey().equals(fieldKey)).findFirst().ifPresent(ctl -> {
                String parentCtlId = ctl.getParentId();
                ControlAp parentCtl = formMeta.getItem(parentCtlId);
                if (parentCtl != null) {
                    row.set("groupname", (Object)parentCtl.getName().getLocaleValue());
                }
            });
        }
        this.getView().updateView("fieldentity");
    }

    private void deleteField() {
        EntryGrid entryGrid = (EntryGrid)this.getControl("fieldentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entity = this.getModel().getEntryEntity("fieldentity");
        int beginSize = entity.size();
        if (selectRows != null && selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                DynamicObject dynamicRow = (DynamicObject)entity.get(selectRows[i]);
                if (dynamicRow.getBoolean("issyspreset")) continue;
                entity.remove(selectRows[i]);
            }
        }
        this.getModel().updateEntryCache(entity);
        this.getView().updateView("fieldentity");
        if (selectRows != null && beginSize < selectRows.length + entity.size()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9884\u7f6e\u6570\u636e\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"EleVoucherTypeEdit_0", (String)"fi-evp-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
        }
    }

    private void chooseField() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("evp_elevoucher_choose");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        IDataModel model = this.getModel();
        int index = model.getEntryCurrentRowIndex("fieldentity");
        String number = (String)model.getValue("number");
        if (!StringUtils.isNotBlank((CharSequence)number)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u7f16\u7801\u9700\u8981\u8981\u662f\u5143\u6570\u636e\u7684\u6807\u8bc6\u3002", (String)"EleVoucherTypeEdit_1", (String)"fi-evp-formplugin", (Object[])new Object[0]), Integer.valueOf(2000));
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("billnumber", number);
        map.put("index", index);
        parameter.setCustomParams(map);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "field_choose_close_call_back"));
        this.getView().showForm(parameter);
    }

    private void parseClosedCallBackInfo(Object returnData) {
        ArrayList returnParams = (ArrayList)returnData;
        DynamicObjectType entryType = this.getModel().getEntryEntity("fieldentity").getDynamicObjectType();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("fieldentity");
        if (CollectionUtils.isNotEmpty((Collection)entryColl)) {
            entryColl.remove(this.getModel().getEntryCurrentRowIndex("fieldentity"));
        }
        for (HashMap returnParam : returnParams) {
            DynamicObject entryObj = new DynamicObject(entryType);
            entryObj.set("fieldname", returnParam.get("fieldname"));
            entryObj.set("fieldnumber", returnParam.get("fieldnumber"));
            entryObj.set("fieldtype", returnParam.get("fieldtype"));
            entryObj.set("displayprop", returnParam.get("displayprop"));
            entryObj.set("isvisibleorigin", (Object)true);
            entryObj.set("isvisibleevp", (Object)true);
            entryObj.set("issyspreset", (Object)false);
            entryObj.set("groupname", returnParam.get("groupname"));
            entryColl.add(Integer.parseInt((String)returnParam.get("index")), entryObj);
        }
        ComboEdit comboEdit = (ComboEdit)this.getControl("displayprop");
        comboEdit.setVisible("4", true);
        this.getModel().updateEntryCache(entryColl);
        this.getView().updateView("fieldentity");
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.handlingInternationalization();
    }

    private void handlingInternationalization() {
        Object number = this.getModel().getValue("number");
        Object fieldEntity = this.getModel().getValue("fieldentity");
        if (Objects.isNull(number) || Objects.isNull(fieldEntity)) {
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = (DynamicObjectCollection)fieldEntity;
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)number.toString(), (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        Set allFieldNumberSet = dynamicObjectCollection.stream().map(dyn -> dyn.getString("fieldnumber")).collect(Collectors.toSet());
        ReportUtil.FiledModel filedModel = ReportUtil.getFiledModel((FormMetadata)formMeta, allFieldNumberSet);
        Map fieldNumber2FieldNameMap = filedModel.getFieldNumber2FieldNameMap();
        Map fieldNumber2GroupNameMap = filedModel.getFieldNumber2GroupNameMap();
        EntityType fieldentity = (EntityType)this.getModel().getDataEntityType().getAllEntities().get("fieldentity");
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String groupName;
            String fieldKey = dynamicObject.getString("fieldnumber");
            if (StringUtils.isEmpty((CharSequence)fieldKey)) continue;
            String localDisplayName = (String)fieldNumber2FieldNameMap.get(fieldKey);
            if (StringUtils.isNotEmpty((CharSequence)localDisplayName)) {
                String gbName;
                String fieldName = dynamicObject.getString("fieldname");
                if (StringUtils.isNotEmpty((CharSequence)fieldName)) {
                    dynamicObject.set("fieldname", (Object)localDisplayName);
                }
                if (StringUtils.isNotEmpty((CharSequence)(gbName = dynamicObject.getString("gbname")))) {
                    dynamicObject.set("gbname", (Object)localDisplayName);
                }
            }
            if (StringUtils.isNotEmpty((CharSequence)(groupName = (String)fieldNumber2GroupNameMap.get(fieldKey))) && StringUtils.isNotEmpty((CharSequence)dynamicObject.getString("groupname"))) {
                dynamicObject.set("groupname", (Object)groupName);
            }
            DataEntityState dataEntityState = dynamicObject.getDataEntityState();
            DynamicProperty property = fieldentity.getProperty("fieldname");
            dataEntityState.setBizChanged(property.getOrdinal(), false);
            DynamicProperty property2 = fieldentity.getProperty("gbname");
            dataEntityState.setBizChanged(property2.getOrdinal(), false);
            DynamicProperty property3 = fieldentity.getProperty("groupname");
            dataEntityState.setBizChanged(property3.getOrdinal(), false);
        }
    }
}

