/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.fi.evp.common.constant.DisplayProp;

public class EvpFieldChooseEdit
extends AbstractBillPlugIn {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter form = this.getView().getFormShowParameter();
        Map customParams = form.getCustomParams();
        if (customParams == null) {
            this.getView().close();
            return;
        }
        String billNumber = (String)customParams.get("billnumber");
        this.initEntryEntity(billNumber);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            this.returnDataToParent();
        }
    }

    private void initEntryEntity(String billNumber) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        FormMetadata formMeta = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)billNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        Map allEntities = dataEntityType.getAllEntities();
        DynamicObjectType entryType = this.getModel().getEntryEntity("entryentity").getDynamicObjectType();
        DynamicObjectCollection entryColl = this.getModel().getEntryEntity("entryentity");
        entryColl.clear();
        int index = 0;
        for (EntityType value : allEntities.values()) {
            for (IDataEntityProperty property : value.getProperties()) {
                if (property instanceof LongProp || property instanceof EntryProp) continue;
                DynamicObject entryObj = new DynamicObject(entryType);
                String number = property.getName();
                String localeValue = property.getDisplayName().getLocaleValue();
                if (StringUtils.isBlank((CharSequence)localeValue) || StringUtils.isBlank((CharSequence)number)) {
                    ++index;
                    continue;
                }
                entryObj.set("number", (Object)number);
                entryObj.set("name", (Object)localeValue);
                if (property instanceof BasedataProp) {
                    String displayProp = ((BasedataProp)property).getDisplayProp();
                    entryObj.set("showtype", (Object)DisplayProp.getDisplayProp((String)displayProp));
                    entryObj.set("type", (Object)3);
                } else if (property instanceof AmountProp) {
                    entryObj.set("type", (Object)2);
                } else if (property instanceof BooleanProp) {
                    entryObj.set("type", (Object)4);
                } else if (property instanceof DateTimeProp) {
                    entryObj.set("type", (Object)5);
                } else {
                    entryObj.set("type", (Object)1);
                }
                formMeta.getItems().stream().filter(ctl -> ctl.getKey().equals(number)).findFirst().ifPresent(ctl -> {
                    String parentCtlId = ctl.getParentId();
                    ControlAp parentCtl = formMeta.getItem(parentCtlId);
                    if (parentCtl != null) {
                        entryObj.set("groupname", (Object)parentCtl.getName().getLocaleValue());
                    }
                });
                entryColl.add((Object)entryObj);
                ++index;
            }
        }
        this.getModel().updateEntryCache(entryColl);
        this.getView().updateView("entryentity");
    }

    public void returnDataToParent() {
        ArrayList para = new ArrayList();
        IFormView view = this.getView();
        Map customParams = view.getFormShowParameter().getCustomParams();
        int index = (Integer)customParams.get("index");
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        int[] selectRows = entryGrid.getSelectRows();
        DynamicObjectCollection entity = this.getModel().getEntryEntity("entryentity");
        if (selectRows != null && selectRows.length > 0) {
            for (int selectRow : selectRows) {
                DynamicObject dynamicRow = (DynamicObject)entity.get(selectRow);
                HashMap<String, String> rowInfo = new HashMap<String, String>(10);
                rowInfo.put("index", String.valueOf(index++));
                rowInfo.put("fieldname", dynamicRow.getString("name"));
                rowInfo.put("fieldnumber", dynamicRow.getString("number"));
                rowInfo.put("fieldtype", dynamicRow.getString("type"));
                rowInfo.put("displayprop", dynamicRow.getString("showtype"));
                rowInfo.put("groupname", dynamicRow.getString("groupname"));
                para.add(rowInfo);
            }
        }
        view.returnDataToParent(para);
        view.close();
    }
}

