/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.bos.util.ExceptionUtils;
import kd.fi.evp.common.cache.CacheHelper;
import kd.fi.evp.common.cache.CacheModule;
import kd.fi.evp.common.cache.DistributeCache;
import kd.fi.evp.common.util.ArchiveUtils;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.common.util.SysConfigUtil;
import kd.fi.evp.engine.ArchiveEngineImpl;
import kd.fi.evp.engine.BuildEvoucherEngineImpl;
import kd.fi.evp.entity.ArchiveLogVo;
import kd.fi.evp.entity.ExecResult;
import kd.fi.evp.entity.ExportTaskVo;
import kd.fi.evp.formplugin.OrgBookFillService;

public class ExportPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final Log log = LogFactory.getLog(ExportPlugin.class);
    private static ThreadPool threadPoolCash = ThreadPools.newFixedThreadPool((String)"fi/evp/BuildEvoucherEngineImpl", (int)5);
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"fi/evp/exportzip", (int)2);
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.export);
    private String appId = AppMetadataCache.getAppInfo((String)"evp").getId();
    public static final String IS_FINISH = "isFinish";
    public static final String ERROR_MSG = "errorMsg";
    public static final String PAGEID = "pageid";
    private static final String ENTITY = "evp_export";
    private static final String ELEVOUCHERTYPE = "elevouchertype";
    private static final String EXPORT = "exportzip";
    private static final String ARCHIVE = "archivezip";
    private static final String ORGS = "orgs";
    private static final String BOOKTYPE = "booktype";
    private static final String PERIODTYPE = "periodtype";
    private static final String STARTPERIOD = "startperiod";
    private static final String ENDPERIOD = "endperiod";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String RECONDATE = "recondate";
    private OrgBookFillService periodFillService;

    public void setView(IFormView formView) {
        super.setView(formView);
        this.periodFillService = new OrgBookFillService(ORGS, BOOKTYPE, PERIODTYPE, STARTPERIOD, ENDPERIOD);
        this.periodFillService.init(formView).setDateKey(STARTDATE, ENDDATE);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.addProgressListener((ProgresssListener)this);
        this.addClickListeners(new String[]{EXPORT});
        this.addClickListeners(new String[]{ARCHIVE});
        this.periodFillService.registerOrgSelectListener();
        this.periodFillService.registerBookTypeSelectListener();
        this.periodFillService.registerPeriodTypeSelectListener();
        this.periodFillService.registerPeriodSelectListener();
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.getPageCache().put(PAGEID, this.getView().getPageId());
        DynamicObject dyn = QueryServiceHelper.queryOne((String)"evp_elevouchertype", (String)"id", (QFilter[])new QFilter("elevchid", "=", (Object)"bker").toArray());
        this.getModel().setValue(ELEVOUCHERTYPE, (Object)new Long[]{dyn.getLong("id")});
        this.periodFillService.setDefaultVal();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"labelap"});
        this.calculateOrgCount(((DynamicObjectCollection)this.getModel().getValue(ORGS)).size());
        this.changeVisibleByBillType();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (key) {
            case "elevouchertype": {
                DynamicObjectCollection billTypes = (DynamicObjectCollection)newValue;
                if (billTypes == null || billTypes.size() <= 0) break;
                this.changeVisibleByBillType();
                if (!this.isbkrs()) break;
                Date now = new Date();
                Date firstMonthDay = DateFomatUtils.getFirstMonthDay((Date)now);
                this.getModel().setValue(STARTDATE, (Object)firstMonthDay);
                this.getModel().setValue(ENDDATE, (Object)firstMonthDay);
                break;
            }
            case "orgs": {
                DynamicObjectCollection orgdyns = (DynamicObjectCollection)this.getModel().getValue(ORGS);
                if (orgdyns.isEmpty()) break;
                List<Long> orgs = orgdyns.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                this.periodFillService.setValByOrg(orgs);
                this.calculateOrgCount(((DynamicObjectCollection)this.getModel().getValue(ORGS)).size());
                break;
            }
            case "periodtype": 
            case "startperiod": 
            case "endperiod": 
            case "startdate": 
            case "enddate": {
                this.periodFillService.propertyChanged(key, newValue);
                break;
            }
            case "booktype": {
                this.getModel().setValue(PERIODTYPE, null);
                this.getModel().setValue(STARTPERIOD, null);
                this.getModel().setValue(ENDPERIOD, null);
                break;
            }
        }
    }

    private boolean isbkrs() {
        if (this.getModel().getValue(ELEVOUCHERTYPE) == null) {
            return false;
        }
        DynamicObjectCollection evtCol = (DynamicObjectCollection)this.getModel().getValue(ELEVOUCHERTYPE);
        List tableNames = evtCol.stream().map(o -> o.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
        return tableNames.size() == 1 && "evp_bkrs".equals(tableNames.get(0));
    }

    private boolean isNotbkrs() {
        if (this.getModel().getValue(ELEVOUCHERTYPE) == null) {
            return true;
        }
        DynamicObjectCollection evtCol = (DynamicObjectCollection)this.getModel().getValue(ELEVOUCHERTYPE);
        List tableNames = evtCol.stream().map(o -> o.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
        return tableNames.size() >= 1 && !tableNames.contains("evp_bkrs");
    }

    private void changeVisibleByBillType() {
        if (this.isbkrs()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{BOOKTYPE, PERIODTYPE, STARTPERIOD, ENDPERIOD});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{STARTDATE, ENDDATE});
        } else if (this.isNotbkrs()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BOOKTYPE, PERIODTYPE, STARTPERIOD, ENDPERIOD});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{STARTDATE, ENDDATE});
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u94f6\u884c\u5bf9\u8d26\u5355\u548c\u5176\u4ed6\u7535\u5b50\u51ed\u8bc1\u4e0d\u80fd\u4e00\u8d77\u751f\u6210\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u3002", (String)"ExportPlugin_11", (String)"fi-evp-common", (Object[])new Object[0]));
            this.getModel().setValue(ELEVOUCHERTYPE, null);
            this.getView().setVisible(Boolean.valueOf(true), new String[]{BOOKTYPE, PERIODTYPE, STARTPERIOD, ENDPERIOD});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{STARTDATE, ENDDATE});
        }
    }

    public void onProgress(ProgressEvent arg0) {
        String pageId = this.getPageCache().get(PAGEID);
        boolean isFinish = Boolean.parseBoolean(this.cache.get(pageId + IS_FINISH));
        if (isFinish) {
            String errorMsg = this.cache.get(pageId + ERROR_MSG);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                this.getView().showTipNotification(errorMsg);
            } else {
                if (EXPORT.equals(this.getPageCache().get("opdesc"))) {
                    if (this.cache.get(pageId + "ziplist") != null) {
                        String listjson = this.cache.get(pageId + "ziplist");
                        List ziplist = (List)SerializationUtils.fromJsonString((String)listjson, List.class);
                        TempFileCache filecache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                        String endurl = "";
                        endurl = ziplist.size() == 1 ? (String)ziplist.get(0) : filecache.compress(DateFomatUtils.getDateString((Date)new Date(), (String)"yyyyMMddHHmmssSSS") + ".zip", ziplist.toArray(new String[0]), 7200);
                        this.getView().openUrl(endurl);
                    }
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"ExportPlugin_14", (String)"fi-evp-common", (Object[])new Object[0]), Integer.valueOf(20000));
                }
                if (ARCHIVE.equals(this.getPageCache().get("opdesc")) && this.cache.get(pageId + "allcount") != null) {
                    String allcount = this.cache.get(pageId + "allcount");
                    if (this.cache.get(pageId + "errorCnt") != null) {
                        String errcnt = this.cache.get(pageId + "errorCnt");
                        int totalcount = Integer.parseInt(allcount) - Integer.parseInt(errcnt);
                        String string = String.format(ResManager.loadKDString((String)"\u672c\u6b21\u5f52\u6863\u6570\u636e\u5171%1$s\u6761\uff0c\u6210\u529f%2$s\u6761\u3002", (String)"ExportPlugin_16", (String)"fi-evp-common", (Object[])new Object[0]), allcount, Integer.toString(totalcount));
                        this.getView().showSuccessNotification(string, Integer.valueOf(50000));
                    } else {
                        String string = String.format(ResManager.loadKDString((String)"\u5f52\u6863\u6210\u529f%s\u6761\u3002", (String)"ExportPlugin_15", (String)"fi-evp-common", (Object[])new Object[0]), allcount);
                        this.getView().showSuccessNotification(string, Integer.valueOf(50000));
                    }
                }
            }
            this.stopProgressBar();
        }
    }

    private void stopProgressBar() {
        ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
        bar.stop();
        String pageId = this.getPageCache().get(PAGEID);
        this.cache.remove(pageId + IS_FINISH);
        this.cache.remove(pageId + ERROR_MSG);
        this.cache.remove(pageId + "ziplist");
        this.setPage(true);
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        boolean isbkrs = this.isbkrs();
        if (!this.checkParam(isbkrs)) {
            return;
        }
        if (EXPORT.equals(key)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u5165\u6c60\u6570\u636e\u624d\u80fd\u751f\u6210zip\u6587\u4ef6\uff0c\u8bf7\u786e\u8ba4\u539f\u59cb\u6570\u636e\u662f\u5426\u5df2\u5165\u6c60\u3002", (String)"ExportPlugin_4", (String)"fi-evp-common", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(EXPORT));
        }
        if (ARCHIVE.equals(key)) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u53ea\u80fd\u5f52\u6863\u5df2\u5165\u6c60\u6570\u636e\u4e14\u5f52\u6863\u540e\u4e0d\u80fd\u5220\u9664\u3002", (String)"ExportPlugin_5", (String)"fi-evp-common", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener(ARCHIVE));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        final String pageId = this.getPageCache().get(PAGEID);
        final String key = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if (MessageBoxResult.Yes.equals((Object)result)) {
            this.showkey(key);
            this.setPage(false);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    String err = null;
                    try {
                        if (ExportPlugin.EXPORT.equals(key)) {
                            ExportPlugin.this.getPageCache().put("opdesc", ExportPlugin.EXPORT);
                            err = ExportPlugin.this.isbkrs() ? ExportPlugin.this.splitBkrsAndoutOutput() : ExportPlugin.this.splitAndoutOutput();
                        }
                        if (ExportPlugin.ARCHIVE.equals(key)) {
                            ExportPlugin.this.getPageCache().put("opdesc", ExportPlugin.ARCHIVE);
                            String archiveclass = SysConfigUtil.getString((String)"archiveclass");
                            if (StringUtils.isBlank((CharSequence)archiveclass)) {
                                err = ResManager.loadKDString((String)"\u8bf7\u5728\u3010\u53c2\u6570\u7ef4\u62a4-\u7535\u5b50\u51ed\u8bc1\u6c60\u3011\u7ef4\u62a4\u5f52\u6863\u5b9e\u73b0\u7c7b\u3002", (String)"ExportPlugin_9", (String)"fi-evp-common", (Object[])new Object[0]);
                                ExportPlugin.this.cache.put(pageId + ExportPlugin.IS_FINISH, "true");
                                ExportPlugin.this.cache.put(pageId + ExportPlugin.ERROR_MSG, err);
                                return;
                            }
                            err = ExportPlugin.this.isbkrs() ? ExportPlugin.this.archiveBkrs() : ExportPlugin.this.archiveTicket();
                        }
                        ExportPlugin.this.cache.put(pageId + ExportPlugin.IS_FINISH, "true");
                        ExportPlugin.this.cache.put(pageId + ExportPlugin.ERROR_MSG, err);
                    }
                    catch (Exception e) {
                        ExportPlugin.this.cache.put(pageId + ExportPlugin.IS_FINISH, "true");
                        ExportPlugin.this.cache.put(pageId + ExportPlugin.ERROR_MSG, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    }
                }
            };
            threadPool.execute((Runnable)thread);
            ProgressBar bar = (ProgressBar)this.getView().getControl("progressbarap");
            bar.start();
        }
    }

    private void setPage(boolean finish) {
        this.getView().setEnable(Boolean.valueOf(finish), new String[]{EXPORT, ARCHIVE});
        this.getView().setVisible(Boolean.valueOf(!finish), new String[]{"labelap"});
    }

    private String splitAndoutOutput() {
        StringBuilder err = new StringBuilder();
        DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue(ORGS);
        Long startPeriodId = (Long)this.getModel().getValue("startperiod_id");
        Long endPeriodId = (Long)this.getModel().getValue("endperiod_id");
        DynamicObjectCollection evtCol = (DynamicObjectCollection)this.getModel().getValue(ELEVOUCHERTYPE);
        List<String> entityNames = evtCol.stream().map(o -> o.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
        ArrayList<Future> resultList = new ArrayList<Future>(16);
        Long booktTypeId = (Long)this.getModel().getValue("booktype_id");
        Long periodTypeId = (Long)this.getModel().getValue("periodtype_id");
        int allcount = 0;
        for (DynamicObject dynamicObject : orgCol) {
            Long orgid = dynamicObject.getDynamicObject("fbasedataid").getLong("id");
            List<Long> periodIds = ExportPlugin.getPeriodIds(startPeriodId, endPeriodId, periodTypeId);
            for (Long periodId : periodIds) {
                ExportTaskVo exportTaskVo = this.buildTask(entityNames, orgid, booktTypeId, periodId);
                int tempcount = exportTaskVo.getInvoiceNum();
                allcount += tempcount;
                if (tempcount <= 0 || exportTaskVo.getInvoiceNum() <= 0) continue;
                Future future = threadPoolCash.submit((Callable)new BuildEvoucherEngineImpl(exportTaskVo));
                resultList.add(future);
            }
        }
        if (allcount == 0) {
            return err.append(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ExportPlugin_13", (String)"fi-evp-common", (Object[])new Object[0])).toString();
        }
        for (Future taskResult : resultList) {
            try {
                if (((ExecResult)taskResult.get()).getIsSuccess().booleanValue()) continue;
                err.append(((ExecResult)taskResult.get()).getErrMsg());
                log.error(((ExecResult)taskResult.get()).getErrMsg() + "--" + ((ExecResult)taskResult.get()).getErrIds());
            }
            catch (Exception exception) {}
        }
        return err.toString();
    }

    private String splitBkrsAndoutOutput() {
        StringBuilder err = new StringBuilder();
        DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue(ORGS);
        Date startdate = (Date)this.getModel().getValue(STARTDATE);
        Date endate = (Date)this.getModel().getValue(ENDDATE);
        startdate = DateFomatUtils.getFirstMonthDay((Date)startdate);
        endate = DateFomatUtils.getLastMonthDay((Date)endate);
        Map dateMap = DateFomatUtils.getIntervalTimeByMonth((Date)startdate, (Date)endate);
        ArrayList<Future> resultList = new ArrayList<Future>(16);
        int allcount = 0;
        for (DynamicObject dynamicObject : orgCol) {
            Long orgid = dynamicObject.getDynamicObject("fbasedataid").getLong("id");
            for (Map.Entry entry : dateMap.entrySet()) {
                ExportTaskVo exportTaskVo = this.buildBkrsTask((Date)entry.getKey(), (Date)entry.getValue(), orgid);
                allcount += exportTaskVo.getBkrsnum().intValue();
                if (exportTaskVo.getBkrsnum() <= 0) continue;
                Future future = threadPoolCash.submit((Callable)new BuildEvoucherEngineImpl(exportTaskVo));
                resultList.add(future);
            }
        }
        if (allcount == 0) {
            err.append(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"ExportPlugin_10", (String)"fi-evp-common", (Object[])new Object[0]));
            return err.toString();
        }
        for (Future taskResult : resultList) {
            try {
                if (((ExecResult)taskResult.get()).getIsSuccess().booleanValue()) continue;
                err.append(((ExecResult)taskResult.get()).getErrMsg());
                log.error(((ExecResult)taskResult.get()).getErrMsg() + "--" + ((ExecResult)taskResult.get()).getErrIds());
            }
            catch (Exception exception) {}
        }
        return err.toString();
    }

    private String archiveTicket() {
        StringBuilder err = new StringBuilder();
        DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue(ORGS);
        Long startPeriodId = (Long)this.getModel().getValue("startperiod_id");
        Long endPeriodId = (Long)this.getModel().getValue("endperiod_id");
        DynamicObjectCollection evtCol = (DynamicObjectCollection)this.getModel().getValue(ELEVOUCHERTYPE);
        List entityNames = evtCol.stream().map(o -> o.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
        ArrayList<Future> resultList = new ArrayList<Future>(16);
        Long booktTypeId = (Long)this.getModel().getValue("booktype_id");
        String booktTypeName = ((DynamicObject)this.getModel().getValue(BOOKTYPE)).getString("name");
        String booktTypeNumber = ((DynamicObject)this.getModel().getValue(BOOKTYPE)).getString("number");
        Long periodTypeId = (Long)this.getModel().getValue("periodtype_id");
        int allcount = 0;
        for (DynamicObject dynamicObject : orgCol) {
            Long orgid = dynamicObject.getDynamicObject("fbasedataid").getLong("id");
            String orgnumber = dynamicObject.getDynamicObject("fbasedataid").getString("number");
            String orgname = dynamicObject.getDynamicObject("fbasedataid").getString("name");
            List<Long> periodIds = ExportPlugin.getPeriodIds(startPeriodId, endPeriodId, periodTypeId);
            for (Long periodId : periodIds) {
                ArchiveLogVo archiveLogVo = ArchiveUtils.buildTicketTask((Long)booktTypeId, (Long)periodId, entityNames, (Long)orgid, (String)orgnumber, (String)orgname);
                archiveLogVo.setPageId(this.getPageCache().get(PAGEID));
                archiveLogVo.setCurrentid(ArchiveUtils.saveArchiveLog((ArchiveLogVo)archiveLogVo));
                archiveLogVo.setBooktypeid(booktTypeId);
                archiveLogVo.setBooktypename(booktTypeName);
                archiveLogVo.setBooktypenumber(booktTypeNumber);
                allcount += archiveLogVo.getAllcount();
                if (archiveLogVo.getAllcount() <= 0) continue;
                Future future = threadPoolCash.submit((Callable)new ArchiveEngineImpl(archiveLogVo));
                resultList.add(future);
            }
        }
        if (allcount == 0) {
            return err.append(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5f52\u6863\u7684\u6570\u636e\u3002", (String)"ExportPlugin_12", (String)"fi-evp-common", (Object[])new Object[0])).toString();
        }
        for (Future taskResult : resultList) {
            try {
                if (((ExecResult)taskResult.get()).getIsSuccess().booleanValue()) continue;
                err.append(((ExecResult)taskResult.get()).getErrMsg());
                log.error(((ExecResult)taskResult.get()).getErrMsg() + "--" + ((ExecResult)taskResult.get()).getErrIds());
            }
            catch (Exception exception) {}
        }
        return err.toString();
    }

    private String archiveBkrs() {
        StringBuilder err = new StringBuilder();
        DynamicObjectCollection orgCol = (DynamicObjectCollection)this.getModel().getValue(ORGS);
        Date startdate = (Date)this.getModel().getValue(STARTDATE);
        Date endate = (Date)this.getModel().getValue(ENDDATE);
        startdate = DateFomatUtils.getFirstMonthDay((Date)startdate);
        endate = DateFomatUtils.getLastMonthDay((Date)endate);
        Map dateMap = DateFomatUtils.getIntervalTimeByMonth((Date)startdate, (Date)endate);
        ArrayList<Future> resultList = new ArrayList<Future>(16);
        int allcount = 0;
        for (DynamicObject dynamicObject : orgCol) {
            String orgnumber = dynamicObject.getDynamicObject("fbasedataid").getString("number");
            Long orgid = dynamicObject.getDynamicObject("fbasedataid").getLong("id");
            String orgname = dynamicObject.getDynamicObject("fbasedataid").getString("name");
            for (Map.Entry entry : dateMap.entrySet()) {
                ArchiveLogVo archiveLogVo = ArchiveUtils.buildBkrsTask((Date)((Date)entry.getKey()), (Date)((Date)entry.getValue()), (Long)orgid, (String)orgnumber, (String)orgname);
                archiveLogVo.setPageId(this.getPageCache().get(PAGEID));
                archiveLogVo.setCurrentid(ArchiveUtils.saveArchiveLog((ArchiveLogVo)archiveLogVo));
                allcount += archiveLogVo.getAllcount();
                if (archiveLogVo.getAllcount() <= 0) continue;
                Future future = threadPoolCash.submit((Callable)new ArchiveEngineImpl(archiveLogVo));
                resultList.add(future);
            }
        }
        if (allcount == 0) {
            err.append(ResManager.loadKDString((String)"\u6682\u65e0\u9700\u8981\u5f52\u6863\u7684\u6570\u636e\u3002", (String)"ExportPlugin_12", (String)"fi-evp-common", (Object[])new Object[0]));
            return err.toString();
        }
        for (Future taskResult : resultList) {
            try {
                if (((ExecResult)taskResult.get()).getIsSuccess().booleanValue()) continue;
                err.append(((ExecResult)taskResult.get()).getErrMsg());
                log.error(((ExecResult)taskResult.get()).getErrMsg() + "--" + ((ExecResult)taskResult.get()).getErrIds());
            }
            catch (Exception exception) {}
        }
        return err.toString();
    }

    private ExportTaskVo buildTask(List<String> entityNames, Long orgid, Long booktTypeId, Long periodId) {
        ExportTaskVo exportTaskVo = new ExportTaskVo();
        exportTaskVo.setPageid(this.getPageCache().get(PAGEID));
        exportTaskVo.setNumber(Long.toString(DBServiceHelper.genGlobalLongId()));
        exportTaskVo.setOrg(orgid);
        exportTaskVo.setBooktype(booktTypeId);
        exportTaskVo.setPeriod(periodId);
        exportTaskVo.setCreatetime(new Date());
        exportTaskVo.setCreator(Long.valueOf(RequestContext.get().getCurrUserId()));
        HashSet<Object> sourcevIds = new HashSet<Object>(16);
        QFilter qFilter = new QFilter("isintopool", "=", (Object)"1");
        QFilter qFilter1 = new QFilter("period", "=", (Object)periodId);
        QFilter qFilter2 = new QFilter("isdelete", "=", (Object)"0");
        QFilter qFilter3 = new QFilter("org", "=", (Object)orgid);
        QFilter qFilter4 = new QFilter(BOOKTYPE, "=", (Object)booktTypeId);
        try (DataSet set = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"evp_voucher", (String)"billid", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3, qFilter4}, null);){
            if (set != null) {
                for (Row row : set) {
                    sourcevIds.add(row.get("billid"));
                }
            }
        }
        HashMap<String, Map> invoiceMap = new HashMap<String, Map>(16);
        QFilter invoiceFilter = new QFilter("voucherid", "in", sourcevIds);
        for (String entityName : entityNames) {
            DataSet set = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)entityName, (String)"voucherid, billid", (QFilter[])new QFilter[]{qFilter, invoiceFilter, qFilter2}, null);
            Throwable throwable = null;
            try {
                if (set == null) continue;
                for (Row row : set) {
                    invoiceMap.computeIfAbsent(entityName, value -> new HashMap()).put(row.get("billid"), row.get("voucherid"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (set == null) continue;
                if (throwable != null) {
                    try {
                        set.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                set.close();
            }
        }
        exportTaskVo.setVoucherids(sourcevIds);
        exportTaskVo.setInvoicemap(invoiceMap);
        exportTaskVo.setVouchernum(Integer.valueOf(sourcevIds.size()));
        exportTaskVo.setAtrnum(Integer.valueOf(invoiceMap.get("evp_atrreceiver") == null ? 0 : ((Map)invoiceMap.get("evp_atrreceiver")).size()));
        exportTaskVo.setRainum(Integer.valueOf(invoiceMap.get("evp_raireceiver") == null ? 0 : ((Map)invoiceMap.get("evp_raireceiver")).size()));
        exportTaskVo.setInvordnum(Integer.valueOf(invoiceMap.get("evp_invordreceiver") == null ? 0 : ((Map)invoiceMap.get("evp_invordreceiver")).size()));
        exportTaskVo.setInvspclnum(Integer.valueOf(invoiceMap.get("evp_invspclreceiver") == null ? 0 : ((Map)invoiceMap.get("evp_invspclreceiver")).size()));
        exportTaskVo.setEinvordnum(Integer.valueOf(invoiceMap.get("evp_einvordreceiver") == null ? 0 : ((Map)invoiceMap.get("evp_einvordreceiver")).size()));
        exportTaskVo.setEinvspclnum(Integer.valueOf(invoiceMap.get("evp_einvspclreceiver") == null ? 0 : ((Map)invoiceMap.get("evp_einvspclreceiver")).size()));
        exportTaskVo.setInvtlnum(Integer.valueOf(invoiceMap.get("evp_invtlfreceiver") == null ? 0 : ((Map)invoiceMap.get("evp_invtlfreceiver")).size()));
        exportTaskVo.setNtrenum(Integer.valueOf(invoiceMap.get("evp_ntrevgpmreceiver") == null ? 0 : ((Map)invoiceMap.get("evp_ntrevgpmreceiver")).size()));
        exportTaskVo.setEfinum(Integer.valueOf(invoiceMap.get("evp_efi") == null ? 0 : ((Map)invoiceMap.get("evp_efi")).size()));
        exportTaskVo.setBkernum(Integer.valueOf(invoiceMap.get("evp_bkerreceiver") == null ? 0 : ((Map)invoiceMap.get("evp_bkerreceiver")).size()));
        return exportTaskVo;
    }

    private ExportTaskVo buildBkrsTask(Date startdate, Date enddate, Long orgid) {
        ExportTaskVo exportTaskVo = new ExportTaskVo();
        exportTaskVo.setPageid(this.getPageCache().get(PAGEID));
        exportTaskVo.setNumber(Long.toString(DBServiceHelper.genGlobalLongId()));
        exportTaskVo.setOrg(orgid);
        exportTaskVo.setCreatetime(new Date());
        exportTaskVo.setCreator(Long.valueOf(RequestContext.get().getCurrUserId()));
        HashSet<Object> bkrsIds = new HashSet<Object>(16);
        QFilter qFilter = new QFilter("isintopool", "=", (Object)"1");
        QFilter qFilter3 = new QFilter("isdelete", "=", (Object)"0");
        QFilter qFilter1 = new QFilter(RECONDATE, ">=", (Object)startdate);
        QFilter qFilter2 = new QFilter(RECONDATE, "<", (Object)enddate);
        QFilter qFilter4 = new QFilter("org", "=", (Object)orgid);
        try (DataSet set = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"evp_bkrs", (String)"billid", (QFilter[])new QFilter[]{qFilter, qFilter1, qFilter2, qFilter3, qFilter4}, null);){
            if (set != null) {
                for (Row row : set) {
                    bkrsIds.add(row.get("billid"));
                }
            }
        }
        exportTaskVo.setBookdate(startdate);
        exportTaskVo.setRecondate(startdate);
        exportTaskVo.setBkrsids(bkrsIds);
        exportTaskVo.setBkrsnum(Integer.valueOf(bkrsIds.size()));
        return exportTaskVo;
    }

    private static List<Long> getPeriodIds(Long startPeriodId, Long endPeriod, Long periodTypeId) {
        ArrayList<Long> periodIds = new ArrayList<Long>();
        String algoKey = "kd.fi.evp.formplugin.ExportPlugin.getPeriodIds";
        QFilter[] filters = new QFilter[]{new QFilter("id", ">=", (Object)startPeriodId), new QFilter("id", "<=", (Object)endPeriod), new QFilter(PERIODTYPE, "=", (Object)periodTypeId)};
        try (DataSet set = QueryServiceHelper.queryDataSet((String)algoKey, (String)"bd_period", (String)"id", (QFilter[])filters, (String)"id");){
            for (Row row : set) {
                periodIds.add(row.getLong("id"));
            }
        }
        return periodIds;
    }

    private void showkey(String key) {
        if (EXPORT.equals(key)) {
            ((Label)this.getControl("labelap")).setText(ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u51fa\uff0c\u8bf7\u7a0d\u5019...", (String)"ExportPlugin_18", (String)"fi-evp-common", (Object[])new Object[0]));
        }
        if (ARCHIVE.equals(key)) {
            ((Label)this.getControl("labelap")).setText(ResManager.loadKDString((String)"\u6b63\u5728\u5f52\u6863\uff0c\u8bf7\u7a0d\u5019...", (String)"ExportPlugin_19", (String)"fi-evp-common", (Object[])new Object[0]));
        }
    }

    private void calculateOrgCount(int param) {
        String homeSuffix = ResManager.loadKDString((String)"\u5bb6", (String)"ExportPlugin_17", (String)"fi-evp-common", (Object[])new Object[0]);
        ((Label)this.getControl("total")).setText(param + homeSuffix);
    }

    private boolean checkParam(boolean isbkrs) {
        IDataModel model = this.getView().getModel();
        DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue(ORGS);
        DynamicObjectCollection eletypes = (DynamicObjectCollection)model.getValue(ELEVOUCHERTYPE);
        if (null == orgs || orgs.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"ExportPlugin_7", (String)"fi-evp-common", (Object[])new Object[0]));
            return false;
        }
        if (null == eletypes || eletypes.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7535\u5b50\u51ed\u8bc1\u7c7b\u578b\u3002", (String)"ExportPlugin_8", (String)"fi-evp-common", (Object[])new Object[0]));
            return false;
        }
        if (isbkrs) {
            if (this.getModel().getValue(STARTDATE) == null || this.getModel().getValue(ENDDATE) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5bf9\u8d26\u5355\u6708\u4efd\u3002", (String)"ExportPlugin_1", (String)"fi-evp-common", (Object[])new Object[0]));
                return false;
            }
        } else {
            DynamicObject bookType = (DynamicObject)model.getValue(BOOKTYPE);
            if (null == bookType) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"ExportPlugin_6", (String)"fi-evp-common", (Object[])new Object[0]));
                return false;
            }
            DynamicObject periodType = (DynamicObject)model.getValue(PERIODTYPE);
            if (null == periodType) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u7c7b\u578b\u3002", (String)"ExportPlugin_2", (String)"fi-evp-common", (Object[])new Object[0]));
                return false;
            }
            if (this.getModel().getValue(STARTPERIOD) == null || this.getModel().getValue(ENDPERIOD) == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u671f\u95f4\u3002", (String)"ExportPlugin_3", (String)"fi-evp-common", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }
}

