/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.common.util.FileUtils;

public class ExportZipListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(ExportZipListPlugin.class);
    private static final String EXPORTALL = "exportall";
    private static final String ENTITY = "evp_exporttask";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{EXPORTALL});
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        super.itemClick(evt);
        switch (key = evt.getItemKey()) {
            case "exportall": {
                this.export();
                break;
            }
        }
    }

    private void export() {
        ListSelectedRowCollection listSelectedRows = ((ListView)this.getView()).getSelectedRows();
        if (listSelectedRows.size() <= 0) {
            return;
        }
        ArrayList<Object> list = new ArrayList<Object>(16);
        for (ListSelectedRow listSelectedRow : listSelectedRows) {
            list.add(listSelectedRow.getPrimaryKeyValue());
        }
        List<DynamicObject> dyns = this.findurls(ENTITY, list);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        List zipurls = dyns.stream().map(o -> o.getString("zipurl")).collect(Collectors.toList());
        Map attachname = FileUtils.getattachName((String)ENTITY, zipurls);
        ArrayList<String> urls = new ArrayList<String>(16);
        String endurl = "";
        try {
            for (String string : zipurls) {
                byte[] bytes = FileUtils.downLoadHttpsFile((String)string);
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                String url = cache.saveAsUrl((String)attachname.get(string), (InputStream)inputStream, 60);
                urls.add(url);
            }
            endurl = cache.compress(DateFomatUtils.getDateString((Date)new Date(), (String)"yyyyMMddHHmmssSSS") + ".zip", urls.toArray(new String[0]), 7200);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"ExportZipListPlugin_1", (String)"fi-evp-common", (Object[])new Object[0]));
            return;
        }
        this.getView().openUrl(endurl);
    }

    private List<DynamicObject> findurls(String entity, List<Object> list) {
        ArrayList<DynamicObject> returnlist = new ArrayList<DynamicObject>(16);
        QFilter qFilter = new QFilter("id", "in", list);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)entity, (String)"id,zipurl,org.number orgnumber,status", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject dynamicObject : dyns) {
            if (!"1".equals(dynamicObject.getString("status"))) continue;
            returnlist.add(dynamicObject);
        }
        return returnlist;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        String hyperLinkName = args.getHyperLinkClickEvent().getFieldName();
        ListSelectedRow currentRow = ((ListView)this.getView()).getCurrentSelectedRowInfo();
        Object pkObject = currentRow.getPrimaryKeyValue();
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkObject, (String)ENTITY);
        TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        switch (hyperLinkName) {
            case "zipurl": {
                String zipurl = dynamicObject.getString("zipurl");
                byte[] bytes = null;
                try {
                    bytes = FileUtils.downLoadHttpsFile((String)zipurl);
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\u3002", (String)"ExportZipListPlugin_1", (String)"fi-evp-common", (Object[])new Object[0]));
                    return;
                }
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                Map attachname = FileUtils.getattachName((String)ENTITY, Collections.singletonList(zipurl));
                String url = cache.saveAsUrl((String)attachname.get(zipurl), (InputStream)inputStream, 60);
                this.getView().openUrl(url);
                break;
            }
        }
        args.setCancel(true);
    }
}

