/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.MulBasedataEdit;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.evp.common.util.AccountingSysUtil;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.formplugin.util.OrgBookInfoFillUtil;

public class OrgBookFillService {
    private String orgKey;
    private String bookTypeKey;
    private String periodTypeKey;
    private String startPeriodKey;
    private String endPeriodKey;
    private String startDateKey;
    private String endDateKey;
    private IFormView formView;
    private IDataModel dataModel;
    private boolean isMultiOrg = false;

    public OrgBookFillService(String orgKey, String bookTypeKey, String periodTypeKey, String periodKey) {
        this.orgKey = orgKey;
        this.bookTypeKey = bookTypeKey;
        this.periodTypeKey = periodTypeKey;
        this.startPeriodKey = periodKey;
    }

    public OrgBookFillService(String orgKey, String bookTypeKey, String periodTypeKey, String startPeriodKey, String endPeriodKey) {
        this.orgKey = orgKey;
        this.bookTypeKey = bookTypeKey;
        this.periodTypeKey = periodTypeKey;
        this.startPeriodKey = startPeriodKey;
        this.endPeriodKey = endPeriodKey;
    }

    public void setDateKey(String startDateKey, String endDateKey) {
        this.startDateKey = startDateKey;
        this.endDateKey = endDateKey;
    }

    public OrgBookFillService init(IFormView formView) {
        this.formView = formView;
        this.dataModel = formView.getModel();
        BasedataEdit orgControl = (BasedataEdit)this.formView.getControl(this.orgKey);
        if (orgControl instanceof MulBasedataEdit) {
            this.isMultiOrg = true;
        }
        return this;
    }

    public void propertyChanged(String key, Object newValue) {
        if (key.equals(this.periodTypeKey)) {
            DynamicObject periodType = (DynamicObject)newValue;
            if (periodType == null) {
                this.dataModel.setValue(this.startPeriodKey, null);
                if (StringUtils.isNotEmpty((String)this.endPeriodKey)) {
                    this.dataModel.setValue(this.endPeriodKey, null);
                }
            } else {
                long periodId = OrgBookInfoFillUtil.getPeriodByCurrentDay(periodType.getLong("id"));
                if (periodId == 0L) {
                    this.dataModel.setValue(this.startPeriodKey, null);
                } else {
                    this.dataModel.setValue(this.startPeriodKey, (Object)periodId);
                }
                if (StringUtils.isNotEmpty((String)this.endPeriodKey)) {
                    this.dataModel.setValue(this.endPeriodKey, (Object)periodId);
                }
            }
        } else if (key.equals(this.startPeriodKey)) {
            if (newValue != null && StringUtils.isNotEmpty((String)this.endPeriodKey)) {
                long sp = ((DynamicObject)newValue).getLong("id");
                long ep = (Long)this.dataModel.getValue(this.endPeriodKey + "_id");
                if (ep == 0L || ep < sp) {
                    this.dataModel.setValue(this.endPeriodKey, (Object)sp);
                }
            } else {
                this.dataModel.setValue(this.endPeriodKey, null);
            }
        } else if (key.equals(this.endPeriodKey)) {
            if (newValue != null) {
                long endPeriod = ((DynamicObject)newValue).getLong("id");
                long startPeriod = (Long)this.dataModel.getValue(this.startPeriodKey + "_id");
                if (startPeriod == 0L || startPeriod > endPeriod) {
                    this.dataModel.setValue(this.startPeriodKey, (Object)endPeriod);
                }
            }
        } else if (key.equals(this.startDateKey)) {
            Date sd = (Date)newValue;
            if (sd != null) {
                Date ed = (Date)this.dataModel.getValue(this.endDateKey);
                if (ed == null) {
                    this.dataModel.setValue(this.endDateKey, (Object)sd);
                } else {
                    Date edfd;
                    Date sdfd = DateFomatUtils.getFirstMonthDay((Date)sd);
                    if (sdfd.compareTo(edfd = DateFomatUtils.getFirstMonthDay((Date)ed)) > 0) {
                        this.dataModel.setValue(this.endDateKey, (Object)sd);
                    }
                }
            }
        } else if (key.equals(this.endDateKey) && newValue != null) {
            Date ed = (Date)newValue;
            Date sd = (Date)this.dataModel.getValue(this.startDateKey);
            if (sd == null) {
                this.dataModel.setValue(this.startDateKey, (Object)ed);
            } else {
                Date edfd;
                Date sdfd = DateFomatUtils.getFirstMonthDay((Date)sd);
                if (sdfd.compareTo(edfd = DateFomatUtils.getFirstMonthDay((Date)ed)) > 0) {
                    this.dataModel.setValue(this.startDateKey, (Object)ed);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDefaultVal() {
        Object org = this.dataModel.getValue(this.orgKey);
        long orgId = 0L;
        if (org == null || org instanceof DynamicObjectCollection && CollectionUtils.isEmpty((Collection)((DynamicObjectCollection)org))) {
            HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"10", (String)this.formView.getFormShowParameter().getAppId(), (String)this.formView.getEntityId(), (String)"47150e89000000ac", (boolean)true);
            List orgList = allPermOrgs.getHasPermOrgs();
            if (orgList.size() == 0) {
                this.formView.showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5df2\u542f\u7528\u7684\u8d26\u7c3f\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8bbe\u7f6e", (String)"EvpHomePlugin_0", (String)"fi-gl-formplugin", (Object[])new Object[0]));
                return;
            }
            orgId = RequestContext.get().getOrgId();
            long l = orgId = orgList.contains(orgId) ? orgId : (Long)orgList.get(0);
            if (this.isMultiOrg) {
                this.dataModel.setValue(this.orgKey, (Object)new Long[]{orgId});
            } else {
                this.dataModel.setValue(this.orgKey, (Object)orgId);
            }
        } else if (this.isMultiOrg) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)org;
            if (orgs.size() != 1) return;
            DynamicObject orgDyn = (DynamicObject)orgs.get(0);
            orgId = orgDyn.getLong("fbasedataid");
            this.dataModel.setValue(this.orgKey, (Object)new Long[]{orgId});
        } else {
            DynamicObject orgDyn = (DynamicObject)org;
            orgId = orgDyn.getLong("id");
            this.dataModel.setValue(this.orgKey, (Object)orgId);
        }
        this.setValByOrg(orgId);
    }

    public void setValByOrg(long orgId) {
        Object[] defaultPeriodInfo = OrgBookInfoFillUtil.getDefaultPeriodInfo(orgId);
        if (defaultPeriodInfo != null) {
            if (StringUtils.isNotEmpty((String)this.bookTypeKey)) {
                this.dataModel.setValue(this.bookTypeKey, defaultPeriodInfo[0]);
            }
            this.dataModel.setValue(this.periodTypeKey, defaultPeriodInfo[1]);
            this.dataModel.setValue(this.startPeriodKey, defaultPeriodInfo[2]);
            if (StringUtils.isNotEmpty((String)this.endPeriodKey)) {
                this.dataModel.setValue(this.endPeriodKey, defaultPeriodInfo[2]);
            }
        }
    }

    public void setValByOrg(Collection<Long> orgIds) {
        Object[] defaultPeriodInfo = OrgBookInfoFillUtil.getDefaultPeriodInfo(orgIds);
        if (defaultPeriodInfo != null) {
            if (StringUtils.isNotEmpty((String)this.bookTypeKey)) {
                this.dataModel.setValue(this.bookTypeKey, defaultPeriodInfo[0]);
            }
            this.dataModel.setValue(this.periodTypeKey, defaultPeriodInfo[1]);
            this.dataModel.setValue(this.startPeriodKey, defaultPeriodInfo[2]);
            if (StringUtils.isNotEmpty((String)this.endPeriodKey)) {
                this.dataModel.setValue(this.endPeriodKey, defaultPeriodInfo[2]);
            }
        }
    }

    public void registerOrgSelectListener() {
        BasedataEdit orgEdit = (BasedataEdit)this.formView.getControl(this.orgKey);
        orgEdit.addBeforeF7SelectListener(evt -> {
            HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"10", (String)this.formView.getFormShowParameter().getAppId(), (String)this.formView.getEntityId(), (String)"47150e89000000ac");
            if (allPermOrgs.hasAllOrgPerm()) {
                return;
            }
            evt.getCustomQFilters().add(new QFilter("id", "in", (Object)allPermOrgs.getHasPermOrgs()));
        });
    }

    public void registerPeriodSelectListener() {
        BasedataEdit startPeriodEdit = (BasedataEdit)this.formView.getControl(this.startPeriodKey);
        startPeriodEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject periodType = (DynamicObject)this.dataModel.getValue(this.periodTypeKey);
            if (periodType != null) {
                evt.getCustomQFilters().add(new QFilter("periodtype", "=", (Object)periodType.getLong("id")));
            } else {
                evt.getCustomQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            }
        });
        if (this.endPeriodKey != null) {
            BasedataEdit endPeriodEdit = (BasedataEdit)this.formView.getControl(this.endPeriodKey);
            endPeriodEdit.addBeforeF7SelectListener(evt -> {
                DynamicObject periodType = (DynamicObject)this.dataModel.getValue(this.periodTypeKey);
                if (periodType != null) {
                    evt.getCustomQFilters().add(new QFilter("periodtype", "=", (Object)periodType.getLong("id")));
                } else {
                    evt.getCustomQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
                }
            });
        }
    }

    public void registerBookTypeSelectListener() {
        BasedataEdit bookTypeKeyEdit = (BasedataEdit)this.formView.getControl(this.bookTypeKey);
        bookTypeKeyEdit.addBeforeF7SelectListener(evt -> {
            DynamicObjectCollection orgdyns = (DynamicObjectCollection)this.dataModel.getValue(this.orgKey);
            if (orgdyns != null && orgdyns.size() > 0) {
                List orgs = orgdyns.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                evt.getCustomQFilters().add(new QFilter("id", "in", (Object)AccountingSysUtil.getBookTypes(orgs)));
            } else {
                evt.getCustomQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            }
        });
    }

    public void registerPeriodTypeSelectListener() {
        BasedataEdit periodTypeKeyEdit = (BasedataEdit)this.formView.getControl(this.periodTypeKey);
        periodTypeKeyEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject bookType = (DynamicObject)this.dataModel.getValue(this.bookTypeKey);
            DynamicObjectCollection orgdyns = (DynamicObjectCollection)this.dataModel.getValue(this.orgKey);
            if (orgdyns != null && orgdyns.size() > 0 && bookType != null) {
                Long bookTypeId = bookType.getLong("id");
                List orgs = orgdyns.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                DynamicObjectCollection periodTypes = AccountingSysUtil.getPeriodTypes(orgs, (Long)bookTypeId);
                List periodTypeIds = periodTypes.stream().map(o -> o.getLong("periodtype")).collect(Collectors.toList());
                evt.getCustomQFilters().add(new QFilter("id", "in", periodTypeIds));
            } else {
                evt.getCustomQFilters().add(QFilter.of((String)"1!=1", (Object[])new Object[0]));
            }
        });
    }
}

