/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin.base;

import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.evp.formplugin.OrgBookFillService;

public class BaseOriginRefVoucherEditPlugin
extends AbstractFormPlugin {
    private static final String KEY_ORG = "org";
    private static final String KEY_BOOK_TYPE = "qbookstype";
    private static final String KEY_PERIOD_TYPE = "qperiodtype";
    private static final String KEY_PERIOD = "qperiod";
    private static final String KEY_VOUCHER = "qvoucher";
    private OrgBookFillService periodFillService;

    public void setView(IFormView formView) {
        super.setView(formView);
        this.periodFillService = new OrgBookFillService(KEY_ORG, KEY_BOOK_TYPE, KEY_PERIOD_TYPE, KEY_PERIOD);
        this.periodFillService.init(formView);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.periodFillService.registerPeriodSelectListener();
        BasedataEdit voucherEdit = (BasedataEdit)this.getControl(KEY_VOUCHER);
        voucherEdit.addBeforeF7SelectListener(evt -> {
            DynamicObject period;
            DynamicObject org = (DynamicObject)this.getModel().getValue(KEY_ORG);
            evt.getCustomQFilters().add(new QFilter("isdelete", "=", (Object)false));
            evt.getCustomQFilters().add(new QFilter(KEY_ORG, "=", (Object)org.getLong("id")));
            DynamicObject bookType = (DynamicObject)this.getModel().getValue(KEY_BOOK_TYPE);
            if (bookType != null) {
                evt.getCustomQFilters().add(new QFilter("booktype", "=", (Object)bookType.getLong("id")));
            }
            if ((period = (DynamicObject)this.getModel().getValue(KEY_PERIOD)) != null) {
                evt.getCustomQFilters().add(new QFilter("period", "=", (Object)period.getLong("id")));
            }
        });
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String entityId = this.getView().getEntityId();
        if ("evp_voucher".equals(entityId) || "evp_bkrs".equals(entityId)) {
            return;
        }
        String voucherid = (String)this.getModel().getValue("voucherid");
        if (StringUtils.isNotEmpty((String)voucherid)) {
            QFilter qFilter = new QFilter("billid", "=", (Object)voucherid).and(new QFilter("isdelete", "=", (Object)"0"));
            DynamicObject evpVoucher = BusinessDataServiceHelper.loadSingle((String)"evp_voucher", (QFilter[])qFilter.toArray());
            if (evpVoucher != null) {
                DynamicObject bookType = evpVoucher.getDynamicObject("booktype");
                DynamicObject period = evpVoucher.getDynamicObject("period");
                if (period != null) {
                    DynamicObject periodType = period.getDynamicObject("periodtype");
                    this.getModel().setValue(KEY_PERIOD_TYPE, (Object)periodType);
                }
                this.getModel().setValue(KEY_BOOK_TYPE, (Object)bookType);
                this.getModel().setValue(KEY_PERIOD, (Object)period);
                this.getModel().setValue(KEY_VOUCHER, (Object)evpVoucher.getLong("id"));
            }
        } else {
            this.periodFillService.setDefaultVal();
        }
        this.getModel().setDataChanged(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        if (key.equals(KEY_VOUCHER)) {
            if (changeData.getNewValue() == null) {
                this.getModel().setValue("voucherid", null);
                this.getModel().setValue("voucherno", null);
            } else {
                DynamicObject evpVoucher = (DynamicObject)changeData.getNewValue();
                this.getModel().setValue("voucherid", (Object)evpVoucher.getString("billid"));
                this.getModel().setValue("voucherno", (Object)evpVoucher.getString("voucherno"));
            }
        } else if (key.equals(KEY_PERIOD_TYPE)) {
            this.periodFillService.propertyChanged(key, changeData.getNewValue());
        }
    }
}

