/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin.bill;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.evp.common.entity.VoucherBilllinkVo;
import kd.fi.evp.common.util.EVoucherModel;
import kd.fi.evp.common.util.EvpDapUtil;

public class EvpVoucherListPlugin
extends AbstractListPlugin {
    private static final String LINKBILL = "linkbill";
    private static final String EVP_LINKBILL = "evp_linkbill";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{LINKBILL});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (LINKBILL.equals(key)) {
            String org;
            String voucherno;
            String voucherid;
            ListSelectedRowCollection listSelectedRows = ((ListView)this.getView()).getSelectedRows();
            if (listSelectedRows.size() == 0) {
                return;
            }
            Object[] voucherpks = listSelectedRows.getPrimaryKeyValues();
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"evp_voucher", (String)"id, billid, org.name org, voucherno", (QFilter[])new QFilter("id", "in", (Object)voucherpks).toArray());
            ArrayList<VoucherBilllinkVo> params = new ArrayList<VoucherBilllinkVo>(16);
            Set voucherids = dyns.stream().map(d -> d.getString("billid")).collect(Collectors.toSet());
            Map rationBill = EvpDapUtil.getRationBill(voucherids);
            HashSet<String> enableVids = new HashSet<String>(16);
            Map namemap = EVoucherModel.getNameMap();
            for (DynamicObject voucherDyn : dyns) {
                voucherid = voucherDyn.getString("billid");
                voucherno = voucherDyn.getString("voucherno");
                org = voucherDyn.getString("org");
                for (Map.Entry entry : rationBill.entrySet()) {
                    String billtype = (String)entry.getKey();
                    for (Map.Entry tempentry : ((Map)entry.getValue()).entrySet()) {
                        String billidString = (String)tempentry.getKey();
                        String vid = (String)tempentry.getValue();
                        if (!vid.equals(voucherid)) continue;
                        VoucherBilllinkVo voucherBilllinkVo = new VoucherBilllinkVo();
                        voucherBilllinkVo.setOrg(org);
                        voucherBilllinkVo.setVoucherid(voucherid);
                        voucherBilllinkVo.setVoucherno(voucherno);
                        voucherBilllinkVo.setBilltype((String)namemap.get(billtype));
                        voucherBilllinkVo.setBillidstring(billidString);
                        params.add(voucherBilllinkVo);
                        enableVids.add(vid);
                    }
                }
            }
            dyns.removeIf(dyn -> enableVids.contains(dyn.getString("billid")));
            if (dyns.size() > 0) {
                for (DynamicObject dyn2 : dyns) {
                    voucherid = dyn2.getString("billid");
                    voucherno = dyn2.getString("voucherno");
                    org = dyn2.getString("org");
                    VoucherBilllinkVo voucherBilllinkVo = new VoucherBilllinkVo();
                    voucherBilllinkVo.setOrg(org);
                    voucherBilllinkVo.setVoucherid(voucherid);
                    voucherBilllinkVo.setVoucherno(voucherno);
                    voucherBilllinkVo.setBilltype("");
                    voucherBilllinkVo.setBillidstring("");
                    params.add(voucherBilllinkVo);
                }
            }
            if (params.size() > 0) {
                FormShowParameter parameter = new FormShowParameter();
                parameter.setFormId(EVP_LINKBILL);
                parameter.getOpenStyle().setShowType(ShowType.Modal);
                parameter.setCustomParam("params", (Object)SerializationUtils.toJsonString(params));
                this.getView().showForm(parameter);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u51ed\u8bc1\u6ca1\u6709\u5173\u8054\u7684\u7968\u636e\u3002", (String)"EvpVoucherListPlugin_1", (String)"fi-evp-common", (Object[])new Object[0]));
                return;
            }
        }
    }
}

