/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin.extractdata;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.evp.common.util.AccountingSysUtil;

public class EvpScheduleEdit
extends AbstractBillPlugIn
implements ClickListener,
BeforeF7SelectListener {
    private static final String KEY_ORG = "orgs";
    private static final String KEY_EXECUTOR = "executor";
    private static final String RANGE = "range";
    private static final String BOOKTYPE = "booktype";
    private static final String PERIODTYPE = "periodtype";
    private static final String MONTHRANGE = "monthrange";
    private static final String PERIODRANGE = "periodrange";
    private static final String PLAN = "plan";
    private static final String EVP_SCHEDULE = "evp_schedule";
    private static final String FORM_SCHEDULE = "sch_schedule";
    private static final String ENDTIME = "endtime";
    private static final String EXETASKCLASS = "kd.fi.evp.business.task.ExtractDataFormTask";
    private static final String VOUCHERTASKDEFINEID = "3M7CVXQRXT9F";
    private static final String BKRSTASKDEFINEID = "3M7F/MKGX4A0";
    private static final String VOUCHERRANGE = "1";
    private static final String BKRSRANGE = "2";

    public void preOpenForm(PreOpenFormEventArgs e) {
    }

    public void initialize() {
        BasedataEdit orgF7 = (BasedataEdit)this.getView().getControl(KEY_ORG);
        orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit executorF7 = (BasedataEdit)this.getView().getControl(KEY_EXECUTOR);
        executorF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        long userId = UserServiceHelper.getCurrentUserId();
        if (!PermissionServiceHelper.isSuperUser((long)userId) && !PermissionServiceHelper.checkPermission((Long)userId, (String)"evp", (String)EVP_SCHEDULE, (String)"47156aff000000ac")) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_save"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"execopertoolbarap"});
        this.addItemClickListeners(new String[]{"orgtoolbarap"});
        this.addClickListeners(new String[]{PLAN});
        this.addClickListeners(new String[]{"addcard", "addimg", "modifycard", "fabulousimage", "addlabel", "deleteoper", "cardentryflexpanelap6"});
    }

    public void afterLoadData(EventObject e) {
        IDataModel dataModel = this.getModel();
        Object executorId = dataModel.getValue("executor_id");
        this.getPageCache().put("executorId", StringUtils.isBlank((Object)executorId) ? "0" : executorId.toString());
        this.getModel().setDataChanged(false);
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (PLAN.equalsIgnoreCase(key)) {
            IBillModel billmodel = (IBillModel)this.getModel();
            long id = (Long)billmodel.getValue("id");
            if (StringUtils.isBlank((Object)id) || id == 0L) {
                String tableName = billmodel.getDataEntityType().getAlias();
                long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
                id = ids[0];
                billmodel.getDataEntity().set("id", (Object)id);
            }
            BillShowParameter parameter = new BillShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.Modal);
            parameter.setFormId(FORM_SCHEDULE);
            parameter.addCustPlugin("kd.fi.evp.formplugin.extractdata.SchScheduleSavePlugin");
            parameter.addCustPlugin("kd.fi.evp.formplugin.extractdata.SchScheduleLayoutPlugin");
            String scheduleId = (String)this.getView().getModel().getValue("planid");
            if (StringUtils.isNotEmpty((CharSequence)scheduleId) && this.checkScheduleOrTips(id, scheduleId)) {
                scheduleId = null;
            }
            if (scheduleId == null || scheduleId.trim().length() == 0) {
                parameter.setStatus(OperationStatus.ADDNEW);
                String idJson = "{\"intellSchemaidList\":[{\"Id\":" + id + "}]}";
                parameter.setCustomParam("paramjsonstr", (Object)idJson);
                parameter.setCustomParam("taskclassname", (Object)EXETASKCLASS);
                parameter.setCustomParam("taskdefineid", (Object)this.getDefineId());
                parameter.setCustomParam("taskname", (Object)ResManager.loadKDString((String)"\u7535\u5b50\u51ed\u8bc1\u6c60\u540e\u53f0\u81ea\u52a8\u521b\u5efa", (String)"EvpScheduleEdit_0", (String)"fi-evp-formplugin", (Object[])new Object[0]));
                parameter.setCustomParam("tasknumber", (Object)("evp_autocreate" + System.currentTimeMillis()));
                DynamicObject executor = (DynamicObject)billmodel.getValue(KEY_EXECUTOR);
                if (executor != null) {
                    parameter.setCustomParam(KEY_EXECUTOR, executor.get("id"));
                }
            } else {
                parameter.setPkId((Object)scheduleId);
                parameter.setStatus(OperationStatus.EDIT);
            }
            String appId = this.getAppId(billmodel, parameter);
            parameter.setCustomParam("taskappnumber", (Object)appId);
            parameter.setCustomParam("taskdefineid", (Object)this.getDefineId());
            parameter.setHasRight(true);
            parameter.setCustomParam("frombiz", (Object)"true");
            IDataModel model = this.getModel();
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "newshedule"));
            StyleCss css1 = new StyleCss();
            css1.setWidth("800");
            css1.setHeight("700");
            parameter.getOpenStyle().setInlineStyleCss(css1);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        boolean isExist;
        super.beforeClosed(e);
        Object id = this.getModel().getValue("id");
        Object scheduleId = this.getModel().getValue("planid");
        if (StringUtils.isNotBlank((Object)scheduleId) && !(isExist = QueryServiceHelper.exists((String)EVP_SCHEDULE, (Object)id))) {
            DeleteServiceHelper.delete((IDataEntityType)EntityMetadataCache.getDataEntityType((String)FORM_SCHEDULE), (Object[])new Object[]{scheduleId});
        }
    }

    public void afterCreateNewData(EventObject e) {
        IBillModel billmodel = (IBillModel)this.getModel();
        String tableName = billmodel.getDataEntityType().getAlias();
        long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)1);
        billmodel.setPKValue((Object)ids[0]);
        Object executorId = billmodel.getValue("executor_id");
        this.getPageCache().put("executorId", StringUtils.isBlank((Object)executorId) ? "0" : executorId.toString());
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate oper = (AbstractOperate)args.getSource();
            if (oper.getOperateKey().equals("save")) {
                if (!this.checkDraft()) {
                    args.cancel = true;
                }
            } else if (oper.getOperateKey().equals("modify") && Objects.equals(this.getModel().getValue("enable"), VOUCHERRANGE)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u8ba1\u5212\u4e3a\u542f\u7528\u72b6\u6001\uff0c\u8bf7\u7981\u7528\u540e\u518d\u4fee\u6539\u3002", (String)"EvpScheduleEdit_5", (String)"fi-evp-formplugin", (Object[])new Object[0]));
                args.cancel = true;
            }
        }
    }

    private boolean checkDraft() {
        IDataModel datamodel = this.getModel();
        String errMsg = null;
        Object number = datamodel.getValue("number");
        if (errMsg != null) {
            this.getView().showErrorNotification(errMsg);
            return false;
        }
        long id = (Long)datamodel.getValue("id");
        DynamicObject checkNumber = QueryServiceHelper.queryOne((String)EVP_SCHEDULE, (String)"id,number", (QFilter[])new QFilter[]{new QFilter("number", "=", number)});
        if (checkNumber != null && id != checkNumber.getLong("id")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"EvpScheduleEdit_8", (String)"fi-evp-formplugin", (Object[])new Object[0]));
            return false;
        }
        String range = (String)this.getModel().getValue(RANGE);
        if (VOUCHERRANGE.equals(range)) {
            if (StringUtils.isBlank((Object)this.getModel().getValue(BOOKTYPE))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"EvpScheduleEdit_1", (String)"fi-evp-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.isBlank((Object)this.getModel().getValue(PERIODTYPE))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u671f\u95f4\u7c7b\u578b\u3002", (String)"EvpScheduleEdit_2", (String)"fi-evp-formplugin", (Object[])new Object[0]));
                return false;
            }
            if (StringUtils.isBlank((Object)this.getModel().getValue(PERIODRANGE))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u671f\u95f4\u8303\u56f4\u3002", (String)"EvpScheduleEdit_3", (String)"fi-evp-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else if (StringUtils.isBlank((Object)this.getModel().getValue(MONTHRANGE))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5bf9\u8d26\u5355\u6708\u4efd\u8303\u56f4\u3002", (String)"EvpScheduleEdit_4", (String)"fi-evp-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperationResult() == null) {
            return;
        }
        if (afterDoOperationEventArgs.getOperationResult().isSuccess() && afterDoOperationEventArgs.getOperateKey().equals("save")) {
            String newValueStr;
            String planid = (String)this.getModel().getValue("planid");
            if (StringUtils.isBlank((CharSequence)planid)) {
                return;
            }
            DynamicObject sch = BusinessDataServiceHelper.loadSingle((Object)planid, (String)FORM_SCHEDULE);
            sch.set("name", this.getModel().getValue("name"));
            DynamicObject schJob = sch.getDynamicObject("job");
            if (schJob == null) {
                return;
            }
            DynamicObject job = BusinessDataServiceHelper.loadSingle((Object)schJob.get("id"), (String)"sch_job");
            if (job == null) {
                return;
            }
            Lang lang = RequestContext.get().getLang();
            job.set("runbylang", (Object)lang.toString());
            job.set("runconcurrent", (Object)Boolean.FALSE);
            IBillModel billmodel = (IBillModel)this.getModel();
            String appId = this.getAppId(billmodel, null);
            job.set("classname", (Object)appId);
            job.set("taskclassname", (Object)this.getDefineId());
            String params = this.getParams();
            if (StringUtils.isNotBlank((CharSequence)params)) {
                job.set("params", (Object)params);
            }
            String oldValue = this.getPageCache().get("executorId");
            IDataModel dataModel = this.getModel();
            Object newValue = dataModel.getValue("executor_id");
            String string = newValueStr = StringUtils.isBlank((Object)newValue) ? "0" : newValue.toString();
            if (!newValueStr.equals(oldValue)) {
                MainEntityType userType = EntityMetadataCache.getDataEntityType((String)"bos_user");
                DynamicObject userInfo = new DynamicObject((DynamicObjectType)userType);
                userInfo.set("id", (Object)Long.valueOf(newValueStr));
                job.set("name", this.getModel().getValue("name"));
                job.set("runbyuser", (Object)userInfo);
                this.getPageCache().put("executorId", newValueStr);
            }
            OperationServiceHelper.executeOperate((String)"save", (String)FORM_SCHEDULE, (DynamicObject[])new DynamicObject[]{sch}, (OperateOption)OperateOption.create());
            OperationServiceHelper.executeOperate((String)"save", (String)"sch_job", (DynamicObject[])new DynamicObject[]{job}, (OperateOption)OperateOption.create());
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object rtn;
        if (e.getReturnData() == null) {
            return;
        }
        if (e.getActionId().equals("newshedule") && (rtn = e.getReturnData()) != null) {
            DynamicObject scheduleInfo = (DynamicObject)rtn;
            Date endtime = scheduleInfo.getDate(ENDTIME);
            String planid = (String)scheduleInfo.get("id");
            this.getModel().setValue("planid", (Object)planid);
            String txtdesc = (String)scheduleInfo.get("txtdesc");
            if (StringUtils.isNotEmpty((CharSequence)txtdesc) && txtdesc.length() > 153) {
                txtdesc = txtdesc.substring(0, 150) + "...";
            }
            this.getModel().setValue(PLAN, (Object)txtdesc);
            this.getModel().setValue(ENDTIME, (Object)endtime);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String name = beforeF7SelectEvent.getProperty().getName();
        if (KEY_ORG.equals(name)) {
            ListShowParameter showParam = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParam.setMultiSelect(Boolean.TRUE.booleanValue());
            long userId = UserServiceHelper.getCurrentUserId();
            if (!PermissionServiceHelper.isSuperUser((long)userId)) {
                List orgs = AccountingSysUtil.getAcctOrgPkList((String)EVP_SCHEDULE, (String)"3J/LR//UD/LX");
                showParam.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)orgs));
            }
        }
    }

    private boolean checkScheduleOrTips(Long id, String scheduleId) {
        if (!EvpScheduleEdit.isExistSchedule(id, scheduleId)) {
            String msg = ResManager.loadKDString((String)"\u62bd\u6570\u4f9d\u8d56\u7684\u8c03\u5ea6\u8ba1\u5212\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u8c03\u5ea6\u8ba1\u5212\u3002", (String)"EvpScheduleEdit_10", (String)"fi-evp-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return true;
        }
        return false;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean fromDatabase = this.getModel().getDataEntity().getDataEntityState().getFromDatabase();
        if (!fromDatabase) {
            Long orgid = RequestContext.get().getOrgId();
            List acctOrgPks = AccountingSysUtil.getAcctOrgPkList((String)EVP_SCHEDULE, (String)"3J/LR//UD/LX");
            if (acctOrgPks != null && acctOrgPks.size() > 0) {
                ArrayList<Long> orgs = new ArrayList<Long>(2);
                if (acctOrgPks.contains(orgid)) {
                    orgs.add(orgid);
                    this.getModel().setValue(KEY_ORG, (Object)new Long[]{orgid});
                } else {
                    orgs.add((Long)acctOrgPks.get(0));
                    this.getModel().setValue(KEY_ORG, (Object)new Long[]{(Long)acctOrgPks.get(0)});
                }
                this.setDefBookType(orgs);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        Object value = e.getChangeSet()[0].getNewValue();
        if (value == null) {
            return;
        }
        IDataModel model = this.getModel();
        String propertyName = e.getProperty().getName();
        if (RANGE.equals(propertyName)) {
            String string = (String)model.getValue(RANGE);
            if (VOUCHERRANGE.equals(string)) {
                model.setValue(MONTHRANGE, (Object)"");
            }
            if (BKRSRANGE.equals(string)) {
                model.setValue(PERIODRANGE, (Object)"");
                model.setValue(BOOKTYPE, (Object)0L);
                model.setValue(PERIODTYPE, (Object)0L);
            }
        }
    }

    private void setDefBookType(List<Long> orgList) {
        if (orgList.size() == 0) {
            return;
        }
        Long defaultBookType = null;
        Long defaultPeriodType = null;
        Long defPeriod = null;
        ArrayList<Long> bookTypes = new ArrayList<Long>(1);
        ArrayList<Long> periodTypes = new ArrayList<Long>(orgList.size());
        QFilter orgFiler = new QFilter("org", "in", orgList).and("enable", "=", (Object)true);
        DynamicObjectCollection btCol = QueryServiceHelper.query((String)"gl_accountbook", (String)"org, periodtype, bookstype id, bookstype.accounttype type, curperiod", (QFilter[])new QFilter[]{orgFiler}, (String)"bookstype.accounttype desc");
        for (DynamicObject bt : btCol) {
            bookTypes.add(bt.getLong("id"));
            periodTypes.add(bt.getLong(PERIODTYPE));
            defPeriod = bt.getLong("curperiod");
            if (!VOUCHERRANGE.equals(bt.getString("type"))) continue;
            defaultBookType = bt.getLong("id");
            defaultPeriodType = bt.getLong(PERIODTYPE);
        }
        if (defaultBookType == null && bookTypes.size() > 0) {
            defaultBookType = (Long)bookTypes.get(0);
            defaultPeriodType = (Long)periodTypes.get(0);
        }
        if (defaultBookType == null) {
            return;
        }
        this.getModel().setValue(BOOKTYPE, defaultBookType);
        if (periodTypes.size() > 0) {
            this.getModel().setValue(PERIODTYPE, (Object)defaultPeriodType);
        }
    }

    public static boolean isExistSchedule(Object pkId, String scheduleId) {
        return QueryServiceHelper.exists((String)FORM_SCHEDULE, (Object)scheduleId);
    }

    private String getDefineId() {
        String range = (String)this.getModel().getValue(RANGE);
        if (StringUtils.isBlank((CharSequence)range)) {
            String msg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u62bd\u53d6\u8303\u56f4\u3002", (String)"EvpScheduleEdit_9", (String)"fi-evp-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(msg);
            return null;
        }
        if (VOUCHERRANGE.equals(range)) {
            return VOUCHERTASKDEFINEID;
        }
        return BKRSTASKDEFINEID;
    }

    private String getParams() {
        String range = (String)this.getModel().getValue(RANGE);
        HashMap<String, String> params = new HashMap<String, String>(5);
        DynamicObjectCollection dynamicObjects = (DynamicObjectCollection)this.getModel().getValue(KEY_ORG);
        List orgnumbers = dynamicObjects.stream().map(o -> o.getDynamicObject("fbasedataid").getString("number")).collect(Collectors.toList());
        params.put(KEY_ORG, String.join((CharSequence)",", orgnumbers));
        if (VOUCHERRANGE.equals(range)) {
            params.put("booktypenumber", ((DynamicObject)this.getModel().getValue(BOOKTYPE)).getString("number"));
            params.put("periodtypenumber", ((DynamicObject)this.getModel().getValue(PERIODTYPE)).getString("number"));
            params.put("period", (String)this.getModel().getValue(PERIODRANGE));
        } else {
            params.put("month", (String)this.getModel().getValue(MONTHRANGE));
        }
        return SerializationUtils.toJsonString(params);
    }

    private String getAppId(IBillModel billmodel, BillShowParameter parameter) {
        return "evp";
    }
}

