/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin.extractdata;

import com.alibaba.fastjson.JSON;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dataentity.utils.Uuid16;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.executor.JobClient;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class EvpScheduleList
extends AbstractListPlugin {
    private static final String SCH_SCHEDULE = "sch_schedule";
    private static final String SCH_JOB = "sch_job";
    private static final String PLANID = "planid";
    private static final String EXECPLAN = "execplan";
    private static final String EVP_SCHEDULE = "evp_schedule";

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{EXECPLAN});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        String appId = AppMetadataCache.getAppInfo((String)"evp").getId();
        if (EXECPLAN.equals(key)) {
            long userId = UserServiceHelper.getCurrentUserId();
            if (!PermissionServiceHelper.isSuperUser((long)userId) && !PermissionServiceHelper.checkPermission((Long)userId, (String)"evp", (String)EVP_SCHEDULE, (String)"3ZN2GFGXZ/S7")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"EvpScheduleList_0", (String)"fi-evp-formplugin", (Object[])new Object[0]));
                return;
            }
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            if (selectedRows.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u65b9\u6848\u6267\u884c\u3002", (String)"EvpScheduleList_1", (String)"fi-evp-formplugin", (Object[])new Object[0]));
                return;
            }
            HashSet<DynamicObject> schemaDyns = new HashSet<DynamicObject>(selectedRows.size());
            OperationResult result = new OperationResult();
            result.setBillCount(selectedRows.size());
            for (ListSelectedRow selectedRow : selectedRows) {
                long primaryKey = (Long)selectedRow.getPrimaryKeyValue();
                DynamicObject data = BusinessDataServiceHelper.loadSingle((Object)primaryKey, (String)EVP_SCHEDULE);
                String enable = data.getString("enable");
                if (enable == null || "0".equals(enable)) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo("ExecPlanError", ErrorLevel.Error, (Object)primaryKey);
                    errorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\uff1a \u6267\u884c\u65b9\u6848\u5931\u8d25\uff0c\u6570\u636e\u4e3a\u7981\u7528\u72b6\u6001\u3002", (String)"EvpScheduleList_2", (String)"fi-evp-formplugin", (Object[])new Object[0]), data.getString("number")));
                    result.getAllErrorInfo().add(errorInfo);
                    continue;
                }
                schemaDyns.add(data);
                result.getSuccessPkIds().add(primaryKey);
            }
            for (DynamicObject dyn : schemaDyns) {
                this.excutePlanAsyn(dyn);
            }
            if (result.getAllErrorInfo().size() > 0) {
                this.getView().showOperationResult(result);
                return;
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6210\u529f\uff0c\u65b9\u6848\u5df2\u7ecf\u5f00\u59cb\u6267\u884c", (String)"EvpScheduleList_4", (String)"fi-evp-formplugin", (Object[])new Object[0]));
        } else if ("tbldel".equals(key)) {
            long userId = UserServiceHelper.getCurrentUserId();
            if (!PermissionServiceHelper.isSuperUser((long)userId) && !PermissionServiceHelper.checkPermission((Long)userId, (String)"evp", (String)EVP_SCHEDULE, (String)"4715e1f1000000ac")) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"EvpScheduleList_0", (String)"fi-evp-formplugin", (Object[])new Object[0]));
                return;
            }
            IListView listView = (IListView)this.getView();
            ListSelectedRowCollection selectedRows = listView.getSelectedRows();
            if (selectedRows.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"EvpScheduleList_7", (String)"fi-evp-formplugin", (Object[])new Object[0]));
                return;
            }
            ConfirmCallBackListener confirmCallBacks1 = new ConfirmCallBackListener("tbldel", (IFormPlugin)this);
            String strDeleteConfirmTip = String.format(ResManager.loadKDString((String)"\u5220\u9664\u9009\u4e2d\u7684%d\u6761\u8bb0\u5f55\u540e\u5c06\u65e0\u6cd5\u6062\u590d\uff0c\u786e\u5b9a\u8981\u5220\u9664\u8be5\u8bb0\u5f55\u5417\uff1f", (String)"EvpScheduleList_8", (String)"fi-evp-formplugin", (Object[])new Object[0]), selectedRows.size());
            this.getView().showConfirm(strDeleteConfirmTip, MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks1);
        }
    }

    private void excutePlanAsyn(DynamicObject dyn) {
        RequestContext rc = RequestContext.get();
        DynamicObject schemaDb = dyn.getDynamicObject("executor");
        JobInfo job = new JobInfo();
        job.setRunByLang(rc.getLang());
        job.setJobType(JobType.BIZ);
        job.setName(rc.getUserName() + " execute job");
        job.setId(Uuid16.create().toString());
        if (schemaDb == null || schemaDb.getLong("id") == 0L) {
            job.setRunByUserId(Long.parseLong(rc.getUserId()));
        } else {
            job.setRunByUserId(schemaDb.getLong("id"));
        }
        String planid = dyn.getString(PLANID);
        DynamicObject plan = QueryServiceHelper.queryOne((String)SCH_SCHEDULE, (String)"job", (QFilter[])new QFilter("id", "=", (Object)planid).toArray());
        DynamicObject jobdyn = QueryServiceHelper.queryOne((String)SCH_JOB, (String)"taskclassname.classname name,params", (QFilter[])new QFilter("id", "=", (Object)plan.getString("job")).toArray());
        job.setTaskClassname(jobdyn.getString("name"));
        job.setParams((Map)JSON.parseObject((String)jobdyn.getString("params"), Map.class));
        String number = "evp";
        job.setAppId(number);
        job.setRunConcurrently(false);
        JobClient.dispatch((JobInfo)job);
    }

    public void confirmCallBack(MessageBoxClosedEvent arg0) {
        super.confirmCallBack(arg0);
        if ("tbldel".equalsIgnoreCase(arg0.getCallBackId()) && MessageBoxResult.Yes.equals((Object)arg0.getResult())) {
            ListSelectedRowCollection selectedRows = ((BillList)this.getControl("billlistap")).getSelectedRows();
            OperationResult resultAll = new OperationResult();
            resultAll.setBillCount(selectedRows.size());
            for (ListSelectedRow singleRow : selectedRows) {
                long schemeId = (Long)singleRow.getPrimaryKeyValue();
                DynamicObject singleRowDb = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)EVP_SCHEDULE);
                if ("0".equals(singleRowDb.getString("enable"))) {
                    OperateErrorInfo errorInfo = new OperateErrorInfo("tbldelError", ErrorLevel.Error, (Object)schemeId);
                    errorInfo.setMessage(String.format(ResManager.loadKDString((String)"%s\uff1a\u6570\u636e\u5df2\u7ecf\u7981\u7528\uff0c\u4e0d\u80fd\u88ab\u5220\u9664\u3002", (String)"EvpScheduleList_10", (String)"fi-evp-formplugin", (Object[])new Object[0]), singleRowDb.getString("number")));
                    resultAll.getAllErrorInfo().add(errorInfo);
                    continue;
                }
                QFilter idListFilter = new QFilter("intelschemaid", "=", (Object)schemeId);
                Object sheduleplanid = singleRowDb.get(PLANID);
                OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)EVP_SCHEDULE, (Object[])new Object[]{schemeId}, (OperateOption)OperateOption.create());
                if (result.isSuccess()) {
                    this.deleteSch(sheduleplanid);
                    resultAll.getSuccessPkIds().add(schemeId);
                    continue;
                }
                resultAll.getAllErrorInfo().addAll(result.getAllErrorInfo());
            }
            if (resultAll.getAllErrorInfo().size() > 0) {
                this.getView().showOperationResult(resultAll);
            } else {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f", (String)"EvpScheduleList_9", (String)"fi-iep-formplugin", (Object[])new Object[0]));
            }
            IListView listView = (IListView)this.getView();
            BillList list = (BillList)this.getControl("billlistap");
            listView.refresh();
            list.clearSelection();
        }
    }

    private void deleteSch(Object sheduleplanid) {
        QFilter qf = new QFilter("id", "=", sheduleplanid);
        DynamicObjectCollection jobColl = QueryServiceHelper.query((String)SCH_SCHEDULE, (String)"job", (QFilter[])new QFilter[]{qf});
        OperationServiceHelper.executeOperate((String)"delete", (String)SCH_SCHEDULE, (Object[])new Object[]{sheduleplanid}, null);
        for (DynamicObject jobDb : jobColl) {
            OperationServiceHelper.executeOperate((String)"delete", (String)SCH_JOB, (Object[])new Object[]{jobDb.getString("job")}, null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if ("disable".equals(operateKey) || "enable".equals(operateKey)) {
            this.handleScheduleAndJobStatus(evt, operateKey);
        }
    }

    private void handleScheduleAndJobStatus(AfterDoOperationEventArgs evt, String operateKey) {
        List successPkIds = evt.getOperationResult().getSuccessPkIds();
        if (successPkIds != null && !successPkIds.isEmpty()) {
            HashSet<String> scheduleIds = new HashSet<String>(10);
            try (DataSet ds = QueryServiceHelper.queryDataSet((String)"EVP_SCHEDULE", (String)EVP_SCHEDULE, (String)"id,planid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)successPkIds)}, null);){
                for (Row row : ds) {
                    String scheduId = row.getString(PLANID);
                    if (!StringUtils.isNotEmpty((CharSequence)scheduId)) continue;
                    scheduleIds.add(scheduId);
                }
            }
            if (!scheduleIds.isEmpty()) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)SCH_SCHEDULE);
                DynamicObject[] dySchedules = BusinessDataServiceHelper.load((Object[])scheduleIds.toArray(), (DynamicObjectType)type);
                String status = "enable".equals(operateKey) ? "1" : "0";
                for (DynamicObject dySchedule : dySchedules) {
                    dySchedule.set("status", (Object)status);
                    ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
                    boolean isEnable = "enable".equals(operateKey);
                    String scheduleId = (String)dySchedule.getPkValue();
                    if (isEnable) {
                        scheduleManager.enableSchedule(scheduleId);
                        continue;
                    }
                    scheduleManager.disableSchedule(scheduleId);
                }
                OperationServiceHelper.executeOperate((String)"save", (String)SCH_SCHEDULE, (DynamicObject[])dySchedules, (OperateOption)OperateOption.create());
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        args.setCancel(true);
        Object pkId = ((BillList)this.getControl("billlistap")).getFocusRowPkId();
        BillShowParameter parameter = new BillShowParameter();
        parameter.setFormId(EVP_SCHEDULE);
        parameter.setPkId(pkId);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.getOpenStyle().setTargetKey("_submaintab_");
        parameter.setStatus(OperationStatus.VIEW);
        this.getView().showForm((FormShowParameter)parameter);
    }
}

