/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin.extractdata;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.evp.common.util.AccountingSysUtil;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.common.util.MapUtil;

public class PullXinghanDataFormPlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener(this::orgSelectListener);
        BasedataEdit bookTypeEdit = (BasedataEdit)this.getControl("booktype");
        bookTypeEdit.addBeforeF7SelectListener(this::bookTypeSelectListener);
        BasedataEdit periodTypeEdit = (BasedataEdit)this.getControl("periodtype");
        periodTypeEdit.addBeforeF7SelectListener(this::periodTypeSelectListener);
        BasedataEdit beginPeriod = (BasedataEdit)this.getControl("beginperiod");
        BasedataEdit endPeriod = (BasedataEdit)this.getControl("endperiod");
        beginPeriod.addBeforeF7SelectListener(this::periodSelectListener);
        endPeriod.addBeforeF7SelectListener(this::periodSelectListener);
    }

    private void periodTypeSelectListener(BeforeF7SelectEvent evt) {
        String periodTypesCache = this.getPageCache().get("periodTypes");
        if (StringUtils.isEmpty((CharSequence)periodTypesCache)) {
            evt.getCustomQFilters().add(new QFilter("id", "=", (Object)0L));
        } else {
            List periodTypes = (List)SerializationUtils.deSerializeFromBase64((String)periodTypesCache);
            evt.getCustomQFilters().add(new QFilter("id", "in", (Object)periodTypes));
        }
    }

    private void bookTypeSelectListener(BeforeF7SelectEvent evt) {
        String bookTypesCache = this.getPageCache().get("bookTypes");
        if (StringUtils.isEmpty((CharSequence)bookTypesCache)) {
            evt.getCustomQFilters().add(new QFilter("id", "=", (Object)0L));
        } else {
            List bookTypes = (List)SerializationUtils.deSerializeFromBase64((String)bookTypesCache);
            evt.getCustomQFilters().add(new QFilter("id", "in", (Object)bookTypes));
        }
    }

    private void orgSelectListener(BeforeF7SelectEvent evt) {
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String billType = MapUtil.getStr((Map)showParam.getCustomParams(), (Object)"evpBillType");
        String filterType = MapUtil.getStr((Map)showParam.getCustomParams(), (Object)"filterType", (String)"period");
        if (StringUtils.isEmpty((CharSequence)billType)) {
            evt.getCustomQFilters().add(new QFilter("id", "=", (Object)0));
        } else if ("period".equals(filterType)) {
            List orgPks = AccountingSysUtil.getAcctOrgPkList((String)billType, (String)"3J/LR//UD/LX");
            evt.getCustomQFilters().add(new QFilter("id", "in", (Object)orgPks));
        } else {
            String appId = this.getView().getFormShowParameter().getAppId();
            HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"10", (String)appId, (String)billType, (String)"3J/LR//UD/LX");
            if (!allPermOrgs.hasAllOrgPerm()) {
                List permOrgPks = allPermOrgs.getHasPermOrgs();
                evt.getCustomQFilters().add(new QFilter("id", "in", (Object)permOrgPks));
            }
        }
    }

    private void periodSelectListener(BeforeF7SelectEvent evt) {
        DynamicObject periodtype = (DynamicObject)this.getModel().getValue("periodtype");
        if (periodtype == null) {
            evt.setCancel(true);
            return;
        }
        evt.getCustomQFilters().add(new QFilter("periodtype", "=", (Object)periodtype.getLong("id")));
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        List orgs = (List)customParams.get("orgIds");
        String entityTypeId = MapUtil.getStr((Map)customParams, (Object)"evpBillType");
        List<Object> orgPks = new ArrayList();
        if (orgs != null) {
            orgPks = orgs.stream().filter(id -> StringUtils.isNotEmpty((CharSequence)id.toString())).map(id -> Long.valueOf(id.toString())).collect(Collectors.toList());
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        String filterType = MapUtil.getStr((Map)customParams, (Object)"filterType", (String)"period");
        if ("period".equals(filterType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"startdate", "enddate"});
            List acctOrgPks = AccountingSysUtil.getAcctOrgPkList((String)entityTypeId, (String)"3J/LR//UD/LX");
            orgPks.retainAll(acctOrgPks);
            this.getModel().setValue("org", (Object)orgPks.toArray());
            this.setDefBookType(orgPks);
        } else {
            HasPermOrgResult allPermOrgs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"10", (String)appId, (String)entityTypeId, (String)"3J/LR//UD/LX");
            if (allPermOrgs.hasAllOrgPerm()) {
                this.getModel().setValue("org", (Object)orgPks.toArray());
                this.setDefBookType(orgPks);
            } else {
                List permOrgPks = allPermOrgs.getHasPermOrgs();
                orgPks.retainAll(permOrgPks);
                this.getModel().setValue("org", (Object)orgPks.toArray());
            }
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"booktype", "periodtype", "beginperiod", "endperiod"});
            Date now = new Date();
            Date firstMonthDay = DateFomatUtils.getFirstMonthDay((Date)now);
            this.getModel().setValue("startdate", (Object)firstMonthDay);
            this.getModel().setValue("enddate", (Object)firstMonthDay);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        Object value = e.getChangeSet()[0].getNewValue();
        if (value == null) {
            return;
        }
        if ("org".equals(key)) {
            DynamicObjectCollection orgs = (DynamicObjectCollection)value;
            ArrayList<Long> orgPks = new ArrayList<Long>(orgs.size());
            for (DynamicObject orgDyn : orgs) {
                DynamicObject org = orgDyn.getDynamicObject("fbasedataid");
                orgPks.add(org.getLong("id"));
            }
            this.setDefBookType(orgPks);
            return;
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String filterType = MapUtil.getStr((Map)customParams, (Object)"filterType", (String)"period");
        if (filterType.equals("period")) {
            if ("beginperiod".equals(key)) {
                long sp = ((DynamicObject)value).getLong("id");
                long ep = (Long)this.getModel().getValue("endperiod_id");
                if (ep == 0L || ep < sp) {
                    this.getModel().setValue("endperiod", (Object)sp);
                }
            } else if ("endperiod".equals(key)) {
                long endPeriod = ((DynamicObject)value).getLong("id");
                long startPeriod = (Long)this.getModel().getValue("beginperiod_id");
                if (startPeriod == 0L || startPeriod > endPeriod) {
                    this.getModel().setValue("beginperiod", (Object)endPeriod);
                }
            }
        } else if ("startdate".equals(key)) {
            Date sd = (Date)value;
            Date ed = (Date)this.getModel().getValue("enddate");
            if (ed == null) {
                this.getModel().setValue("enddate", (Object)sd);
            } else {
                Date edfd;
                Date sdfd = DateFomatUtils.getFirstMonthDay((Date)sd);
                if (sdfd.compareTo(edfd = DateFomatUtils.getFirstMonthDay((Date)ed)) > 0) {
                    this.getModel().setValue("enddate", (Object)sd);
                }
            }
        } else if ("enddate".equals(key)) {
            Date ed = (Date)value;
            Date sd = (Date)this.getModel().getValue("startdate");
            if (sd == null) {
                this.getModel().setValue("startdate", (Object)ed);
            } else {
                Date edfd;
                Date sdfd = DateFomatUtils.getFirstMonthDay((Date)sd);
                if (sdfd.compareTo(edfd = DateFomatUtils.getFirstMonthDay((Date)ed)) > 0) {
                    this.getModel().setValue("startdate", (Object)ed);
                }
            }
        }
    }

    private void setDefBookType(List<Long> orgList) {
        if (orgList.size() == 0) {
            return;
        }
        Long defaultBookType = null;
        Long defaultPeriodType = null;
        Long defPeriod = null;
        ArrayList<Long> bookTypes = new ArrayList<Long>(1);
        ArrayList<Long> periodTypes = new ArrayList<Long>(orgList.size());
        QFilter orgFiler = new QFilter("org", "in", orgList).and("enable", "=", (Object)true);
        DynamicObjectCollection btCol = QueryServiceHelper.query((String)"gl_accountbook", (String)"org, periodtype, bookstype id, bookstype.accounttype type, curperiod", (QFilter[])new QFilter[]{orgFiler}, (String)"bookstype.accounttype desc");
        for (DynamicObject bt : btCol) {
            bookTypes.add(bt.getLong("id"));
            periodTypes.add(bt.getLong("periodtype"));
            defPeriod = bt.getLong("curperiod");
            if (!"1".equals(bt.getString("type"))) continue;
            defaultBookType = bt.getLong("id");
            defaultPeriodType = bt.getLong("periodtype");
        }
        if (defaultBookType == null && bookTypes.size() > 0) {
            defaultBookType = (Long)bookTypes.get(0);
            defaultPeriodType = (Long)periodTypes.get(0);
        }
        if (defaultBookType == null) {
            return;
        }
        this.getPageCache().put("bookTypes", SerializationUtils.serializeToBase64(bookTypes));
        this.getPageCache().put("periodTypes", SerializationUtils.serializeToBase64(periodTypes));
        this.getModel().setValue("booktype", (Object)defaultBookType);
        this.getModel().setValue("beginperiod", (Object)defPeriod);
        this.getModel().setValue("endPeriod", (Object)defPeriod);
        if (periodTypes.size() > 0) {
            this.getModel().setValue("periodtype", (Object)defaultPeriodType);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        String key = ((Control)evt.getSource()).getKey();
        if ("btnok".equals(key)) {
            FormShowParameter showParam = this.getView().getFormShowParameter();
            String entityTypeId = MapUtil.getStr((Map)showParam.getCustomParams(), (Object)"evpBillType");
            String appId = this.getView().getFormShowParameter().getAppId();
            boolean hasPerm = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)appId, (String)entityTypeId, (String)"3J/LR//UD/LX");
            if (!hasPerm) {
                return;
            }
            Map<String, Object> returnParamMap = this.getParamMap();
            this.getView().returnDataToParent(returnParamMap);
            this.getView().close();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<String, Object> getParamMap() {
        HashMap returnParamMap = MapUtil.newHashMap((int)6);
        FormShowParameter showParam = this.getView().getFormShowParameter();
        String billType = MapUtil.getStr((Map)showParam.getCustomParams(), (Object)"evpBillType");
        String filterType = MapUtil.getStr((Map)showParam.getCustomParams(), (Object)"filterType", (String)"period");
        returnParamMap.put("evpBillType", billType);
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("org");
        if (orgs.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PullXinghanDataFormPlugin_7", (String)"fi-evp-formplugin", (Object[])new Object[0]));
        }
        ArrayList<Long> orgPks = new ArrayList<Long>(orgs.size());
        for (DynamicObject orgDyn : orgs) {
            DynamicObject org = orgDyn.getDynamicObject("fbasedataid");
            orgPks.add(org.getLong("id"));
        }
        returnParamMap.put("orgIds", orgPks);
        if ("period".equals(filterType)) {
            DynamicObject booktype = (DynamicObject)this.getModel().getValue("booktype");
            if (booktype != null) {
                returnParamMap.put("bookType", booktype.getLong("id"));
                String bookTypeName = booktype.getString("name");
                returnParamMap.put("bookTypeName", bookTypeName);
                DynamicObject periodtype = (DynamicObject)this.getModel().getValue("periodtype");
                if (periodtype == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PullXinghanDataFormPlugin_2", (String)"fi-evp-formplugin", (Object[])new Object[0]));
                }
                Map orgBooks = BusinessDataServiceHelper.loadFromCache((String)"gl_accountbook", (QFilter[])new QFilter[]{new QFilter("org", "in", orgPks), new QFilter("bookstype", "=", (Object)booktype.getLong("id")), new QFilter("enable", "=", (Object)true)});
                Map<Long, DynamicObject> orgBookMap = orgBooks.values().stream().collect(Collectors.toMap(book -> book.getLong("org_id"), book -> book));
                for (DynamicObject orgDyn : orgs) {
                    DynamicObject org = orgDyn.getDynamicObject("fbasedataid");
                    long orgPk = org.getLong("id");
                    String orgName = org.getString("name");
                    DynamicObject bookInfo = orgBookMap.get(orgPk);
                    if (bookInfo == null) {
                        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%1$s\u4e0d\u5b58\u5728\u8d26\u7c3f\u7c7b\u578b\u4e3a%2$s\u7684\u4f1a\u8ba1\u8d26\u7c3f\u3002", (String)"PullXinghanDataFormPlugin_1", (String)"fi-evp-formplugin", (Object[])new Object[0]), orgName, bookTypeName));
                    }
                    DynamicObject bookPeriodType = bookInfo.getDynamicObject("periodtype");
                    long orgBookPeriod = bookPeriodType.getLong("id");
                    if (orgBookPeriod == periodtype.getLong("id")) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u7684\u4f1a\u8ba1\u8d26\u7c3f\u671f\u95f4\u7c7b\u578b\u4e0e\u6240\u9009\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002", (String)"PullXinghanDataFormPlugin_3", (String)"fi-evp-formplugin", (Object[])new Object[0]), orgName));
                }
                DynamicObject beginPeriod = (DynamicObject)this.getModel().getValue("beginperiod");
                DynamicObject endPeriod = (DynamicObject)this.getModel().getValue("endperiod");
                if (beginPeriod == null || endPeriod == null) throw new KDBizException(ResManager.loadKDString((String)"\u671f\u95f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PullXinghanDataFormPlugin_6", (String)"fi-evp-formplugin", (Object[])new Object[0]));
                returnParamMap.put("beginPeriod", beginPeriod.getLong("id"));
                returnParamMap.put("endPeriod", endPeriod.getLong("id"));
                if (!DateFomatUtils.checkMonthDiff((Date)beginPeriod.getDate("begindate"), (Date)endPeriod.getDate("begindate")).booleanValue()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u62bd\u53d6\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u5927\u4e8e\u4e09\u4e2a\u6708\u3002", (String)"PullXinghanDataFormPlugin_5", (String)"fi-evp-formplugin", (Object[])new Object[0]));
                }
            }
        } else {
            Date startDate = (Date)this.getModel().getValue("startdate");
            Date endDate = (Date)this.getModel().getValue("enddate");
            if (startDate == null || endDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u6708\u4efd\u548c\u7ed3\u675f\u6708\u4efd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"PullXinghanDataFormPlugin_4", (String)"fi-evp-formplugin", (Object[])new Object[0]));
            }
            returnParamMap.put("startDate", startDate);
            returnParamMap.put("endDate", endDate);
            if (!DateFomatUtils.checkMonthDiff((Date)DateFomatUtils.getFirstMonthDay((Date)startDate), (Date)DateFomatUtils.getFirstMonthDay((Date)endDate)).booleanValue()) {
                throw new KDBizException(ResManager.loadKDString((String)"\u62bd\u53d6\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u5927\u4e8e\u4e09\u4e2a\u6708\u3002", (String)"PullXinghanDataFormPlugin_5", (String)"fi-evp-formplugin", (Object[])new Object[0]));
            }
        }
        returnParamMap.put("filterType", filterType);
        return returnParamMap;
    }
}

