/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin.home;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.portal.pluginnew.GridContainerPlugin;
import kd.fi.evp.formplugin.OrgBookFillService;

public class EvpHomePlugin
extends GridContainerPlugin
implements TabSelectListener {
    public static final String HOME_ORG = "org";
    public static final String HOME_PERIOD_TYPE = "periodtype";
    public static final String HOME_PERIOD = "period";
    private OrgBookFillService fillService;

    public void setView(IFormView formView) {
        super.setView(formView);
        this.fillService = new OrgBookFillService(HOME_ORG, "", HOME_PERIOD_TYPE, HOME_PERIOD);
        this.fillService.init(formView);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.fillService.registerOrgSelectListener();
        this.fillService.registerPeriodSelectListener();
    }

    public void tabSelected(TabSelectEvent tabSelectEvent) {
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.fillService.setDefaultVal();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if (HOME_ORG.equals(key)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            if (newValue != null) {
                DynamicObject org = (DynamicObject)newValue;
                this.fillService.setValByOrg(org.getLong("id"));
                this.refreshView();
            } else {
                this.getModel().setValue(HOME_ORG, e.getChangeSet()[0].getOldValue());
            }
        } else if (HOME_PERIOD_TYPE.equals(key)) {
            Object newValue = e.getChangeSet()[0].getNewValue();
            this.fillService.propertyChanged(key, newValue);
        } else if (HOME_PERIOD.equals(key)) {
            this.refreshView();
        }
    }

    private void refreshView() {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        HashMap dataMap = new HashMap();
        proxy.invokeControlMethod("gridcontainerap", "trigger", new Object[]{dataMap});
    }
}

