/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin.home;

import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.PieChart;
import kd.bos.form.chart.PieSeries;
import kd.fi.evp.formplugin.home.BillCountModel;
import kd.fi.evp.formplugin.home.HomeCardPlugin;

public class HomeCardBillStatisticsPlugin
extends HomeCardPlugin {
    private static final String PIE_KEY = "piechartap";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long orgId = this.getHomePropVal("org");
        long periodId = this.getHomePropVal("period");
        if (orgId == 0L || periodId == 0L) {
            return;
        }
        this.showPieChart();
    }

    private void showPieChart() {
        PieChart pieChart = (PieChart)this.getControl(PIE_KEY);
        pieChart.setLegendPropValue("width", (Object)"30%");
        pieChart.setLegendPropValue("right", (Object)130);
        pieChart.setLegendPropValue("type", (Object)"scroll");
        pieChart.setShowTooltip(true);
        PieSeries series = pieChart.createSeries(ResManager.loadKDString((String)"\u539f\u59cb\u5355\u636e\u6570", (String)"EvpHomePlugin_3", (String)"fi-evp-formplugin", (Object[])new Object[0]));
        series.setRadius("30%", "70%");
        series.setCenter("35%", "50%");
        pieChart.setTitlePropValue("left", (Object)"295");
        pieChart.setTitlePropValue("textAlign", (Object)"center");
        Label seriesLabel = new Label();
        seriesLabel.setShow(false);
        series.setLabel(seriesLabel);
        long orgId = this.getHomePropVal("org");
        long periodId = this.getHomePropVal("period");
        List<BillCountModel> notInPoolInfo = this.queryBillCnt(orgId, periodId, true);
        boolean index = false;
        boolean totalCnt = false;
        for (BillCountModel billCountModel : notInPoolInfo) {
            series.addData(billCountModel.getEntityName(), (Number)billCountModel.getTotalCnt(), this.getColor(billCountModel.getEntityId()));
        }
        pieChart.refresh();
    }

    private String getColor(String string) {
        switch (string) {
            case "evp_bkrs": {
                return "#95DE64";
            }
            case "evp_bkerreceiver": {
                return "#999999";
            }
            case "efi": {
                return "#FFA940";
            }
            case "evp_ntrevgpmreceiver": {
                return "#49A9EE";
            }
            case "evp_einvordreceiver": {
                return "#FFDB4A";
            }
            case "evp_einvspclreceiver": {
                return "#B889EA";
            }
            case "evp_invordreceiver": {
                return "#7A93F7";
            }
            case "evp_invspclreceiver": {
                return "#F57582";
            }
            case "evp_invtlfreceiver": {
                return "#FFFF00";
            }
            case "evp_atrreceiver": {
                return "#73D13D";
            }
            case "evp_raireceiver": {
                return "#F273B5";
            }
            case "evp_voucher": {
                return "#1890FF";
            }
        }
        return "#1890FF";
    }
}

