/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin.home;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.BarChart;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.fi.evp.formplugin.home.BillCountModel;
import kd.fi.evp.formplugin.home.HomeCardPlugin;

public class HomeCardEleVchInfoPlugin
extends HomeCardPlugin {
    private static final String BAR_KEY = "barchartap";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        long orgId = this.getHomePropVal("org");
        long periodId = this.getHomePropVal("period");
        if (orgId == 0L || periodId == 0L) {
            return;
        }
        this.showBarChart();
    }

    private void showBarChart() {
        BarChart barChart = (BarChart)this.getControl(BAR_KEY);
        barChart.setShowTooltip(true);
        barChart.setShowTitle(false);
        barChart.setMargin(Position.left, "10%");
        barChart.setMargin(Position.right, "10%");
        BarSeries outPoolSeries = barChart.createSeries(ResManager.loadKDString((String)"\u672a\u5165\u6c60", (String)"HomeCardEleVchInfoPlugin_1", (String)"fi-evp-formplugin", (Object[])new Object[0]));
        outPoolSeries.setStack("1");
        Label seriesLabel = new Label();
        seriesLabel.setShow(true);
        seriesLabel.setPosition(Position.inside);
        outPoolSeries.setLabel(seriesLabel);
        BarSeries inPoolSeries = barChart.createSeries(ResManager.loadKDString((String)"\u5df2\u5165\u6c60", (String)"HomeCardEleVchInfoPlugin_2", (String)"fi-evp-formplugin", (Object[])new Object[0]));
        inPoolSeries.setStack("1");
        inPoolSeries.setLabel(seriesLabel);
        long orgId = this.getHomePropVal("org");
        long periodId = this.getHomePropVal("period");
        List<BillCountModel> notInPoolInfo = this.queryBillCnt(orgId, periodId, false);
        Collections.reverse(notInPoolInfo);
        ArrayList<String> billTypeNames = new ArrayList<String>(notInPoolInfo.size());
        for (BillCountModel billCountModel : notInPoolInfo) {
            inPoolSeries.addData((Number)billCountModel.getInPollCnt());
            outPoolSeries.addData((Number)billCountModel.getOutPollCnt());
            billTypeNames.add(billCountModel.getEntityName());
        }
        Axis xAis = barChart.createXAxis(ResManager.loadKDString((String)"\u6570\u91cf", (String)"EvpHomePlugin_4", (String)"fi-evp-formplugin", (Object[])new Object[0]));
        xAis.setInterval((Number)1);
        Axis yAxis = barChart.createYAxis(ResManager.loadKDString((String)"\u7968\u636e\u7c7b\u578b", (String)"EvpHomePlugin_2", (String)"fi-evp-formplugin", (Object[])new Object[0]), billTypeNames);
        barChart.refresh();
    }
}

