/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin.home;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.formplugin.home.BillCountModel;

public class HomeCardPlugin
extends AbstractFormPlugin {
    protected long getHomePropVal(String key) {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return 0L;
        }
        DynamicObject res = (DynamicObject)parentView.getModel().getValue(key);
        if (res == null) {
            return 0L;
        }
        return res.getLong("id");
    }

    protected List<BillCountModel> queryBillCnt(long orgId, long periodId, boolean includeVch) {
        if (orgId == 0L || periodId == 0L) {
            return Collections.emptyList();
        }
        DynamicObject[] billTypes = BusinessDataServiceHelper.load((String)"evp_elevouchertype", (String)"number, name", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)true)}, (String)"dispseq");
        ArrayList<BillCountModel> billTypeCnts = new ArrayList<BillCountModel>(billTypes.length);
        QFilter filter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"begindate,enddate", (QFilter[])filter.toArray());
        for (DynamicObject billType : billTypes) {
            String entityId = billType.getString("number");
            if ("evp_voucher".equals(entityId) && !includeVch) continue;
            BillCountModel billCountModel = new BillCountModel();
            billCountModel.setEntityId(entityId);
            billCountModel.setEntityName(billType.getString("name"));
            billTypeCnts.add(billCountModel);
            Date beginDate = DateFomatUtils.beginOfDay((Date)period.getDate("begindate"));
            Date endDate = DateFomatUtils.endOfDay((Date)period.getDate("enddate"));
            this.queryBillTypeCount(orgId, beginDate, endDate, billCountModel);
        }
        return billTypeCnts;
    }

    private void queryBillTypeCount(long orgId, Date beginDate, Date endDate, BillCountModel billCountModel) {
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billCountModel.getEntityId());
        String tableName = mainEntityType.getAlias();
        String sql = "select fisintopool, count(fisintopool) billcnt  from " + tableName + " where forgid = ? and fbookdate >= ? and fbookdate <= ? and fisdelete = '0' group by fisintopool";
        DataSet dataSet = DB.queryDataSet((String)"evp_home", (DBRoute)DBRoute.of((String)"fi"), (String)sql, (Object[])new Object[]{orgId, beginDate, endDate});
        for (Row row : dataSet) {
            Boolean isintopool = row.getBoolean("fisintopool");
            Integer billcnt = row.getInteger("billcnt");
            if (isintopool != null && isintopool.booleanValue()) {
                billCountModel.setInPollCnt(billcnt == null ? 0 : billcnt);
                continue;
            }
            billCountModel.setOutPollCnt(billcnt == null ? 0 : billcnt);
        }
        billCountModel.setTotalCnt(billCountModel.getInPollCnt() + billCountModel.getOutPollCnt());
    }
}

