/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.formplugin.util;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.evp.common.util.AccountingSysUtil;

public class OrgBookInfoFillUtil {
    public static Object[] getDefaultPeriodInfo(Long orgId) {
        if (orgId == null || orgId == 0L) {
            return null;
        }
        Long defaultBookType = null;
        Long defaultPeriodType = null;
        QFilter orgFiler = new QFilter("org", "=", (Object)orgId).and("enable", "=", (Object)true);
        DynamicObjectCollection btCol = QueryServiceHelper.query((String)"gl_accountbook", (String)"org, periodtype, bookstype id, bookstype.accounttype type", (QFilter[])new QFilter[]{orgFiler});
        if (btCol.isEmpty()) {
            defaultBookType = AccountingSysUtil.getMainBookTypeId();
            Iterator periodType = BusinessDataServiceHelper.loadSingle((String)"bd_period_type", (String)"id", (QFilter[])new QFilter[0]);
            if (periodType != null) {
                defaultPeriodType = periodType.getLong("id");
            }
        } else {
            for (DynamicObject bt : btCol) {
                if (!"1".equals(bt.getString("type"))) continue;
                defaultBookType = bt.getLong("id");
                defaultPeriodType = bt.getLong("periodtype");
            }
            if (defaultBookType == null) {
                DynamicObject bt = (DynamicObject)btCol.get(0);
                defaultBookType = bt.getLong("id");
                defaultPeriodType = bt.getLong("periodtype");
            }
        }
        long periodId = 0L;
        if (defaultPeriodType != null) {
            periodId = OrgBookInfoFillUtil.getPeriodByCurrentDay(defaultPeriodType);
        }
        return new Object[]{defaultBookType, defaultPeriodType, periodId};
    }

    public static Object[] getDefaultPeriodInfo(Collection<Long> orgIds) {
        if (orgIds == null || orgIds.isEmpty()) {
            return null;
        }
        Long defaultBookType = null;
        Long defaultPeriodType = null;
        QFilter orgFiler = new QFilter("org", "in", orgIds);
        DynamicObjectCollection btCol = QueryServiceHelper.query((String)"gl_accountbook", (String)"org, periodtype, bookstype id, bookstype.accounttype type", (QFilter[])new QFilter[]{orgFiler});
        if (btCol.isEmpty()) {
            defaultBookType = AccountingSysUtil.getMainBookTypeId();
            Iterator periodType = BusinessDataServiceHelper.loadSingle((String)"bd_period_type", (String)"id", (QFilter[])new QFilter[0]);
            if (periodType != null) {
                defaultPeriodType = periodType.getLong("id");
            }
        } else {
            for (DynamicObject bt : btCol) {
                if (!"1".equals(bt.getString("type"))) continue;
                defaultBookType = bt.getLong("id");
                defaultPeriodType = bt.getLong("periodtype");
            }
            if (defaultBookType == null) {
                DynamicObject bt = (DynamicObject)btCol.get(0);
                defaultBookType = bt.getLong("id");
                defaultPeriodType = bt.getLong("periodtype");
            }
        }
        long periodId = 0L;
        if (defaultPeriodType != null) {
            periodId = OrgBookInfoFillUtil.getPeriodByCurrentDay(defaultPeriodType);
        }
        return new Object[]{defaultBookType, defaultPeriodType, periodId};
    }

    public static long getPeriodByCurrentDay(Long periodType) {
        Date curDay = new Date();
        DynamicObject periodByDate = PeriodUtil.getPeriodByDate((Date)curDay, (long)periodType);
        if (periodByDate == null) {
            return 0L;
        }
        return periodByDate.getLong("id");
    }
}

