/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.report;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.SecurityUtils;
import kd.fi.evp.common.util.BuildFileUtils;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.common.util.EVoucherModel;
import kd.fi.evp.common.util.FileUtils;
import kd.fi.evp.common.util.ReportUtil;
import kd.fi.evp.entity.OriginBillVo;
import kd.fi.evp.formplugin.OrgBookFillService;

public class EleVchPoolFormRpt
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private static final Log logger = LogFactory.getLog(EleVchPoolFormRpt.class);
    private static final String ENTITY = "evp_elevchpool";
    private static final String FILTERGRIDAP = "filtergridap";
    private static final String Q_ORG = "orgs";
    private static final String TYPE = "type";
    private static final String QTYPE = "qtype";
    private static final String STARTDATE = "startdate";
    private static final String ENDDATE = "enddate";
    private static final String STARTPERIOD = "periodstart";
    private static final String ENDPERIOD = "periodend";
    private static final String BOOKTYPE = "booktype";
    private static final String PERIODTYPE = "periodtype";
    private static final String EXPORTZIP = "exportzip";
    private static final String INTOPOOL = "intopool";
    private OrgBookFillService fillService;

    public void setView(IFormView formView) {
        super.setView(formView);
        this.fillService = new OrgBookFillService(Q_ORG, BOOKTYPE, PERIODTYPE, STARTPERIOD, ENDPERIOD);
        this.fillService.init(formView).setDateKey(STARTDATE, ENDDATE);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.fillService.registerOrgSelectListener();
        this.fillService.registerBookTypeSelectListener();
        this.fillService.registerPeriodTypeSelectListener();
        this.fillService.registerPeriodSelectListener();
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        Toolbar bar = (Toolbar)this.getControl("toolbarap");
        bar.addItemClickListener((ItemClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.fillService.setDefaultVal();
    }

    private boolean isFinance(String qType) {
        return !"evp_bkrs".equals(qType);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.changeVisibleByBillType();
        this.flushFilterGridAp(false);
    }

    private void changeVisibleByBillType() {
        String qType = ((DynamicObject)this.getModel().getValue(QTYPE)).getString("number");
        if ("evp_bkrs".equals(qType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{BOOKTYPE, PERIODTYPE, STARTPERIOD, ENDPERIOD});
            this.getView().setVisible(Boolean.TRUE, new String[]{STARTDATE, ENDDATE});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{BOOKTYPE, PERIODTYPE, STARTPERIOD, ENDPERIOD});
            this.getView().setVisible(Boolean.FALSE, new String[]{STARTDATE, ENDDATE});
        }
    }

    private void flushFilterGridAp(boolean isClearRow) {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        FilterCondition fc = filterGridState.getFilterCondition();
        if (isClearRow) {
            fc.getFilterRow().clear();
        }
        EntityTypeUtil util = new EntityTypeUtil();
        if (null == (DynamicObject)this.getModel().getValue(QTYPE)) {
            return;
        }
        String qType = ((DynamicObject)this.getModel().getValue(QTYPE)).getString("number");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)qType);
        List filterColumns = util.getFilterColumns((IDataEntityType)entityType);
        this.filterColumnList(filterColumns, qType, fc);
        filterGrid.setFilterColumns(filterColumns);
        filterGrid.setEntityNumber(qType);
        filterGrid.SetValue(fc);
        this.getView().updateView(FILTERGRIDAP);
    }

    private void filterColumnList(List<Map<String, Object>> filterColumns, String qType, FilterCondition fc) {
        ArrayList fieldList = new ArrayList(20);
        ReportUtil.buildOriVoiceSelect(fieldList, (String)qType);
        Iterator<Map<String, Object>> iter = filterColumns.iterator();
        while (iter.hasNext()) {
            Map<String, Object> column = iter.next();
            String fieldName = (String)column.get("fieldName");
            if (fieldList.contains(fieldName)) continue;
            iter.remove();
        }
        fc.getFilterRow().removeIf(row -> !fieldList.contains(row.getFieldName()));
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if (QTYPE.equals(propertyName)) {
            DynamicObject billType = (DynamicObject)newValue;
            if (billType != null) {
                String qType = billType.getString("number");
                this.changeVisibleByBillType();
                if (!this.isFinance(qType)) {
                    Date now = new Date();
                    Date firstMonthDay = DateFomatUtils.getFirstMonthDay((Date)now);
                    this.getModel().setValue(STARTDATE, (Object)firstMonthDay);
                    this.getModel().setValue(ENDDATE, (Object)firstMonthDay);
                }
                this.flushFilterGridAp(true);
            }
        } else if (Q_ORG.equals(propertyName)) {
            DynamicObjectCollection orgdyns = (DynamicObjectCollection)this.getModel().getValue(Q_ORG);
            if (!orgdyns.isEmpty()) {
                List<Long> orgs = orgdyns.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
                this.fillService.setValByOrg(orgs);
            }
        } else if (PERIODTYPE.equals(propertyName)) {
            this.fillService.propertyChanged(propertyName, newValue);
        } else if (STARTPERIOD.equals(propertyName)) {
            this.fillService.propertyChanged(propertyName, newValue);
        } else if (ENDPERIOD.equals(propertyName)) {
            this.fillService.propertyChanged(propertyName, newValue);
        } else if (STARTDATE.equals(propertyName)) {
            this.fillService.propertyChanged(propertyName, newValue);
        } else if (ENDDATE.equals(propertyName)) {
            this.fillService.propertyChanged(propertyName, newValue);
        } else if (BOOKTYPE.equals(propertyName)) {
            this.getModel().setValue(PERIODTYPE, null);
            this.getModel().setValue(STARTPERIOD, null);
            this.getModel().setValue(ENDPERIOD, null);
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo.getDynamicObjectCollection(Q_ORG) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"EleVchOriginFormRpt_0", (String)"fi-evp-common", (Object[])new Object[0]));
            return false;
        }
        if (null == filterInfo.getValue(QTYPE)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7535\u5b50\u51ed\u8bc1\u7c7b\u578b\u3002", (String)"EleVchOriginFormRpt_1", (String)"fi-evp-common", (Object[])new Object[0]));
            return false;
        }
        String qType = ((DynamicObject)this.getModel().getValue(QTYPE)).getString("number");
        if ("evp_bkrs".equals(qType)) {
            if (null == filterInfo.getValue(STARTDATE) || null == filterInfo.getValue(ENDDATE)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5bf9\u8d26\u5355\u6708\u4efd\u3002", (String)"EleVchOriginFormRpt_3", (String)"fi-evp-common", (Object[])new Object[0]));
                return false;
            }
        } else {
            if (null == filterInfo.getValue(BOOKTYPE)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u7c3f\u7c7b\u578b\u3002", (String)"EleVchOriginFormRpt_5", (String)"fi-evp-common", (Object[])new Object[0]));
                return false;
            }
            if (null == filterInfo.getValue(STARTPERIOD) || null == filterInfo.getValue(ENDPERIOD)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u671f\u95f4\u8303\u56f4\u3002", (String)"EleVchOriginFormRpt_4", (String)"fi-evp-common", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        int rowIndex = event.getRowIndex();
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(rowIndex);
        switch (fieldName) {
            case "number": {
                String number = rowData.getString("number");
                String type = rowData.getString(TYPE);
                if (!StringUtils.isNotEmpty((CharSequence)number)) break;
                Long id = Long.parseLong(number.replace(ReportUtil.getNumberPrefixByType((String)type), ""));
                MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)type);
                this.showTabForm(type + "_pc", entityType.getDisplayName().getLocaleValue() + "_" + number, id);
                break;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String key = evt.getItemKey();
        if (StringUtils.equals((CharSequence)INTOPOOL, (CharSequence)key)) {
            // empty if block
        }
        if (StringUtils.equals((CharSequence)EXPORTZIP, (CharSequence)key)) {
            String filePath;
            ReportList control = (ReportList)this.getControl("reportlistap");
            ReportListModel reportModel = (ReportListModel)control.getReportModel();
            int rowCount = reportModel.getRowCount();
            if (rowCount == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u65e0\u6570\u636e\u3002", (String)"EleVchPoolFormRpt_7", (String)"fi-evp-common", (Object[])new Object[0]));
                return;
            }
            DynamicObject dynamicObject = reportModel.getRowData(1);
            String type = dynamicObject.getString(TYPE);
            DynamicObjectCollection dyns = reportModel.getRowData(0, rowCount);
            List ids = dyns.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            Set billids = dyns.stream().map(o -> o.getString("billid")).collect(Collectors.toSet());
            String pageid = this.getView().getPageId();
            String lastDir = FileUtils.getPoolDir((String)pageid);
            String tickteType = (String)EVoucherModel.TICKETTYPEMAP.get(type);
            try {
                OriginBillVo originBillVo;
                List xbrlurls;
                Map urlMap;
                if ("evp_bkrs".equals(type)) {
                    urlMap = BuildFileUtils.getXbrlurls((String)type, billids);
                    xbrlurls = urlMap.values().stream().map(o -> o.getXbrlurl()).collect(Collectors.toList());
                    ArrayList allurls = new ArrayList(16);
                    allurls.addAll(xbrlurls);
                    Map filenamemap = FileUtils.getattachName((String)"evp_bkrs", allurls);
                    for (Map.Entry entry : urlMap.entrySet()) {
                        Object k = entry.getKey();
                        originBillVo = (OriginBillVo)entry.getValue();
                        String fileurl = originBillVo.getFileurl();
                        String xbrlName = (String)filenamemap.get(originBillVo.getXbrlurl());
                        String fullurl = FileUtils.getXbrlWriteDir((String)(lastDir + File.separator + EVoucherModel.createXBRLpath((String)xbrlName)));
                        if (StringUtils.isNotEmpty((CharSequence)originBillVo.getXbrlurl())) {
                            byte[] xbrlbytes = FileUtils.downLoadHttpsFile((String)originBillVo.getXbrlurl());
                            FileUtils.writeToFile((byte[])xbrlbytes, (String)(fullurl + File.separator + xbrlName));
                        } else {
                            logger.error("xbrl_is_empty. billtype: {}, billid:{}", (Object)tickteType, originBillVo.getBillid());
                        }
                        FileUtils.zipSpecFile((String)(lastDir + File.separator + EVoucherModel.createXBRLpath((String)xbrlName)));
                    }
                } else {
                    urlMap = BuildFileUtils.getXbrlurls((String)type, billids);
                    xbrlurls = urlMap.values().stream().map(o -> o.getXbrlurl()).collect(Collectors.toList());
                    List fileurls = urlMap.values().stream().map(o -> o.getFileurl()).collect(Collectors.toList());
                    Map xbrlnamemap = FileUtils.getattachName((String)type, xbrlurls);
                    Map filenamemap = FileUtils.getattachName((String)type, fileurls);
                    if (xbrlnamemap.size() == 0) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"xbrl\u6587\u4ef6\u5728\u9644\u4ef6\u4e0a\u4e0d\u5b58\u5728\u3002", (String)"EleVchPoolFormRpt_6", (String)"fi-evp-common", (Object[])new Object[0]));
                        return;
                    }
                    for (Map.Entry entry : urlMap.entrySet()) {
                        byte[] filebytes;
                        originBillVo = (OriginBillVo)entry.getValue();
                        if (StringUtils.isEmpty((CharSequence)originBillVo.getXbrlurl())) {
                            logger.error("xbrl_is_empty. billtype: {}, billid:{}", (Object)tickteType, originBillVo.getBillid());
                            continue;
                        }
                        byte[] xbrlbytes = FileUtils.downLoadHttpsFile((String)originBillVo.getXbrlurl());
                        String xbrlName = (String)xbrlnamemap.get(originBillVo.getXbrlurl());
                        String fullurl = FileUtils.getXbrlWriteDir((String)(lastDir + File.separator + EVoucherModel.createXBRLpath((String)xbrlName)));
                        FileUtils.writeToFile((byte[])xbrlbytes, (String)(fullurl + File.separator + xbrlName));
                        logger.info("xbrlName : {}", (Object)(fullurl + File.separator + xbrlName));
                        String fileurl = originBillVo.getFileurl();
                        String filename = (String)filenamemap.get(fileurl);
                        if (StringUtils.isNotEmpty((CharSequence)fileurl) && (filebytes = FileUtils.downLoadHttpsFile((String)fileurl)) != null && filebytes.length > 0) {
                            FileUtils.writeToFile((byte[])filebytes, (String)(fullurl + File.separator + filename));
                            logger.info("filename : {}", (Object)(fullurl + File.separator + filename));
                            if (StringUtils.isNotEmpty((CharSequence)filename)) {
                                String issuerFilename = fullurl + File.separator + xbrlName.replace("receiver", "issuer");
                                if ("evp_efi".equals(type)) {
                                    issuerFilename = issuerFilename.replace("efi", "efi_issuer");
                                }
                                BuildFileUtils.extractXBRL((String)(fullurl + File.separator + filename), (String)issuerFilename);
                                logger.info("issuername : {}", (Object)issuerFilename);
                            }
                        }
                        FileUtils.deleteFile((String)(fullurl + File.separator + filename));
                        FileUtils.zipSpecFile((String)(lastDir + File.separator + EVoucherModel.createXBRLpath((String)xbrlName)));
                    }
                }
            }
            catch (IOException e) {
                logger.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fazip\u6587\u4ef6\u5931\u8d25\u3002", (String)"EleVchPoolFormRpt_4", (String)"fi-evp-common", (Object[])new Object[0]));
                return;
            }
            Map result = FileUtils.exportPool((String)pageid);
            DynamicObjectCollection orgdyns = (DynamicObjectCollection)this.getModel().getValue(Q_ORG);
            List orgs = orgdyns.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toList());
            String filename = "";
            if (orgs.size() == 1) {
                void var19_25;
                DynamicObject orgDyn = BusinessDataServiceHelper.loadSingleFromCache(orgs.get(0), (String)"bos_org", (String)"uniformsocialcreditcode,number");
                String string = orgDyn.getString("uniformsocialcreditcode");
                if (StringUtils.isBlank((CharSequence)string)) {
                    String string2 = orgDyn.getString("number");
                }
                filename = "receiver_" + (String)var19_25 + "_" + System.currentTimeMillis() + ".zip";
            } else {
                filename = "receiver_" + System.currentTimeMillis() + ".zip";
            }
            if (!result.isEmpty() && StringUtils.isNotBlank((CharSequence)(filePath = (String)result.get("fileName")))) {
                File file = new File(SecurityUtils.normalize((String)filePath));
                try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));){
                    String url = FileUtils.saveAsUrl((InputStream)bufferedInputStream, (String)filename);
                    this.getView().openUrl(url);
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6210\u529f\u3002", (String)"EleVchPoolFormRpt_14", (String)"fi-evp-common", (Object[])new Object[0]), Integer.valueOf(5000));
                }
                catch (IOException iOException) {
                    throw new KDBizException(iOException.getMessage());
                }
                finally {
                    FileUtils.deleteFile((String)filePath);
                }
            }
        }
    }

    private void showTabForm(String formId, String formName, Object pkValue) {
        IReportView view = this.getView();
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.setFormId(formId);
        if (null != formName) {
            parameter.setCaption(formName);
        }
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.VIEW);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)parameter);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
    }
}

