/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.report;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.common.util.ReportUtil;

public class EleVchPoolQueryRpt
extends AbstractReportListDataPlugin {
    private static final String ALGO = EleVchPoolQueryRpt.class.getName();
    private String qType;
    private String qTypeName;
    private static final String QTYPE = "qtype";

    public DataSet query(ReportQueryParam queryParam, Object o) throws Throwable {
        FilterInfo filterInfo = queryParam.getFilter();
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        this.initParam(filterInfo, filters);
        return QueryServiceHelper.queryDataSet((String)ALGO, (String)this.qType, (String)this.getCurSelectedFields(), (QFilter[])filters.toArray(new QFilter[0]), null).orderBy(new String[]{"intopooldate desc"});
    }

    private void initParam(FilterInfo filterInfo, List<QFilter> filters) {
        DynamicObject qtypeDyn = filterInfo.getDynamicObject(QTYPE);
        this.qType = qtypeDyn.getString("number");
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("orgs");
        List orgIds = orgs.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        filters.add(new QFilter("org", "in", orgIds));
        if ("evp_bkrs".equals(this.qType)) {
            Date startDate = filterInfo.getDate("startdate");
            Date endDate = filterInfo.getDate("enddate");
            startDate = DateFomatUtils.getFirstMonthDay((Date)startDate);
            endDate = DateFomatUtils.getLastMonthDay((Date)endDate);
            filters.add(new QFilter("bookdate", ">=", (Object)startDate));
            filters.add(new QFilter("bookdate", "<=", (Object)endDate));
        } else {
            filters.add(new QFilter("period", ">=", filterInfo.getDynamicObject("periodstart").get("id")));
            filters.add(new QFilter("period", "<=", filterInfo.getDynamicObject("periodend").get("id")));
        }
        QFilter commFilter = filterInfo.getCommFilter(this.qType);
        if (null != commFilter) {
            filters.add(commFilter);
        }
        filters.add(new QFilter("isdelete", "=", (Object)"0"));
        filters.add(new QFilter("isintopool", "=", (Object)"1"));
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) {
        ReportUtil.createColumnFromConfig((String)this.qType, columns, (boolean)true);
        return columns;
    }

    private String getCurSelectedFields() {
        List<String> result = this.buildSelectFieldList();
        return String.join((CharSequence)",", result);
    }

    private List<String> buildSelectFieldList() {
        ArrayList<String> fieldList = new ArrayList<String>(20);
        fieldList.add("id");
        fieldList.add("billid");
        fieldList.add("voucherid");
        fieldList.add("org");
        fieldList.add("intopooldate");
        fieldList.add(String.format("%s as %s", "'" + this.qType + "'", "type"));
        fieldList.add(String.format("%s as %s", ReportUtil.getNumberFieldExpr((String)this.qType), "number"));
        ReportUtil.buildOriVoiceSelectFromConfig(fieldList, (String)this.qType, (boolean)true);
        return fieldList;
    }
}

