/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.evp.model.ArchiveParamDetail;
import kd.bos.ext.fi.evp.model.ArchiveParamVo;
import kd.bos.ext.fi.evp.model.ArchiveReturnVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.evp.business.invoke.InvokeBizQueryService;
import kd.fi.evp.common.cache.CacheHelper;
import kd.fi.evp.common.cache.CacheModule;
import kd.fi.evp.common.cache.DistributeCache;
import kd.fi.evp.common.util.ArchiveUtils;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.common.util.EVoucherModel;
import kd.fi.evp.common.util.SysConfigUtil;
import kd.fi.evp.entity.ArchiveDetailLogVo;

public class ArchivepoolOpService
extends EntityOperateService {
    private static final Log logger = LogFactory.getLog(ArchivepoolOpService.class);
    private DistributeCache cache = CacheHelper.getDistributeCache((CacheModule)CacheModule.export);
    private String billType;
    private List<Long> errids = new ArrayList<Long>();
    public static final int BATCHNUM = 1000;
    private static final String ID = "id";
    private static final String BILLID = "billid";
    private static final String VOUCHERNO = "voucherno";
    private static final String ISINTOPOOL = "isintopool";
    private static final String VOUCHERID = "voucherid";
    private static final String OPERATOR = "operator";
    private static final String XBRLURL = "xbrlurl";
    private static final String INTOPOOLDATE = "intopooldate";
    private static final String PERIOD = "period";
    private static final String FILEURL = "fileurl_tag";
    private static final String ISARCHIVE = "isarchive";
    private static final String ISDELETEE = "isdelete";
    private static final String ORG = "org";
    private static final String BOOKDATE = "bookdate";
    private static final String SEQNO = "seqno";
    private static final String ARCHIVEBATCHCODE = "archivebatchcode";

    protected void preparePropertys(List<String> fieldKeys) {
        fieldKeys.add(ID);
        fieldKeys.add(BILLID);
        fieldKeys.add(VOUCHERNO);
        fieldKeys.add(ISINTOPOOL);
        fieldKeys.add(VOUCHERID);
        fieldKeys.add(OPERATOR);
        fieldKeys.add(XBRLURL);
        fieldKeys.add(PERIOD);
        fieldKeys.add(INTOPOOLDATE);
        fieldKeys.add(PERIOD);
        fieldKeys.add(ORG);
        fieldKeys.add(BOOKDATE);
        fieldKeys.add(SEQNO);
        fieldKeys.add(FILEURL);
        fieldKeys.add(ARCHIVEBATCHCODE);
        fieldKeys.add(ISARCHIVE);
        super.preparePropertys(fieldKeys);
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        this.billType = this.billEntityType.getName();
        validators.add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] exDatas = this.getDataEntities();
                List<ExtendedDataEntity> list = Arrays.asList(exDatas);
                List<Object> pkIds = list.stream().map(p -> p.getBillPkId()).collect(Collectors.toList());
                List<Long> archivedids = this.getArchivedids(ArchivepoolOpService.this.billType, pkIds);
                List<Long> notPoolids = this.getnotPoolids(ArchivepoolOpService.this.billType, pkIds);
                for (ExtendedDataEntity exData : exDatas) {
                    String err;
                    Long tempId = (Long)exData.getBillPkId();
                    Object billid = exData.getValue(ArchivepoolOpService.BILLID);
                    if (archivedids.contains(tempId)) {
                        err = String.format(ResManager.loadKDString((String)"\u5df2\u5f52\u6863\uff0c\u65e0\u9700\u518d\u5f52\u6863\u3002", (String)"ArchivepoolOpService_3", (String)"fi-evp-common", (Object[])new Object[0]), billid);
                        this.addMessage(exData, err, ErrorLevel.Error);
                    }
                    if (!notPoolids.contains(tempId)) continue;
                    err = String.format(ResManager.loadKDString((String)"\u53ea\u6709\u5df2\u5165\u6c60\u7684\u6570\u636e\u624d\u80fd\u5f52\u6863\u3002", (String)"ArchivepoolOpService_2", (String)"fi-evp-common", (Object[])new Object[0]), billid);
                    this.addMessage(exData, err, ErrorLevel.Error);
                }
            }

            private List<Long> getArchivedids(String billType, List<Object> pkIds) {
                ArrayList<Long> ids = new ArrayList<Long>(16);
                QFilter qFilter = new QFilter(ArchivepoolOpService.ISARCHIVE, "=", (Object)"1");
                QFilter qFilter1 = new QFilter(ArchivepoolOpService.ISDELETEE, "=", (Object)"0");
                QFilter idFilter = new QFilter(ArchivepoolOpService.ID, "in", pkIds);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)billType, (String)ArchivepoolOpService.ID, (QFilter[])new QFilter[]{qFilter, idFilter, qFilter1}, null);){
                    for (Row row : ds) {
                        ids.add(row.getLong(ArchivepoolOpService.ID));
                    }
                }
                return ids;
            }

            private List<Long> getnotPoolids(String billType, List<Object> pkIds) {
                ArrayList<Long> ids = new ArrayList<Long>(16);
                QFilter qFilter = new QFilter(ArchivepoolOpService.ISINTOPOOL, "=", (Object)"0");
                QFilter qFilter1 = new QFilter(ArchivepoolOpService.ISDELETEE, "=", (Object)"0");
                QFilter idFilter = new QFilter(ArchivepoolOpService.ID, "in", pkIds);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)billType, (String)ArchivepoolOpService.ID, (QFilter[])new QFilter[]{qFilter, idFilter, qFilter1}, null);){
                    for (Row row : ds) {
                        ids.add(row.getLong(ArchivepoolOpService.ID));
                    }
                }
                return ids;
            }
        });
        super.addDefaultValidator(validators);
    }

    protected void executeOperate(DynamicObject[] arg0) {
        block22: {
            if (arg0.length == 0) {
                return;
            }
            OperateOption option = this.getOption();
            try {
                if (option.containsVariable("isfrompage")) {
                    this.executedyns(arg0);
                    if (this.errids.size() > 0) {
                        if (this.cache.get(option.getVariableValue("pageid") + "errorCnt") != null) {
                            int errcnt = Integer.parseInt(this.cache.get(option.getVariableValue("pageid") + "errorCnt"));
                            this.cache.put(option.getVariableValue("pageid") + "errorCnt", "" + (errcnt += this.errids.size()));
                        } else {
                            this.cache.put(option.getVariableValue("pageid") + "errorCnt", "" + this.errids.size());
                        }
                    }
                    break block22;
                }
                List lists = ArchiveUtils.splitdata((DynamicObject[])arg0, (String)this.billEntityType.getName());
                for (List dynamicObjects : lists) {
                    try (TXHandle txHandle = TX.requiresNew((String)"kd.fi.evp.opplugin.ArchivepoolOpService");){
                        try {
                            MainEntityType type = EntityMetadataCache.getDataEntityType((String)"evp_archivelog");
                            DynamicObject logEntity = (DynamicObject)type.createInstance();
                            logEntity.set("username", (Object)RequestContext.get().getUserName());
                            logEntity.set("opname", (Object)ResManager.loadKDString((String)"\u5f52\u6863", (String)"ArchiveUtils", (String)"fi-evp-common", (Object[])new Object[0]));
                            logEntity.set("opdesc", (Object)"archive");
                            logEntity.set("opdate", (Object)new Date());
                            logEntity.set("orgnumber", ((DynamicObject)dynamicObjects.get(0)).get("org.number"));
                            logEntity.set("orgname", ((DynamicObject)dynamicObjects.get(0)).get("org.name"));
                            logEntity.set("archivedate", (Object)new Date());
                            logEntity.set("allcount", (Object)dynamicObjects.size());
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logEntity});
                            option.setVariableValue("archivelogid", Long.toString(logEntity.getLong(ID)));
                        }
                        catch (Exception e) {
                            logger.error("archiveevp error : " + e);
                            txHandle.markRollback();
                            throw e;
                        }
                    }
                    this.executedyns(dynamicObjects.toArray(new DynamicObject[0]));
                }
            }
            catch (Exception e) {
                logger.error("archiveevp executeOperate error : " + e);
                if (!option.containsVariable("isfrompage")) break block22;
                this.cache.put(option.getVariableValue("pageid") + "isFinish", "true");
                this.cache.put(option.getVariableValue("pageid") + "errorMsg", "" + e);
            }
        }
    }

    private void executedyns(DynamicObject[] arg0) throws Exception {
        String archiveclass;
        String archivebatchcode = UUID.randomUUID().toString();
        DynamicObject dynamicObject = arg0[0];
        Long orgid = dynamicObject.getLong("org_id");
        String orgnumber = dynamicObject.getString("org.number");
        String orgname = dynamicObject.getString("org.name");
        Long period = null;
        String periodnumber = null;
        String periodname = null;
        if (!"evp_bkrs".equals(this.billEntityType.getName())) {
            period = dynamicObject.getLong("period_id");
            periodnumber = dynamicObject.getString("period.number");
            periodname = dynamicObject.getString("period.name");
        }
        if (StringUtils.isBlank((Object)(archiveclass = SysConfigUtil.getString((String)"archiveclass")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5728\u914d\u7f6e\u53c2\u6570\u4e2d\u914d\u7f6e\u5f52\u6863\u5b9e\u73b0\u7c7b\u3002", (String)"ArchivepoolOpService_5", (String)"fi-evp-common", (Object[])new Object[0]));
        }
        ArchiveParamVo archiveParamVo = new ArchiveParamVo(orgid, orgnumber, orgname, period, periodnumber, periodname, DateFomatUtils.format((Date)dynamicObject.getDate(BOOKDATE), (String)"yyyyMM"), (String)EVoucherModel.TICKETTYPEMAP.get(this.billEntityType.getName()), null);
        List<ArchiveParamDetail> details = this.buildDetails(arg0);
        try (TXHandle txHandle = TX.requiresNew((String)"kd.fi.evp.opplugin.ArchivepoolOpService");){
            try {
                archiveParamVo.setDetails(details);
                ArchiveReturnVo archiveReturnVo = InvokeBizQueryService.archive((ArchiveParamVo)archiveParamVo, (String)archiveclass.toString());
                Long parentid = Long.parseLong(this.getOption().getVariableValue("archivelogid"));
                ArchiveDetailLogVo archiveDetailLogVo = new ArchiveDetailLogVo(parentid, ResManager.loadKDString((String)"\u5f52\u6863", (String)"ArchivepoolOpService_0", (String)"fi-evp-common", (Object[])new Object[0]), "archive", orgnumber, this.billEntityType.getName(), this.billEntityType.getDisplayName().toString(), "1", archivebatchcode, "", Integer.valueOf(arg0.length), Integer.valueOf(arg0.length));
                if (archiveReturnVo.getErrids() != null && archiveReturnVo.getErrids().size() > 0) {
                    this.errids.addAll(archiveReturnVo.getErrids());
                    archiveDetailLogVo.setStatus("0");
                    archiveDetailLogVo.setErrmsg(archiveReturnVo.getErrmsg());
                    archiveDetailLogVo.setSuccesscnt(Integer.valueOf(arg0.length - archiveReturnVo.getErrids().size()));
                }
                ArchiveUtils.saveDetail((ArchiveDetailLogVo)archiveDetailLogVo);
            }
            catch (Exception e) {
                logger.error("executedyns error : " + e);
                txHandle.markRollback();
                throw e;
            }
        }
        for (DynamicObject dyn : arg0) {
            Long id = dyn.getLong(ID);
            Object billid = dyn.get(BILLID);
            if (this.errids.contains(id)) continue;
            dyn.set(ISARCHIVE, (Object)"1");
            dyn.set(ARCHIVEBATCHCODE, (Object)archivebatchcode);
        }
        SaveServiceHelper.save((DynamicObject[])arg0);
    }

    private List<ArchiveParamDetail> buildDetails(DynamicObject[] arg0) {
        ArrayList<ArchiveParamDetail> list = new ArrayList<ArchiveParamDetail>(16);
        List voucherids = Arrays.asList(arg0).stream().map(o -> o.get(VOUCHERID)).collect(Collectors.toList());
        HashMap<Object, String> dateMap = new HashMap<Object, String>(16);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"evp_voucher", (String)"billid, bookdate", (QFilter[])new QFilter(BILLID, "in", voucherids).toArray());
        for (DynamicObject dynamicObject : dyns) {
            dateMap.put(dynamicObject.get(BILLID), DateFomatUtils.format((Date)dynamicObject.getDate(BOOKDATE), (String)"yyyy-MM-dd"));
        }
        for (DynamicObject dynamicObject : arg0) {
            ArchiveParamDetail archiveParamDetail = new ArchiveParamDetail();
            archiveParamDetail.setId(Long.valueOf(dynamicObject.getLong(ID)));
            archiveParamDetail.setBillid(dynamicObject.get(BILLID));
            archiveParamDetail.setBillno(dynamicObject.getString(SEQNO));
            archiveParamDetail.setVoucherno(dynamicObject.getString(VOUCHERNO));
            archiveParamDetail.setBilldate(DateFomatUtils.format((Date)dynamicObject.getDate(BOOKDATE), (String)"yyyy-MM-dd"));
            archiveParamDetail.setXbrlurl(dynamicObject.getString(XBRLURL));
            archiveParamDetail.setFileurl(dynamicObject.getString(FILEURL));
            archiveParamDetail.setVoucherid(dynamicObject.get(VOUCHERID));
            archiveParamDetail.setBookdate((String)dateMap.get(dynamicObject.get(VOUCHERID)));
            list.add(archiveParamDetail);
        }
        return list;
    }

    private OperationResult createErrorResult(String errorMsg) {
        OperationResult result = new OperationResult();
        result.setSuccess(false);
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setLevel(ErrorLevel.FatalError);
        if (errorMsg != null) {
            errorInfo.setMessage(errorMsg);
        }
        result.addErrorInfo(errorInfo);
        result.setShowMessage(true);
        return result;
    }
}

