/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.opplugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.evp.common.util.BuildFileUtils;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.common.util.EVoucherModel;
import kd.fi.evp.common.util.FileUtils;

public class IntopoolOpService
extends EntityOperateService {
    private static final Log logger = LogFactory.getLog((String)"evp.IntopoolOpService");
    private String billType;
    private Map<Object, String> voucherIdVoucherNo = new HashMap<Object, String>(16);
    private Map<Object, Long> voucherIdAndPeriod = new HashMap<Object, Long>(16);
    private List<Object> voucherids = new ArrayList<Object>();
    public static final int BATCHNUM = 1000;
    private static final String ID = "id";
    private static final String BILLID = "billid";
    private static final String VOUCHERNO = "voucherno";
    private static final String ISINTOPOOL = "isintopool";
    private static final String ISDELETE = "isdelete";
    private static final String VOUCHERID = "voucherid";
    private static final String OPERATOR = "operator";
    private static final String XBRLURL = "xbrlurl";
    private static final String INTOPOOLDATE = "intopooldate";
    private static final String PERIOD = "period";

    protected void preparePropertys(List<String> fieldKeys) {
        fieldKeys.add(ID);
        fieldKeys.add(BILLID);
        fieldKeys.add(VOUCHERNO);
        fieldKeys.add(ISINTOPOOL);
        fieldKeys.add(VOUCHERID);
        fieldKeys.add(OPERATOR);
        fieldKeys.add(XBRLURL);
        fieldKeys.add(INTOPOOLDATE);
        fieldKeys.add(PERIOD);
        super.preparePropertys(fieldKeys);
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        this.billType = this.billEntityType.getName();
        validators.add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] exDatas = this.getDataEntities();
                List<ExtendedDataEntity> list = Arrays.asList(exDatas);
                List<Object> pkIds = list.stream().map(p -> p.getBillPkId()).collect(Collectors.toList());
                List<Long> isintopoolids = this.getIntopoolids(IntopoolOpService.this.billType, pkIds);
                List<Long> noVoucherids = this.noVoucherids(IntopoolOpService.this.billType, pkIds);
                List<Long> deletedids = this.getDeletedids(IntopoolOpService.this.billType, pkIds);
                for (ExtendedDataEntity exData : exDatas) {
                    String err;
                    Long tempId = (Long)exData.getBillPkId();
                    Object billid = exData.getValue(IntopoolOpService.BILLID);
                    if (deletedids.contains(tempId)) {
                        err = String.format(ResManager.loadKDString((String)"\u5df2\u5220\u9664\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"IntopoolOpService_0", (String)"fi-evp-common", (Object[])new Object[0]), billid);
                        this.addMessage(exData, err, ErrorLevel.Error);
                    }
                    if (isintopoolids.contains(tempId)) {
                        err = String.format(ResManager.loadKDString((String)"\u5df2\u5165\u6c60\uff0c\u65e0\u9700\u518d\u91cd\u590d\u5165\u6c60\u3002", (String)"IntopoolOpService_1", (String)"fi-evp-common", (Object[])new Object[0]), billid);
                        this.addMessage(exData, err, ErrorLevel.Error);
                    }
                    if (!noVoucherids.contains(tempId)) continue;
                    err = String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u5173\u8054\u7684\u51ed\u8bc1\uff0c\u5165\u6c60\u5931\u8d25\u3002", (String)"IntopoolOpService_2", (String)"fi-evp-common", (Object[])new Object[0]), billid);
                    this.addMessage(exData, err, ErrorLevel.Error);
                }
            }

            private List<Long> getIntopoolids(String billType, List<Object> pkIds) {
                ArrayList<Long> ids = new ArrayList<Long>(16);
                QFilter qFilter = new QFilter(IntopoolOpService.ISINTOPOOL, "=", (Object)"1");
                QFilter idFilter = new QFilter(IntopoolOpService.ID, "in", pkIds);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)billType, (String)IntopoolOpService.ID, (QFilter[])new QFilter[]{qFilter, idFilter}, null);){
                    for (Row row : ds) {
                        ids.add(row.getLong(IntopoolOpService.ID));
                    }
                }
                return ids;
            }

            private List<Long> getDeletedids(String billType, List<Object> pkIds) {
                ArrayList<Long> ids = new ArrayList<Long>(16);
                QFilter qFilter = new QFilter(IntopoolOpService.ISDELETE, "=", (Object)"1");
                QFilter idFilter = new QFilter(IntopoolOpService.ID, "in", pkIds);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)billType, (String)IntopoolOpService.ID, (QFilter[])new QFilter[]{qFilter, idFilter}, null);){
                    for (Row row : ds) {
                        ids.add(row.getLong(IntopoolOpService.ID));
                    }
                }
                return ids;
            }

            private List<Long> noVoucherids(String billType, List<Object> pkIds) {
                HashMap<Long, Object> billAndVoucher = new HashMap<Long, Object>(16);
                QFilter idFilter = new QFilter(IntopoolOpService.ID, "in", pkIds);
                QFilter idFilter2 = new QFilter(IntopoolOpService.ISDELETE, "=", (Object)"0");
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)billType, (String)"id,voucherid", (QFilter[])new QFilter[]{idFilter, idFilter2}, null);){
                    for (Row row : ds) {
                        billAndVoucher.put(row.getLong(IntopoolOpService.ID), row.get(IntopoolOpService.VOUCHERID));
                    }
                }
                QFilter voucherFilter = new QFilter(IntopoolOpService.BILLID, "in", billAndVoucher.values());
                DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"evp_voucher", (String)"id,billid,voucherno,period", (QFilter[])new QFilter[]{voucherFilter, idFilter2}, null);
                Object object = null;
                try {
                    for (Row row : ds) {
                        Object voucherid = row.get(IntopoolOpService.BILLID);
                        IntopoolOpService.this.voucherids.add(voucherid);
                        IntopoolOpService.this.voucherIdVoucherNo.put(voucherid, row.getString(IntopoolOpService.VOUCHERNO));
                        IntopoolOpService.this.voucherIdAndPeriod.put(voucherid, row.getLong(IntopoolOpService.PERIOD));
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (ds != null) {
                        if (object != null) {
                            try {
                                ds.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            ds.close();
                        }
                    }
                }
                billAndVoucher.entrySet().removeIf(entry -> IntopoolOpService.this.voucherids.contains(entry.getValue()));
                return new ArrayList<Long>(billAndVoucher.keySet());
            }
        });
        super.addDefaultValidator(validators);
    }

    protected void executeOperate(DynamicObject[] arg0) {
        Map voucherjson = BuildFileUtils.getVoucherJson(new HashSet<Object>(this.voucherids));
        List<DynamicObject> dyns = Arrays.asList(arg0);
        Set sourceIds = dyns.stream().map(o -> o.get(BILLID)).collect(Collectors.toSet());
        Map returnJson = BuildFileUtils.getInvoiceJson((String)this.billType, sourceIds);
        Date date = new Date();
        for (DynamicObject dynamicObject : arg0) {
            Long id = dynamicObject.getLong(ID);
            Object billid = dynamicObject.get(BILLID);
            Object voucherid = dynamicObject.get(VOUCHERID);
            JSONObject json = (JSONObject)returnJson.get(billid);
            JSONObject vjson = (JSONObject)voucherjson.get(voucherid);
            if (vjson == null) {
                logger.error("IntopoolOpService error billtype : {} billid : {}", (Object)this.billType, billid);
                continue;
            }
            JSONObject vJson = new JSONObject();
            vJson.put("UnifiedSocialCreditCodeOfAccountingEntity", ((JSONObject)voucherjson.get(voucherid)).get((Object)"UnifiedSocialCreditCodeOfAccountingEntity"));
            vJson.put("NameOfAccountingEntity", ((JSONObject)voucherjson.get(voucherid)).get((Object)"NameOfAccountingEntity"));
            vJson.put("InformationOfAccountingDocumentsTuple", voucherjson.get(voucherid));
            json.putAll((Map)vJson);
            String tickteType = (String)EVoucherModel.TICKETTYPEMAP.get(this.billType);
            if ("einv_ord_receiver".equals(tickteType) || "einv_spcl_receiver".equals(tickteType)) {
                json.put("RequestTime", (Object)DateFomatUtils.format((Date)json.getDate("RequestTime"), (String)"yyyy-MM-dd HH:mm:ss"));
            }
            byte[] xbrlbytes = BuildFileUtils.json2Xbrl((String)json.toJSONString(), (String)tickteType);
            String xbrlurl = FileUtils.uploadFile((byte[])xbrlbytes, (String)dynamicObject.getString(ID), (String)this.billType, (String)EVoucherModel.createXBRLFilename((String)tickteType, (JSONObject)json));
            dynamicObject.set(VOUCHERNO, (Object)this.voucherIdVoucherNo.get(voucherid));
            dynamicObject.set(PERIOD, (Object)this.voucherIdAndPeriod.get(voucherid));
            dynamicObject.set(ISINTOPOOL, (Object)"1");
            dynamicObject.set(INTOPOOLDATE, (Object)date);
            dynamicObject.set(OPERATOR, (Object)UserServiceHelper.getCurrentUserId());
            dynamicObject.set(XBRLURL, (Object)xbrlurl);
        }
        SaveServiceHelper.save((DynamicObject[])arg0);
    }
}

