/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OutpoolOpService
extends EntityOperateService {
    private String billType;
    private static final String ID = "id";
    private static final String BILLID = "billid";
    private static final String VOUCHERNO = "voucherno";
    private static final String ISINTOPOOL = "isintopool";
    private static final String ISARCHIVE = "isarchive";
    private static final String XBRLURL = "xbrlurl";
    private static final String OPERATOR = "operator";
    private static final String INTOPOOLDATE = "intopooldate";
    private static final String PERIOD = "period";

    protected void preparePropertys(List<String> fieldKeys) {
        fieldKeys.add(ID);
        fieldKeys.add(BILLID);
        fieldKeys.add(VOUCHERNO);
        fieldKeys.add(ISINTOPOOL);
        fieldKeys.add(ISARCHIVE);
        fieldKeys.add(OPERATOR);
        fieldKeys.add(INTOPOOLDATE);
        fieldKeys.add(PERIOD);
        fieldKeys.add(XBRLURL);
        super.preparePropertys(fieldKeys);
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        this.billType = this.billEntityType.getName();
        validators.add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] exDatas = this.getDataEntities();
                List<ExtendedDataEntity> list = Arrays.asList(exDatas);
                List<Object> pkIds = list.stream().map(p -> p.getBillPkId()).collect(Collectors.toList());
                List<Long> isintopoolids = this.getIntopoolids(OutpoolOpService.this.billType, pkIds);
                List<Long> deletedids = this.getArchivedids(OutpoolOpService.this.billType, pkIds);
                for (ExtendedDataEntity exData : exDatas) {
                    String err;
                    Long tempId = (Long)exData.getBillPkId();
                    Object billid = exData.getValue(OutpoolOpService.BILLID);
                    if (deletedids.contains(tempId)) {
                        err = String.format(ResManager.loadKDString((String)"\u5df2\u5f52\u6863\uff0c\u4e0d\u53ef\u4ee5\u53cd\u5165\u6c60\u3002", (String)"OutpoolOpService_0", (String)"fi-evp-common", (Object[])new Object[0]), billid);
                        this.addMessage(exData, err, ErrorLevel.Error);
                    }
                    if (!isintopoolids.contains(tempId)) continue;
                    err = String.format(ResManager.loadKDString((String)"\u672a\u5165\u6c60\uff0c\u4e0d\u53ef\u4ee5\u53cd\u5165\u6c60\u3002", (String)"OutpoolOpService_1", (String)"fi-evp-common", (Object[])new Object[0]), billid);
                    this.addMessage(exData, err, ErrorLevel.Error);
                }
            }

            private List<Long> getIntopoolids(String billType, List<Object> pkIds) {
                ArrayList<Long> ids = new ArrayList<Long>(16);
                QFilter qFilter = new QFilter(OutpoolOpService.ISINTOPOOL, "=", (Object)"0");
                QFilter idFilter = new QFilter(OutpoolOpService.ID, "in", pkIds);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)billType, (String)OutpoolOpService.ID, (QFilter[])new QFilter[]{qFilter, idFilter}, null);){
                    for (Row row : ds) {
                        ids.add(row.getLong(OutpoolOpService.ID));
                    }
                }
                return ids;
            }

            private List<Long> getArchivedids(String billType, List<Object> pkIds) {
                ArrayList<Long> ids = new ArrayList<Long>(16);
                QFilter qFilter = new QFilter(OutpoolOpService.ISARCHIVE, "=", (Object)"1");
                QFilter idFilter = new QFilter(OutpoolOpService.ID, "in", pkIds);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)billType, (String)OutpoolOpService.ID, (QFilter[])new QFilter[]{qFilter, idFilter}, null);){
                    for (Row row : ds) {
                        ids.add(row.getLong(OutpoolOpService.ID));
                    }
                }
                return ids;
            }
        });
        super.addDefaultValidator(validators);
    }

    protected void executeOperate(DynamicObject[] arg0) {
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        ArrayList<String> enableids = new ArrayList<String>(16);
        ArrayList<String> xbrlurls = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : arg0) {
            String id = dynamicObject.getString(ID);
            enableids.add(id);
            String billid = dynamicObject.getString(BILLID);
            String xbrlurl = dynamicObject.getString(XBRLURL);
            if (StringUtils.isNotBlank((CharSequence)xbrlurl)) {
                attachmentFileService.delete(xbrlurl);
                xbrlurls.add(xbrlurl);
            }
            dynamicObject.set(ISINTOPOOL, (Object)"0");
            dynamicObject.set(INTOPOOLDATE, null);
            dynamicObject.set(OPERATOR, (Object)0L);
            dynamicObject.set(XBRLURL, (Object)"");
        }
        try (TXHandle txHandle = TX.requiresNew((String)"kd.fi.evp.opplugin.SoftDeleteOp");){
            try {
                QFilter qFilter2 = new QFilter("fbilltype", "=", (Object)this.billType);
                qFilter2.and(new QFilter("finterid", "in", enableids));
                qFilter2.and(new QFilter("ffileid", "in", xbrlurls));
                DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])new QFilter[]{qFilter2});
            }
            catch (Exception err) {
                txHandle.markRollback();
                throw err;
            }
        }
        SaveServiceHelper.save((DynamicObject[])arg0);
    }
}

