/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.evp.model.ArchiveReturnVo;
import kd.bos.ext.fi.evp.model.ReverseParamVo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.evp.business.invoke.InvokeBizQueryService;
import kd.fi.evp.common.util.ArchiveUtils;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.common.util.EVoucherModel;
import kd.fi.evp.common.util.SysConfigUtil;
import kd.fi.evp.entity.ArchiveDetailLogVo;

public class ReverseArchiveOpService
extends EntityOperateService {
    private static final Log logger = LogFactory.getLog(ReverseArchiveOpService.class);
    private String billType;
    private List<Long> errids = new ArrayList<Long>(16);
    public static final int BATCHNUM = 1000;
    private static final String ID = "id";
    private static final String BILLID = "billid";
    private static final String VOUCHERNO = "voucherno";
    private static final String ISINTOPOOL = "isintopool";
    private static final String VOUCHERID = "voucherid";
    private static final String OPERATOR = "operator";
    private static final String XBRLURL = "xbrlurl";
    private static final String INTOPOOLDATE = "intopooldate";
    private static final String PERIOD = "period";
    private static final String FILEURL = "fileurl_tag";
    private static final String ISARCHIVE = "isarchive";
    private static final String ARCHIVEBATCHCODE = "archivebatchcode";
    private static final String BOOKDATE = "bookdate";
    private static final String ORG = "org";
    private static final String SEQNO = "seqno";

    protected void preparePropertys(List<String> fieldKeys) {
        fieldKeys.add(ID);
        fieldKeys.add(BILLID);
        fieldKeys.add(VOUCHERNO);
        fieldKeys.add(ISINTOPOOL);
        fieldKeys.add(VOUCHERID);
        fieldKeys.add(OPERATOR);
        fieldKeys.add(XBRLURL);
        fieldKeys.add(INTOPOOLDATE);
        fieldKeys.add(PERIOD);
        fieldKeys.add(INTOPOOLDATE);
        fieldKeys.add(PERIOD);
        fieldKeys.add(FILEURL);
        fieldKeys.add(ISARCHIVE);
        fieldKeys.add(BOOKDATE);
        fieldKeys.add(ORG);
        fieldKeys.add(BOOKDATE);
        fieldKeys.add(SEQNO);
        fieldKeys.add(FILEURL);
        fieldKeys.add(ARCHIVEBATCHCODE);
        super.preparePropertys(fieldKeys);
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        this.billType = this.billEntityType.getName();
        validators.add(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] exDatas = this.getDataEntities();
                List<ExtendedDataEntity> list = Arrays.asList(exDatas);
                List<Object> pkIds = list.stream().map(p -> p.getBillPkId()).collect(Collectors.toList());
                List<Long> notarchiveids = this.getnotarchiveids(ReverseArchiveOpService.this.billType, pkIds);
                for (ExtendedDataEntity exData : exDatas) {
                    Long tempId = (Long)exData.getBillPkId();
                    Object billid = exData.getValue(ReverseArchiveOpService.BILLID);
                    if (!notarchiveids.contains(tempId)) continue;
                    String err = String.format(ResManager.loadKDString((String)"\u672a\u5f52\u6863\uff0c\u65e0\u9700\u53cd\u5f52\u6863\u3002", (String)"ReverseArchiveOpService_0", (String)"fi-evp-common", (Object[])new Object[0]), billid);
                    this.addMessage(exData, err, ErrorLevel.Error);
                }
            }

            private List<Long> getnotarchiveids(String billType, List<Object> pkIds) {
                ArrayList<Long> ids = new ArrayList<Long>(16);
                QFilter qFilter = new QFilter(ReverseArchiveOpService.ISARCHIVE, "=", (Object)"0");
                QFilter idFilter = new QFilter(ReverseArchiveOpService.ID, "in", pkIds);
                try (DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)billType, (String)ReverseArchiveOpService.ID, (QFilter[])new QFilter[]{qFilter, idFilter}, null);){
                    for (Row row : ds) {
                        ids.add(row.getLong(ReverseArchiveOpService.ID));
                    }
                }
                return ids;
            }
        });
        super.addDefaultValidator(validators);
    }

    protected void executeOperate(DynamicObject[] arg0) {
        String archiveclass = SysConfigUtil.getString((String)"archiveclass");
        Map tempdyns = ArchiveUtils.splitReversedata((DynamicObject[])arg0, (String)this.billEntityType.getName());
        String archivebatchcode = UUID.randomUUID().toString();
        for (Map.Entry entry : tempdyns.entrySet()) {
            Long orgid = (Long)entry.getKey();
            Map map = (Map)entry.getValue();
            for (Map.Entry entry2 : map.entrySet()) {
                Long period = Long.parseLong((String)entry2.getKey());
                List dyns = (List)entry2.getValue();
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"evp_archivelog");
                DynamicObject logEntity = (DynamicObject)type.createInstance();
                logEntity.set("username", (Object)RequestContext.get().getUserName());
                logEntity.set("opname", (Object)ResManager.loadKDString((String)"\u53cd\u5f52\u6863", (String)"ReverseArchiveOpService_1", (String)"fi-evp-common", (Object[])new Object[0]));
                logEntity.set("opdesc", (Object)"reversearchive");
                logEntity.set("opdate", (Object)new Date());
                logEntity.set("orgnumber", ((DynamicObject)dyns.get(0)).get("org.number"));
                logEntity.set("orgname", ((DynamicObject)dyns.get(0)).get("org.name"));
                logEntity.set("archivedate", (Object)new Date());
                logEntity.set("allcount", (Object)dyns.size());
                try (TXHandle txHandle = TX.requiresNew((String)"kd.fi.evp.opplugin.ReverseArchiveOpService");){
                    try {
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logEntity});
                        Long logid = logEntity.getLong(ID);
                        ArchiveReturnVo returnVo = this.reverse(dyns, archiveclass);
                        ArchiveDetailLogVo archiveDetailLogVo = new ArchiveDetailLogVo(logid, ResManager.loadKDString((String)"\u53cd\u5f52\u6863", (String)"ReverseArchiveOpService_1", (String)"fi-evp-common", (Object[])new Object[0]), "reversearchive", ((DynamicObject)dyns.get(0)).getString("org.number"), this.billEntityType.getName(), this.billEntityType.getDisplayName().toString(), "1", archivebatchcode, "", Integer.valueOf(dyns.size()), Integer.valueOf(dyns.size()));
                        if (returnVo.getErrids() != null && returnVo.getErrids().size() > 0) {
                            this.errids.addAll(returnVo.getErrids());
                            archiveDetailLogVo.setStatus("0");
                            archiveDetailLogVo.setErrmsg(returnVo.getErrmsg());
                            archiveDetailLogVo.setSuccesscnt(Integer.valueOf(arg0.length - returnVo.getErrids().size()));
                        }
                        ArchiveUtils.saveDetail((ArchiveDetailLogVo)archiveDetailLogVo);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                        txHandle.markRollback();
                        throw e;
                    }
                }
                for (DynamicObject dynamicObject : dyns) {
                    Long id = dynamicObject.getLong(ID);
                    Object billid = dynamicObject.get(BILLID);
                    if (this.errids.contains(id)) continue;
                    dynamicObject.set(ISARCHIVE, (Object)"0");
                    dynamicObject.set(ARCHIVEBATCHCODE, (Object)archivebatchcode);
                }
                SaveServiceHelper.save((DynamicObject[])arg0);
            }
        }
    }

    private ArchiveReturnVo reverse(List<DynamicObject> dyns, Object archiveclass) {
        ReverseParamVo reverseParamVo = new ReverseParamVo();
        List ids = dyns.stream().map(o -> o.getLong(ID)).collect(Collectors.toList());
        DynamicObject dynamicObject = dyns.get(0);
        Long orgid = dynamicObject.getLong("org_id");
        String orgnumber = dynamicObject.getString("org.number");
        String orgname = dynamicObject.getString("org.name");
        Long period = null;
        String periodnumber = null;
        String periodname = null;
        if (!"evp_bkrs".equals(this.billEntityType.getName())) {
            period = dynamicObject.getLong("period_id");
            periodnumber = dynamicObject.getString("period.number");
            periodname = dynamicObject.getString("period.name");
        }
        reverseParamVo.setOrgid(orgid);
        reverseParamVo.setOrgname(orgname);
        reverseParamVo.setOrgnumber(orgnumber);
        reverseParamVo.setPeriodid(period);
        reverseParamVo.setPeriodname(periodname);
        reverseParamVo.setPeriodnumber(periodnumber);
        reverseParamVo.setYearandmonth(DateFomatUtils.format((Date)dynamicObject.getDate(BOOKDATE), (String)"yyyyMM"));
        reverseParamVo.setTickettype((String)EVoucherModel.TICKETTYPEMAP.get(this.billEntityType.getName()));
        reverseParamVo.setIds(ids);
        ArchiveReturnVo returnVo = new ArchiveReturnVo();
        try {
            returnVo = InvokeBizQueryService.reversearchive((ReverseParamVo)reverseParamVo, (String)archiveclass.toString());
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        return returnVo;
    }
}

