/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.evp.common.util.EVoucherModel;
import kd.fi.evp.validate.SoftDeleteValidator;

public class SoftDeleteOp
extends AbstractOperationServicePlugIn {
    private static final Long ORIGINSYSID = 100000L;
    private static final String ORIGINSYS = "originsys";
    private static final String ORIGINSYS_ID = "originsys_id";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("isdelete");
        e.getFieldKeys().add("isintopool");
        e.getFieldKeys().add("fileurl_tag");
        e.getFieldKeys().add("xbrlurl");
        e.getFieldKeys().add("ishandle");
        e.getFieldKeys().add(ORIGINSYS);
        e.getFieldKeys().add("billid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new SoftDeleteValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        String entity = this.billEntityType.getName();
        DynamicObject[] dyns = e.getDataEntities();
        ArrayList<Long> enableids = new ArrayList<Long>(16);
        ArrayList<String> fileurls = new ArrayList<String>(16);
        ArrayList<String> orginVoucherIds = new ArrayList<String>(16);
        for (DynamicObject dynamicObject : dyns) {
            dynamicObject.set("isdelete", (Object)"1");
            dynamicObject.set("isintopool", (Object)"0");
            if (!"evp_voucher".equals(entity) || !ORIGINSYSID.equals(dynamicObject.getLong(ORIGINSYS_ID))) continue;
            orginVoucherIds.add(dynamicObject.getString("billid"));
        }
        SaveServiceHelper.save((DynamicObject[])dyns);
        if (orginVoucherIds.size() > 0) {
            DynamicObject[] billmap = this.getLinkBillids(orginVoucherIds);
            for (Map.Entry<String, List<Long>> entry : billmap.entrySet()) {
                String billtype = entry.getKey();
                List<Long> ids = entry.getValue();
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"delete", (String)billtype, (Object[])ids.toArray(), (OperateOption)OperateOption.create());
            }
            return;
        }
        if ("evp_voucher".equals(entity)) {
            return;
        }
        for (DynamicObject dynamicObject : dyns) {
            enableids.add(dynamicObject.getLong("id"));
            List<String> urls = Arrays.asList(dynamicObject.getString("fileurl_tag").split(";"));
            for (String string : urls) {
                fileurls.add(string);
            }
            fileurls.add(dynamicObject.getString("xbrlurl"));
        }
        TXHandle txHandle = TX.requiresNew((String)"kd.fi.evp.opplugin.SoftDeleteOp");
        Object object = null;
        try {
            try {
                QFilter qFilter2 = new QFilter("fbilltype", "=", (Object)entity);
                qFilter2.and(new QFilter("finterid", "in", enableids.stream().map(x -> String.valueOf(x)).collect(Collectors.toSet())));
                DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])new QFilter[]{qFilter2});
            }
            catch (Exception err) {
                txHandle.markRollback();
                throw err;
            }
        }
        catch (Throwable err) {
            object = err;
            throw err;
        }
        finally {
            if (txHandle != null) {
                if (object != null) {
                    try {
                        txHandle.close();
                    }
                    catch (Throwable err) {
                        ((Throwable)object).addSuppressed(err);
                    }
                } else {
                    txHandle.close();
                }
            }
        }
        FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
        for (String url : fileurls) {
            if (!StringUtils.isNotBlank((CharSequence)url)) continue;
            attachmentFileService.delete(url);
        }
    }

    private Map<String, List<Long>> getLinkBillids(List<String> billids) {
        HashMap<String, List<Long>> returnmap = new HashMap<String, List<Long>>(16);
        Set tables = EVoucherModel.TICKETTYPEMAP.keySet();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("voucherid", "in", billids));
        for (String string : tables) {
            DataSet dataset = QueryServiceHelper.queryDataSet((String)"SoftDeleteOp.getLinkBillids", (String)string, (String)"id,voucherid,billid", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id");
            Throwable throwable = null;
            try {
                for (Row row : dataset) {
                    Long id = row.getLong("id");
                    returnmap.computeIfAbsent(string, value -> new ArrayList()).add(id);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataset == null) continue;
                if (throwable != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataset.close();
            }
        }
        return returnmap;
    }
}

