/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.opplugin.base;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.plugin.args.InitOperationArgs;
import kd.bos.entity.plugin.args.ReturnOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.openapi.service.context.ServiceApiContext;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.fi.evp.common.constant.enums.DataFromType;
import kd.fi.evp.common.util.AccountingSysUtil;
import kd.fi.evp.common.util.BuildFileUtils;
import kd.fi.evp.common.util.DateFomatUtils;
import kd.fi.evp.common.util.EVoucherModel;
import kd.fi.evp.common.util.FileUtils;
import kd.fi.evp.entity.Attach;
import org.apache.commons.io.FilenameUtils;

public class BaseOriginDataSaveOp
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(BaseOriginDataSaveOp.class);
    private static final String ISHANDLE = "ishandle";
    private static final String ID = "id";
    private static final String ISINTOPOOL = "isintopool";
    private static final String BASETEXT_TAG = "basetext_tag";
    private static final String FILENAME = "filename";
    private static final String FILEURL_TAG = "fileurl_tag";
    private static final String FILEURL = "fileurl";
    private static final String ISDELETE = "isdelete";
    private static final String CREATEDATE = "createdate";
    private static final String INTOPOOLDATE = "intopooldate";
    private static final String CREATOR = "creator";
    private static final String SEQNO = "seqno";
    private static final String ORIGINSYS = "originsys";
    private static final String BILLID = "billid";
    private static final String VOUCHERID = "voucherid";
    private static final String OPERATOR = "operator";
    private static final String XBRLURL = "xbrlurl";
    private static final String ORG = "org";
    private static final String BOOKTYPE = "booktype";
    private static final String PERIODTYPE = "periodtype";
    private static final String BOOKDATE = "bookdate";
    private static final String PERIOD = "period";
    private static final String BILLNO = "billno";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add(BASETEXT_TAG);
        e.getFieldKeys().add(FILENAME);
        e.getFieldKeys().add(FILEURL);
        e.getFieldKeys().add(FILEURL_TAG);
        e.getFieldKeys().add(ISINTOPOOL);
        e.getFieldKeys().add(ISDELETE);
        e.getFieldKeys().add(CREATEDATE);
        e.getFieldKeys().add(CREATOR);
        e.getFieldKeys().add(SEQNO);
        e.getFieldKeys().add(BASETEXT_TAG);
        e.getFieldKeys().add(ORIGINSYS);
        e.getFieldKeys().add(BILLID);
        e.getFieldKeys().add(VOUCHERID);
        e.getFieldKeys().add(ORG);
        e.getFieldKeys().add(BOOKTYPE);
        e.getFieldKeys().add(PERIODTYPE);
        e.getFieldKeys().add(BOOKDATE);
        e.getFieldKeys().add(PERIOD);
        e.getFieldKeys().add(BILLNO);
    }

    public void initialize(InitOperationArgs e) {
        super.initialize(e);
        if (ServiceApiContext.getContext() != null) {
            this.getOption().setVariableValue(ISHANDLE, DataFromType.API.getValue());
        }
        this.getOption().setVariableValue("opdate", DateFomatUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
    }

    public void onAddValidators(final AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                if (e.getDataEntities().length > 0) {
                    if (!this.getOption().containsVariable(BaseOriginDataSaveOp.ISHANDLE)) {
                        this.getOption().setVariableValue(BaseOriginDataSaveOp.ISHANDLE, DataFromType.ADD.getValue());
                    }
                    DynamicObject firstRow = e.getDataEntities()[0];
                    boolean fromDatabase = firstRow.getDataEntityState().getFromDatabase();
                    String batchcode = firstRow.getString("batchcode");
                    firstRow.getBoolean(BaseOriginDataSaveOp.ISDELETE);
                    this.getOption().setVariableValue("batchcode", batchcode);
                    if (fromDatabase) {
                        this.getOption().setVariableValue("opdesc", "update");
                    } else {
                        this.getOption().setVariableValue("opdesc", "add");
                    }
                }
                String entity = this.getEntityKey();
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    String filename;
                    String base64;
                    dataEntity.getDataEntity().set(BaseOriginDataSaveOp.BILLNO, (Object)dataEntity.getDataEntity().getString(BaseOriginDataSaveOp.BILLID));
                    boolean isdelete = dataEntity.getDataEntity().getBoolean(BaseOriginDataSaveOp.ISDELETE);
                    boolean frombase = dataEntity.getDataEntity().getDataEntityState().getFromDatabase();
                    if (frombase && !isdelete && !DataFromType.ADD.getValue().equals(this.getOption().getVariableValue(BaseOriginDataSaveOp.ISHANDLE))) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4fee\u6539\u6570\u636e\u3002", (String)"BaseOriginDataSaveOp_8", (String)"fi-evp-common", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if ("evp_voucher".equals(entity)) {
                        this.checkVouhcerParam(dataEntity);
                        continue;
                    }
                    if ("evp_bkrs".equals(entity)) {
                        this.checkBkrsParam(dataEntity);
                    }
                    if (!StringUtils.isNotBlank((CharSequence)(base64 = dataEntity.getDataEntity().getString(BaseOriginDataSaveOp.BASETEXT_TAG))) || !StringUtils.isBlank((CharSequence)(filename = dataEntity.getDataEntity().getString(BaseOriginDataSaveOp.FILENAME)))) continue;
                    String mString = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6587\u4ef6\u540d\u3002", (String)"BaseOriginDataSaveOp_2", (String)"fi-evp-common", (Object[])new Object[0]);
                    this.addMessage(dataEntity, mString, ErrorLevel.Error);
                }
            }

            private void checkVouhcerParam(ExtendedDataEntity dataEntity) {
                Long orgid = dataEntity.getDataEntity().getLong("org_id");
                Long booktypeid = dataEntity.getDataEntity().getLong("booktype_id");
                QFilter orgF = new QFilter(BaseOriginDataSaveOp.ORG, "=", (Object)orgid);
                QFilter typeB = new QFilter("bookstype", "=", (Object)booktypeid);
                if (DataFromType.API.getValue().equals(this.getOption().getVariableValue(BaseOriginDataSaveOp.ISHANDLE))) {
                    Long periodtypeid = dataEntity.getDataEntity().getLong("periodtype_id");
                    Date bookdate = dataEntity.getDataEntity().getDate(BaseOriginDataSaveOp.BOOKDATE);
                    String billid = dataEntity.getDataEntity().getString(BaseOriginDataSaveOp.BILLID);
                    Long period = 0L;
                    try {
                        if (periodtypeid == 0L) {
                            DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,curperiod,periodtype,startperiod", (QFilter[])new QFilter[]{orgF, typeB});
                            periodtypeid = dyn.getLong(BaseOriginDataSaveOp.PERIODTYPE);
                            period = AccountingSysUtil.getPeriodByDate((Long)periodtypeid, (Date)bookdate);
                        } else {
                            period = AccountingSysUtil.getPeriodByDate((Long)periodtypeid, (Date)bookdate);
                        }
                        if (period == null || period == 0L) {
                            logger.error("voucher : {}, bookdate illegal {}", (Object)billid, (Object)bookdate);
                            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5408\u6cd5\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BaseOriginDataSaveOp_7", (String)"fi-evp-common", (Object[])new Object[0]), ErrorLevel.Error);
                        }
                    }
                    catch (Exception e2) {
                        logger.error("voucher : {}, bookdate illegal {}", (Object)billid, (Object)e2);
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u4e0d\u5408\u6cd5\u3002", (String)"BaseOriginDataSaveOp_6", (String)"fi-evp-common", (Object[])new Object[0]), ErrorLevel.Error);
                    }
                } else {
                    DynamicObject dyn = QueryServiceHelper.queryOne((String)"gl_accountbook", (String)"id,curperiod,periodtype,startperiod", (QFilter[])new QFilter[]{orgF, typeB});
                    if (dyn == null || dyn.getLong(BaseOriginDataSaveOp.PERIODTYPE) == 0L) {
                        String mString = ResManager.loadKDString((String)"\u8be5\u8d26\u7c3f\u6ca1\u6709\u671f\u95f4\u7c7b\u578b\u3002", (String)"BaseOriginDataSaveOp_9", (String)"fi-evp-common", (Object[])new Object[0]);
                        this.addMessage(dataEntity, mString, ErrorLevel.Error);
                    }
                }
            }

            private void checkBkrsParam(ExtendedDataEntity dataEntity) {
                String year = dataEntity.getDataEntity().getString("reconyear");
                String month = dataEntity.getDataEntity().getString("reconmonth");
                String regex = "\\d{4}";
                boolean matches = Pattern.matches(regex, year);
                if (!matches) {
                    String mString = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u5bf9\u8d26\u5355\u5e74\u4efd\u3002", (String)"BaseOriginDataSaveOp_4", (String)"fi-evp-common", (Object[])new Object[0]);
                    this.addMessage(dataEntity, mString, ErrorLevel.Error);
                }
                try {
                    int imonth = Integer.parseInt(month);
                    if (imonth > 12 || imonth < 1) {
                        String mString = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u5bf9\u8d26\u5355\u6708\u4efd\u3002", (String)"BaseOriginDataSaveOp_5", (String)"fi-evp-common", (Object[])new Object[0]);
                        this.addMessage(dataEntity, mString, ErrorLevel.Error);
                    }
                }
                catch (Exception e2) {
                    String mString = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6b63\u786e\u7684\u5bf9\u8d26\u5355\u6708\u4efd\u3002", (String)"BaseOriginDataSaveOp_5", (String)"fi-evp-common", (Object[])new Object[0]);
                    this.addMessage(dataEntity, mString, ErrorLevel.Error);
                }
            }
        });
        super.onAddValidators(e);
    }

    public void onReturnOperation(ReturnOperationArgs e) {
        super.onReturnOperation(e);
        try {
            OperationResult operationResult = (OperationResult)e.getOperationResult();
            List successPkIds = operationResult.getSuccessPkIds();
            MainEntityType logEntityType = MetadataServiceHelper.getDataEntityType((String)"evp_oridata_log");
            DynamicObject logEntity = new DynamicObject((DynamicObjectType)logEntityType);
            logEntity.set("username", (Object)RequestContext.get().getUserName());
            logEntity.set("opname", (Object)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"BaseOriginDataSaveOp_1", (String)"fi-evp-common", (Object[])new Object[0]));
            String opdesc = this.getOption().getVariableValue("opdesc");
            logEntity.set("opdesc", (Object)opdesc);
            String opdate = this.getOption().getVariableValue("opdate");
            Date opDate = DateFomatUtils.stringToDate((String)opdate, (String)"yyyy-MM-dd HH:mm:ss");
            logEntity.set("opdate", (Object)opDate);
            logEntity.set("endtime", (Object)new Date());
            logEntity.set("recordcnt", (Object)operationResult.getBillCount());
            logEntity.set("successcnt", (Object)successPkIds.size());
            logEntity.set("entitynumber", (Object)this.billEntityType.getName());
            logEntity.set("entityname", (Object)this.billEntityType.getDisplayName().getLocaleValue());
            String batchcode = this.getOption().getVariableValue("batchcode");
            logEntity.set("batchcode", (Object)batchcode);
            if (operationResult.isSuccess()) {
                logEntity.set("status", (Object)"1");
            } else {
                logEntity.set("status", (Object)"0");
                List errorList = operationResult.getAllErrorOrValidateInfo();
                Map<Object, List<IOperateInfo>> billErrorGroup = errorList.stream().collect(Collectors.groupingBy(IOperateInfo::getPkValue));
                ArrayList<String> errorInfos = new ArrayList<String>(billErrorGroup.size());
                for (Map.Entry<Object, List<IOperateInfo>> billErrorList : billErrorGroup.entrySet()) {
                    List<IOperateInfo> bills = billErrorList.getValue();
                    if (bills == null || bills.size() == 0) continue;
                    StringBuilder errorBuilder = new StringBuilder();
                    String billTitle = bills.get(0).getTitle();
                    errorBuilder.append("billId=").append(billTitle).append(":");
                    for (IOperateInfo opInfo : billErrorList.getValue()) {
                        errorBuilder.append(opInfo.getMessage());
                    }
                    errorInfos.add(errorBuilder.toString());
                }
                String join = String.join((CharSequence)"\r\n", errorInfos);
                join = join.length() > 1000 ? join.substring(0, 1000) : join;
                logEntity.set("errmsg", (Object)join);
            }
            LogORM.create().insert(Collections.singletonList(logEntity));
        }
        catch (Throwable ex) {
            logger.error("\u65e5\u5fd7\u8bb0\u5f55\u5931\u8d25", ex);
        }
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dyns = e.getDataEntities();
        Date date = new Date();
        long uid = UserServiceHelper.getCurrentUserId();
        boolean isadd = "add".equals(this.getOption().getVariableValue("opdesc"));
        Map<String, DynamicObject> voucherNos = this.getVoucherFields(dyns);
        for (DynamicObject dynamicObject : dyns) {
            if (DataFromType.ADD.getValue().equals(this.getOption().getVariableValue(ISHANDLE)) && isadd) {
                Long id = DBServiceHelper.genGlobalLongId();
                dynamicObject.set(ID, (Object)id);
                dynamicObject.set(BILLID, (Object)id);
            }
            dynamicObject.set(BILLNO, dynamicObject.get(BILLID));
            dynamicObject.set(ISDELETE, (Object)"0");
            dynamicObject.set(CREATEDATE, (Object)date);
            dynamicObject.set("creator_id", (Object)uid);
            dynamicObject.set(ISINTOPOOL, (Object)"0");
            if ("evp_voucher".equals(this.billEntityType.getName())) {
                dynamicObject.set(ISINTOPOOL, (Object)"1");
                dynamicObject.set(INTOPOOLDATE, (Object)date);
                dynamicObject.set("operator_id", (Object)uid);
                dynamicObject.set("creator_id", (Object)uid);
                dynamicObject.set(BILLNO, (Object)dynamicObject.getString("voucherno"));
                if (dynamicObject.get(PERIOD) != null && dynamicObject.getLong("period_id") != 0L) continue;
                this.writePeriod(dynamicObject);
                continue;
            }
            if ("evp_bkrs".equals(this.billEntityType.getName())) {
                this.buildrecondate(e.getDataEntities());
            } else {
                DynamicObject vDyn;
                String voucherid = dynamicObject.getString(VOUCHERID);
                if (StringUtils.isNotEmpty((CharSequence)voucherid) && (vDyn = voucherNos.get(voucherid)) != null) {
                    dynamicObject.set("voucherno", (Object)vDyn.getString("voucherno"));
                    dynamicObject.set("period_id", (Object)vDyn.getLong(PERIOD));
                }
            }
            String base64 = dynamicObject.getString(BASETEXT_TAG);
            String filename = dynamicObject.getString(FILENAME);
            String orginsys = dynamicObject.getString(ORIGINSYS);
            String billid = dynamicObject.getString(BILLID);
            String fileurl = dynamicObject.getString(FILEURL);
            if (StringUtils.isNotBlank((CharSequence)base64)) {
                if (base64.contains(",")) {
                    base64 = base64.split(",")[1];
                }
                byte[] bytes = FileUtils.Base64toByte((String)base64);
                String url = FileUtils.uploadOriFile((byte[])bytes, (String)dynamicObject.getString(ID), (String)this.billEntityType.getName(), (String)FilenameUtils.getName((String)filename), (String)orginsys, (Object)billid);
                dynamicObject.set(FILEURL_TAG, (Object)url);
                continue;
            }
            if (DataFromType.ADD.getValue().equals(this.getOption().getVariableValue(ISHANDLE))) continue;
            this.writeFileUrl(dynamicObject);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if ("evp_bkrs".equals(this.billEntityType.getName())) {
            this.writeBkrsXbrl(e.getDataEntities());
        }
        if (DataFromType.ADD.getValue().equals(this.getOption().getVariableValue(ISHANDLE)) && !"evp_voucher".equals(this.billEntityType.getName())) {
            DynamicObject[] dyns = e.getDataEntities();
            ArrayList<Long> ids = new ArrayList<Long>(16);
            ArrayList<String> xbrls = new ArrayList<String>(16);
            for (DynamicObject dynamicObject : dyns) {
                Long id = dynamicObject.getLong(ID);
                ids.add(id);
                xbrls.add(dynamicObject.getString(XBRLURL));
            }
            Map attachmap = FileUtils.getIdAndAttacheFiles((String)this.billEntityType.getName(), new HashSet(ids));
            for (DynamicObject dynamicObject : dyns) {
                Long id = dynamicObject.getLong(ID);
                if (!attachmap.containsKey(id)) continue;
                List attachs = (List)attachmap.get(id);
                attachs.removeIf(attach -> xbrls.contains(attach.getUrl()));
                StringBuilder fileBuilder = new StringBuilder();
                for (Attach attach2 : attachs) {
                    fileBuilder.append(attach2.getUrl()).append(";");
                }
                if (!StringUtils.isNotBlank((CharSequence)fileBuilder)) continue;
                dynamicObject.set(FILEURL_TAG, (Object)fileBuilder.substring(0, fileBuilder.length() - 1));
            }
            SaveServiceHelper.update((DynamicObject[])dyns);
        }
    }

    private void writeBkrsXbrl(DynamicObject[] dataEntities) {
        List<DynamicObject> dyns = Arrays.asList(dataEntities);
        Date date = new Date();
        Set sourceIds = dyns.stream().map(o -> o.get(BILLID)).collect(Collectors.toSet());
        List oldxbrlurls = dyns.stream().map(o -> o.getString(XBRLURL)).collect(Collectors.toList());
        QFilter qFilter2 = new QFilter("fbilltype", "=", (Object)"evp_bkrs");
        qFilter2.and(new QFilter("ffileid", "in", oldxbrlurls));
        Map returnJson = BuildFileUtils.getInvoiceJson((String)"evp_bkrs", sourceIds);
        try (TXHandle txHandle = TX.requiresNew((String)"kd.fi.evp.opplugin.base.BaseOriginDataSaveOp.writeBkrsXbrl");){
            try {
                DeleteServiceHelper.delete((String)"bos_attachment", (QFilter[])new QFilter[]{qFilter2});
                FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
                for (String string : oldxbrlurls) {
                    try {
                        attachmentFileService.delete(string);
                    }
                    catch (Exception e) {
                        logger.error((Throwable)e);
                    }
                }
            }
            catch (Exception err) {
                txHandle.markRollback();
                throw err;
            }
        }
        for (DynamicObject dynamicObject : dataEntities) {
            Long id = dynamicObject.getLong(ID);
            Object billid = dynamicObject.get(BILLID);
            JSONObject json = (JSONObject)returnJson.get(billid);
            String tickteType = (String)EVoucherModel.TICKETTYPEMAP.get("evp_bkrs");
            byte[] xbrlbytes = BuildFileUtils.json2Xbrl((String)json.toJSONString(), (String)tickteType);
            String xbrlurl = FileUtils.uploadFile((byte[])xbrlbytes, (String)dynamicObject.getString(ID), (String)"evp_bkrs", (String)EVoucherModel.createXBRLFilename((String)tickteType, (JSONObject)json));
            dynamicObject.set(ISINTOPOOL, (Object)"1");
            dynamicObject.set(INTOPOOLDATE, (Object)date);
            dynamicObject.set(OPERATOR, (Object)UserServiceHelper.getCurrentUserId());
            dynamicObject.set(XBRLURL, (Object)xbrlurl);
        }
        SaveServiceHelper.update((DynamicObject[])dataEntities);
    }

    private void writePeriod(DynamicObject dynamicObject) {
        Long orgid = dynamicObject.getLong("org_id");
        Long booktypeid = dynamicObject.getLong("booktype_id");
        Long periodtypeid = dynamicObject.getLong("periodtype_id");
        Date bookdate = dynamicObject.getDate(BOOKDATE);
        Long period = 0L;
        if (periodtypeid == 0L) {
            QFilter orgF = new QFilter(ORG, "=", (Object)orgid);
            QFilter typeB = new QFilter("bookstype", "=", (Object)booktypeid);
            DynamicObject dyn = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (QFilter[])new QFilter[]{orgF, typeB});
            periodtypeid = dyn.getDynamicObject(PERIODTYPE).getLong(ID);
            period = AccountingSysUtil.getPeriodByDate((Long)periodtypeid, (Date)bookdate);
        } else {
            period = AccountingSysUtil.getPeriodByDate((Long)periodtypeid, (Date)bookdate);
        }
        dynamicObject.set("periodtype_id", (Object)periodtypeid);
        dynamicObject.set("period_id", (Object)period);
    }

    private void buildrecondate(DynamicObject[] dyns) {
        Date date = new Date();
        Long uid = UserServiceHelper.getCurrentUserId();
        for (DynamicObject dynamicObject : dyns) {
            String year = dynamicObject.getString("reconyear");
            String month = dynamicObject.getString("reconmonth");
            dynamicObject.set("recondate", (Object)DateFomatUtils.stringToDate((String)(year + month), (String)"yyyyMM"));
            dynamicObject.set(BOOKDATE, (Object)DateFomatUtils.stringToDate((String)(year + month), (String)"yyyyMM"));
            dynamicObject.set(ISDELETE, (Object)"0");
            dynamicObject.set(CREATEDATE, (Object)date);
            dynamicObject.set("creator_id", (Object)uid);
        }
    }

    private void writeFileUrl(DynamicObject dynamicObject) {
        Date date = new Date();
        String base64 = dynamicObject.getString(BASETEXT_TAG);
        String filename = dynamicObject.getString(FILENAME);
        String orginsys = dynamicObject.getString("originsys_id");
        String billid = dynamicObject.getString(BILLID);
        String fileurl = dynamicObject.getString(FILEURL);
        if (dynamicObject.getLong(ID) == 0L) {
            dynamicObject.set(ID, (Object)DBServiceHelper.genGlobalLongId());
        }
        byte[] bytes = null;
        if (StringUtils.isNotBlank((CharSequence)fileurl)) {
            StringBuilder urlBuild = new StringBuilder();
            StringBuilder nameBuild = new StringBuilder();
            List<String> fileurls = Arrays.asList(fileurl.split(";"));
            DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)"bos_attachment", (String)"fattachmentname,fextname,fcreatemen,fcreatetime,fattachmentsize,finterid,fbilltype,ffileid,fattachmentpanel,id", (QFilter[])new QFilter("ffileid", "in", fileurls).toArray());
            HashMap<String, DynamicObject> existMap = new HashMap<String, DynamicObject>(16);
            for (DynamicObject o : dynamicObjects) {
                existMap.put(o.getString("ffileid"), o);
            }
            logger.info("origin fileurl:{}", fileurls);
            for (String url : fileurls) {
                if (url.startsWith("http")) {
                    try {
                        bytes = FileUtils.downLoadAnyUrl((String)url);
                    }
                    catch (IOException ioe) {
                        logger.error((Throwable)ioe);
                    }
                    String fileName = this.getFileName(url);
                    if (bytes == null) continue;
                    String attachurl = FileUtils.uploadOriFile((byte[])bytes, (String)dynamicObject.getString(ID), (String)this.billEntityType.getName(), (String)fileName, (String)orginsys, (Object)billid);
                    urlBuild.append(attachurl).append(";");
                    nameBuild.append(fileName).append("-----");
                    continue;
                }
                if (existMap.containsKey(url)) {
                    DynamicObject dyn = (DynamicObject)existMap.get(url);
                    MainEntityType type = EntityMetadataCache.getDataEntityType((String)"bos_attachment");
                    DynamicObject temp = new DynamicObject((DynamicObjectType)type);
                    TXHandle txHandle = TX.requiresNew((String)"kd.fi.evp.opplugin.base.BaseOriginDataSaveOp");
                    Throwable throwable = null;
                    try {
                        try {
                            temp.set("fattachmentname", (Object)dyn.getString("fattachmentname"));
                            temp.set("fextname", (Object)dyn.getString("fextname"));
                            temp.set("fnumber", (Object)AttachmentServiceHelper.generateUid());
                            temp.set("fcreatemen", (Object)UserServiceHelper.getCurrentUserId());
                            temp.set("fcreatetime", (Object)date);
                            temp.set("fattachmentsize", (Object)dyn.getString("fattachmentsize"));
                            temp.set("finterid", (Object)dynamicObject.getString(ID));
                            temp.set("fbilltype", (Object)this.billEntityType.getName());
                            temp.set("ffileid", (Object)dyn.getString("ffileid"));
                            temp.set("fattachmentpanel", (Object)"attachmentpanel");
                            temp.set(ID, (Object)DBServiceHelper.genGlobalLongId());
                            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{temp});
                            FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
                            String realurl = attachmentFileService.getFileServiceExt().getRealPath(dyn.getString("ffileid"));
                            urlBuild.append(dyn.getString("ffileid")).append(";");
                            nameBuild.append(realurl).append("-----");
                            continue;
                        }
                        catch (Exception ex) {
                            logger.error((Throwable)ex);
                            txHandle.markRollback();
                            throw ex;
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (txHandle == null) continue;
                        if (throwable != null) {
                            try {
                                txHandle.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        txHandle.close();
                        continue;
                    }
                }
                try {
                    bytes = FileUtils.downLoadHttpsFile((String)url);
                }
                catch (IOException io) {
                    logger.error((Throwable)io);
                }
                if (bytes == null) continue;
                FileService attachmentFileService = FileServiceFactory.getAttachmentFileService();
                String realurl = attachmentFileService.getFileServiceExt().getRealPath(url);
                String attachurl = FileUtils.uploadOriFile((byte[])bytes, (String)dynamicObject.getString(ID), (String)this.billEntityType.getName(), (String)FilenameUtils.getName((String)realurl), (String)orginsys, (Object)billid);
                logger.info("realurl:{}", (Object)attachmentFileService.getFileServiceExt().getRealPath(attachurl));
                urlBuild.append(attachurl).append(";");
                nameBuild.append(FilenameUtils.getName((String)realurl)).append("-----");
            }
            String finalurl = urlBuild.substring(0, urlBuild.length() - 1);
            String finalfilename = nameBuild.substring(0, nameBuild.length() - 5);
            logger.info("finalurl:{}, finalfilename:{}", (Object)finalurl, (Object)finalfilename);
            if (finalfilename.length() > 2000) {
                finalfilename = finalfilename.substring(0, 2000);
            }
            dynamicObject.set(FILEURL, (Object)"");
            dynamicObject.set(FILEURL_TAG, (Object)finalurl);
            dynamicObject.set(FILENAME, (Object)finalfilename);
        }
    }

    private String getFileName(String urlStr) {
        String fileName;
        block5: {
            fileName = "";
            if (urlStr.startsWith("http")) {
                try {
                    URL url = new URL(urlStr);
                    URLConnection urlConnection = url.openConnection();
                    Pattern pattern = Pattern.compile(".*filename=\"?([^\"]+)\"?.*$");
                    Matcher matcher = pattern.matcher(urlConnection.getHeaderField("content-disposition"));
                    if (matcher.matches()) {
                        fileName = matcher.group(1);
                        logger.info(String.format(ResManager.loadKDString((String)"\u6b63\u5219\u5339\u914d\u5230\u7684\u6587\u4ef6\u540d\uff1a%1$s\u3002", (String)"BaseOriginDataSaveOp_10", (String)"fi-evp-common", (Object[])new Object[0]), fileName));
                        break block5;
                    }
                    logger.error(String.format(ResManager.loadKDString((String)"\u6b63\u5219\u5339\u914d\u4e0d\u5230\u7684\u6587\u4ef6\u540d\uff0cURL\uff1a%1$s\u3002", (String)"BaseOriginDataSaveOp_11", (String)"fi-evp-common", (Object[])new Object[0]), urlStr));
                }
                catch (Exception e) {
                    logger.error(String.format(ResManager.loadKDString((String)"\u901a\u8fc7http\u5f00\u5934\u7684\u5730\u5740\u83b7\u53d6\u6587\u4ef6\u540d\u5931\u8d25\uff0cURL\uff1a%1$s\u3002", (String)"BaseOriginDataSaveOp_12", (String)"fi-evp-common", (Object[])new Object[0]), urlStr), (Throwable)e);
                }
            } else {
                fileName = FilenameUtils.getName((String)urlStr);
            }
        }
        return fileName;
    }

    private Map<String, DynamicObject> getVoucherFields(DynamicObject[] dyns) {
        HashMap<String, DynamicObject> returnMap = new HashMap<String, DynamicObject>(16);
        List vouchrids = Arrays.asList(dyns).stream().map(dyn -> dyn.getString(VOUCHERID)).collect(Collectors.toList());
        vouchrids.removeIf(voucherid -> StringUtils.isEmpty((CharSequence)voucherid));
        QFilter qFilter = new QFilter(BILLID, "in", vouchrids);
        qFilter.and(new QFilter(ISDELETE, "=", (Object)"0"));
        if (vouchrids.size() > 0) {
            DynamicObjectCollection voucherDyns = QueryServiceHelper.query((String)"evp_voucher", (String)"billid, voucherno, period", (QFilter[])qFilter.toArray());
            for (DynamicObject voucherDyn : voucherDyns) {
                returnMap.put(voucherDyn.getString(BILLID), voucherDyn);
            }
        }
        return returnMap;
    }
}

