/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.evp.common.util.EVoucherModel;

public class SoftDeleteValidator
extends AbstractValidator {
    private static final Long ORIGINSYSID = 100000L;
    private static final String ORIGINSYS = "originsys";
    private static final String ORIGINSYS_ID = "originsys_id";
    private static final String BILLID = "billid";
    private static final String VOUCHERNO = "voucherno";
    private static final String ISHANDLE = "ishandle";
    private static final String ISARCHIVE = "isarchive";

    public Set<String> preparePropertys() {
        Set set = super.preparePropertys();
        set.add(ORIGINSYS);
        set.add(BILLID);
        set.add(VOUCHERNO);
        set.add(ISHANDLE);
        set.add(ISARCHIVE);
        set.add("isintopool");
        return set;
    }

    public void validate() {
        HashSet<Object> billids = new HashSet<Object>(this.getDataEntities().length);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            billids.add(dataEntity.getDataEntity().get(BILLID));
        }
        String entity = this.getEntityKey();
        HashMap<Object, Map<String, List<String>>> errBillIds = new HashMap(16);
        HashMap<Object, Map<String, List<String>>> otherBillIds = new HashMap(16);
        if ("evp_voucher".equals(entity)) {
            errBillIds = this.geterrBillids(billids);
            otherBillIds = this.getOtherBillids(billids);
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject dyn = dataEntity.getDataEntity();
            String billid = dyn.getString(BILLID);
            String ishandle = dyn.getString(ISHANDLE);
            String errMsg = "";
            switch (entity) {
                case "evp_voucher": {
                    errMsg = this.checkVoucherDyn(dyn, errBillIds, otherBillIds);
                    break;
                }
                case "evp_bkrs": {
                    errMsg = this.checkBkrsDyn(dyn);
                    break;
                }
                default: {
                    errMsg = this.checkBillDyn(dyn);
                }
            }
            if (!StringUtils.isNotEmpty((CharSequence)errMsg)) continue;
            this.addErrorMessage(dataEntity, errMsg);
        }
    }

    private String checkVoucherDyn(DynamicObject dyn, Map<Object, Map<String, List<String>>> errBillIds, Map<Object, Map<String, List<String>>> otherBillIds) {
        String entity = this.getEntityKey();
        String billid = dyn.getString(BILLID);
        Long originsysid = dyn.getLong(ORIGINSYS_ID);
        if (errBillIds.containsKey(billid)) {
            Map<String, List<String>> map = errBillIds.get(dyn.get(BILLID));
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                stringBuilder.append(entry.getKey()).append(":\u201c").append(entry.getValue()).append("\u201d ");
            }
            String voucherno = dyn.getString(VOUCHERNO);
            String mString = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1:\u201c%1$s\u201d\u5df2\u5173\u8054\u5165\u6c60\u6570\u636e:%2$s\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"SoftDeleteValidator_1", (String)"fi-evp-common", (Object[])new Object[0]), voucherno, stringBuilder.toString());
            return mString;
        }
        if (otherBillIds.containsKey(billid)) {
            Map<String, List<String>> map = otherBillIds.get(dyn.get(BILLID));
            StringBuilder stringBuilder = new StringBuilder();
            for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                stringBuilder.append(entry.getKey()).append(":\u201c").append(entry.getValue()).append("\u201d ");
            }
            String voucherno = dyn.getString(VOUCHERNO);
            String mString = String.format(ResManager.loadKDString((String)"\u51ed\u8bc1:\u201c%1$s\u201d\u5df2\u5173\u8054\u6765\u6e90\u4e8e\u975e\u5f53\u524d\u7cfb\u7edf\u7684\u7968\u636e:%2$s\uff0c\u4e0d\u53ef\u4ee5\u5220\u9664\uff0c\u8bf7\u5148\u5220\u9664\u5173\u8054\u7968\u636e\u3002", (String)"SoftDeleteValidator_5", (String)"fi-evp-common", (Object[])new Object[0]), voucherno, stringBuilder.toString());
            return mString;
        }
        return null;
    }

    private String checkBkrsDyn(DynamicObject dyn) {
        if (dyn.getBoolean(ISARCHIVE)) {
            return ResManager.loadKDString((String)"\u5df2\u5f52\u6863\uff0c\u4e0d\u53ef\u4ee5\u5220\u9664\u3002", (String)"SoftDeleteValidator_2", (String)"fi-evp-common", (Object[])new Object[0]);
        }
        return null;
    }

    private String checkBillDyn(DynamicObject dyn) {
        Long originsysid = dyn.getLong(ORIGINSYS_ID);
        if (dyn.getBoolean(ISARCHIVE)) {
            return ResManager.loadKDString((String)"\u5df2\u5f52\u6863\uff0c\u4e0d\u53ef\u4ee5\u5220\u9664\u3002", (String)"SoftDeleteValidator_2", (String)"fi-evp-common", (Object[])new Object[0]);
        }
        if (dyn.getBoolean("isintopool")) {
            return ResManager.loadKDString((String)"\u5df2\u5165\u6c60\uff0c\u4e0d\u53ef\u4ee5\u5220\u9664\u3002", (String)"SoftDeleteValidator_3", (String)"fi-evp-common", (Object[])new Object[0]);
        }
        if (ORIGINSYSID.equals(originsysid)) {
            return ResManager.loadKDString((String)"\u6765\u6e90\u4e8e\u5f53\u524d\u7cfb\u7edf\u7684\u6570\u636e\uff0c\u4e0d\u53ef\u4ee5\u5220\u9664\uff0c\u8bf7\u901a\u8fc7\u5173\u8054\u51ed\u8bc1\u5220\u9664\u3002", (String)"SoftDeleteValidator_4", (String)"fi-evp-common", (Object[])new Object[0]);
        }
        return null;
    }

    private Map<Object, Map<String, List<String>>> geterrBillids(Set<Object> billids) {
        HashMap<Object, Map<String, List<String>>> returnmap = new HashMap<Object, Map<String, List<String>>>(16);
        Set tables = EVoucherModel.TICKETTYPEMAP.keySet();
        Map namemap = EVoucherModel.getNameMap();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("isintopool", "=", (Object)"1"));
        qFilters.add(new QFilter("isdelete", "=", (Object)"0"));
        qFilters.add(new QFilter("voucherid", "in", billids));
        for (String string : tables) {
            DataSet dataset = QueryServiceHelper.queryDataSet((String)"SoftDeleteValidator.geterrBillids", (String)string, (String)"id,voucherid,billid", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id");
            Throwable throwable = null;
            try {
                String tablename = (String)namemap.get(string);
                for (Row row : dataset) {
                    Object voucherid = row.get("voucherid");
                    String billid = row.getString(BILLID);
                    returnmap.computeIfAbsent(voucherid, value -> new HashMap()).computeIfAbsent(tablename, value -> new ArrayList()).add(billid);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataset == null) continue;
                if (throwable != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataset.close();
            }
        }
        return returnmap;
    }

    private Map<Object, Map<String, List<String>>> getOtherBillids(Set<Object> billids) {
        HashMap<Object, Map<String, List<String>>> returnmap = new HashMap<Object, Map<String, List<String>>>(16);
        Set tables = EVoucherModel.TICKETTYPEMAP.keySet();
        Map namemap = EVoucherModel.getNameMap();
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter(ORIGINSYS, "!=", (Object)ORIGINSYSID));
        qFilters.add(new QFilter("isdelete", "=", (Object)"0"));
        qFilters.add(new QFilter("voucherid", "in", billids));
        for (String string : tables) {
            DataSet dataset = QueryServiceHelper.queryDataSet((String)"SoftDeleteValidator.getOtherBillids", (String)string, (String)"id,voucherid,billid", (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id");
            Throwable throwable = null;
            try {
                String tablename = (String)namemap.get(string);
                for (Row row : dataset) {
                    Object voucherid = row.get("voucherid");
                    String billid = row.getString(BILLID);
                    returnmap.computeIfAbsent(voucherid, value -> new HashMap()).computeIfAbsent(tablename, value -> new ArrayList()).add(billid);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataset == null) continue;
                if (throwable != null) {
                    try {
                        dataset.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataset.close();
            }
        }
        return returnmap;
    }
}

