/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.evp.common.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.AppMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.bd.util.PeriodUtil;
import kd.fi.evp.common.entity.AccountBookInfo;

public class AccountingSysUtil {
    public static List<Long> getAcctOrgPkList(String entityId, String permType) {
        String appId = AppMetadataCache.getAppInfo((String)"evp").getId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((long)RequestContext.get().getCurrUserId(), (String)"10", (String)appId, (String)entityId, (String)permType);
        LinkedHashSet<Long> orgSet = new LinkedHashSet<Long>();
        QFilter[] bookFilter = new QFilter[]{new QFilter("bookstype", "=", (Object)AccountingSysUtil.getMainBookTypeId())};
        try (DataSet bookDataSet = QueryServiceHelper.queryDataSet((String)(AccountingSysUtil.class.getName() + ".getAcctOrgPkList"), (String)"gl_accountbook", (String)"org", (QFilter[])bookFilter, null);){
            for (Row row : bookDataSet) {
                orgSet.add(row.getLong("org"));
            }
        }
        if (!permOrgRs.hasAllOrgPerm()) {
            orgSet.retainAll(permOrgRs.getHasPermOrgs());
        }
        return new ArrayList<Long>(orgSet);
    }

    public static long getMainBookTypeId() {
        DynamicObject booksTypeDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (String)"id", (QFilter[])new QFilter("accounttype", "=", (Object)"1").toArray());
        return booksTypeDyn.getLong("id");
    }

    public static DynamicObject getMainBookType() {
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbookstype", (String)"id,number,name", (QFilter[])new QFilter("accounttype", "=", (Object)"1").toArray());
    }

    public static DynamicObject getBookFromAccSys(long orgId) {
        QFilter h = new QFilter("org", "=", (Object)orgId);
        QFilter k = new QFilter("bookstype", "=", (Object)AccountingSysUtil.getMainBookTypeId());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (QFilter[])new QFilter[]{k, h});
    }

    public static DynamicObject getBookFromAccSys(long orgId, long bookType) {
        QFilter h = new QFilter("org", "=", (Object)orgId);
        QFilter k = new QFilter("bookstype", "=", (Object)bookType);
        return BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (QFilter[])new QFilter[]{k, h});
    }

    public static AccountBookInfo getAcctBookFromAccSys(long orgId, long bookType) {
        DynamicObject curPeriodDyn;
        QFilter h = new QFilter("org", "=", (Object)orgId);
        QFilter k = new QFilter("bookstype", "=", (Object)bookType);
        DynamicObject acctBookDyn = BusinessDataServiceHelper.loadSingleFromCache((String)"gl_accountbook", (QFilter[])new QFilter[]{k, h});
        if (acctBookDyn == null) {
            return null;
        }
        AccountBookInfo bookInfo = new AccountBookInfo();
        bookInfo.setId(acctBookDyn.getLong("id"));
        bookInfo.setNumber(acctBookDyn.getString("number"));
        DynamicObject orgDyn = acctBookDyn.getDynamicObject("org");
        bookInfo.setOrgId(orgDyn.getLong("id"));
        bookInfo.setOrgNumber(orgDyn.getString("number"));
        bookInfo.setOrgName(orgDyn.getString("name"));
        DynamicObject bookTypeDyn = acctBookDyn.getDynamicObject("bookstype");
        bookInfo.setBookTypeId(bookTypeDyn.getLong("id"));
        bookInfo.setBookTypeNumber(bookTypeDyn.getString("number"));
        bookInfo.setBookTypeName(bookTypeDyn.getString("name"));
        DynamicObject acctTable = acctBookDyn.getDynamicObject("accounttable");
        bookInfo.setAcctTableId(acctTable.getLong("id"));
        bookInfo.setAcctTableName(acctTable.getString("name"));
        bookInfo.setPeriodTypeId(acctBookDyn.getLong("periodtype_id"));
        DynamicObject startPeriodDyn = acctBookDyn.getDynamicObject("startperiod");
        if (startPeriodDyn != null) {
            bookInfo.setStartPeriodId(startPeriodDyn.getLong("id"));
            bookInfo.setStartPeriodNumber(startPeriodDyn.getString("number"));
            bookInfo.setStartPeriodName(startPeriodDyn.getString("name"));
        }
        if ((curPeriodDyn = acctBookDyn.getDynamicObject("curperiod")) != null) {
            bookInfo.setCurPeriodId(curPeriodDyn.getLong("id"));
            bookInfo.setCurPeriodNumber(curPeriodDyn.getString("number"));
            bookInfo.setCurPeriodName(curPeriodDyn.getString("name"));
        }
        return bookInfo;
    }

    public static long getCurPeriodId(long orgId, long booksTypeId) {
        DynamicObject bookFromAccSys = AccountingSysUtil.getBookFromAccSys(orgId, booksTypeId);
        return bookFromAccSys == null ? 0L : bookFromAccSys.getLong("curperiod_id");
    }

    public static Long getPeriodByDate(Long periodType, Date bookedate) {
        DynamicObject dynamicObject = PeriodUtil.getPeriodByDate((Date)bookedate, (long)periodType, (Boolean)Boolean.FALSE);
        if (dynamicObject == null) {
            String selectField = "id,periodtype.id,periodyear,periodnumber,begindate,enddate,isadjustperiod,number,name";
            DynamicObjectCollection dyns = QueryServiceHelper.query((String)"bd_period", (String)selectField, (QFilter[])new QFilter("periodtype", "=", (Object)periodType).toArray(), (String)"enddate desc");
            if (dyns.size() == 0) {
                return null;
            }
            return ((DynamicObject)dyns.get(0)).getLong("id");
        }
        return dynamicObject.getLong("id");
    }

    public static DynamicObject getPreviousPeriod(Object curPeriodId) {
        if (curPeriodId == null) {
            return null;
        }
        try {
            String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate, periodnumber number";
            DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)curPeriodId, (String)"bd_period");
            Object periodtypeid = currPeriod.get("periodtype_id");
            QFilter filterDate = new QFilter("id", "<", curPeriodId);
            QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
            QFilter isadjustperiod = new QFilter("isadjustperiod", "=", (Object)"0");
            DynamicObjectCollection coll = QueryServiceHelper.query((String)"bd_period", (String)selector, (QFilter[])new QFilter[]{filterDate, filterType, isadjustperiod}, (String)"id desc", (int)1);
            if (coll == null || coll.isEmpty()) {
                return null;
            }
            return (DynamicObject)coll.get(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Map<Long, String> getGlAccountNumberBySubledger(Set<Long> accountIds, Long accountTableId) {
        Serializable parentId;
        HashMap<Long, String> idAndGlAccountName = new HashMap<Long, String>(accountIds.size());
        HashMap<Long, Long> idAndParentId = new HashMap<Long, Long>();
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"getGlAccountNumberBySubledger", (String)"bd_accountview", (String)"id,parent.id parentid", (QFilter[])new QFilter("accounttable", "=", (Object)accountTableId).toArray(), null);
        Object object = null;
        try {
            for (Row row : dataSet) {
                idAndParentId.put(row.getLong("id"), row.getLong("parentid"));
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashMap<Long, Long> idAndTopId = new HashMap<Long, Long>(100);
        for (Long accountId : accountIds) {
            parentId = AccountingSysUtil.getParentId(accountId, idAndParentId);
            idAndTopId.put(accountId, (Long)parentId);
        }
        HashMap<Long, String> topidAndName = new HashMap<Long, String>();
        DataSet dataSet2 = QueryServiceHelper.queryDataSet((String)"getTopAccountNumberBySubledger", (String)"bd_accountview", (String)"id,name", (QFilter[])new QFilter("id", "in", idAndTopId.values()).toArray(), null);
        parentId = null;
        try {
            for (Row row : dataSet2) {
                topidAndName.put(row.getLong("id"), row.getString("name"));
            }
        }
        catch (Throwable throwable) {
            parentId = throwable;
            throw throwable;
        }
        finally {
            if (dataSet2 != null) {
                if (parentId != null) {
                    try {
                        dataSet2.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)parentId).addSuppressed(throwable);
                    }
                } else {
                    dataSet2.close();
                }
            }
        }
        for (Map.Entry entry : idAndTopId.entrySet()) {
            idAndGlAccountName.put((Long)entry.getKey(), (String)topidAndName.get(entry.getValue()));
        }
        return idAndGlAccountName;
    }

    private static Long getParentId(Long accountId, Map<Long, Long> idAndParentId) {
        Long id = idAndParentId.get(accountId);
        if (id == null || id == 0L) {
            return accountId;
        }
        return AccountingSysUtil.getParentId(id, idAndParentId);
    }

    public static DynamicObject getPeriodDyn(Long periodId) {
        QFilter filter = new QFilter("id", "=", (Object)periodId);
        DynamicObject period = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"begindate,enddate", (QFilter[])filter.toArray());
        return period;
    }

    public static List<Long> getBookTypes(List<Long> orgids) {
        ArrayList<Long> booktypeIds = new ArrayList<Long>(16);
        QFilter orgF = new QFilter("org", "in", orgids);
        DynamicObjectCollection books = QueryServiceHelper.query((String)"gl_accountbook", (String)"bookstype.id,bookstype.name, bookstype.accounttype", (QFilter[])new QFilter[]{orgF}, (String)"bookstype.accounttype");
        for (DynamicObject dynamicObject : books) {
            booktypeIds.add(dynamicObject.getLong("bookstype.id"));
        }
        return booktypeIds;
    }

    public static DynamicObjectCollection getPeriodTypes(List<Long> orgids, Long booktypeid) {
        QFilter orgF = new QFilter("org", "in", orgids);
        QFilter typeB = new QFilter("bookstype", "=", (Object)booktypeid);
        DynamicObjectCollection dyns = QueryServiceHelper.query((String)"gl_accountbook", (String)"id, curperiod, periodtype, startperiod", (QFilter[])new QFilter[]{orgF, typeB});
        DynamicObjectCollection returendys = new DynamicObjectCollection();
        HashSet<Long> periods = new HashSet<Long>();
        for (DynamicObject dynamicObject : dyns) {
            if (!periods.add(dynamicObject.getLong("periodtype"))) continue;
            returendys.add((Object)dynamicObject);
        }
        return returendys;
    }
}

